 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */


/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>           Display Creation Routines
   >>>>
   >>>>  Private:
   >>>>           edimg_create_image()
   >>>>           edimg_create_panicon()
   >>>>           edimg_create_position()
   >>>>           edimg_create_printpixel()
   >>>>           edimg_create_printmapval()
   >>>>           edimg_create_zoom()
   >>>>           edimg_create_pseudo()
   >>>>           edimg_create_threshold()
   >>>>   Static:
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#include "editimage.h"

/*-----------------------------------------------------------
|
|  Routine Name: edimg_create_image
|
|       Purpose: Creates the image object for displaying input image
|
|         Input: None
|        Output: None
|       Returns: None
|    Written By: Danielle Argiro & Mark Young
|          Date: October 28, 1993
| Modifications:
|
------------------------------------------------------------*/
void edimg_create_image(void)
{
	xvobject parent;

        parent = gui_info->workspace;

	/*
	 * create the image object
	 */
        image = xvw_create_image(parent, "Image");
        xvw_set_attribute(image, XVW_IMAGE_BAND_DIMENSIONS, dimensions);
}

/*-----------------------------------------------------------
|
|  Routine Name: edimg_create_panicon
|
|       Purpose: Creates the pan icon for use with large images
|
|         Input: None
|        Output: None
|       Returns: None
|    Written By: Danielle Argiro & Mark Young
|          Date: October 28, 1993
| Modifications:
|
------------------------------------------------------------*/
void edimg_create_panicon(void)
{
	xvobject offset, parent;

	/* 
	 * when panicon appears, need it below the "Threshold" subform button 
	 */
        offset = xvf_get_xvobject(gui_info->Thresh_struct, 
			          XVF_BUTTON_OBJ, TRUE);

	/*
	 * the parent of the panicon is the backplane of editimage's main form
	 */
        parent = xvf_get_xvobject(gui_info->editimage_struct, 
			          XVF_BACKPLANE, TRUE);
	/*
	 * create the (global) pan icon object
	 */
        panicon = xvw_create_panicon(parent, "Panicon");
        xvw_set_attributes(panicon,
                           XVW_BELOW,                 offset,
                           XVW_LEFT_OF,               gui_info->workspace,
                           XVW_RIGHT_OF,              NULL,
                           XVW_IMAGE_BAND_DIMENSIONS, dimensions,
                           NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: edimg_create_position
|
|       Purpose: Creates the position object that appears below the 
|                image workspace.
|
|         Input: None
|        Output: None
|       Returns: None
|    Written By: Danielle Argiro & Mark Young
|          Date: October 28, 1993
| Modifications:
|
------------------------------------------------------------*/
void edimg_create_position(void)
{
        xvobject parent;

        parent = gui_info->workspace;

	/*
	 * create the (global) position object
	 */
        position = xvw_create_position(parent, "Position");
        xvw_set_attributes(position,
                XVW_STRING_JUSTIFICATION, KSTRING_JUSTIFY_CENTER,
                XVW_POSITION_OBJECT,      NULL,
                XVW_BELOW,                image,
                XVW_LEFT_OF,              NULL,
                XVW_RIGHT_OF,             NULL,
                NULL);

}

/*-----------------------------------------------------------
|
|  Routine Name: edimg_create_printpixel
|
|       Purpose: Creates the printpixel object for the 
|                display on the printpixel subform
|
|         Input: None
|        Output: None
|       Returns: None
|    Written By: Danielle Argiro & Mark Young
|          Date: October 28, 1993
| Modifications:
|
------------------------------------------------------------*/
void edimg_create_printpixel(void)
{
        xvobject parent;

        parent = gui_info->Pixel->pixel->pixel_object;

        xvw_set_attribute(parent, XVW_TACK_EDGE, 
		          KMANAGER_TACK_RIGHT | KMANAGER_TACK_BOTTOM);
        xvw_set_attribute(xvw_parent(parent), XVW_TACK_EDGE,
                          KMANAGER_TACK_BOTTOM | KMANAGER_TACK_RIGHT);
	/*
	 *  create the (global) printpixel object
	 */
        printpixel = xvw_create_printpixel(parent, "PrintPixel");
        xvw_set_attributes(printpixel, 
			   XVW_PRINTPIXEL_SHOWCOLOR, TRUE,
        		   XVW_TACK_EDGE,            KMANAGER_TACK_ALL,
			   NULL);

}

/*-----------------------------------------------------------
|
|  Routine Name: edimg_create_printmapval
|
|       Purpose: Creates the printmapval object for the
|                display on the printmapval subform
|
|         Input: None
|        Output: None
|       Returns: None
|    Written By: Danielle Argiro & Mark Young
|          Date: October 28, 1993
| Modifications:
|
------------------------------------------------------------*/
void edimg_create_printmapval(void)
{
        xvobject parent;

        parent = gui_info->MapValues->mapvals->mapval_object;

        xvw_set_attribute(parent, XVW_TACK_EDGE,
                          KMANAGER_TACK_RIGHT | KMANAGER_TACK_BOTTOM);
        xvw_set_attribute(xvw_parent(parent), XVW_TACK_EDGE,
                          KMANAGER_TACK_BOTTOM | KMANAGER_TACK_RIGHT);

        /*
         *  create the (global) printmapval object
         */
        printmapval = xvw_create_printmapval(parent, "PrintMapVal");
        xvw_set_attributes(printmapval, 
			   XVW_PRINTMAPVAL_SHOWCOLOR, TRUE,
			   XVW_TACK_EDGE,             KMANAGER_TACK_ALL,
			   NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: edimg_create_zoom
|
|       Purpose: Creates the zoom object for the
|                display on the zoom subform
|
|         Input: None
|        Output: None
|       Returns: None
|    Written By: Danielle Argiro & Mark Young
|          Date: October 28, 1993
| Modifications:
|
------------------------------------------------------------*/
void edimg_create_zoom(void)
{
        xvobject parent;

        parent = gui_info->Zoom->zoom->zoom_object;

        xvw_set_attribute(parent, XVW_TACK_EDGE,
                          KMANAGER_TACK_RIGHT | KMANAGER_TACK_BOTTOM);
        xvw_set_attribute(xvw_parent(parent), XVW_TACK_EDGE,
                          KMANAGER_TACK_BOTTOM | KMANAGER_TACK_RIGHT);
        xvw_set_attributes(xvw_parent(xvw_parent(parent)),
                           XVW_MINIMUM_WIDTH,  276,
                           XVW_MINIMUM_HEIGHT, 250,
                           NULL);
        /*
         *  create the (global) zoom object
         */
        zoom = xvw_create_zoom(parent, "Zoom");
        xvw_set_attributes(zoom,
			   XVW_IMAGE_BAND_DIMENSIONS, dimensions,
			   XVW_TACK_EDGE,             KMANAGER_TACK_ALL,
			   NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: edimg_create_pseudo
|
|       Purpose: Creates the pseudocolor object for the
|                display on the pseudocolor subform
|
|         Input: None
|        Output: None
|       Returns: None
|    Written By: Danielle Argiro & Mark Young
|          Date: October 28, 1993
| Modifications:
|
------------------------------------------------------------*/
void edimg_create_pseudo(void)
{
        xvobject parent;

        parent = gui_info->Pseudo->pseudo->pseudo_object;

        xvw_set_attribute(parent, XVW_TACK_EDGE,
                          KMANAGER_TACK_RIGHT | KMANAGER_TACK_BOTTOM);
        xvw_set_attribute(xvw_parent(parent), XVW_TACK_EDGE,
                          KMANAGER_TACK_BOTTOM | KMANAGER_TACK_RIGHT);

        /*
         *  create the (global) pseudo object
         */
        pseudo = xvw_create_pseudo(parent, "Pseudo");
	xvw_set_attribute(pseudo, XVW_WIDTH, 400);
			  
        xvw_set_attribute(pseudo, XVW_TACK_EDGE, KMANAGER_TACK_ALL);
}

/*-----------------------------------------------------------
|
|  Routine Name: edimg_create_threshold
|
|       Purpose: Creates the threshold object for the
|                display on the threshold subform
|
|         Input: None
|        Output: None
|       Returns: None
|    Written By: Danielle Argiro & Mark Young
|          Date: October 28, 1993
| Modifications:
|
------------------------------------------------------------*/
void edimg_create_threshold(void)
{
        xvobject parent;

        parent = gui_info->Thresh->thresh->thresh_object;

        xvw_set_attribute(parent, XVW_TACK_EDGE,
                          KMANAGER_TACK_RIGHT | KMANAGER_TACK_BOTTOM);
        xvw_set_attribute(xvw_parent(parent), XVW_TACK_EDGE,
                          KMANAGER_TACK_BOTTOM | KMANAGER_TACK_RIGHT);

        /*
         *  create the (global) threshold object
         */
        threshold = xvw_create_threshold(parent, "Threshold");
	xvw_set_attribute(threshold, XVW_TACK_EDGE,  KMANAGER_TACK_ALL);
}
