 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for editcmap
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "editcmap.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Interactively Edit Image Colormap
|
|       Purpose: main program for editcmap
|
|         Input:
|		Loose group:
|		    char *clui_info->i_file; {file with initial value data}
|		    int   clui_info->i_flag; {TRUE if -i specified}
|
|		    char *clui_info->cmap_file; {file with initial colormap}
|		    int   clui_info->cmap_flag; {TRUE if -cmap specified}
|
|		Required M.E. group:
|		    int clui_info->pseudo_flag; {TRUE if -pseudo specified}
|
|		    int clui_info->thresh_flag; {TRUE if -thresh specified}
|
|		int clui_info->use_cmap_logic; {use colormap?}
|		int clui_info->use_cmap_flag; {TRUE if -use_cmap specified}
|
|		int clui_info->x_int; {x location of GUI}
|		int clui_info->x_flag; {TRUE if -x specified}
|
|		int clui_info->y_int; {y location of GUI}
|		int clui_info->y_flag; {TRUE if -y specified}
|
|		int clui_info->width_int; {The window width}
|		int clui_info->width_flag; {TRUE if -width specified}
|
|		int clui_info->height_int; {The window height}
|		int clui_info->height_flag; {TRUE if -height specified}
|
|		float clui_info->update_float; {initial update time}
|		int   clui_info->update_flag; {TRUE if -update specified}
|
|		char *clui_info->o_file; {file in which to store the modified colormap}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "ENVISION");
	kexit_handler(editcmap_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "ENVISION", "editcmap",
		editcmap_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	editcmap_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

	/*
	 * Initialize xvwidgets lib
	 */
	if (!(xvw_initialize(XVW_MENUS_XVFORMS)))
	{
	     kinfo(KSTANDARD, "Could not open connection to server");
	     kexit(KEXIT_FAILURE);
	}

/* -main_before_lib_call */
	create_cmap_workspace();
/* -main_before_lib_call_end */

/* -main_library_call */
	xvf_run_form();
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: editcmap_usage_additions
| 
|       Purpose: Prints usage additions in editcmap_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname editcmap
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void editcmap_usage_additions(void)
{
	kfprintf(kstderr, "\tInteractively Edit Image Colormap\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: editcmap_free_args
| 
|       Purpose: Frees CLUI struct allocated in editcmap_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname editcmap
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
editcmap_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
