 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	FormInfo Extraction Routines
   >>>> 
   >>>>  Private: 
   >>>> 	_xvf_get_animate
   >>>> 
   >>>>   Static: 
   >>>> 	_xvf_get_File
   >>>> 	_xvf_get_file
   >>>> 	_xvf_get_options
   >>>> 	_xvf_get_attributes
   >>>> 	_xvf_get_display
   >>>> 	_xvf_get_lists
   >>>> 	_xvf_get_colormap
   >>>> 	_xvf_get_function
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "animate.h"


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_animate
| 
|       Purpose: Extracts information from GUI
| 
|         Input: forminfo - pointer to gui_info_struct
| 
|        Output: none
|    Written By: conductor -name animate -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_animate(
     gui_info_struct *forminfo)
{
	kselection *selection;
	ksubform   *subform;
	if (forminfo->quit_struct != NULL)
	{
	    selection = forminfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->quit));

	}

	if (forminfo->reverse_struct != NULL)
	{
	    selection = forminfo->reverse_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->reverse));

	}

	if (forminfo->previous_struct != NULL)
	{
	    selection = forminfo->previous_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->previous));

	}

	if (forminfo->stop_struct != NULL)
	{
	    selection = forminfo->stop_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->stop));

	}

	if (forminfo->next_struct != NULL)
	{
	    selection = forminfo->next_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->next));

	}

	if (forminfo->forward_struct != NULL)
	{
	    selection = forminfo->forward_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->forward));

	}

	if (forminfo->object_struct != NULL)
	{
	    selection = forminfo->object_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(forminfo->object));
	    }

	}

	if (forminfo->File_struct != NULL)
	{
	    subform = forminfo->File_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->File_selected));
	    _xvf_get_File(forminfo->File);

	}
	if (forminfo->options_struct != NULL)
	{
	    subform = forminfo->options_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->options_selected));
	    _xvf_get_options(forminfo->options);

	}

}

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_File
| 
|       Purpose: Extracts information from File subform
| 
|         Input: subforminfo - pointer to animate_File structure
| 
|        Output: none
|    Written By: conductor -name animate -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_File(
     animate_File *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->file_struct != NULL)
	{
	    pane = subforminfo->file_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->file_selected));
	    _xvf_get_file(subforminfo->file);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_file
| 
|       Purpose: Extracts information from file pane
| 
|         Input: paneinfo - pointer to File_file structure
| 
|        Output: none
|    Written By: conductor -name animate -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_file(
     File_file *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'animate->File->file' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->c_struct != NULL)
	{
	    selection = paneinfo->c_struct->Selptr;
	    if (selection->modified)
	    {
		if (paneinfo->c != NULL) kfree(paneinfo->c);
		kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
		                  &(paneinfo->c));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->c_selected));
	    }
	}

	if (paneinfo->cmap_struct != NULL)
	{
	    selection = paneinfo->cmap_struct->Selptr;
	    if (selection->modified)
	    {
		if (paneinfo->cmap != NULL) kfree(paneinfo->cmap);
		kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
		                  &(paneinfo->cmap));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->cmap_selected));
	    }
	}

	if (paneinfo->o_struct != NULL)
	{
	    selection = paneinfo->o_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->o != NULL) kfree(paneinfo->o);
	    kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
	                    &(paneinfo->o));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->o_selected));
	    }
	}

	if (paneinfo->i_struct != NULL)
	{
	    selection = paneinfo->i_struct->Selptr;
	    if (selection->modified || selection->back_group->modified)
	    {
		if (paneinfo->i != NULL) kfree(paneinfo->i);
		kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
		                  &(paneinfo->i));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->i_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->i_optsel));
	    }
	}

	if (paneinfo->b_struct != NULL)
	{
	    selection = paneinfo->b_struct->Selptr;
	    if (selection->modified || selection->back_group->modified)
	    {
	    if (paneinfo->b != NULL) kfree(paneinfo->b);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->b));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->b_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->b_optsel));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_options
| 
|       Purpose: Extracts information from options subform
| 
|         Input: subforminfo - pointer to animate_options structure
| 
|        Output: none
|    Written By: conductor -name animate -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_options(
     animate_options *subforminfo)
{
	kselection *selection;
	kcontrol   *pane;
	if (subforminfo->quit_struct != NULL)
	{
	    selection = subforminfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->quit));

	}

	if (subforminfo->attributes_struct != NULL)
	{
	    pane = subforminfo->attributes_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->attributes_selected));
	    _xvf_get_attributes(subforminfo->attributes);
	}

	if (subforminfo->display_struct != NULL)
	{
	    pane = subforminfo->display_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->display_selected));
	    _xvf_get_display(subforminfo->display);
	}

	if (subforminfo->lists_struct != NULL)
	{
	    pane = subforminfo->lists_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->lists_selected));
	    _xvf_get_lists(subforminfo->lists);
	}

	if (subforminfo->colormap_struct != NULL)
	{
	    pane = subforminfo->colormap_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->colormap_selected));
	    _xvf_get_colormap(subforminfo->colormap);
	}

	if (subforminfo->function_struct != NULL)
	{
	    pane = subforminfo->function_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->function_selected));
	    _xvf_get_function(subforminfo->function);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_attributes
| 
|       Purpose: Extracts information from attributes pane
| 
|         Input: paneinfo - pointer to options_attributes structure
| 
|        Output: none
|    Written By: conductor -name animate -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_attributes(
     options_attributes *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'animate->options->attributes' Pane Info structure
	 */

	if (paneinfo->control_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->control_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->control_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->control_val = atoi(value_string);
	    kfree(value_string);
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->control_selected));
	    }

	}

	if (paneinfo->elements_struct != NULL)
	{
	   selection = paneinfo->elements_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->elements));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->elements_selected));
	    }

	}

	if (paneinfo->depth_struct != NULL)
	{
	   selection = paneinfo->depth_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->depth));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->depth_selected));
	    }

	}

	if (paneinfo->time_struct != NULL)
	{
	   selection = paneinfo->time_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->time));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->time_selected));
	    }

	}

	if (paneinfo->show_framenum_struct != NULL)
	{
	   selection = paneinfo->show_framenum_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_VAL,
	                    &(paneinfo->show_framenum));
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_LABEL,
	                    &(paneinfo->show_framenum_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->show_framenum_selected));
	    }

	}

	if (paneinfo->speed_struct != NULL)
	{
	    selection = paneinfo->speed_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->speed));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->speed_selected));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_display
| 
|       Purpose: Extracts information from display pane
| 
|         Input: paneinfo - pointer to options_display structure
| 
|        Output: none
|    Written By: conductor -name animate -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_display(
     options_display *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'animate->options->display' Pane Info structure
	 */

	if (paneinfo->norm_type_struct != NULL)
	{
	    selection = paneinfo->norm_type_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_CYCLE_VAL,
	                    &(paneinfo->norm_type));
	    if (paneinfo->norm_type_label != NULL) kfree(paneinfo->norm_type_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_CYCLE_LABEL,
	                    &(paneinfo->norm_type_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->norm_type_selected));
	    }

	}

	if (paneinfo->norm_method_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->norm_method_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->norm_method_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->norm_method_val = atoi(value_string);
	    kfree(value_string);
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->norm_method_selected));
	    }

	}

	if (paneinfo->red_mapcol_struct != NULL)
	{
	    selection = paneinfo->red_mapcol_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->red_mapcol));

	}

	if (paneinfo->green_mapcol_struct != NULL)
	{
	    selection = paneinfo->green_mapcol_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->green_mapcol));

	}

	if (paneinfo->blue_mapcol_struct != NULL)
	{
	    selection = paneinfo->blue_mapcol_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->blue_mapcol));

	}

	if (paneinfo->red_function_struct != NULL)
	{
	    selection = paneinfo->red_function_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->red_function != NULL) kfree(paneinfo->red_function);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->red_function));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->red_function_selected));
	    }

	}

	if (paneinfo->green_function_struct != NULL)
	{
	    selection = paneinfo->green_function_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->green_function != NULL) kfree(paneinfo->green_function);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->green_function));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->green_function_selected));
	    }

	}

	if (paneinfo->blue_function_struct != NULL)
	{
	    selection = paneinfo->blue_function_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->blue_function != NULL) kfree(paneinfo->blue_function);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->blue_function));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->blue_function_selected));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_lists
| 
|       Purpose: Extracts information from lists pane
| 
|         Input: paneinfo - pointer to options_lists structure
| 
|        Output: none
|    Written By: conductor -name animate -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_lists(
     options_lists *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'animate->options->lists' Pane Info structure
	 */

	if (paneinfo->animate_list_struct != NULL)
	{
	    selection = paneinfo->animate_list_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->animate_list));
	    if (paneinfo->animate_list_label != NULL) kfree(paneinfo->animate_list_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->animate_list_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->animate_list_selected));
	    }

	}

	if (paneinfo->band_list_struct != NULL)
	{
	    selection = paneinfo->band_list_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->band_list));
	    if (paneinfo->band_list_label != NULL) kfree(paneinfo->band_list_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->band_list_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->band_list_selected));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_colormap
| 
|       Purpose: Extracts information from colormap pane
| 
|         Input: paneinfo - pointer to options_colormap structure
| 
|        Output: none
|    Written By: conductor -name animate -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_colormap(
     options_colormap *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'animate->options->colormap' Pane Info structure
	 */

	if (paneinfo->wksp1_struct != NULL)
	{
	    selection = paneinfo->wksp1_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(paneinfo->wksp1));
	    }

	}

	if (paneinfo->wksp2_struct != NULL)
	{
	    selection = paneinfo->wksp2_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(paneinfo->wksp2));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_function
| 
|       Purpose: Extracts information from function pane
| 
|         Input: paneinfo - pointer to options_function structure
| 
|        Output: none
|    Written By: conductor -name animate -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_function(
     options_function *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'animate->options->function' Pane Info structure
	 */

	if (paneinfo->create_struct != NULL)
	{
	    selection = paneinfo->create_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->create));

	}

	if (paneinfo->expr_struct != NULL)
	{
	    selection = paneinfo->expr_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->expr != NULL) kfree(paneinfo->expr);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->expr));
	    }

	}

	if (paneinfo->wbegin_struct != NULL)
	{
	    selection = paneinfo->wbegin_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_DOUBLE_VAL,
	                    &(paneinfo->wbegin));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->wbegin_optsel));
	    }

	}

	if (paneinfo->wend_struct != NULL)
	{
	    selection = paneinfo->wend_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_DOUBLE_VAL,
	                    &(paneinfo->wend));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->wend_optsel));
	    }

	}

	if (paneinfo->wsize_struct != NULL)
	{
	    selection = paneinfo->wsize_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->wsize));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->wsize_optsel));
	    }
	}

	if (paneinfo->hbegin_struct != NULL)
	{
	    selection = paneinfo->hbegin_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_DOUBLE_VAL,
	                    &(paneinfo->hbegin));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->hbegin_optsel));
	    }

	}

	if (paneinfo->hend_struct != NULL)
	{
	    selection = paneinfo->hend_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_DOUBLE_VAL,
	                    &(paneinfo->hend));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->hend_optsel));
	    }

	}

	if (paneinfo->hsize_struct != NULL)
	{
	    selection = paneinfo->hsize_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->hsize));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->hsize_optsel));
	    }
	}

	if (paneinfo->dbegin_struct != NULL)
	{
	    selection = paneinfo->dbegin_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_DOUBLE_VAL,
	                    &(paneinfo->dbegin));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->dbegin_optsel));
	    }

	}

	if (paneinfo->dend_struct != NULL)
	{
	    selection = paneinfo->dend_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_DOUBLE_VAL,
	                    &(paneinfo->dend));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->dend_optsel));
	    }

	}

	if (paneinfo->dsize_struct != NULL)
	{
	    selection = paneinfo->dsize_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->dsize));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->dsize_optsel));
	    }
	}

	if (paneinfo->tbegin_struct != NULL)
	{
	    selection = paneinfo->tbegin_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_DOUBLE_VAL,
	                    &(paneinfo->tbegin));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->tbegin_optsel));
	    }

	}

	if (paneinfo->tend_struct != NULL)
	{
	    selection = paneinfo->tend_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_DOUBLE_VAL,
	                    &(paneinfo->tend));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->tend_optsel));
	    }

	}

	if (paneinfo->tsize_struct != NULL)
	{
	    selection = paneinfo->tsize_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->tsize));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->tsize_optsel));
	    }
	}

	if (paneinfo->ebegin_struct != NULL)
	{
	    selection = paneinfo->ebegin_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_DOUBLE_VAL,
	                    &(paneinfo->ebegin));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->ebegin_optsel));
	    }

	}

	if (paneinfo->eend_struct != NULL)
	{
	    selection = paneinfo->eend_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_DOUBLE_VAL,
	                    &(paneinfo->eend));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->eend_optsel));
	    }

	}

	if (paneinfo->esize_struct != NULL)
	{
	    selection = paneinfo->esize_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->esize));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->esize_optsel));
	    }
	}

	if (paneinfo->type_struct != NULL)
	{
	    selection = paneinfo->type_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->type));
	    if (paneinfo->type_label != NULL) kfree(paneinfo->type_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->type_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->type_optsel));
	    }

	}

}


