 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for animate
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "animate.h"

clui_info_struct *clui_info = NULL;

gui_info_struct *gui_info;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Interactive Animation of Image Sequence
|
|       Purpose: main program for animate
|
|         Input:
|		Optional M.E. group:
|		    char *clui_info->i_file; {Filename of Input Object Containing Multiple Images}
|		    int   clui_info->i_flag; {TRUE if -i specified}
|
|		    char *clui_info->base_string; {Basename for a Set of Image Files}
|		    int   clui_info->base_flag; {TRUE if -base specified}
|
|		char *clui_info->c_file; {Filename of Input Object with Clip Mask}
|		int   clui_info->c_flag; {TRUE if -c specified}
|
|		char *clui_info->cmap_file; {Filename of Input Object with Alternate Colormap}
|		int   clui_info->cmap_flag; {TRUE if -cmap specified}
|
|		int clui_info->use_cmap_logic; {Use colormap?}
|		int clui_info->use_cmap_flag; {TRUE if -use_cmap specified}
|
|		int clui_info->x_int; {x location of GUI}
|		int clui_info->x_flag; {TRUE if -x specified}
|
|		int clui_info->y_int; {y location of GUI}
|		int clui_info->y_flag; {TRUE if -y specified}
|
|		float clui_info->update_float; {initial update time}
|		int   clui_info->update_flag; {TRUE if -update specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *form;            /* form tree representing *.form file */
	char   *form_filestring; /* *.form file for animate    */ 
	char   *form_pathname;   /* location of animate.form   */
	char   *form_fullpath;   /* expanded animate.form path */
	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	xvobject label, parent, offset;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "ENVISION");
	kexit_handler(animate_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_XVROUTINE, "ENVISION", "animate",
		animate_usage_additions);

	animate_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

	/*
	 * Initialize xvwidgets lib
	 */
	if (!(xvw_initialize(XVW_MENUS_XVFORMS)))
	{
	     kinfo(KSTANDARD, "Could not open connection to server");
	     kexit(KEXIT_FAILURE);
	}

	/*
	 * Set location of animate.form
	 */
	if (clui_info->form_flag)
	{
	    form_filestring = kstrdup(clui_info->form_file);
	    form_pathname   = NULL;
	}
	else
	{
	    form_filestring = kstrdup("animate.form");
	    form_pathname   = kstrdup("$TOOLBOX/objects/xvroutine/animate/uis");
	}
	form_fullpath   = kfullpath(form_filestring, form_pathname, NULL);

	/*
	 * Allocate the GUI Info structure 
	 */
	gui_info = (gui_info_struct *)
				kcalloc (1, sizeof (gui_info_struct));
	/*
	 * Create the forms for animate 
	 */
	form = xvf_create_form(form_fullpath, NONE, run_animate, gui_info,
				clui_info->x_int, clui_info->y_int,
				XVF_PARTIAL_EDIT);
	if (form == NULL)
	   kexit(KEXIT_FAILURE);

	/*
	 * Initialize the GUI Info structure 
	 */
	if (!(_xvf_init_animate(form, gui_info)))
	    kexit(KEXIT_FAILURE);

/* -main_before_lib_call */
	/*
	 *  Create the animate object
	 */
	animate = xvw_create_animate(gui_info->object, "animate");
	xvw_set_attributes(animate,
		XVW_BORDER_WIDTH, 0,
		XVW_RIGHT_OF, NULL,
		XVW_BELOW, NULL,
		XVW_ANIMATE_UPDATETIME, clui_info->update_float,
		NULL);

	/*
	 *  Create the panicon object
	 */
	offset = xvf_get_xvobject(gui_info->options_struct,XVF_BUTTON_OBJ,TRUE);
	parent = xvf_get_xvobject(gui_info->animate_struct, XVF_BACKPLANE,TRUE);

	panicon = xvw_create_panicon(parent, "panicon");
	xvw_set_attributes(panicon,
		XVW_BELOW,      offset,
		XVW_RIGHT_OF,   NULL,
		XVW_VERT_DIST,  15,
		XVW_HORIZ_DIST, 15,
		NULL);

	label = xvw_create_labelstr(gui_info->object, "label");
	xvw_set_attributes(label,
		XVW_RIGHT_OF, NULL,
		XVW_BELOW,    animate,
		XVW_LABEL,    " Animation Frame Number: ",
		NULL);

	framenum = xvw_create_labelstr(gui_info->object, "framenum");
	xvw_set_attributes(framenum,
		XVW_RIGHT_OF, label,
		XVW_BELOW,    animate,
		XVW_FORCE_REDISPLAY, TRUE,
		NULL);
	xvw_insert_callback(animate, XVW_ANIMATE_CALLBACK, FALSE,
		update_framenum, (kaddr) framenum);

	startup_from_clui();
/* -main_before_lib_call_end */

/* -main_library_call */
	xvf_run_form();
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */

	kfree(form_filestring);
	kfree(form_pathname);
	kfree(form_fullpath);

	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: animate_usage_additions
| 
|       Purpose: Prints usage additions in animate_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname animate
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void animate_usage_additions(void)
{
	kfprintf(kstderr, "\tInteractive Animation of Image Sequence\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: animate_free_args
| 
|       Purpose: Frees CLUI struct allocated in animate_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname animate
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
animate_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
		kfree(clui_info->form_file);
	kfree(clui_info->i_file);
	kfree(clui_info->c_file);
	kfree(clui_info->cmap_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
