 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kautocolor
   >>>> 
   >>>>    Written By: Mark Young
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kautocolor_h_
#define _kautocolor_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <envision.h>

/* -include_includes */
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$ENVISION/objects/kroutine/kautocolor/uis/kautocolor.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 * autocolor by (Required integer toggle)
 *	0 (Original Colormap)
 *	1 (rgb cube)
 *	2 (rgb triangle)
 *	3 (rgb spiral)
 *	4 (hls spiral)
 *	5 (hsv rings)
 *	6 (hls rings)
 *	7 (rgb distance)
 *	8 (cie diagram)
 *	9 (density slice)
 *	10 (grey scale)
 *	11 (Equalize each column component globally)
 *	12 (Stretch each column component independently)
 *	13 (Normalize according to Standard Deviation)
 *	14 (Scientific American pseudocolor)
 *	15 (rainbow)
 *	16 (disjoint greycode)
 *	17 (greycode)
 *	18 (3-3-2 Filter)
 *	19 (Random Map),
 */
int	 autocolor_toggle;		/* autocolor by INT TOGGLE */
int	 autocolor_flag;		/* autocolor by FLAG */

/*
 *  Resulting output data object (required outfile)
 */
char	*o_file;	/* Resulting output data object FILENAME */
int	 o_flag;	/* Resulting output data object FLAG */

/*
 *  First Input data object (optional infile)
 */
char	*i_file;	/* First Input data object FILENAME */
int	 i_flag;	/* First Input data object FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kautocolor_get_args PROTO((kform *));
void kautocolor_usage_additions PROTO((void));
void kautocolor_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
