#include <xvinclude.h>

void  quit_program       PROTO((xvobject, kaddr, XEvent *));
void  region_of_interest PROTO((xvobject, kaddr, kaddr));

xvobject img_visual_obj; /* image object to display entire image */

/*
 * This program puts up an image object displaying the entire image; it
 * also creates a smaller image object to the lower right in which a region
 * of interest can be displayed.  
 *
 * A button is created, labeled "Extract Region of Interest".  When you click
 * on the button, a callback installed on the button allows you to rubber-band 
 * a rectangle about the desired region of interest;  that region of interest 
 * will then be displayed in the smaller image object to the lower right.
 *
 */

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject manager;        /* backplane for both image objects */
	xvobject button;         /* button to start ROI extraction */
        xvobject roi_visual_obj; /* image object to display ROI */
	kobject  data_obj;

	/* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* initialize the xvwidgets library */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }
	
	/* create a manager backplane */
	manager = xvw_create_manager(NULL, "parent");

	/* create the image object which will display the entire image */
        img_visual_obj = xvw_create_image(manager, "image");

	/* associate the image data with the image visual object */
	data_obj = kpds_open_input_object("image:lizard");
        xvw_set_attribute(img_visual_obj, XVW_IMAGE_IMAGEOBJ, data_obj);

	/*
	 *  change the size of the data object to be 100x100 so that the
	 *  roi image object will initially display the upper-left hand
	 *  corner of the image. 
	 */
	kpds_set_attribute(data_obj, KPDS_VALUE_SIZE, 100, 100, 1, 1, 1);

	/* create the image object which will display the region of interest */
        roi_visual_obj = xvw_create_image(manager, "image");
        xvw_set_attributes(roi_visual_obj,
		           XVW_BELOW,    img_visual_obj,
		           XVW_RIGHT_OF, img_visual_obj,
        		   XVW_IMAGE_IMAGEOBJ, data_obj,
		           NULL);

	/* add the action handler to quit the program */
	xvw_add_action(img_visual_obj, "<Key>q", quit_program, NULL, TRUE);

	/*
	 * create button to initiate region of interest extraction process.
	 */
	button = xvw_create_button(manager, "button");
	xvw_set_attributes(button,
			   XVW_BELOW,       img_visual_obj,
			   XVW_LEFT_OF,     roi_visual_obj,
			   XVW_LABEL,      "Extract Region of Interest",
			   XVW_CHAR_HEIGHT, 2.0,
			   NULL);

	/* install callback to acquire the ROI */
	xvw_insert_callback(button, XVW_BUTTON_SELECT, FALSE,
			region_of_interest, (kaddr) roi_visual_obj);

	/* display and run */
        xvf_run_form();
}

/*
 *  event handler to get region of interest and display the
 *  region of interest in the smaller image visual object.
 */
void  region_of_interest(
    xvobject object, 
    kaddr    client_data,  
    kaddr    call_data)
{
	kobject  iobject = NULL;
 	xvobject roi_visual_obj = (xvobject) client_data;

	/* 
	 * simply getting the XVW_IMAGE_ROI attribute causes all
	 * the work to be done automatically;  the user is prompted to
         * rubberband the area of interest, the rubberbanding is performed,
	 * and a data object containing the extracted region of interest
	 * is returned.
	 */
        xvw_get_attribute(img_visual_obj, XVW_IMAGE_ROI, &iobject);
	if (iobject == NULL) return;

	/*
	 * region of interest successfully extracted; update image object
	 */
	xvw_set_attribute(roi_visual_obj, XVW_IMAGE_IMAGEOBJ, iobject);
	kpds_close_object(iobject);
}


/*
 *  action handler to quit program on Key Press 'q'
 */
void  quit_program(
   xvobject object,
   kaddr    client_data,
   XEvent   *event)
{
        xvw_destroy(object);
        kexit(KEXIT_SUCCESS);
}

