#include <xvinclude.h>

/* 
 *  This introductory program creates a 3D Constant shade plot from the 
 *  information stored in a VIFF file, and installs a colormap on it.
 */
void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject plot3d;
	kobject  data_object;
	char *filename = "image:flow";

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/* use filename specified on cmd line (if any) */
	if (argc > 1)
	    filename = argv[1];

	/* open the data object defined by file */
	data_object = kpds_open_input_object(filename);

	/* autocolor the map for the data object so it looks prettier */
	kcolor_set_attribute(data_object, KCOLOR_MAP_AUTOCOLOR, KRGB_SPIRAL);

	/* create a 3D color mesh plot from the VIFF file */
	plot3d = xvw_create_plot3d(NULL, "Plot3D");
	xvw_set_attributes(plot3d, 
			   XVW_PLOT3D_PLOTOBJ,   data_object,
			   XVW_PLOT3D_PLOTTYPE,  KPLOT3D_CONSTANT_SHADING,
                           XVW_GRAPHICS_VIEWPORT_MIN_X, 0.15,
                           XVW_GRAPHICS_VIEWPORT_MIN_Y, 0.15,
                           XVW_GRAPHICS_VIEWPORT_MIN_Z, 0.15,
                           XVW_GRAPHICS_VIEWPORT_MAX_X, 0.85,
                           XVW_GRAPHICS_VIEWPORT_MAX_Y, 0.85,
                           XVW_GRAPHICS_VIEWPORT_MAX_Z, 0.85,
			   NULL);

	/* set background of parent to black to make colormesh show up */
	xvw_set_attribute(xvw_parent(plot3d), XVW_BACKGROUND_COLOR, "black");

	/* display & run; there is no way to exit the program but ^C */
	xvf_run_form();
}
