#include <xvinclude.h>


/*
 *  Creates a pixmap in a window and makes the pixmap 
 *  roam around by using a timeout
 */
void roam_timeout   PROTO((xvobject, kaddr, int *));

float roam_time       = 0.05;
int   roam_increment  = 3;

#define WIDTH 500
#define HEIGHT 500

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	char     *filename = "eyeguy.xpm";
	xvobject pixmap, manager;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/*  initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/* use filename specified on cmd line if provided */
	if (argc > 1)
	   filename = argv[1];

	/* create manager backplane for the pixmap */
	manager = xvw_create_manager(NULL, "manager");
	xvw_set_attributes(manager, XVW_WIDTH, WIDTH, XVW_HEIGHT, HEIGHT, NULL);

	/* create pixmap with default starting position */
	pixmap = xvw_create_pixmap(manager, "pixmap");
	xvw_set_attributes(pixmap,
		           XVW_PIXMAP_FILENAME, filename,
		           XVW_XPOSITION,       WIDTH/2,
		           XVW_YPOSITION,       HEIGHT/2,
		           NULL);

	xvw_add_timeout(pixmap, roam_time, roam_timeout, NULL);

	/* display & run */
	xvf_run_form();
}

void roam_timeout(
   xvobject object,
   kaddr    client_data,
   int      *dispatch)
{
	int        current, x, y, width, height;
	xvobject   pixmap = object;
	double     noise;
	static int direction = 0;

	/*
	 *  Retrieve the current x & y position, width & height.
	 */
	xvw_get_attributes(pixmap,
		XVW_XPOSITION, &x,
		XVW_YPOSITION, &y,
		XVW_WIDTH,  &width,
		XVW_HEIGHT, &height,
		NULL);

	/*
	 *  assign xposition and yposition, since these are of type Dimension,
	 *  which are unsigned longs.  This causes problems with wrap-around.
	 */
	switch (direction)
	{
	    case  0:
		  x += roam_increment;
		  break;

	    case  1:
		  x += roam_increment;
		  y += roam_increment;
		  break;

	    case  2:
		  y += roam_increment;
		  break;

	    case  3:
		  x -= roam_increment;
		  y += roam_increment;
		  break;

	    case  4:
		  x -= roam_increment;
		  break;

	    case  5:
		  x -= roam_increment;
		  y += roam_increment;
		  break;

	    case  6:
		  y -= roam_increment;
		  break;

	    case  7:
		  x += roam_increment;
		  y -= roam_increment;
		  break;

	    default:
		  kfprintf(kstderr,"Unknown direction (%d).\n", direction);
	}

	/*
	 *  Make sure we are not trying to set the offset past the edge of
	 *  the object.
	 */
	if (x < 0 || x+width  > WIDTH ||
	    y < 0 || y+height > HEIGHT)
	{
	   if ((x+width/2) > WIDTH)
	      x = WIDTH - width/2;
	   if ((x-width/2) < 0)
	      x = width/2;

	   if ((y+height/2) > HEIGHT)
	      y = HEIGHT - height;
	   if ((y-height/2) < 0)
	      y = height/2;

	   kgen_gauss(1,0.0,0.5,&noise);
	   current = ((int) noise) % 8;
	   if (current < 0)
	      current += 8;
	   if (current == 0)
	      current = 1;

	   direction = (direction + current) % 8;
	}

	/*
	 *  Set the newly acquired x & y offset....
	 */
	xvw_set_attributes(pixmap,
		XVW_XPOSITION, x,
		XVW_YPOSITION, y,
		NULL);
}
