#include <xvinclude.h>

void  quit_program PROTO((xvobject, kaddr, XEvent *));

/*
 *  Here, the Khoros Manager widget that is to serve as the 
 *  parent for the image object is created specifically;  the
 *  toplevel widget is created automatically since the first parameter
 *  to xvw_create_manager() is NULL. An image object is created within
 *  the parent, and an action handler installed that uses the client_data 
 *  pointer to pass a string as a parameter.  A pop-up information object
 *  is used.
 */
void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject parent;
	xvobject img_visual_obj;
	char *filename = "image:kitten";

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* initialize the xvwidgets library */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror("test", "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/* 
         * create the Khoros Manager to be the parent of the 
         * image visual object. Let the toplevel be created by default.
	 */
	parent = xvw_create_manager(NULL, "parent");
	xvw_set_attributes(parent, XVW_WIDTH,  256, XVW_HEIGHT, 256, NULL);

	/* pop up information message.  */
	kinfo(KSTANDARD, "You should now have an empty toplevel window that is 256x256.  Click on 'ok' and the kitten image will be displayed");

	/* Create the image visual object using the manager widget as parent */
	img_visual_obj = xvw_create_image(parent, "image");

	/* associate the image we just read in w/ the image xvobject */
	xvw_set_attribute(img_visual_obj, XVW_IMAGE_IMAGEFILE, filename);

	/* add an action handler to quit on Key Press Q or q */
        xvw_add_action(img_visual_obj, "<Key>q", quit_program, 
	 	       filename, TRUE);

	xvf_run_form();
}

/*
 * action handler allowing the user to quit program
 */
void  quit_program(
   xvobject object,
   kaddr    client_data,
   XEvent   *event)
{
	char *filename = (char *) client_data;

	kinfo(KSTANDARD, "This was the kitten image, keyword '%s', Meow!", 
	      filename);
        xvw_destroy(object);
        kexit(KEXIT_SUCCESS);
}

