#include <xvinclude.h>

void  quit_program PROTO((xvobject, kaddr, XEvent *, Boolean *));

/*
 * This program reads in the ball image, and then uses polymorphic data 
 * services to increase the size of the of ball by padding with a value 
 * of 150; this produces a grey border to the right and bottom of the image. 
 * The large, padded image is displayed. An event handler exits program 
 * on key press 'Q' or 'q'.
 */
void main(
int  argc,
   char *argv[],
   char *envp[])
{
	kobject  image;
        xvobject object;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* initialize xvwidgets lib */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "Unable to open display");
           kexit(KEXIT_FAILURE);
        }

	/* create the xvobject to display the image */
        object = xvw_create_image(NULL, "image");

	/*
	 *  read in the ball image;  double its size through a padding
         *  interpolation, with a pad value of 150.0 (a lovely grey).
         *  the image will appear in the upper left corner of the window,
         *  the rest of the window will have pixels w/ a value of 150. 
	 */
	image = kpds_open_input_object("image:ball");
	kpds_set_attribute(image, KPDS_VALUE_SIZE,
			   1024, 1024, 1, 1, 1);
	kpds_set_attribute(image, KPDS_VALUE_INTERPOLATE, KPAD);
	kpds_set_attribute(image, KPDS_VALUE_PAD_VALUE, 150.0, 150.0);

	/* associate the image we just read in w/ the image xvobject */
        xvw_set_attribute(object, XVW_IMAGE_IMAGEOBJ, image);

	/*
	 * add an event handler to quit the program on Key Press Q or q.
	 */
	xvw_add_event(object, KeyPressMask, quit_program, NULL);

        xvf_run_form();
}

/*
 * event handler allowing the user to quit program
 */
void  quit_program(
   xvobject object,
   kaddr    clientData,
   XEvent   *event,
   Boolean  *dispatch)
{
	char   ch;

	if (XLookupString(&(event->xkey), &ch, 1, NULL, NULL)  == 0)
            return;
	if (ch != 'q' && ch != 'Q')
	    return;
	xvw_destroy(object);
	kexit(KEXIT_SUCCESS);
}

