#include <xvinclude.h>

void quit_example PROTO((xvobject, kaddr, XEvent *, Boolean *));

/*
 * This program uses polymorphic data services to create a data object 
 * containing a sinusoid, and puts up an image visual object to display the 
 * sinusoidal image. An event handler allows you to hit 'q' or 'Q' to quit.
 */

#define WIDTH  512
#define HEIGHT 512
void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	int	 i; 
	xvobject img_object;     /* visual object to display   */
	kobject  data_object;       /* data object defining image */
	unsigned char *data = NULL;  /* data values for image      */

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* initialize the xvwidgets library */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/*
	 *  Now create the sinusodal data object to be displayed:
	 *  create the object using kpds_create_object(), instantiate
	 *  a value segment with a particular size and data type
	 */
	data = (unsigned char *) kmalloc(sizeof(unsigned char) * WIDTH);

	data_object = kpds_create_object();
	kpds_create_value(data_object);
	kpds_set_attribute(data_object, KPDS_VALUE_SIZE, 
			   WIDTH, HEIGHT, 1, 1, 1);
	kpds_set_attribute(data_object, KPDS_VALUE_DATA_TYPE, KUBYTE);

	/*
	 *  give sinusoidal values to the image data
	 */
	for (i = 0; i < WIDTH; i++)
	   data[i] = (unsigned char)(128.0 * ksin(i*15.0/WIDTH)) + 127;

	for (i = 0; i < HEIGHT; i++)
	   kpds_put_data(data_object, KPDS_VALUE_LINE, data);

	kfree(data);

	/*
	 *  Create the image visual object in which to 
         *  display our image data object.
	 */
	img_object = xvw_create_image(NULL, "image");
	xvw_set_attribute(img_object, XVW_IMAGE_IMAGEOBJ, data_object);

	/* 
	 * add event handler to quit program on KeyPress Q or q.
         * since a "kobject" is really a pointer, we can pass it as
         * the client data directly (as data_object, instead of &img_data_obj) 
	 */
	xvw_add_event(img_object, KeyPressMask,
		      quit_example, data_object);

	/* display & run */
	xvf_run_form();
}

/*
 * the event handler which will quit the program on KeyPress Q or q
 */
void  quit_example(
   xvobject object,  
   kaddr    client_data,
   XEvent   *event,
   Boolean  *dispatch)
{
	char    ch;
	kobject data_object;

	data_object = (kobject) client_data;  /* cast ptr to image data obj */

	if (XLookupString(&(event->xkey), &ch, 1, NULL, NULL)  == 0)
              return;
	if (ch != 'q' && ch != 'Q') return;

	xvw_destroy(object);	          /* destroy image visual object */
	kpds_close_object(data_object);  /* close image data object     */
	kexit(KEXIT_SUCCESS);                       
}

