#include <xvinclude.h>

/*
 *  This example creates a polyline object.
 */
void main(int  argc,
   char *argv[],
   char *envp[])
{
        xvobject parent, polyline;
	Coord	 points[6];
	int      i, numpts = knumber(points);

	/* initialize Khoros program */
	khoros_initialize(argc, argv, envp, "ENVISION");

        /* initialize the xvwidgets lib */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }

	/* create a manager to act as backplane for polyline */
	parent = xvw_create_manager(NULL, "parent");
	xvw_set_attributes(parent,
			   XVW_WIDTH,  200,
			   XVW_HEIGHT, 100,
			   XVW_SELECTABLE, TRUE,
			   XVW_RESIZABLE, TRUE,
			   NULL);

	/* initialize polyline points */
	for (i = 0; i < numpts; i++)
	{
	   points[i].x = i;
	   if ((i % 2) == 0)
	       points[i].y = i/2;
	   else points[i].y = -i/2;
	   points[i].z = 0;
	   points[i].d = 0;
	}

	/*
	 *  create the polyline object;  set the points and the number of
         *  points; make it menuable so user has access to its
         *  internal menuform.
         */
        polyline = xvw_create_polyline(parent, "polyline");
        xvw_set_attributes(polyline,
		           XVW_POLYLINE_POINTS,	   points,
		           XVW_POLYLINE_NUMPTS,	   numpts,
		           XVW_MENUABLE,	   TRUE,
		           XVW_GRAPHICS_LINEWIDTH, KLINE_MEDIUM,
		           XVW_FOREGROUND_COLOR,   "blue",
		           NULL);
        /* display & run the program */
        xvf_run_form();
}
