#include <xvinclude.h>

/*
 *  This program does an animation sequence. The animation data
 *  is read in, the animation visual object is created, the visual object
 *  is associated with the animation data, and the animation is run.
 */
void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	kobject  data_object;
	xvobject animate;
	char *filename = "sequence:baby";

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

        /* allow different images to be used, as in "% example sequence:bush" */
        if (argc > 1)
           filename = argv[1];

	/* create data object from the input file */
	data_object = kpds_open_input_object(filename);

	/* give it a colormap to make it look pretty */
	kcolor_set_attribute(data_object, KCOLOR_MAP_AUTOCOLOR, KRGB_SPIRAL);

        /* initialize the xvwidgets lib */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }

	/* 
	 * create the animate object.  Set the animate object to operate on
         * the data object representing the input file, set the update time,
         * the animation control and the animation direction.   Note that 
         * the XVW_ANIMATE_DIRECTION attribute is an "action attribute"; setting
         * it to KANIMATE_DIRECTION_FORWARD has the effect of starting the
         * animation in a forward direction.
	 */
	animate = xvw_create_animate(NULL, "animate");
	xvw_set_attributes(animate, 
	                   XVW_IMAGE_IMAGEOBJ,     data_object,
	                   XVW_ANIMATE_UPDATETIME, 0.2,
	                   XVW_ANIMATE_CONTROL,    KANIMATE_CONTROL_AUTOREVERSE,
	                   XVW_ANIMATE_DIRECTION,  KANIMATE_DIRECTION_FORWARD,
	                   NULL);

	/* display & run */
	xvf_run_form();
}
