 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>         Special Purpose Functionality Routines for pane create
   >>>>
   >>>>  Private:
   >>>>         create_guide_button
   >>>>         create_subform_button
   >>>>         create_submenu
   >>>>         create_me_group_req
   >>>>         create_mi_group_opt
   >>>>         create_ls_group
   >>>>   Static:
   >>>>         create_group
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "guise.h"

static void create_group PROTO((int, int));

/*-----------------------------------------------------------
| 
|  Routine Name: create_guide_button
| 
|       Purpose: Do routine which is called when
|                  pane action button guide_button is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Aug 20, 1993
| Modifications: 
| 
------------------------------------------------------------*/
void create_guide_button(
     options_create *create_info)
{
	int       panenum, new_guidepane = FALSE; 
	float     save_x, save_y, save_width, save_height;
	kguide    *display_guide, *new_guide, *guide;
	ksubform  *display_subform;
	char      *name, *line = NULL, *guide_line = NULL;
	char      temp[KLENGTH];
	Line_Info line_info;
	char      *filename = EMPTY_FORM_UIS;
	kcontrol  *display_control, *display_pane, *guidepane;
	kselection *selection, *sel_list;

	/*
	 * kludge to force destination to be PANE to avoid error
	 * message.
	 */
	if (create_info->control_dest_val != KPANE)
	{
	    ksprintf(temp, "%d", KPANE);
	    xvf_set_attribute(create_info->control_dest_struct,
			      XVF_TOGGLE_VAL, temp);
	    create_info->control_dest_val = KPANE;
	}

	/*
	 * guide button / pane pair must go on guide pane
	 */
	display_control = find_displayed_control("create_guide_button",
                              "guide button", create_info->control_dest_val,
                              &display_subform, &display_guide, &display_pane);
	if (display_control == NULL) return;

	if (display_subform == NULL)
	{
	    kerror(NULL, "create_guide_button",
		   "No displayed subform to which to add new pane.");
	    return;
	}

	/* 
         * see how many guide buttons this will be 
         */
	panenum = find_pane_num(display_subform);

	/*
	 * find a variable & title name for the new guide/pane pair
	 */
	name = compose_gb_name(display_subform, &panenum);
	
	/*
	 * create the new guide button UIS line
	 */
	kvf_clear_line_info(&line_info);
	line_info.typeflag    = KUIS_GUIDEBUTTON;
	line_info.activate    = TRUE;
        line_info.variable    = kstrdup(name);
        line_info.title       = kstrdup(name);
        line_info.width       = 10.0;
        line_info.height      = 1.0;
        line_info.x           = 1.0;
        line_info.y           = panenum * 1.5;
        kvf_gen_deparse(&line_info, &guide_line);
        kvf_free_line_info_strings(&line_info);

	/*
	 * create new guide branch in form tree
	 */
	new_guide = xvf_create_new_guide(filename, guide_line);
	if (new_guide != NULL)
	    kvf_add_guide_to_subform(display_subform, new_guide);
	new_guide->selected = FALSE;
	new_guide->back_kformstruct = kvf_create_struct((kaddr) new_guide,
                                              KUIS_GUIDEBUTTON, KGUIDE);
        kvf_link_formstruct(new_guide->back_kformstruct);
        xvf_add_gui_callback(new_guide->pane->back_kformstruct,
                             KVF_PRINT_PANE, add_uis_misc_file, NULL);
        xvf_add_gui_callback(new_guide->pane->back_kformstruct,
                             "xvf_all_attributes", set_save_needed,
                             (kaddr) create_info->save_struct);
	/*
	 *  make sure variable on new -P line matches the new -g line;
	 */
	kvf_parse_startpane_line(new_guide->control_line, &line_info);
	kfree(line_info.variable);
	line_info.variable = kstrdup(name);
	kvf_deparse_startpane_line(&line_info, &new_guide->pane->control_line);
	kvf_deparse_startpane_line(&line_info, &new_guide->control_line);
	kvf_free_line_info_strings(&line_info);

        /*
         * create the guidepane back if necessary
         */
	guidepane = display_subform->guidepane;
	if (guidepane == NULL)
	{
	    kerror(NULL, "create_guide_button",
		   "Error creating new guide on guidepane");
	    return;
	}
	if (guidepane->back == NULL)
	{
	    guidepane->back = display_subform->back;

	    /* change the -G line that defines the guide pane */
	    kvf_parse_startguide_line(guidepane->control_line, &line_info);
	    line_info.width  = 15.0;
	    line_info.height = kmax(panenum*1.5,  
				    xvf_calculate_y_position(display_pane));
	    line_info.x      = 0.0;
	    line_info.y      = 1.0;
	    kfree(line_info.title);
	    line_info.title  = kstrdup("Guide Pane");
	    line_info.xpos   = 2.0;
	    kvf_deparse_startguide_line(&line_info, &guidepane->control_line);
            kvf_free_line_info_strings(&line_info);

	    /* scoot the current pane over to accomodate the new guide pane */
	    xvf_set_attributes(display_pane->back_kformstruct,
			       XVF_X,     16.0,
			       XVF_Y,     1.5, 
			       NULL);
	    /* 
	     * never did create a guide button for the 1st pane - do it now 
             */

	    /* get the variable name from the -P line */
	    kvf_parse_startpane_line(display_pane->control_line, &line_info);
            ksprintf(temp, "%s", line_info.variable);
	    kvf_free_line_info_strings(&line_info);
	
	    /* create the -g line */
	    kvf_clear_line_info(&line_info);
	    line_info.activate    = TRUE;
            line_info.typeflag    = KUIS_GUIDEBUTTON;
            line_info.variable    = kstrdup(temp);
            line_info.title       = kstrdup(temp);
            line_info.width       = 10.0;
            line_info.height      = 1.0;
            line_info.x           = 1.0;
            line_info.y           = 1.5;
            line_info.selected    = TRUE;
            kvf_deparse_guide_line(&line_info, &display_guide->line);
            kvf_free_line_info_strings(&line_info);

	    /* create actual guide button */
	    guidepane->guide_list->button = 
		xvf_create_guide_sel(display_guide, guidepane->back);
	    xvw_reverse_colors(guidepane->guide_list->button, TRUE);
            xvf_add_gui_callback(guidepane->guide_list->back_kformstruct,
                                 "xvf_all_attributes", set_save_needed,
                                 (kaddr) create_info->save_struct);

	    /* create a license button for the subform */
            kvf_clear_line_info(&line_info);
            line_info.typeflag    = KUIS_HELP;
            line_info.title       = kstrdup("License");
            line_info.description = kstrdup("displays license");
            line_info.help_file   = kstrdup("$BOOTSTRAP/repos/license/License");
            line_info.variable    = kstrdup("license");
            line_info.activate    = 1;
            line_info.width       = 10.5;
            line_info.x           = 39.0;
            line_info.y           = 0.0;
            line_info.height      = 1.0;
            kvf_gen_deparse(&line_info, &line);
            guidepane->sel_list = create_new_selection(guidepane, line);
            kvf_free_line_info_strings(&line_info);

	    /* create a help button for the subform */
            kvf_clear_line_info(&line_info);
            line_info.typeflag    = KUIS_HELP;
            line_info.title       = kstrdup("Help");
            line_info.description = kstrdup("display online help");
            line_info.help_file   = kstrdup("$GUI/help/menuform/Empty.doc");
            line_info.variable    = kstrdup("help");
            line_info.activate    = 1;
            line_info.width       = 6.0;
            line_info.x           = 51.0;
            line_info.y           = 0.0;
            line_info.height      = 1.0;
            kvf_gen_deparse(&line_info, &line);
            guidepane->sel_list->next = create_new_selection(guidepane, line);
            kvf_free_line_info_strings(&line_info);


            /* create a quit button for the subform */
            kvf_clear_line_info(&line_info);
            line_info.typeflag = KUIS_QUIT;
	    if (guidepane->back_form->master == NULL)
                line_info.title    = kstrdup("Quit");
	    else line_info.title    = kstrdup("Close");
            line_info.activate = 1;
            line_info.selected = 0;
            line_info.width    = 6.0;
            line_info.x        = 59.0;
            line_info.y        = 0.0;
            line_info.height   = 1.0;
            kvf_gen_deparse(&line_info, &line);
            guidepane->sel_list->next->next = 
			create_new_selection(guidepane, line);
            kvf_free_line_info_strings(&line_info);

	    new_guidepane = TRUE;
	}

	/*
	 *  find geometry of currently displayed pane; make geometry
	 *  of new pane match whatever it was.
	 */
	kvf_get_attributes(display_pane->back_kformstruct,
			   KVF_WIDTH,    &save_width,
			   KVF_HEIGHT,   &save_height,
			   KVF_X,        &save_x,
			   KVF_Y,        &save_y,
			   NULL);
	kvf_set_attributes(new_guide->pane->back_kformstruct,
			   KVF_WIDTH,    save_width,
                           KVF_HEIGHT,   save_height,
                           KVF_X,        save_x,
                           KVF_Y,        save_y,
                           KVF_VARIABLE, name,
                           NULL);
	/*
	 *  delete any QUIT buttons on original panes, delete QUIT buttons
	 */
	guide = guidepane->guide_list;
	while (guide != NULL)
	{

	    /* delete quit button if there is one */
	    sel_list = guide->pane->sel_list;
	    selection = kvf_find_specified_selection(sel_list, KUIS_QUIT, -1);
	    if (selection != NULL)
		xvf_delete_selection(selection);

	    /* delete license button if there is one */
	    sel_list = guide->pane->sel_list;
	    selection = kvf_find_specified_selection(sel_list, KUIS_HELP, 
					        kstring_to_token("license"));
	    if (selection != NULL)
		xvf_delete_selection(selection);
	    
	    /* move help button to right if there is one */
	    sel_list = guide->pane->sel_list;
	    selection = kvf_find_specified_selection(sel_list, KUIS_HELP, 
                                                kstring_to_token("help"));
	    if (selection != NULL)
	        xvf_set_attribute(selection->back_kformstruct, XVF_X, 42.0);

	    guide = guide->next;
	}

        /*
         * create the new guide buttton on the GUI
         */
        new_guide->button = xvf_create_guide_sel(new_guide, guidepane->back);

	/*
	 *  update Save button to Save(Needed)
	 */
	set_save_needed(create_info->save_struct, NULL, NULL, 
		        create_info->save_struct);

	/*
	 * change to the new pane, using new guide button
	 */
	xvf_guide_cb(new_guide->button, new_guide->back_kformstruct, NULL);
	
	/*
	 *  edit mode on for the guidepane backplane
	 */
	xvw_set_attribute(guidepane->back, XVW_EDIT_MODE_ON, TRUE);

	/*
	 * register callback to update Save button to Save(Needed) 
	 * for changes in the guide button, new pane.
	 */
	add_save_needed_callback(new_guide->back_kformstruct);
        add_save_needed_callback(new_guide->pane->back_kformstruct);
	xvf_add_gui_callback(new_guide->pane->back_kformstruct,
                             XVF_PRINT_PANE, add_uis_misc_file, NULL);

	/* 
	 * if we have just created the guidepane for the first time,
	 * switch "Create Selection On:" toggle to GuidePane,
	 */
	if (new_guidepane)
	{
	    ksprintf(temp, "%d", KGUIDEPANE);
	    xvf_set_attribute(create_info->control_dest_struct,
			          XVF_TOGGLE_VAL, temp);
	    create_info->control_dest_val = KGUIDEPANE;
	    create_control_dest(create_info);

	    
	}

	
}

/*-----------------------------------------------------------
|
|  Routine Name: create_subform_button
|
|       Purpose: Do routine which is called when
|                  pane action button subform_button is used
|
|         Input: create_info - ptr to PaneInfo struct for create pane
|
|        Output: None
|    Written By: Danielle Argiro
|          Date: Aug 22, 1993
| Modifications:
|
------------------------------------------------------------*/
void create_subform_button(
     options_create *create_info)
{
        int       subformnum, new_master = FALSE;
        ksubform  *subform, *new_subform;
        char      *name, *line = NULL, *subform_line = NULL;
        char      temp[KLENGTH];
        Line_Info line_info;
        char      *filename = EMPTY_FORM_UIS;
        kcontrol  *master;
	kform     *form = display_form;
	kselection *selection, *next_selection;

	kvf_clear_line_info(&line_info);

	if (form == NULL)
	{
	    kerror(NULL, "create_subform_button",
		   "No displayed GUI to which to add new subform.");
	    return;
	}

	/*
         * create the master if this is the first subform
         */
        if (form->master == NULL)
        {
	    /* create the most basic master control panel */
	    form->master = kvf_begin_control(form, NULL, NULL, KMASTER);
            form->master->subform_list = form->subform;
            form->master->subform_list->next = NULL;
            form->subform = NULL;
	    kvf_unlink_formstruct(form->master->subform_list->back_kformstruct);
            kfree(form->master->subform_list->back_kformstruct);
            form->master->subform_list->back_kformstruct =
                        kvf_create_struct((kaddr) form->master->subform_list,
                                           KUIS_SUBFORMBUTTON, KSUBFORM);
	    kvf_link_formstruct(form->master->subform_list->back_kformstruct);
	    line_info.logical_val = TRUE;
	    line_info.activate    = TRUE;
	    kvf_deparse_startmaster_line(&line_info, &form->master->control_line);
	    new_master = TRUE;

        }
	master = form->master;
	master->excl_subforms = TRUE;

	/*
	 *  adding the first subform to the master 
	 */
        if (master->back == NULL)
        {
	    /* set the master for mutually exclusive subforms */
            kvf_parse_startmaster_line(master->control_line, &line_info);
	    line_info.logical_val = TRUE;
            kvf_deparse_startmaster_line(&line_info, &master->control_line);
            kvf_free_line_info_strings(&line_info);

            /* change the -F line that defines the master's geometry */
            kvf_parse_startform_line(form->control_line, &line_info);
            kfree(line_info.title);
            line_info.title  = kstrdup("Master Form");
            line_info.width  = 30.0;
            line_info.height = 7.0;
            line_info.xpos   = 6.0;
            kvf_deparse_startform_line(&line_info, &form->control_line);

	    /* create the master toplevel */
	    form->toplevel = xvw_create_application_shell(line_info.variable,
                                                      NULL, NULL);
            xvw_set_attribute(form->toplevel, XVW_SHELL_TITLE, "Master Form");
	    if (form->toplevel == NULL)
            {
		errno = KWIDGET_CREATION;
                kerror(NULL, "xvf_create_master_form",
                      "Couldn't create toplevel object for master form");
                return;
            }

            /* create the master backplane */
            master->back = xvf_create_backplane((kaddr) form,
                                               KUIS_STARTFORM,
                                               form->toplevel, TRUE);
	    if (form->master->back == NULL)
            {
		errno = KWIDGET_CREATION;
                kerror(NULL, "xvf_create_master_form",
                       "Couldn't create backplane for master form");
                return;
            }
            kvf_free_line_info_strings(&line_info);

            /*
             * create a subform button for the 1st pane
             */
            /* get the variable name from the -M line */
	    subform = form->master->subform_list;
            kvf_parse_startpane_line(subform->control_line, &line_info);
            ksprintf(temp, "%s", line_info.variable);
            kvf_free_line_info_strings(&line_info);

            /* create the -d line */
            kvf_clear_line_info(&line_info);
            line_info.activate    = TRUE;
            line_info.typeflag    = KUIS_SUBFORMBUTTON;
            line_info.variable    = kstrdup(temp);
            line_info.title       = kstrdup(temp);
            line_info.width       = 10.0;
            line_info.height      = 1.5;
            line_info.x           = 1.0;
            line_info.y           = 1.5;
            line_info.selected    = 1;
            kvf_deparse_subformbutton_line(&line_info, &subform->line);
            kvf_free_line_info_strings(&line_info);

            /* create actual subform button */
            subform->button =
                xvf_create_subform_sel(subform, master->back);
	    subform->back_control = master;
            xvw_reverse_colors(subform->button, TRUE);
            xvf_add_gui_callback(subform->back_kformstruct,
                                 "xvf_all_attributes", set_save_needed,
                                 (kaddr) create_info->save_struct);
            xvf_add_gui_callback(subform->back_kformstruct,
                                 XVF_PRINT_SUBFORM, add_uis_misc_file, NULL);

	    /* map the master form */
	    xvf_map_form(form);

	    /* create a help button for the master */
	    kvf_clear_line_info(&line_info);
	    line_info.typeflag    = KUIS_HELP;
            line_info.title       = kstrdup("Help");
            line_info.description = kstrdup("display online help");
            line_info.help_file   = kstrdup("$GUI/help/menuform/Empty.doc");
            line_info.variable    = kstrdup("help");
            line_info.activate    = 1;
            line_info.width       = 6.0;
            line_info.x           = 49.0;
            line_info.y           = 0.0;
            line_info.height      = 1.0;
            kvf_gen_deparse(&line_info, &line);
            form->master->sel_list = create_new_selection(form->master, line);
	    kvf_free_line_info_strings(&line_info);


	    /* create a quit button for the master */
	    kvf_clear_line_info(&line_info);
            line_info.typeflag = KUIS_QUIT;
            line_info.title    = kstrdup("Quit");
            line_info.activate = 1;
            line_info.selected = 0;
            line_info.width    = 6.0;
            line_info.x        = 57.0;
            line_info.y        = 0.0;
            line_info.height   = 1.0;
            kvf_gen_deparse(&line_info, &line);
            form->master->sel_list->next = create_new_selection(form->master,
				                                line);
	    kvf_free_line_info_strings(&line_info);

	    /* create a license button for the master */
	    kvf_clear_line_info(&line_info);
            line_info.typeflag    = KUIS_HELP;
            line_info.title       = kstrdup("License");
            line_info.description = kstrdup("display license");
            line_info.help_file   = kstrdup("$BOOTSTRAP/repos/license/License");
            line_info.variable    = kstrdup("license");
            line_info.activate    = 1;
            line_info.selected    = 0;
            line_info.width       = 9.0;
            line_info.x           = 38.0;
            line_info.y           = 0.0;
            line_info.height      = 1.0;
            kvf_gen_deparse(&line_info, &line);
            form->master->sel_list->next->next = 
			create_new_selection(form->master, line);
	    kvf_free_line_info_strings(&line_info);
        }

	/*
	 *  adding the nth subform to the master 
	 */
	else
	{
	      /*
               *  set default values for action button
               */
            /* see how many subforms this will be */
            subformnum = find_subform_num(form);

            /* find a variable & title name for the new guide/pane pair */
            name = compose_sfb_name(form, &subformnum);

	    /* create the UIS line for the new subform button */
            kvf_clear_line_info(&line_info);
            line_info.typeflag    = KUIS_SUBFORMBUTTON;
            line_info.activate    = TRUE;
            line_info.variable    = kstrdup(name);
            line_info.title       = kstrdup(name);
            line_info.width       = 10.0;
            line_info.height      = 1.5;
            line_info.x           = 1.0;
            line_info.y           = xvf_calculate_y_position(form->master);
            kvf_gen_deparse(&line_info, &subform_line);
            kvf_free_line_info_strings(&line_info);

	    /* create new subform branch in form tree */
            new_subform = xvf_create_new_subform(filename, subform_line);
            if (new_subform != NULL)
                kvf_add_subform(form, new_subform);
            new_subform->selected = FALSE;
	    new_subform->back_kformstruct = 
				kvf_create_struct((kaddr) new_subform,
                                                   KUIS_STARTSUBFORM, KSUBFORM);
            kvf_link_formstruct(new_subform->back_kformstruct);

	    /* need to call add_uis_misc_file if *.subform created */
	    xvf_add_gui_callback(new_subform->back_kformstruct,
                                 XVF_PRINT_SUBFORM, add_uis_misc_file, NULL);
            xvf_add_gui_callback(new_subform->back_kformstruct,
                                 "xvf_all_attributes", set_save_needed,
                                 (kaddr) create_info->save_struct);


	    /* make sure variable on -M line matches variable on -d line */
            kvf_parse_startsubform_line(new_subform->control_line, &line_info);
            kfree(line_info.variable);
            line_info.variable = kstrdup(name);
            kvf_deparse_startsubform_line(&line_info, 
					  &new_subform->control_line);
            kvf_free_line_info_strings(&line_info);

	    /* create the new subform button on the GUI */
	    new_subform->button = xvf_create_subform_sel(new_subform, 
						         master->back);
	    new_subform->back_kformstruct->flag = KUIS_SUBFORMBUTTON;
	    new_subform->back_control = master;
            xvf_subform_cb(new_subform->button, 
	  	           new_subform->back_kformstruct, NULL);
	    add_save_needed_callback(new_subform->back_kformstruct);
            if (new_subform->back_kformstruct != NULL)
                xvf_add_gui_callback(new_subform->back_kformstruct,
                                     XVF_PRINT_SUBFORM,
                                     add_uis_misc_file, NULL);
	}

	/*
	 *  change any QUIT buttons on subforms to be named, "Close".
	 *  delete any Copyright buttons on subforms.
	 */
	subform = form->master->subform_list;
	while (subform != NULL)
	{
	    if (subform->guidepane != NULL)
	        selection = subform->guidepane->sel_list;
	    else selection = subform->guide->pane->sel_list;

	    while (selection != NULL)
	    {
	    	if (selection->type == KUIS_QUIT)
		{
		    xvf_set_attribute(selection->back_kformstruct,
		 	  	      XVF_TITLE, "Close");
		    selection = selection->next;
		}
		else if ((selection->type ==  KUIS_HELP) &&
			(selection->var_token == kstring_to_token("license")))
		{
		    next_selection = selection->next;
		    xvf_delete_selection(selection);
		    selection = next_selection;
		}
		else selection = selection->next;
		    
	    }
	    subform = subform->next;
	}

	set_save_needed(create_info->save_struct, NULL, NULL, 
		        create_info->save_struct);

	/* 
	 * if we have just created the master for the first time,
	 * switch "Create Selection On:" toggle to Master,
	 * change "Create Master" button to "New Subform"
	 */
	if (new_master)
	{
	    ksprintf(temp, "%d", KMASTER);
	    xvf_set_attribute(create_info->control_dest_struct,
			          XVF_TOGGLE_VAL, temp);
	    create_info->control_dest_val = KMASTER;
	    create_control_dest(create_info);
	    xvf_set_attribute(create_info->subform_button_struct, XVF_TITLE,
		              "New Subform");
	}
	add_save_needed_callback(form->master->back_kformstruct);


}

/*-----------------------------------------------------------
| 
|  Routine Name: create_submenu
| 
|       Purpose: Do routine which is called when
|                  pane action button submenu is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Jan 03, 1994
| Modifications: 
| 
------------------------------------------------------------*/
void create_submenu(
     options_create *create_info)
{
        char         *line = NULL;
        char         temp[KLENGTH];
        kselection   *submenu;
        static int   submenu_num = 1; 
        Line_Info    line_info;
        kcontrol     *display_control = NULL;
	xvobject     *gui_items;
	kform_struct *kformstruct;
	int          i, selected_num, control_type, ok = FALSE;

	/*
	 * see which buttons are selected, to go into submenu pulldown
	 */
	gui_items = get_selected_gui_items(&selected_num, &display_control,
				           &control_type);

	if (gui_items == NULL) return;

        for (i = 0; i < selected_num; i++)
        {
            /* get the kformstruct associated with the button */
            xvw_get_attribute(gui_items[i], XVW_MENU_CLIENTDATA, &kformstruct);

            switch(kformstruct->flag)
	    {	
		/* items that are ok for submenu inclusion */
		case KUIS_QUIT:
		case KUIS_HELP:
		case KUIS_PANEACTION:
		case KUIS_SUBFORMACTION:
		case KUIS_MASTERACTION:
		case KUIS_BLANK:
		case KUIS_ROUTINE:
		case KUIS_STARTSUBFORM:
		case KUIS_SUBFORMBUTTON:
		case KUIS_STARTGUIDE:
		case KUIS_GUIDEBUTTON:
		     ok = TRUE;
		     break;

		case KUIS_STARTSUBMENU:
		     kerror(NULL, "create_submenu",
			    "Can't incorporate a submenu into another submenu");
		     xvw_set_attribute(display_control->back,
				       XVW_SELECT_DELETE, gui_items[i]);
	             kfree(gui_items);
		     return;
		     break;
	    }
	}
	if (!ok) 
	{
	    kerror(NULL, "create_submenu",
		   "None of the selected items are valid for incorporation into a submenu.");
	    kfree(gui_items);
	    return;
	}

        /*
         *  set default values for submenu button
         */
        kvf_clear_line_info(&line_info);
        ksprintf(temp, "submenu%d", submenu_num++);
        line_info.typeflag    = KUIS_STARTSUBMENU;
        line_info.title       = kstrdup("SUBMENU");
	line_info.description = kstrdup("pulldown submenu");
        line_info.variable    = kstrdup(temp);
	line_info.activate    = 1.0;
        line_info.width       = 8.0;
        line_info.height      = 1.5;
        line_info.x           = 1.0;
        line_info.y           = xvf_calculate_y_position(display_control);
        kvf_gen_deparse(&line_info, &line);

	/*
	 * create the submenu selection
	 */
        submenu = create_new_selection(display_control, line);
        if (submenu == NULL)
            kerror(NULL, "create_submenu_sel",
                   "Unable to create submenu selection");

	
	/*
	 * incorporate each button into the pulldown submenu.  have to do this
         * backwards, since we are deleting items from the gui_items array 
         * (changing the array) as we go.
	 */
        for (i = selected_num-1; i >= 0; i--)
        {
	    /* get the kformstruct associated with the button */
            xvw_get_attribute(gui_items[i], XVW_MENU_CLIENTDATA, &kformstruct);

	    switch(kformstruct->type)
            {
		/* all buttons except subform buttons & guide buttons */
                case KSELECTION:
		     switch (kformstruct->Selptr->type)
		     {
			 case KUIS_QUIT:
			 case KUIS_HELP:
			 case KUIS_PANEACTION:
			 case KUIS_SUBFORMACTION:
			 case KUIS_MASTERACTION:
			 case KUIS_BLANK:
			 case KUIS_ROUTINE:

			      /* link the selection into the submenu list */
			      if (!(add_item_to_submenu(submenu, kformstruct)))
				  kerror(NULL, "create_submenu", 
					 "Unable to add item to submenu");

			      /* destroy the current button (not on submenu) */ 
			      xvw_destroy(kformstruct->Selptr->back);
			      break;

			 default:
			      kerror(NULL, "create_subform", 
				     "Can't incorporate GUI selection '%s' into submenu, because it is not a button or a label", kvf_ascii_typeflag(kformstruct->Selptr->type));
			      break;
		     }
		     break;
	
		case KSUBFORM:
		     if (kformstruct->Subformptr->button != NULL)
		     {
			if (!(add_item_to_submenu(submenu, kformstruct)))
                            kerror(NULL, "create_submenu", 
                                   "Unable to add suform button to submenu");
			xvw_destroy(kformstruct->Subformptr->button);
		     }
		     break;

		case KGUIDE:
		     if (kformstruct->Guideptr->button != NULL)
		     {
			if (!(add_item_to_submenu(submenu, kformstruct)))
                            kerror(NULL, "create_submenu", 
                                   "Unable to add guide button to submenu");
			xvw_destroy(kformstruct->Guideptr->button);
		     }
		     break;
	    }
	}

	xvf_create_submenu(submenu->submenu_next, control_type); 

        kvf_free_line_info_strings(&line_info);
        kfree(line);
}


/*-----------------------------------------------------------
|
|  Routine Name: create_me_group_req
|
|       Purpose: Do routine which is called when
|                  pane action button me_group_req is used
|
|         Input: create_info - ptr to PaneInfo struct for create pane
|
|        Output: None
|    Written By:
|          Date: Mar 01, 1994
| Modifications:
|
------------------------------------------------------------*/
void create_me_group_req(
     options_create *create_info)
{
	create_group(KUIS_MUTEXCL, TRUE);
}


/*-----------------------------------------------------------
|
|  Routine Name: create_me_group_opt
|
|       Purpose: Do routine which is called when
|                  pane action button me_group_opt is used
|
|         Input: create_info - ptr to PaneInfo struct for create pane
|
|        Output: None
|    Written By:
|          Date: Mar 01, 1994
| Modifications:
|
------------------------------------------------------------*/
void create_me_group_opt(
     options_create *create_info)
{
	create_group(KUIS_MUTEXCL, FALSE);
}



/*-----------------------------------------------------------
| 
|  Routine Name: create_mi_group
| 
|       Purpose: Do routine which is called when
|                  pane action button mi_group is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Mar 01, 1994
| Modifications: 
| 
------------------------------------------------------------*/
void create_mi_group(
     options_create *create_info)
{
	create_group(KUIS_MUTINCL, FALSE);
}


/*-----------------------------------------------------------
| 
|  Routine Name: create_ls_group
| 
|       Purpose: Do routine which is called when
|                  pane action button ls_group is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Mar 01, 1994
| Modifications: 
| 
------------------------------------------------------------*/
void create_ls_group(
     options_create *create_info)
{
	create_group(KUIS_GROUP, FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: create_group
|
|       Purpose: Utility function to create mutually exclusive,
|                mutually inclusive, and loose groups.
|
|         Input: flag - One of KUIS_MUTEXCL, KUIS_MUTINCL, KUIS_GROUP
|
|        Output: None
|    Written By: Danielle Argiro
|          Date: Mar 01, 1994
| Modifications:
|
------------------------------------------------------------*/

static void create_group(
    int flag,
    int required)
{
        char         *line = NULL;
        Line_Info    line_info;
        kcontrol     *display_control = NULL;
	xvobject     *gui_items;
	kform_struct *kformstruct;
	kselection   *me_group, *selection, *last_sel;
	int          i, optsel, optional, selected_num, control_type; 
	int          ok = FALSE;

	/*
	 * see which buttons are selected, to go into submenu pulldown
	 */
	gui_items = get_selected_gui_items(&selected_num, &display_control,
				           &control_type);

	/* nothing selected */
	if (gui_items == NULL) return;

	/* only one thing selected - not enough for a group */
	if (selected_num < 2)
	{
	    kerror(NULL, "create_group",
	          "You must select at least two items to create a group");
	    return;
	}

	/*
	 * general error-checking, setup pass on each selected item
	 */
        for (i = 0; i < selected_num; i++)
        {
            /* get the kformstruct associated with the button */
            xvw_get_attribute(gui_items[i], XVW_MENU_CLIENTDATA, &kformstruct);

            switch(kformstruct->flag)
	    {	
		/* 
		 * these selections are ok for group inclusion 
		 */
		case KUIS_INPUTFILE:
		case KUIS_OUTPUTFILE:
		case KUIS_STDIN:
		case KUIS_STDOUT:
		case KUIS_INTEGER:
		case KUIS_FLOAT:
		case KUIS_DOUBLE:
		case KUIS_STRING:
		case KUIS_LOGICAL:
		case KUIS_FLAG:
		case KUIS_CYCLE:
		case KUIS_LIST:
		case KUIS_DISPLAYLIST:
		case KUIS_STRINGLIST:
		case KUIS_TOGGLE:

		     /* make sure selection is optional for group membership */
		     xvf_get_attribute(kformstruct, XVF_OPTIONAL, &optional);
		     if (!optional)
			xvf_set_attribute(kformstruct, XVF_OPTIONAL, TRUE);

		     /* 
		      * for mutually exclusive and loose groups, just default 
                      * the first selection to be the selected group value 
		      */
		     if ((flag == KUIS_MUTEXCL) || (flag == KUIS_GROUP))
		     {
		         if (i == 0)
			 {
			    xvf_get_attribute(kformstruct, XVF_OPTSEL, &optsel);
			    if (!optsel)
			        xvf_set_attribute(kformstruct, XVF_OPTSEL, TRUE);
		         }
		         else 
			 {
                            xvf_get_attribute(kformstruct, XVF_OPTSEL, &optsel);
                            if (optsel)
			        xvf_set_attribute(kformstruct, XVF_OPTSEL, FALSE);
			 }
			    
		     }

		     /* 
                      * for mutually inclusive groups, default all selections
                      * to be turned on
		      */
		     else
                     {
                         xvf_get_attribute(kformstruct, XVF_OPTSEL, &optsel);
			 if (!optsel)
			     xvf_set_attribute(kformstruct, XVF_OPTSEL, TRUE);
		     }
		     ok = TRUE;
		     break;

		/*
	  	 * other selections not valid as group members
	         */
		default:
		     kerror(NULL, "create_group",
			    "Can't incorporate a %s into a group",
			    kvf_ascii_typeflag(kformstruct->flag));
		     break;
	    }
	}
	if (!ok) 
	{
	    kerror(NULL, "create_group",
		   "None of the selected items are valid for incorporation into a group.");
	    kfree(gui_items);
	    return;
	}

        /*
         *  set default values and create group header selection
         */
        kvf_clear_line_info(&line_info);
        line_info.typeflag    = flag;
        line_info.logical_val = required;
        kvf_gen_deparse(&line_info, &line);
        me_group = create_new_selection(display_control, line);
        if (me_group == NULL)
            kerror(NULL, "create_me_group",
                   "Unable to create ME group selection");
	/* selected field used to tell if it's required */
	me_group->selected = required;

	/*
	 * now, incorporate each selection into the group
	 */
        for (i = 0; i < selected_num; i++)
        {
	    /* 
	     * get the selection associated with the button 
	     */
            xvw_get_attribute(gui_items[i], XVW_MENU_CLIENTDATA, &kformstruct);
	    selection = kformstruct->Selptr;

	    /*
	     * just not sophisticated enough yet to deal with
	     * selections that are already in a group: protection
	     */
	    if (selection->back_group != NULL)
	    {
		kerror(NULL, "create_group", 
		       "Sorry, but I'm simply not smart enough yet to deal with selections that are already part of a group.  At least one of the selected items is already part of a group.  If you mean to move items from one group to another, or change the group type, or add items to a group, or remove items from a group, you will have to use the 'EDIT MANUALLY' button to edit the UIS file directly.  If you didn't mean to include a group member in the selected items, please un-select all items and try again.  Sorry that my capabilities concerning groups are so limited at this time; I hope to be much more sophisticated in the future");
		return;
	    }

	    /* 
	     * first, sever selection from its previous location in sel list
	     */
	    if (selection->back_control->sel_list == selection)
		selection->back_control->sel_list = selection->next;
	    else
	    {
	        last_sel = selection->back_control->sel_list;
		while (last_sel->next != selection)
		   last_sel = last_sel->next;
		last_sel->next = selection->next;
	    }
	    selection->next = NULL;

	    /* 
	     * next, add selection to group list 
	     */
	    if (i == 0)
		me_group->group_next = selection;
	    else
	    {
		last_sel = me_group->group_next;
		while (last_sel->next != NULL)
		    last_sel = last_sel->next;
		last_sel->next = selection;
	    }
	    selection->back_group = me_group;
	}
}
