 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane create
   >>>> 
   >>>>  Private: 
   >>>> 	run_display
   >>>> 	create_i
   >>>> 	create_reload
   >>>> 	create_edit
   >>>> 	create_save
   >>>> 	create_o
   >>>> 	create_new
   >>>> 	create_force
   >>>> 	create_copy
   >>>> 	create_menuform
   >>>> 	create_delete
   >>>>   Static: 
   >>>> 	save_uisfile
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "guise.h"

static void save_uisfile PROTO((options_create *));
static int copy_selection PROTO((kcontrol *, kselection *, int));



/*-----------------------------------------------------------
|
|  Routine Name: run_display
|
|       Purpose: Main GUI driver for the displayed form
|
|         Input: form        - pointer to the form tree of displayed GUI
|                subform     - pointer to currently displayed subform 
|                client_data - client data passed in
|
|        Output: None
|    Written By: Danielle Argiro 
|          Date: Sept 20, 1993
| Modifications: 
|
------------------------------------------------------------*/
/* ARGSUSED */
void run_display(
     kform    *form,
     ksubform *subform,
     kaddr    client_data)
{
        /*
         * GUI info structure passed in as client_data
         */
        gui_info_struct *master_info = (gui_info_struct *) client_data;

	if ((display_form->quit) && (master_info->options != NULL))
	{
	    if (save_needed)
	    {
	        if (kprompt(KSTANDARD, "Yes", "No", 1, 
		    "Save changes before destroying displayed form?"))
		    save_uisfile(master_info->options->create);
	    }
	    xvf_set_attribute(master_info->options->create->save_struct, 
			      XVF_ACTIVATE, 0);
	    xvf_destroy_form(display_form);
	    display_form = NULL;
	}
}

/*-----------------------------------------------------------
| 
|  Routine Name: create_i
| 
|       Purpose: Called when input selection i is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro & Mark Young
|          Date: Mon Dec 7, 1992
| Modifications: Modified from Khoros 1.0 preview
| 
------------------------------------------------------------*/
void create_i(
   options_create *create_info)
{
	int  status;
	char temp[KLENGTH];

	if ((save_needed) && (display_form != NULL))
        {
	    if (!force_output)
	    {
		ksprintf(temp, "Save changes to %s before destroying displayed form?", create_info->o);
		status = xvu_exit_wait(temp, "Inputting new UIS file",
				       NULL, NULL, NULL);
		/* cancel */
		if (status == 0)
		{
		    xvf_set_attribute(create_info->i_struct,
				      XVF_FILE_NAME, create_info->o);
		    kfree(create_info->i);
		    create_info->i = kstrdup(create_info->o);
		    return;
		}

		/* save changes */
		else if (status == 2)
                    save_uisfile(create_info);
	    }
	    else save_uisfile(create_info);
        }

	reload_form(create_info->i, create_info->o);

	set_save_notneeded(create_info->save_struct);

	xvf_set_attribute(create_info->save_struct, XVF_ACTIVATE, 1);

	put_gui_in_edit_mode();


	adjust_gui_from_infile(create_info->i, create_info);

	if (kstrcmp(create_info->i, create_info->o) != 0)
	{
	    if (kstrcmp(create_info->i, EMPTY_FORM_UIS) != 0)
	    {
                xvf_set_attribute(create_info->o_struct,
                                  XVF_FILE_NAME, create_info->i);
		kfree(create_info->o);
		create_info->o = kstrdup(create_info->i);
	        set_uis_directory(create_info->i);
	    }
	    else 
	    {
		xvf_set_attribute(create_info->o_struct,
                                   XVF_FILE_NAME, "new.form");
		kfree(create_info->o);
		create_info->o = kstrdup("new.form");
	    }
	}
}


/*-----------------------------------------------------------
| 
|  Routine Name: create_reload
| 
|       Purpose: Called when pane action button reload is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Mon Dec 7, 1992
| Modifications: 
| 
------------------------------------------------------------*/
void create_reload(
   options_create *create_info)
{
	char temp[KLENGTH];
	int  status;

	if (save_needed)
        {
	    ksprintf(temp, "Save changes to %s before destroying displayed form?", create_info->o);
            status = xvu_exit_wait(temp, "Reloading UIS file",
                                    NULL, NULL, NULL);
	    /* cancel */
	    if (status == 0)
	        return;

	    /* save changes */
	    if (status == 2)
                save_uisfile(create_info);
        }

	reload_form(create_info->i, create_info->o);

	set_save_notneeded(create_info->save_struct);

	xvf_set_attribute(create_info->save_struct, XVF_ACTIVATE, 1);

	put_gui_in_edit_mode();
}


/*-----------------------------------------------------------
| 
|  Routine Name: create_edit
| 
|       Purpose: Called when pane action button edit is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Mark Young, John Rasure, & Danielle Argiro
|          Date: Mon Dec 7, 1992
| Modifications: Modified from Khoros 1.0 preview
| 
------------------------------------------------------------*/
void create_edit(
   options_create *create_info)
{
	int pid;

	/*
	 *  output displayed form so that user edits latest UIS
	 */
	if (!identical_output_file(output_filename))
	    output_display_form(output_filename, TRUE, NULL);

	/*
	 *  put up an xterm with the editor session
	 */
        keditfile(output_filename,   TRUE,
                  KEDITOR_GEOMETRY, "132x24",
                  KEDITOR_CHDIR,     TRUE,
                  KEDITOR_PID,       &pid,
                  NULL);

	/*
	 * detect input on the editor session, so displayed form
	 * will re-display itself after each write of the file
	 */
	xvw_add_detectfile(NULL, output_filename, 2.0, 
			   update_form, create_info);

	/*
	 * put up busy window, set flag, wait for editor session to end
	 */
	xvw_busy(NULL, TRUE);
	editor_up = TRUE;
	xvw_waitpid(pid, NULL);

	/*
	 * editor down: unbusy, set flag
	 */
	xvw_busy(NULL, FALSE);
	editor_up = FALSE;

	/*
         *  update Save button to Save(Needed)
         */
	if (!identical_output_file(create_info->o))
            set_save_needed(create_info->save_struct, NULL, NULL,
                            create_info->save_struct);
}

/*-----------------------------------------------------------
| 
|  Routine Name: create_save
| 
|       Purpose: Called when pane action button save is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Mon Dec 7, 1992
| Modifications: 
| 
------------------------------------------------------------*/

void create_save(
   options_create *create_info)
{
	save_uisfile(create_info);

	xvf_set_attribute(create_info->save_struct, XVF_ACTIVATE, 1);
	xvf_set_attribute(create_info->i_struct, XVF_FILE_NAME, 
		          create_info->o);
	kfree(create_info->i);
	create_info->i = kstrdup(create_info->o);
}



/*-----------------------------------------------------------
| 
|  Routine Name: create_o
| 
|       Purpose: Called when live outputfile selection o is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Mon Dec 7, 1992
| Modifications: 
| 
------------------------------------------------------------*/

void create_o(
   options_create *create_info)
{
	create_save(create_info);
}

/*-----------------------------------------------------------
|
|  Routine Name: create_new
|
|       Purpose: Do routine which is called when
|                  pane action button new is used
|
|         Input: create_info - ptr to PaneInfo struct for create pane
|
|        Output: None
|    Written By: Danielle Argiro
|          Date: Jun 23, 1993
| Modifications:
|
------------------------------------------------------------*/
void create_new(
     options_create *create_info)
{
	kfree(create_info->i);
	create_info->i = kstrdup(EMPTY_FORM_UIS);
	create_i(create_info);

	xvf_set_attribute(create_info->i_struct, XVF_FILE_NAME, NULL);
	kfree(create_info->i);
	create_info->i = NULL;

	put_gui_in_edit_mode();

	xvf_set_attribute(create_info->subform_button_struct, 
		          XVF_TITLE, "Create Master");

	adjust_gui_from_infile(create_info->i, create_info);
}


/*-----------------------------------------------------------
|
|  Routine Name: create_force
|
|       Purpose: Do routine which is called when
|                  pane action button foce is used
|
|         Input: create_info - ptr to PaneInfo struct for create pane
|
|        Output: None
|    Written By: Danielle Argiro
|          Date: Sept 20, 1993
| Modifications:
|
------------------------------------------------------------*/
void create_force(
     options_create *create_info)
{
	force_output = create_info->force;
	
}

/*-----------------------------------------------------------
| 
|  Routine Name: create_copy
| 
|       Purpose: Do routine which is called when
|                  pane action button copy is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Nov 12, 1993
| Modifications: 
| 
------------------------------------------------------------*/
void create_copy(
     options_create *create_info)
{
	kform_struct *kformstruct;
	xvobject     *gui_items;
	kcontrol     *display_control;
        int          i, selected_num, control_type;
static  int          count = 0;

	gui_items = get_selected_gui_items(&selected_num, 
				           &display_control,
					   &control_type);
	if (gui_items == NULL) return;

	for (i = 0; i < selected_num; i++)
	{
            if (!(xvw_get_attribute(gui_items[i], XVW_MENU_CLIENTDATA, 
				    &kformstruct)))
                return;

	    switch(kformstruct->type)
	    {
		case KSELECTION:
		     if (copy_selection(display_control, kformstruct->Selptr,
				        count))
	                 count++;
		     break;
	        
	        default:
		     kerror(NULL, "create_copy", "Sorry, copying of the selected GUI item is not supported");
		     break;
	    }
		
	}
 	kfree(gui_items);

}

/*-----------------------------------------------------------
|
|  Routine Name: copy_selection
|
|       Purpose: Copies a selection
|
|         Input: create_info - ptr to PaneInfo struct for create pane
|
|        Output: None
|    Written By: Danielle Argiro
|          Date: July 06, 1994
| Modifications:
|
------------------------------------------------------------*/

static int copy_selection(
   kcontrol   *display_control,
   kselection *old_selection,
   int        copycount)
{
	char         *line = NULL;
	char         temp[KLENGTH];
	int          type; 
	Line_Info    line_info;
	kselection   *new_selection, *toggleptr, *toggle_member;

	/*
	 *  with some types of selections, copies are not allowed
	 */
	if ((old_selection->type == KUIS_QUIT)          ||
	    (old_selection->type == KUIS_STDIN)         ||
	    (old_selection->type == KUIS_STDOUT)        ||
	    (old_selection->type == KUIS_ROUTINE)) 
	{
            kerror(NULL, "create_copy",
                   "Only one %s selection allowed on a pane",
		   kvf_ascii_typeflag(old_selection->type));
            return(FALSE);
        }

	/*
	 *  parse the line, so we can get x & y positions 
         *  to be offset a little from the original, down & to the right
	 */
	kvf_clear_line_info(&line_info);
        if (!(kvf_gen_parse(old_selection->line, &line_info)))
	    return(FALSE);

	type =  old_selection->type;
        if (type == KUIS_BLANK)
        {
            line_info.xpos += 3.0;
            line_info.ypos += 0.75;
        }
        else
        {
            line_info.x += 3.0;
            line_info.y += 0.75;
        }

	/*
	 *  modify the variable by appending count to make it unique
	 */
        ksprintf(temp, "%s%d", line_info.variable, copycount);
        kfree(line_info.variable);
        line_info.variable = kstrdup(temp);

	/*
	 *  deparse to produce UIS line copied from original selection;
	 *  set line_info.write to TRUE so that selection value & literal
	 *  are not hardwired in the UIS line.
	 */
	line_info.write = TRUE;
        kvf_gen_deparse(&line_info, &line);

	/*
	 *  create the selection node
	 */
	new_selection = create_new_selection(display_control, line);
        if (new_selection == NULL)
        {
            kerror(NULL, "create_copy", "Unable to copy selection");
            return(FALSE);
        }

	/*
	 *  for toggles, all the toggle members also need to be copied
	 */
        if (new_selection->type == KUIS_TOGGLE)
        {
            toggleptr = old_selection->toggle_next;
            while (toggleptr != NULL)
            {
                toggle_member  = kvf_create_new_toggle_member(new_selection, 
						              toggleptr->line);
		if (new_selection->back != NULL)
                    xvf_create_selection(toggle_member, new_selection->back, 
				         display_control->type);
		toggleptr = toggleptr->next;
            }
	    xvf_highlight_toggle(new_selection);
        }

	/*
	 *  if selection was optional & selected, the little optional
	 *  box was never highlighted. similarly for the above need to call
	 *  xvf_highlight_toggle to set the visual appearance of the toggle
	 *  correctly, need to reverse the colors on the optional box now.
	 */
	if ((new_selection->opt_selected != 0) &&
            (new_selection->opt_object != NULL))
            xvw_reverse_colors(new_selection->opt_object, TRUE);

	return(TRUE);
}

/*-----------------------------------------------------------
| 
|  Routine Name: create_menuform
| 
|       Purpose: Do routine which is called when
|                  pane action button menuform is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Nov 12, 1993
| Modifications: 
| 
------------------------------------------------------------*/
void create_menuform(
     options_create *create_info)
{
	xvobject *gui_items;
	int      i, selected_num, control_type;
	kcontrol *display_control;

	gui_items = get_selected_gui_items(&selected_num, 
					   &display_control,
					   &control_type);
	if (gui_items == NULL) return;

	for (i = 0; i < selected_num; i++)
	    xvw_activate_menu(gui_items[i]);

 	kfree(gui_items);
}


/*-----------------------------------------------------------
| 
|  Routine Name: create_delete
| 
|       Purpose: Do routine which is called when
|                  pane action button delete is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Nov 12, 1993
| Modifications: 
| 
------------------------------------------------------------*/
void create_delete(
     options_create *create_info)
{
	xvobject *gui_items;
	int      i, selected_num, control_type;
	kcontrol *display_control;

	gui_items = get_selected_gui_items(&selected_num, 
					   &display_control,
					   &control_type);
	if (gui_items == NULL) return;

	/*
	 * delete the items.  have to do this * backwards, since we are 
         * deleting items from the gui_backs[] array (changing the array) 
	 * as we go.
	 */
	for (i = selected_num-1; i >= 0; i--)
	    xvw_set_attribute(gui_items[i], XVF_DELETE, 1);

 	kfree(gui_items);
}


/*-----------------------------------------------------------
|
|  Routine Name: save_uisfile
|
|       Purpose: Saves a UIS file.  Called by create_i, create_o, 
|                create_save, etc.  NOTE: this routine forces over-write;
|                it assumes that the user has *already* been prompted.
|
|         Input: create_info - ptr to PaneInfo struct for create pane
|        Output: None
|    Written By: Danielle Argiro
|          Date: Fri Feb 18, 1994
| Modifications:
|
------------------------------------------------------------*/

static void save_uisfile(
     options_create *create_info)
{
	char *dup_varname;
	char alternate_filepath[KLENGTH];

	dup_varname = check_all_variables();
	if (dup_varname != NULL)
	{
	    kerror(NULL, "Duplicate Variable Names", 
		   "Warning: UIS file being written out has at 2 selections with the variable name, '%s';  this will result in an error when the GUI is redisplayed.  The UIS file will be saved anyway, but you should use the 'Edit Manually' button or the internal menuforms of the selections in question to give them unique variable names.", dup_varname);
	}

	output_display_form(create_info->o, create_info->force, 
		            alternate_filepath);

	if (kstrlen(alternate_filepath) > 0)
	{
	    xvf_set_attribute(create_info->o_struct, XVF_FILE_NAME, 
			      alternate_filepath);
	    kfree(create_info->o);
	    create_info->o = kstrdup(alternate_filepath);
	}
}
