 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Comparing displayed GUI with output file 
   >>>> 
   >>>>  Private: 
   >>>> 	identical_output_file
   >>>> 	identical_selections
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "guise.h"

/*-----------------------------------------------------------
|
|  Routine Name: identical_output_file
|
|       Purpose: Sees if the GUI described by the current output file 
|                is the same as the form being displayed. 
|         Input: filename - name of output file to compare with
|        Output: None
|       Returns: TRUE if the GUI's are the same, FALSE otherwise
|    Written By: Danielle Argiro
|          Date: Wed Dec 9, 1992 
| Modifications: 
|
------------------------------------------------------------*/
int identical_output_file(
   char *filename)
{
        int   i, line_num, db_size;
	char  **filenames, **database;
	int   *filename_lookup, *linenum_lookup;
	int   filecount = 0;
	kfile *file;
	kform *test_form;

	/* open the working UIS file */
	if (!(file = kfopen(filename, "r")))
        {
            kerror(NULL, "update_form",
                   "Unable to open '%s' to read UIS", filename);
            return(FALSE);
        }

	/* read UIS file into internal database */
	filenames    = (char **) kcalloc(1,sizeof(char *));
        filenames[0] = kstring_copy(filename, NULL);
        database     = kvf_read_database(file, &line_num, &db_size,
                                 &filename_lookup, &linenum_lookup,
                                 &filenames, &filecount);
        kfclose(file);
        if (database == NULL)
            return(FALSE);

	/* create form tree from internal database */
	test_form = kvf_build_form(database, NONE, NULL, NULL, filename_lookup, 
				   linenum_lookup, filenames);
        if (test_form == NULL)
            return(TRUE);

	/* free all the memory we're wasting in the process */
	for (i = 0; i < line_num; i++)
	    kfree(database[i]);
	kfree(database);
        kfree(filenames[0]);
        kfree(filenames);
	kfree(linenum_lookup);
	kfree(filename_lookup);

	/* can abort if the GUI from file same as displayed GUI */
	if (identical_forms(display_form, test_form))
	{
	    kvf_destroy_form(test_form);
	    return(TRUE);
	}
	return(FALSE);
}


/*-----------------------------------------------------------
|
|  Routine Name: identical_forms
|
|       Purpose: Sees if the two forms are identical
|         Input: form1  - first form
|                form2  - second form
|        Output: None
|       Returns: TRUE if the forms are (essentially) the same.
|                FALSE otherwise
|    Written By: Danielle Argiro
|          Date: Wed Dec 9, 1992 
| Modifications: 
|
------------------------------------------------------------*/
int identical_forms(
   kform *form1,
   kform *form2)
{
	if ((form1 == NULL) && (form2 != NULL)) return(FALSE);
	if ((form1 != NULL) && (form2 == NULL)) return(FALSE);
	if ((form1 == NULL) && (form2 == NULL)) return(FALSE);

	if ((form1->master != NULL) && (form2->master == NULL))
	    return(FALSE);

	else if ((form1->master == NULL) && (form2->master != NULL))
	    return(FALSE);

	if ((form1->control_line != NULL) && (form2->control_line != NULL))
        {
            if (kstrcmp(form1->control_line, form2->control_line) != 0)
                return(FALSE);
        }

	if (form1->master != NULL)
	{
	    if (!(identical_selections(form1->master->sel_list,
				       form2->master->sel_list)))
		return(FALSE);

	    if (!(identical_subforms(form1->master->subform_list,
				    form2->master->subform_list)))
		return(FALSE);
	}

	else if (!(identical_subforms(form1->subform, form2->subform)))
                return(FALSE);
	
	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: identical_subforms
|
|       Purpose: Sees if the two subforms are identical
|         Input: subform1  - first subform
|                subform2  - second subform
|        Output: None
|       Returns: TRUE if the subforms are (essentially) the same.
|                FALSE otherwise
|    Written By: Danielle Argiro
|          Date: Wed Dec 9, 1992 
| Modifications: 
|
------------------------------------------------------------*/
int identical_subforms(
   ksubform *subform_list1,
   ksubform *subform_list2)
{
	ksubform *subform1, *subform2;

        subform1 = subform_list1;
        subform2 = subform_list2;

	while ((subform1 != NULL) && (subform2 != NULL))
	{
	    if ((subform1->guidepane != NULL) && 
	        (subform2->guidepane == NULL))
	   	 return(FALSE);

	    else if ((subform1->guidepane == NULL) && 
	             (subform2->guidepane != NULL))
	   	 return(FALSE);

	    if ((subform1->line != NULL) && (subform2->line != NULL))
	    {
	        if (kstrcmp(subform1->line, subform2->line) != 0)
                    return(FALSE);
	    }
	    if ((subform1->control_line != NULL) && 
                (subform2->control_line != NULL))
	    {
	        if (kstrcmp(subform1->control_line, 
			    subform2->control_line) != 0)
                    return(FALSE);
	    }

	    if (subform1->guidepane != NULL)
	    {
	    	if (!(identical_selections(subform1->guidepane->sel_list,
				       subform2->guidepane->sel_list)))
		    return(FALSE);

	        if (!(identical_guides(subform1->guidepane->guide_list,
				   subform2->guidepane->guide_list)))
	   	    return(FALSE);
	    }

	    else if (!(identical_guides(subform1->guide, subform2->guide)))
                return(FALSE);

	    subform1 = subform1->next;
	    subform2 = subform2->next;
	}
	
	return(TRUE);
}


/*-----------------------------------------------------------
|
|  Routine Name: identical_guides
|
|       Purpose: Sees if the guide lists of two subforms are identical
|         Input: guide_list1  - header of the first guide list
|                guide_list2  - header of the second guide list
|        Output: None
|       Returns: TRUE if the guide lists are the same.
|                FALSE otherwise
|    Written By: Danielle Argiro
|          Date: Wed Dec 9, 1992 
| Modifications: 
|
------------------------------------------------------------*/
int identical_guides(
   kguide *guide_list1,
   kguide *guide_list2)
{
	kguide *guide1, *guide2;

	guide1 = guide_list1;
	guide2 = guide_list2;

	while ((guide1 != NULL) && (guide2 != NULL))
	{
	    if ((guide1->line != NULL) && (guide2->line != NULL))
	    {
	        if (kstrcmp(guide1->line, guide2->line) != 0)
	  	    return(FALSE);
	    }
	    if ((guide1->pane->control_line != NULL) &&
	        (guide2->pane->control_line != NULL))
	    {
                if (kstrcmp(guide1->pane->control_line, 
			    guide2->pane->control_line) != 0)
                    return(FALSE);
            }


	    if (!(identical_selections(guide1->pane->sel_list,
				       guide2->pane->sel_list)))
		return(FALSE);

	    guide1 = guide1->next;
	    guide2 = guide2->next;
	}

	if ((guide1 == NULL) && (guide2 != NULL))
	    return(FALSE);
	if ((guide1 != NULL) && (guide2 == NULL))
	    return(FALSE);

	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: identical_selections
|
|       Purpose: Sees if the selection lists of two forms are identical
|         Input: sel_list1  - header of the first selection list
|                sel_list2  - header of the second selection list
|        Output: None
|       Returns: TRUE if the selection lists are the same.
|                FALSE otherwise
|    Written By: Danielle Argiro
|          Date: Wed Dec 9, 1992 
| Modifications: 
|
------------------------------------------------------------*/
int identical_selections(
   kselection *sel_list1,
   kselection *sel_list2)
{
	kselection *sel1, *sel2;

	sel1 = sel_list1;
	sel2 = sel_list2;

	while ((sel1 != NULL) && (sel2 != NULL))
	{
	    if (kstrcmp(sel1->line, sel2->line) != 0)
		return(FALSE);

	    if ((sel1->group_next != NULL) || sel2->group_next != NULL)
		if (!(identical_selections(sel1->group_next, sel2->group_next)))
                    return(FALSE);

	    if ((sel1->toggle_next != NULL) || sel2->toggle_next != NULL)
                if (!(identical_selections(sel1->toggle_next, sel2->toggle_next)))
                    return(FALSE);

	    sel1 = sel1->next;
	    sel2 = sel2->next;
	}

	if ((sel1 == NULL) && (sel2 != NULL))
	    return(FALSE);
	if ((sel1 != NULL) && (sel2 == NULL))
	    return(FALSE);

	return(TRUE);
}
