/* 
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/* 
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            craftsman utility routines
   >>>>
   >>>>  Private:
   >>>>         verify_object_name()
   >>>>         verify_lib_routine()
   >>>>         verify_lib_list()
   >>>>         change_lib_list()
   >>>>         gui_info_handler()
   >>>>
   >>>>   Static:
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "craftsman.h"

/*-----------------------------------------------------------
| Routine Name:	verify_lib_list() - Verify the library routine specifiedd
|
| Purpose:	This routine is called to verify the library routine specified
|		to associate a kroutine with.  Note that the library must
|		already exist.  If the library specified does not exist,
|		then print an error message and return FALSE.   Also, the
|		object specified must be a library object.
|
| Written By:	Neil Bowers
| Date:		3-jun-93
------------------------------------------------------------*/
int
verify_lib_list(
   kstring  library)
{
   int  status = FALSE;


   status = (library != NULL && kstring_cleanup(library, library) != NULL);

   if (!status)
      kerror(NULL, "Verify lib list",
	     "A library name was not specified.\n"
	     "If you wish to create a library routine, you must "
	     "specify an existing library for the library routine");

   return status;
}


/*-----------------------------------------------------------
| Routine Name:	change_lib_list() - Change the library string list
|
| Purpose:	This routine is called to change the library string list.
|		It changes the list by querying kcms for all the existing
|		library objects. 
|
| Written By:	Neil Bowers
| Date:		17-mar-94
------------------------------------------------------------*/
void
change_lib_list(void)
{
   klist *  list;
   char **  array;
   int      count  = 0;


   if ((list = kcms_get_objects(cmsToolbox, KCMS_LIBRARY)) != NULL)
   {
      array = kcms_list_get_attribute(list, KCMS_NAME, &count);

      xvf_set_attributes(paneKroutine->lib_list_struct,
			 XVF_LIST_SIZE,     count,
			 XVF_LIST_CONTENTS, array,
			 NULL);
   }
}

/*-----------------------------------------------------------
| Routine Name:	update_categories() - Update category and subcategory lists
|
| Purpose:	This routine is called to gather the category and subcategory
|		lists.  This is done by querying kcms for existing
|		category/subcategory information.
|
| Written By:	Becky Bishop 
| Date:		Thu Jun  3 10:40:43 MDT 1993
------------------------------------------------------------*/
void
update_categories(void)
{
   char **  cat_list;
   int *    otypes;
   char **  subcat_list;
   char **  programs;
   char **  panefile;
   char **  workspaces;
   char **  tmp_cat;
   char **  tmp_subcat;
   char **  icons;
   int *    incantata;
   char **  short_descriptions;
   int      num_programs;
   int      i;
   int      j;
   int      tmp_cnt;
   int      num_cat;
   int      num_subcat;


   /*-- if global categories & subcategories selected, then do nothing --*/
   if (gui_info->preferences->types->cattype_num == 2)
      return;

   cat_list = NULL;
   subcat_list = NULL;

   kcms_get_attribute(cmsToolbox, KCMS_TB_CATEGORYINFO,
		      &programs, &otypes, &icons, &tmp_cat, &tmp_subcat,
		      &panefile, &workspaces, &incantata,
		      &short_descriptions, &num_programs);

   if (num_programs == 0)
      return;

   num_cat = num_programs;
   num_subcat = num_programs;

   cat_list = karray_add(NULL, tmp_cat[0], 0);
   tmp_cnt = 0;
   for (i = 0; i < num_cat; i++)
   {
      if (tmp_cat[i] == NULL || !kstrcmp(tmp_cat[i], ""))
	 continue;
      j = 0;
      while (j < tmp_cnt && kstrcmp(cat_list[j], tmp_cat[i]))
	 j++;
      if (j == tmp_cnt)
      {
	 cat_list = karray_add(cat_list, tmp_cat[i], tmp_cnt);
	 tmp_cnt++;
      }
   }
   num_cat = tmp_cnt;
   xvf_set_attributes(gui_info->template->category_struct,
		      XVF_LIST_SIZE,     num_cat,
		      XVF_LIST_CONTENTS, cat_list,
		      NULL);
   xvf_set_attributes(paneObjAttrs->category_struct,
		      XVF_LIST_SIZE,     num_cat,
		      XVF_LIST_CONTENTS, cat_list,
		      NULL);

   subcat_list = karray_add(NULL, tmp_subcat[0], 0);
   tmp_cnt = 0;
   for (i = 0; i < num_subcat; i++)
   {
      if (tmp_subcat[i] == NULL || !kstrcmp(tmp_subcat[i], ""))
	 continue;
      j = 0;
      while (j < tmp_cnt && kstrcmp(subcat_list[j], tmp_subcat[i]))
	 j++;
      if (j == tmp_cnt)
      {
	 subcat_list = karray_add(subcat_list, tmp_subcat[i], tmp_cnt);
	 tmp_cnt++;
      }
   }
   num_subcat = tmp_cnt;
   xvf_set_attributes(gui_info->template->subcategory_struct,
		      XVF_LIST_SIZE,     num_subcat,
		      XVF_LIST_CONTENTS, subcat_list,
		      NULL);
   xvf_set_attributes(paneObjAttrs->subcategory_struct,
		      XVF_LIST_SIZE,     num_subcat,
		      XVF_LIST_CONTENTS, subcat_list,
		      NULL);
}

/*-----------------------------------------------------------
| Routine Name:	gui_info_handler - kinfo() handler for craftsman
|
| Purpose:	This routine catches any strings displayed using kinfo()
|		and displays them in the notify-window popup.
|		This means the user will see messages from the code
|		generation library and similar.
|
| Input:	message	- the message to display
| Returns:	TRUE if successful, FALSE otherwise.
| Written By:	Neil Bowers
| Date:		17-mar-94
------------------------------------------------------------*/
int
our_announce_handler(
   kstring  toolbox,
   kstring  object,
   kstring  library,
   kstring  routine,
   kstring  message)
{
   return xvw_set_attribute(xvoNotifier, XVW_NOTIFYWINDOW_MESSAGE, message);
}

void
update_keywords(
   kobject  object,
   kstring  selected)
{
   int            cmstype;
   klist         *list;
   kstring       *keywords;
   int            nkeys;
   kform_struct  *list_struct;
   int            i;


   if (!kcms_get_attribute(object, KCMS_TYPE, &cmstype))
      return;

   if (cmstype == KOBJ_CMSTB)
   {
      if (!kcms_get_attribute(object, KCMS_TB_KEYWORDS, &list))
	 return;
      list_struct = gui_info->tbattrs->keywords->keylist_struct;
   }
   else /*-- assume it's a software object --*/
   {
      if (!kcms_get_attribute(object, KCMS_CMOBJ_KEYWORDS, &list))
	 return;
      list_struct = gui_info->obj_attributes->obj_keywords->keylist_struct;
   }

   if (list == NULL)
      xvf_set_attributes(list_struct,
			 XVF_LIST_SIZE,     0,
			 XVF_LIST_CONTENTS, NULL,
			 NULL);
   else if ((keywords = keylist_to_array(list, &nkeys)) != NULL)
   {
      keywords = karray_sort(keywords, nkeys, TRUE);
      xvf_set_attributes(list_struct,
			 XVF_LIST_SIZE,     nkeys,
			 XVF_LIST_CONTENTS, keywords,
			 NULL);

      /*-- if a selected item was specified, select it ----------------*/
      if (selected != NULL)
      {
	 i=0;
	 while (i < nkeys && kstrcmp(selected, keywords[i]) != 0)
	    i++;
	 if (i < nkeys)
	 {
	    xvf_set_attribute(
	       gui_info->obj_attributes->obj_keywords->keylist_struct,
	       XVF_LIST_INDEX, i);
	 }
      }
   }
}

kstring *
keylist_to_array(
   klist  *keylist,
   int    *count)
{
   int       i;
   kstring  *array;
   klist    *list;
   kstring   keyword;


   *count = klist_size(keylist);
   array = (kstring *)kmalloc(*count * sizeof(kstring));
   if (array == NULL)
      return NULL;

   for (i=0, list = keylist; list != NULL; list = klist_next(list))
   {
      keyword  = (kstring)klist_clientdata(list);
      array[i] = kstrdup(keyword);
      i++;
   }

   return array;
}

/*-----------------------------------------------------------
| Routine Name:	update_categories() - Update category and subcategory lists
|
| Purpose:	This routine is called to gather the category and subcategory
|		lists.  This is done by querying kcms for existing
|		category/subcategory information.
|
| Written By:	Neil Bowers
| Date:		16-mar-1995
------------------------------------------------------------*/
int
craftsman_load_categories(
   kobject  toolbox)
{
   char  **tmp_cat;
   char  **tmp_subcat;
   int     num_programs;
   int     i;
   int     j;


   if (!kcms_get_attribute(toolbox,
			   KCMS_TB_CATEGORYINFO,
			   NULL, NULL, NULL, &tmp_cat, &tmp_subcat,
			   NULL, NULL, NULL, NULL, &num_programs))
      return FALSE;

   for (i = 0; i < num_programs; i++)
   {
      /*-- check i'th category ----------------------------------------*/
      if (tmp_cat[i] != NULL && kstrlen(tmp_cat[i]) > 0)
      {
	 j = 0;
	 while (j < nCategories && kstrcmp(pstrCategories[j], tmp_cat[i]))
	    j++;
	 if (j == nCategories)
	 {
	    pstrCategories = karray_add(pstrCategories, kstrdup(tmp_cat[i]),
					nCategories);
	    nCategories++;
	 }
      }

      /*-- check i'th category ----------------------------------------*/
      if (tmp_subcat[i] != NULL && kstrlen(tmp_subcat[i]) > 0)
      {
	 j = 0;
	 while (j < nSubcategories
		&& kstrcmp(pstrSubcategories[j], tmp_subcat[i]))
	 {
	    j++;
	 }
	 if (j == nSubcategories)
	 {
	    pstrSubcategories = karray_add(pstrSubcategories,
					   kstrdup(tmp_subcat[i]),
					   nSubcategories);
	    nSubcategories++;
	 }
      }
   }

   return TRUE;
}

void
merge_category_strings(
   kstring  category,
   kstring  subcategory)
{
   int  need_update = FALSE;
   int  j = 0;


   if (category != NULL)
   {
      while (j < nCategories && kstrcmp(pstrCategories[j], category))
	 j++;
      if (j == nCategories)
      {
	 pstrCategories = karray_add(pstrCategories, kstrdup(category),
				     nCategories);
	 nCategories++;
	 pstrCategories = karray_sort(pstrCategories, nCategories, FALSE);
	 xvf_set_attributes(gui_info->template->category_struct,
			    XVF_LIST_SIZE,     nCategories,
			    XVF_LIST_CONTENTS, pstrCategories,
			    NULL);
	 xvf_set_attributes(paneObjAttrs->category_struct,
			    XVF_LIST_SIZE,     nCategories,
			    XVF_LIST_CONTENTS, pstrCategories,
			    NULL);
      }
   }

   if (subcategory != NULL)
   {
      while (j < nSubcategories
	     && kstrcmp(pstrSubcategories[j], subcategory))
	 j++;
      if (j == nSubcategories)
      {
	 pstrSubcategories = karray_add(pstrSubcategories,
					kstrdup(subcategory),
					nSubcategories);
	 nSubcategories++;
	 pstrSubcategories = karray_sort(pstrSubcategories, nSubcategories,
					 FALSE);
	 xvf_set_attributes(gui_info->template->subcategory_struct,
			    XVF_LIST_SIZE,     nSubcategories,
			    XVF_LIST_CONTENTS, pstrSubcategories,
			    NULL);
	 xvf_set_attributes(paneObjAttrs->subcategory_struct,
			    XVF_LIST_SIZE,     nSubcategories,
			    XVF_LIST_CONTENTS, pstrSubcategories,
			    NULL);
      }
   }
}
