 /* 
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";

#endif

 /* 
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Image Display Utility Routines
   >>>>
   >>>>  Private:
   >>>>             initialize_ui()
   >>>>
   >>>>   Static:
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#define CRAFTSMAN_GLOBALS
#include "craftsman.h"

static void  quit_callback      PROTO((kaddr));
static void  objtype_handler    PROTO((kaddr));
static void  initialize_globals PROTO((void));
static int   nail_backplane     PROTO((kform_struct *));


/*-- UPDATE: These are effectively globals but can't be declared using	--*/
/*-- the _GLOBAL macro in craftsman.h, due to initialization		--*/
/*-- the tables should be static in a single file with access functions	--*/

AttributeSelection toolbox_attributes[NUM_TB_ATTRS] =
{
   {"Toolbox title",       NULL, NULL, KCMS_TB_TITLE},
   {"Author's email",      NULL, NULL, KCMS_TB_AUTHOR_EMAIL},
   {"Author's name",       NULL, NULL, KCMS_TB_AUTHOR}
};

AttributeSelection object_attributes[NUM_OBJ_ATTRS] =
{
   {"Object Category",    NULL, NULL, KCMS_CMOBJ_CATEGORY},
   {"Object Subcategory", NULL, NULL, KCMS_CMOBJ_SUBCATEGORY},
   {"Short Description",  NULL, NULL, KCMS_CMOBJ_SHORT_DESC},
   {"Icon Name",          NULL, NULL, KCMS_CMOBJ_ICON_NAME},
   {"Author's Name",      NULL, NULL, KCMS_CMOBJ_AUTHOR},
   {"Author's Email",     NULL, NULL, KCMS_CMOBJ_AUTHOR_EMAIL}
};

/*-----------------------------------------------------------
| Routine Name:	initialize - Initialize the user interface form
|
| Purpose:	This routine is called to initialize the UI form.  It
|		checks to see if a toolbox was specified on the command
|		line and if so, opens that toolbox.  
|
| Returns:	TRUE on success, FALSE otherwise.
|
| Written By:	Becky Bishop and Neil Bowers
| Date:		2-jun-1993
------------------------------------------------------------*/
int
initialize(void)
{
   kstring   routine      = "Initialize Craftsman";
   kobject   toolbox      = NULL;
   xvobject  master;
   xvobject  subform;
   kstring   author       = kgetenv("KHOROS_NAME");
   kstring   author_email = kgetenv("KHOROS_MAIL");


   if ((master = xvf_get_xvobject(gui_info->tblist_struct, XVF_BACKPLANE,
				  TRUE)) == NULL)
   {
      kerror(NULL, routine,
	     "Unable to get widget for master selection");
      return FALSE;
   }
   master = xvw_toplevel(master);

   /*-- create the notifier popup used to keep user informed --*/
   if ((xvoNotifier = xvw_create_notifywindow(NULL, "notify")) == NULL)
   {
      kerror(NULL, routine, "Unable to create notifier window.");
      return FALSE;
   }
   xvw_set_attributes(xvoNotifier,
		      XVW_RESIZABLE, TRUE,
		      XVW_WIDTH, 382,
		      XVW_NOTIFYWINDOW_NOTIFYFOR, master,
		      XVW_NOTIFYWINDOW_TITLE, "Working. . .",
		      XVW_NOTIFYWINDOW_LABEL, "Please Wait",
		      XVW_NOTIFYWINDOW_MESSAGE, "Initializing Craftsman",
		      XVW_NOTIFYWINDOW_VISIBLE, TRUE,
		      NULL);

   xvw_busy(xvw_toplevel(master), TRUE);

   (void)kset_announcehandler(our_announce_handler);

   xvw_set_attribute(gui_info->console->conspane->workspace,
		     XVW_BORDER_WIDTH, 0);
   xvoConsole = xvw_create_console(gui_info->console->conspane->workspace,
				   "craftsmanConsole");
   xvw_set_attribute(xvoConsole, XVW_TACK_EDGE, KMANAGER_TACK_ALL);

   initialize_globals();
   nail_backplane(gui_info->tblist_struct);
   nail_backplane(gui_info->objlist_struct);

   xvf_set_attribute(gui_info->newtb->mktb->name_struct,
		     XVF_STRING_VAL, author);
   kfree(gui_info->newtb->mktb->name);
   gui_info->newtb->mktb->name = kstrdup(author);

   xvf_set_attribute(gui_info->newtb->mktb->email_struct,
		     XVF_STRING_VAL, author_email);
   kfree(gui_info->newtb->mktb->email);
   gui_info->newtb->mktb->email = kstrdup(author_email);

   xvf_set_attribute(gui_info->template->author_struct,
                     XVF_STRING_VAL, author);
   kfree(gui_info->template->author);
   gui_info->template->author = kstrdup(author);

   xvf_set_attribute(gui_info->template->email_struct,
                     XVF_STRING_VAL, author_email);
   kfree(gui_info->template->email);
   gui_info->template->email = kstrdup(author_email);

   strObject = NULL;

   update_tblist();

   /*-- was a toolbox specified on the command line? --*/
   if (clui_info->tb_string != NULL)
   {
      toolbox = kcms_open_toolbox(clui_info->tb_string);
      if (toolbox == NULL)
	 kerror(NULL, routine, "Cannot open toolbox '%s'",
		clui_info->tb_string);

      else
      {
	 select_toolbox(toolbox);

         /*-- was an object specified on the command line? --*/
	 if (clui_info->oname_string != NULL)
	    (void)select_object(clui_info->oname_string);
      }
   }

   if ((subform = xvf_get_xvobject(gui_info->newtb->mktb->createtb_struct,
				   XVF_BACKPLANE, TRUE)) != NULL)
   {
      xvw_set_attribute(xvw_toplevel(subform), XVW_SHELL_TITLE,
			"Craftsman: Creating a new toolbox");
   }

   /*-- when QUIT button pressed, destroy any additional toplevels --*/
   xvf_add_extra_call(QUIT_BUTTON, quit_callback, NULL, XVF_CALL_LAST);

   /*-- update create-object subform & panes according to object type --*/
   xvf_add_extra_call(gui_info->template->kroutine_struct,
		      objtype_handler, (kaddr)KCMS_KROUTINE, XVF_CALL_FIRST);
   xvf_add_extra_call(gui_info->template->xvroutine_struct,
		      objtype_handler, (kaddr)KCMS_XVROUTINE, XVF_CALL_FIRST);
   xvf_add_extra_call(gui_info->template->library_struct,
		      objtype_handler, (kaddr)KCMS_LIBRARY, XVF_CALL_FIRST);
   xvf_add_extra_call(gui_info->template->pane_struct,
		      objtype_handler, (kaddr)KCMS_PANE, XVF_CALL_FIRST);
   xvf_add_extra_call(gui_info->template->script_struct,
		      objtype_handler, (kaddr)KCMS_SCRIPT, XVF_CALL_FIRST);

   xvw_set_attribute(xvoNotifier, XVW_NOTIFYWINDOW_VISIBLE, FALSE);
   xvw_busy(xvw_toplevel(master), FALSE);

   return TRUE;
}

static void
objtype_handler(
   kaddr  client_data)
{
   switch ((int)client_data)
   {
      case KCMS_KROUTINE:
      case KCMS_XVROUTINE:
      case KCMS_SCRIPT:
	 xvf_map_kformstruct(gui_info->template->bname_struct);
	 xvf_set_attribute(gui_info->template->bname_struct,
			   XVF_TITLE, "Binary Name   ");
	 break;

      case KCMS_PANE:
	 xvf_unmap_kformstruct(gui_info->template->bname_struct);
	 break;

      case KCMS_LIBRARY:
	 xvf_map_kformstruct(gui_info->template->bname_struct);
	 xvf_set_attribute(gui_info->template->bname_struct,
			   XVF_TITLE, "Archive Name  ");
	 break;

      default:
	 kerror(NULL, "objtype_handler()",
		"Unexpected object type (%d) -- please report as a bug.",
		(int)client_data);
	 break;
   }
}

/*-----------------------------------------------------------
| Routine Name:	quit_callback - extra_call on the QUIT button
|
| Purpose:	This function is called when the user hits the QUIT button.
|		Craftsman is closed down gracefully, any open objects are
|		closed.
|
| Input:	client_data	- data pointer associated with extra-call.
|
| Written By:	Neil Bowers
| Date:		16-oct-93
------------------------------------------------------------*/
/* ARGSUSED */
static void
quit_callback(
   kaddr  client_data)
{
   if (xvoNotifier != NULL)
      xvw_destroy(xvoNotifier);
   if (cmsToolbox != NULL)
      kcms_close(cmsToolbox);
}

/*-----------------------------------------------------------
| Routine Name:	initialize_globals - initialize attribute selection tables
|
| Purpose:	This function fills in the table which holds details of
|		toolbox and object attributes with corresponding
|		selections in the user interface.
|
| Written By:	Neil Bowers
| Date:		5-dec-93
------------------------------------------------------------*/
static void
initialize_globals(void)
{
   tbattrs_strings            *paneTbAttrs;

   paneKroutine  = gui_info->template->kroutine;

   paneTbAttrs   = gui_info->tbattrs->strings;
   paneObjAttrs  = gui_info->obj_attributes->obj_attrs;

   /*-- toolbox attributes --------------------------------------------*/
   toolbox_attributes[0].selection = &paneTbAttrs->tbtitle_struct;
   toolbox_attributes[0].selvalue = &paneTbAttrs->tbtitle;

   toolbox_attributes[1].selection = &paneTbAttrs->authemail_struct;
   toolbox_attributes[1].selvalue = &paneTbAttrs->authemail;

   toolbox_attributes[2].selection = &paneTbAttrs->authname_struct;
   toolbox_attributes[2].selvalue = &paneTbAttrs->authname;

   /*-- object attributes ---------------------------------------------*/
   object_attributes[0].selection = &paneObjAttrs->category_struct;
   object_attributes[0].selvalue = &paneObjAttrs->category;

   object_attributes[1].selection = &paneObjAttrs->subcategory_struct;
   object_attributes[1].selvalue = &paneObjAttrs->subcategory;

   object_attributes[2].selection = &paneObjAttrs->description_struct;
   object_attributes[2].selvalue = &paneObjAttrs->description;

   object_attributes[3].selection = &paneObjAttrs->icon_name_struct;
   object_attributes[3].selvalue = &paneObjAttrs->icon_name;

   object_attributes[4].selection = &paneObjAttrs->name_struct;
   object_attributes[4].selvalue = &paneObjAttrs->name;

   object_attributes[5].selection = &paneObjAttrs->email_struct;
   object_attributes[5].selvalue = &paneObjAttrs->email;

   /*-- global category and subcategory variables ---------------------*/
   pstrCategories    = NULL;
   nCategories       = 0;
   pstrSubcategories = NULL;
   nSubcategories    = 0;
}

/*-----------------------------------------------------------
| Routine Name:	nail_backplane - set min and max dimensions on backplane
| Purpose:	
| Input:	a pointer to a forms selection structure
| Returns:	TRUE on success, FALSE otherwise.
| Written By:	Neil Bowers
| Date:		23-feb-94
------------------------------------------------------------*/
static int
nail_backplane(
   kform_struct * display_list)
{
   xvobject  backplane;
   int       width;
   int       height;


   return (backplane = xvf_get_xvobject(display_list, XVF_BACKPLANE,
					TRUE))!= NULL
      && xvw_get_attributes(backplane,
			    XVW_WIDTH,  &width,
			    XVW_HEIGHT, &height,
			    NULL)
      && xvw_set_attributes(backplane,
			    XVW_MINIMUM_WIDTH,  width,
			    XVW_MAXIMUM_WIDTH,  width,
			    XVW_MINIMUM_HEIGHT, height,
			    XVW_MAXIMUM_HEIGHT, height,
			    NULL);
}
