 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	GUI Drivers for 'craftsman'
   >>>> 
   >>>>  Private: 
   >>>> 	run_craftsman
   >>>> 	run_preferences
   >>>> 	run_types
   >>>> 	run_console
   >>>> 	run_conspane
   >>>> 	run_newtb
   >>>> 	run_mktb
   >>>> 	run_tbaddref
   >>>> 	run_addref
   >>>> 	run_tbattrs
   >>>> 	run_strings
   >>>> 	run_keywords
   >>>> 	run_flags
   >>>> 	run_copyright
   >>>> 	run_files
   >>>> 	run_template
   >>>> 	run_kroutine
   >>>> 	run_xvroutine
   >>>> 	run_library
   >>>> 	run_script
   >>>> 	run_pane
   >>>> 	run_obj_attributes
   >>>> 	run_obj_attrs
   >>>> 	run_obj_keywords
   >>>> 	run_paneattrs
   >>>> 	run_copyobject
   >>>> 	run_copy
   >>>> 	run_mvobject
   >>>> 	run_move
   >>>> 	run_rename_obj
   >>>> 	run_rename
   >>>> 	run_objinfo
   >>>> 	run_infopane
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "craftsman.h"

/*-----------------------------------------------------------
| 
|  Routine Name: run_craftsman
| 
|       Purpose: Main GUI Driver for craftsman
| 
|         Input: None
| 
|        Output: Returns TRUE on success, FALSE on failure
|    Written By: conductor -oname craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void run_craftsman(
     kform    *form,
     ksubform *subform,
     kaddr    client_data)
{
	/*
	 * GUI info structure passed in as client_data 
	 */
	gui_info_struct *master_info = (gui_info_struct *) client_data;

	/*
	 * Get information from the forms
	 */
	_xvf_get_craftsman(master_info);

	if (form->quit)
	{
	    xvf_destroy_allforms();
	    _xvf_free_craftsman(master_info);
	    return;
	}

	    /*
	     * user selected 'live' list selection 'tblist'
	     */
	    if (master_info->tblist_selected)
	    {
	        craftsman_tblist(master_info);
	        master_info->tblist_selected = FALSE;
	    }
	    /*
	     * user double-clicked on list objlist	     */
	    else if ((master_info->objlist_selected)
	              && (master_info->objlist_dblclick))
	    {
	        craftsman_objlist_dblclick(master_info);
	        master_info->objlist_selected = FALSE;
	    }
	    /*
	     * user selected 'live' list selection 'objlist'
	     */
	    else if (master_info->objlist_selected)
	    {
	        craftsman_objlist(master_info);
	        master_info->objlist_selected = FALSE;
	    }
	    /*
	     * user clicked on master action button selection 'mkmanual'
	     */
	    else if (master_info->mkmanual)
	        craftsman_mkmanual(master_info);
	    /*
	     * user clicked on master action button selection 'dereftb'
	     */
	    else if (master_info->dereftb)
	        craftsman_dereftb(master_info);
	    /*
	     * user clicked on master action button selection 'klinttb'
	     */
	    else if (master_info->klinttb)
	        craftsman_klinttb(master_info);
	    /*
	     * user clicked on master action button selection 'rmtb'
	     */
	    else if (master_info->rmtb)
	        craftsman_rmtb(master_info);
	    /*
	     * user clicked on master action button selection 'open'
	     */
	    else if (master_info->open)
	        craftsman_open(master_info);
	    /*
	     * user clicked on master action button selection 'klintobj'
	     */
	    else if (master_info->klintobj)
	        craftsman_klintobj(master_info);
	    /*
	     * user clicked on master action button selection 'delete'
	     */
	    else if (master_info->delete)
	        craftsman_delete(master_info);
	/*
	 * action came from the 'preferences' subform
	 */
	if (master_info->preferences_selected)
	    run_preferences(master_info->preferences);
	/*
	 * action came from the 'console' subform
	 */
	if (master_info->console_selected)
	    run_console(master_info->console);
	/*
	 * action came from the 'newtb' subform
	 */
	if (master_info->newtb_selected)
	    run_newtb(master_info->newtb);
	/*
	 * action came from the 'tbaddref' subform
	 */
	if (master_info->tbaddref_selected)
	    run_tbaddref(master_info->tbaddref);
	/*
	 * action came from the 'tbattrs' subform
	 */
	if (master_info->tbattrs_selected)
	    run_tbattrs(master_info->tbattrs);
	/*
	 * action came from the 'template' subform
	 */
	if (master_info->template_selected)
	    run_template(master_info->template);
	/*
	 * action came from the 'obj_attributes' subform
	 */
	if (master_info->obj_attributes_selected)
	    run_obj_attributes(master_info->obj_attributes);
	/*
	 * action came from the 'copyobject' subform
	 */
	if (master_info->copyobject_selected)
	    run_copyobject(master_info->copyobject);
	/*
	 * action came from the 'mvobject' subform
	 */
	if (master_info->mvobject_selected)
	    run_mvobject(master_info->mvobject);
	/*
	 * action came from the 'rename_obj' subform
	 */
	if (master_info->rename_obj_selected)
	    run_rename_obj(master_info->rename_obj);
	/*
	 * action came from the 'objinfo' subform
	 */
	if (master_info->objinfo_selected)
	    run_objinfo(master_info->objinfo);

	xvf_clear_selections(form);

}

/*-----------------------------------------------------------
| 
|  Routine Name: run_preferences
| 
|       Purpose: GUI Driver for subform 'preferences'
| 
|         Input: form      - pointer to the form tree
|                preferences_info - pointer to craftsman_preferences struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_preferences(
     craftsman_preferences *preferences_info)
{

	/*
	 * action came from the 'types' pane
	 */
	if (preferences_info->types_selected)
	    run_types(preferences_info->types);


}   /* end run_preferences */



/*-----------------------------------------------------------
| 
|  Routine Name: run_types
| 
|       Purpose: GUI Driver for pane 'types'
| 
|         Input: form - pointer to the form tree
|                types_info - pointer to preferences_types struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_types(
     preferences_types *types_info)

{

	/*
	 * user selected 'live' toggle selection 'objtypes'
	 */
	if (types_info->objtypes_selected)
	{
	    types_objtypes(types_info);
	    types_info->objtypes_selected = FALSE;
	}
	/*
	 * user selected 'live' toggle selection 'cattype'
	 */
	else if (types_info->cattype_selected)
	{
	    types_cattype(types_info);
	    types_info->cattype_selected = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_console
| 
|       Purpose: GUI Driver for subform 'console'
| 
|         Input: form      - pointer to the form tree
|                console_info - pointer to craftsman_console struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_console(
     craftsman_console *console_info)
{

	/*
	 * action came from the 'conspane' pane
	 */
	if (console_info->conspane_selected)
	    run_conspane(console_info->conspane);


}   /* end run_console */



/*-----------------------------------------------------------
| 
|  Routine Name: run_conspane
| 
|       Purpose: GUI Driver for pane 'conspane'
| 
|         Input: form - pointer to the form tree
|                conspane_info - pointer to console_conspane struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_conspane(
     console_conspane *conspane_info)

{

	/*
	 * user clicked on pane action button selection 'clear'
	 */
	if (conspane_info->clear)
	{
	    conspane_clear(conspane_info);
	    conspane_info->clear = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_newtb
| 
|       Purpose: GUI Driver for subform 'newtb'
| 
|         Input: form      - pointer to the form tree
|                newtb_info - pointer to craftsman_newtb struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_newtb(
     craftsman_newtb *newtb_info)
{

	/*
	 * action came from the 'mktb' pane
	 */
	if (newtb_info->mktb_selected)
	    run_mktb(newtb_info->mktb);


}   /* end run_newtb */



/*-----------------------------------------------------------
| 
|  Routine Name: run_mktb
| 
|       Purpose: GUI Driver for pane 'mktb'
| 
|         Input: form - pointer to the form tree
|                mktb_info - pointer to newtb_mktb struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_mktb(
     newtb_mktb *mktb_info)

{

	/*
	 * user clicked on pane action button selection 'createtb'
	 */
	if (mktb_info->createtb)
	{
	    mktb_createtb(mktb_info);
	    mktb_info->createtb = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_tbaddref
| 
|       Purpose: GUI Driver for subform 'tbaddref'
| 
|         Input: form      - pointer to the form tree
|                tbaddref_info - pointer to craftsman_tbaddref struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_tbaddref(
     craftsman_tbaddref *tbaddref_info)
{

	/*
	 * action came from the 'addref' pane
	 */
	if (tbaddref_info->addref_selected)
	    run_addref(tbaddref_info->addref);


}   /* end run_tbaddref */



/*-----------------------------------------------------------
| 
|  Routine Name: run_addref
| 
|       Purpose: GUI Driver for pane 'addref'
| 
|         Input: form - pointer to the form tree
|                addref_info - pointer to tbaddref_addref struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_addref(
     tbaddref_addref *addref_info)

{

	/*
	 * user clicked on pane action button selection 'addit'
	 */
	if (addref_info->addit)
	{
	    addref_addit(addref_info);
	    addref_info->addit = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_tbattrs
| 
|       Purpose: GUI Driver for subform 'tbattrs'
| 
|         Input: form      - pointer to the form tree
|                tbattrs_info - pointer to craftsman_tbattrs struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_tbattrs(
     craftsman_tbattrs *tbattrs_info)
{

	/*
	 * action came from the 'strings' pane
	 */
	if (tbattrs_info->strings_selected)
	    run_strings(tbattrs_info->strings);

	/*
	 * action came from the 'keywords' pane
	 */
	else if (tbattrs_info->keywords_selected)
	    run_keywords(tbattrs_info->keywords);

	/*
	 * action came from the 'flags' pane
	 */
	else if (tbattrs_info->flags_selected)
	    run_flags(tbattrs_info->flags);

	/*
	 * action came from the 'copyright' pane
	 */
	else if (tbattrs_info->copyright_selected)
	    run_copyright(tbattrs_info->copyright);

	/*
	 * action came from the 'files' pane
	 */
	else if (tbattrs_info->files_selected)
	    run_files(tbattrs_info->files);


}   /* end run_tbattrs */



/*-----------------------------------------------------------
| 
|  Routine Name: run_strings
| 
|       Purpose: GUI Driver for pane 'strings'
| 
|         Input: form - pointer to the form tree
|                strings_info - pointer to tbattrs_strings struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_strings(
     tbattrs_strings *strings_info)

{

	/*
	 * user clicked on pane action button selection 'apply'
	 */
	if (strings_info->apply)
	{
	    strings_apply(strings_info);
	    strings_info->apply = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_keywords
| 
|       Purpose: GUI Driver for pane 'keywords'
| 
|         Input: form - pointer to the form tree
|                keywords_info - pointer to tbattrs_keywords struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_keywords(
     tbattrs_keywords *keywords_info)

{

	/*
	 * user selected 'live' list selection 'keylist'
	 */
	if (keywords_info->keylist_selected)
	{
	    keywords_keylist(keywords_info);
	    keywords_info->keylist_selected = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'delete'
	 */
	else if (keywords_info->delete)
	{
	    keywords_delete(keywords_info);
	    keywords_info->delete = FALSE;
	}
	/*
	 * user selected 'live' string selection 'addkey'
	 */
	else if (keywords_info->addkey_selected)
	{
	    keywords_addkey(keywords_info);
	    keywords_info->addkey_selected = FALSE;
	}
	/*
	 * user selected 'live' string selection 'chkey'
	 */
	else if (keywords_info->chkey_selected)
	{
	    keywords_chkey(keywords_info);
	    keywords_info->chkey_selected = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_flags
| 
|       Purpose: GUI Driver for pane 'flags'
| 
|         Input: form - pointer to the form tree
|                flags_info - pointer to tbattrs_flags struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_flags(
     tbattrs_flags *flags_info)

{

	/*
	 * user clicked on pane action button selection 'flags_apply'
	 */
	if (flags_info->flags_apply)
	{
	    flags_flags_apply(flags_info);
	    flags_info->flags_apply = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_copyright
| 
|       Purpose: GUI Driver for pane 'copyright'
| 
|         Input: form - pointer to the form tree
|                copyright_info - pointer to tbattrs_copyright struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_copyright(
     tbattrs_copyright *copyright_info)

{

	/*
	 * user clicked on pane action button selection 'copyright_apply'
	 */
	if (copyright_info->copyright_apply)
	{
	    copyright_copyright_apply(copyright_info);
	    copyright_info->copyright_apply = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_files
| 
|       Purpose: GUI Driver for pane 'files'
| 
|         Input: form - pointer to the form tree
|                files_info - pointer to tbattrs_files struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_files(
     tbattrs_files *files_info)

{

	/*
	 * user clicked on pane action button selection 'config'
	 */
	if (files_info->config)
	{
	    files_config(files_info);
	    files_info->config = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'tbinclude'
	 */
	else if (files_info->tbinclude)
	{
	    files_tbinclude(files_info);
	    files_info->tbinclude = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'tbinfo'
	 */
	else if (files_info->tbinfo)
	{
	    files_tbinfo(files_info);
	    files_info->tbinfo = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'tbaliases'
	 */
	else if (files_info->tbaliases)
	{
	    files_tbaliases(files_info);
	    files_info->tbaliases = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'tbtodo'
	 */
	else if (files_info->tbtodo)
	{
	    files_tbtodo(files_info);
	    files_info->tbtodo = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'tbchangelog'
	 */
	else if (files_info->tbchangelog)
	{
	    files_tbchangelog(files_info);
	    files_info->tbchangelog = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_template
| 
|       Purpose: GUI Driver for subform 'template'
| 
|         Input: form      - pointer to the form tree
|                template_info - pointer to craftsman_template struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_template(
     craftsman_template *template_info)
{

	/*
	 * action came from the 'kroutine' pane
	 */
	if (template_info->kroutine_selected)
	    run_kroutine(template_info->kroutine);

	/*
	 * action came from the 'xvroutine' pane
	 */
	else if (template_info->xvroutine_selected)
	    run_xvroutine(template_info->xvroutine);

	/*
	 * action came from the 'library' pane
	 */
	else if (template_info->library_selected)
	    run_library(template_info->library);

	/*
	 * action came from the 'script' pane
	 */
	else if (template_info->script_selected)
	    run_script(template_info->script);

	/*
	 * action came from the 'pane' pane
	 */
	else if (template_info->pane_selected)
	    run_pane(template_info->pane);


}   /* end run_template */



/*-----------------------------------------------------------
| 
|  Routine Name: run_kroutine
| 
|       Purpose: GUI Driver for pane 'kroutine'
| 
|         Input: form - pointer to the form tree
|                kroutine_info - pointer to template_kroutine struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_kroutine(
     template_kroutine *kroutine_info)

{

	/*
	 * user selected 'live' toggle selection 'lib_routine'
	 */
	if (kroutine_info->lib_routine_selected)
	{
	    kroutine_lib_routine(kroutine_info);
	    kroutine_info->lib_routine_selected = FALSE;
	}
	/*
	 * user selected 'live' string selection 'lib_list'
	 */
	else if (kroutine_info->lib_list_selected)
	{
	    kroutine_lib_list(kroutine_info);
	    kroutine_info->lib_list_selected = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'create_kroutine'
	 */
	else if (kroutine_info->create_kroutine)
	{
	    kroutine_create_kroutine(kroutine_info);
	    kroutine_info->create_kroutine = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_xvroutine
| 
|       Purpose: GUI Driver for pane 'xvroutine'
| 
|         Input: form - pointer to the form tree
|                xvroutine_info - pointer to template_xvroutine struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_xvroutine(
     template_xvroutine *xvroutine_info)

{

	/*
	 * user clicked on pane action button selection 'create_xvroutine'
	 */
	if (xvroutine_info->create_xvroutine)
	{
	    xvroutine_create_xvroutine(xvroutine_info);
	    xvroutine_info->create_xvroutine = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_library
| 
|       Purpose: GUI Driver for pane 'library'
| 
|         Input: form - pointer to the form tree
|                library_info - pointer to template_library struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_library(
     template_library *library_info)

{

	/*
	 * user clicked on pane action button selection 'create_library'
	 */
	if (library_info->create_library)
	{
	    library_create_library(library_info);
	    library_info->create_library = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_script
| 
|       Purpose: GUI Driver for pane 'script'
| 
|         Input: form - pointer to the form tree
|                script_info - pointer to template_script struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_script(
     template_script *script_info)

{

	/*
	 * user clicked on pane action button selection 'create_script'
	 */
	if (script_info->create_script)
	{
	    script_create_script(script_info);
	    script_info->create_script = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_pane
| 
|       Purpose: GUI Driver for pane 'pane'
| 
|         Input: form - pointer to the form tree
|                pane_info - pointer to template_pane struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_pane(
     template_pane *pane_info)

{

	/*
	 * user clicked on pane action button selection 'create_pane'
	 */
	if (pane_info->create_pane)
	{
	    pane_create_pane(pane_info);
	    pane_info->create_pane = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_obj_attributes
| 
|       Purpose: GUI Driver for subform 'obj_attributes'
| 
|         Input: form      - pointer to the form tree
|                obj_attributes_info - pointer to craftsman_obj_attributes struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_obj_attributes(
     craftsman_obj_attributes *obj_attributes_info)
{

	/*
	 * action came from the 'obj_attrs' pane
	 */
	if (obj_attributes_info->obj_attrs_selected)
	    run_obj_attrs(obj_attributes_info->obj_attrs);

	/*
	 * action came from the 'obj_keywords' pane
	 */
	else if (obj_attributes_info->obj_keywords_selected)
	    run_obj_keywords(obj_attributes_info->obj_keywords);

	/*
	 * action came from the 'paneattrs' pane
	 */
	else if (obj_attributes_info->paneattrs_selected)
	    run_paneattrs(obj_attributes_info->paneattrs);


}   /* end run_obj_attributes */



/*-----------------------------------------------------------
| 
|  Routine Name: run_obj_attrs
| 
|       Purpose: GUI Driver for pane 'obj_attrs'
| 
|         Input: form - pointer to the form tree
|                obj_attrs_info - pointer to obj_attributes_obj_attrs struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_obj_attrs(
     obj_attributes_obj_attrs *obj_attrs_info)

{

	/*
	 * user clicked on pane action button selection 'apply'
	 */
	if (obj_attrs_info->apply)
	{
	    obj_attrs_apply(obj_attrs_info);
	    obj_attrs_info->apply = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_obj_keywords
| 
|       Purpose: GUI Driver for pane 'obj_keywords'
| 
|         Input: form - pointer to the form tree
|                obj_keywords_info - pointer to obj_attributes_obj_keywords struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_obj_keywords(
     obj_attributes_obj_keywords *obj_keywords_info)

{

	/*
	 * user selected 'live' list selection 'keylist'
	 */
	if (obj_keywords_info->keylist_selected)
	{
	    obj_keywords_keylist(obj_keywords_info);
	    obj_keywords_info->keylist_selected = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'delete'
	 */
	else if (obj_keywords_info->delete)
	{
	    obj_keywords_delete(obj_keywords_info);
	    obj_keywords_info->delete = FALSE;
	}
	/*
	 * user selected 'live' string selection 'addkey'
	 */
	else if (obj_keywords_info->addkey_selected)
	{
	    obj_keywords_addkey(obj_keywords_info);
	    obj_keywords_info->addkey_selected = FALSE;
	}
	/*
	 * user selected 'live' string selection 'chkey'
	 */
	else if (obj_keywords_info->chkey_selected)
	{
	    obj_keywords_chkey(obj_keywords_info);
	    obj_keywords_info->chkey_selected = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_paneattrs
| 
|       Purpose: GUI Driver for pane 'paneattrs'
| 
|         Input: form - pointer to the form tree
|                paneattrs_info - pointer to obj_attributes_paneattrs struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_paneattrs(
     obj_attributes_paneattrs *paneattrs_info)

{

	/*
	 * user clicked on pane action button selection 'apply'
	 */
	if (paneattrs_info->apply)
	{
	    paneattrs_apply(paneattrs_info);
	    paneattrs_info->apply = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_copyobject
| 
|       Purpose: GUI Driver for subform 'copyobject'
| 
|         Input: form      - pointer to the form tree
|                copyobject_info - pointer to craftsman_copyobject struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_copyobject(
     craftsman_copyobject *copyobject_info)
{

	/*
	 * action came from the 'copy' pane
	 */
	if (copyobject_info->copy_selected)
	    run_copy(copyobject_info->copy);


}   /* end run_copyobject */



/*-----------------------------------------------------------
| 
|  Routine Name: run_copy
| 
|       Purpose: GUI Driver for pane 'copy'
| 
|         Input: form - pointer to the form tree
|                copy_info - pointer to copyobject_copy struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_copy(
     copyobject_copy *copy_info)

{

	/*
	 * user clicked on pane action button selection 'docopy'
	 */
	if (copy_info->docopy)
	{
	    copy_docopy(copy_info);
	    copy_info->docopy = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_mvobject
| 
|       Purpose: GUI Driver for subform 'mvobject'
| 
|         Input: form      - pointer to the form tree
|                mvobject_info - pointer to craftsman_mvobject struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_mvobject(
     craftsman_mvobject *mvobject_info)
{

	/*
	 * action came from the 'move' pane
	 */
	if (mvobject_info->move_selected)
	    run_move(mvobject_info->move);


}   /* end run_mvobject */



/*-----------------------------------------------------------
| 
|  Routine Name: run_move
| 
|       Purpose: GUI Driver for pane 'move'
| 
|         Input: form - pointer to the form tree
|                move_info - pointer to mvobject_move struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_move(
     mvobject_move *move_info)

{

	/*
	 * user clicked on pane action button selection 'domove'
	 */
	if (move_info->domove)
	{
	    move_domove(move_info);
	    move_info->domove = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_rename_obj
| 
|       Purpose: GUI Driver for subform 'rename_obj'
| 
|         Input: form      - pointer to the form tree
|                rename_obj_info - pointer to craftsman_rename_obj struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_rename_obj(
     craftsman_rename_obj *rename_obj_info)
{

	/*
	 * action came from the 'rename' pane
	 */
	if (rename_obj_info->rename_selected)
	    run_rename(rename_obj_info->rename);


}   /* end run_rename_obj */



/*-----------------------------------------------------------
| 
|  Routine Name: run_rename
| 
|       Purpose: GUI Driver for pane 'rename'
| 
|         Input: form - pointer to the form tree
|                rename_info - pointer to rename_obj_rename struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_rename(
     rename_obj_rename *rename_info)

{

	/*
	 * user clicked on pane action button selection 'dorename'
	 */
	if (rename_info->dorename)
	{
	    rename_dorename(rename_info);
	    rename_info->dorename = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_objinfo
| 
|       Purpose: GUI Driver for subform 'objinfo'
| 
|         Input: form      - pointer to the form tree
|                objinfo_info - pointer to craftsman_objinfo struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_objinfo(
     craftsman_objinfo *objinfo_info)
{

	/*
	 * action came from the 'infopane' pane
	 */
	if (objinfo_info->infopane_selected)
	    run_infopane(objinfo_info->infopane);


}   /* end run_objinfo */



/*-----------------------------------------------------------
| 
|  Routine Name: run_infopane
| 
|       Purpose: GUI Driver for pane 'infopane'
| 
|         Input: form - pointer to the form tree
|                infopane_info - pointer to objinfo_infopane struct
| 
|        Output: None
|    Written By: conductor -program_name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_infopane(
     objinfo_infopane *infopane_info)

{

	/*
	 * user clicked on pane action button selection 'todo'
	 */
	if (infopane_info->todo)
	{
	    infopane_todo(infopane_info);
	    infopane_info->todo = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'crtodo'
	 */
	else if (infopane_info->crtodo)
	{
	    infopane_crtodo(infopane_info);
	    infopane_info->crtodo = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'bugs'
	 */
	else if (infopane_info->bugs)
	{
	    infopane_bugs(infopane_info);
	    infopane_info->bugs = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'crbugs'
	 */
	else if (infopane_info->crbugs)
	{
	    infopane_crbugs(infopane_info);
	    infopane_info->crbugs = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'done'
	 */
	else if (infopane_info->done)
	{
	    infopane_done(infopane_info);
	    infopane_info->done = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'crdone'
	 */
	else if (infopane_info->crdone)
	{
	    infopane_crdone(infopane_info);
	    infopane_info->crdone = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'changelog'
	 */
	else if (infopane_info->changelog)
	{
	    infopane_changelog(infopane_info);
	    infopane_info->changelog = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'crchangelog'
	 */
	else if (infopane_info->crchangelog)
	{
	    infopane_crchangelog(infopane_info);
	    infopane_info->crchangelog = FALSE;
	}


}


