/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane strings
   >>>> 
   >>>>  Private: 
   >>>> 	strings_apply
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "craftsman.h"

extern AttributeSelection toolbox_attributes[NUM_TB_ATTRS];

/*-----------------------------------------------------------
| Routine Name:	strings_apply
| 
| Purpose:	Do routine which is called when
|		pane action button apply is used
| 
| Input:	strings_info - ptr to PaneInfo struct for strings pane
| 
| Output:	None
| Written By: 
| Date:		6-jul-94
------------------------------------------------------------*/
/* ARGSUSED */
void
strings_apply(
     tbattrs_strings *strings_info)
{
   int      i;
   kobject  toolbox    = cmsToolbox;
   kstring  attrval;
   int      need_sync  = FALSE;


   if (cmsToolbox == NULL)
   {
      kerror(NULL, "strings_apply()", "You have not selected a toolbox.");
      return;
   }

   for (i = 0; i < NUM_TB_ATTRS; i++)
   {
      kcms_get_attribute(toolbox, toolbox_attributes[i].attribute, &attrval);
      if (kstrcmp(*toolbox_attributes[i].selvalue, attrval))
      {
	 kcms_set_attribute(toolbox, toolbox_attributes[i].attribute,
			    *toolbox_attributes[i].selvalue);
	 need_sync = TRUE;
      }
   }

   if (need_sync)
      kcms_sync(toolbox);
}

/*-----------------------------------------------------------
| Routine Name:	update_tb_props - update toolbox attributes selections
|
| Purpose:	This function updates the toolbox attributes subform
|		from the toolbox passed in.
|
| Input:	toolbox	-	The toolbox to get attributes from.
|
| Written By:	Neil Bowers
| Date:		5-nov-93
------------------------------------------------------------*/
void
update_tb_props(
   kobject toolbox)
{
   char     titlestring[KLENGTH];
   kstring  tbname;
   kstring  tbpath;
   int      i;
   kstring  attrval;
   int      status;


   for (i = 0; i < NUM_TB_ATTRS; i++)
   {
      kcms_get_attribute(toolbox, toolbox_attributes[i].attribute, &attrval);
      xvf_set_attribute(*toolbox_attributes[i].selection,
			XVF_STRING_VAL, attrval);
      kfree(*toolbox_attributes[i].selvalue);
      *toolbox_attributes[i].selvalue = kstrdup(attrval);
   }
   kcms_get_attribute(toolbox, KCMS_NAME, &tbname);
   (void)ksprintf(titlestring, "Attributes for Toolbox %s", tbname);
   xvf_set_attribute(gui_info->tbattrs_struct,
		     XVF_TITLE, titlestring);

   if (kcms_get_attribute(toolbox, KCMS_PATH, &tbpath))
      xvf_set_attribute(gui_info->tbattrs->strings->tbpath_struct,
			XVF_TITLE, tbpath);

   if (kcms_get_attribute(toolbox, KCMS_TB_COPYRIGHT_SHORT, &attrval))
   {
      xvf_set_attribute(gui_info->tbattrs->copyright->short_copyright_struct,
			XVF_STRING_VAL, attrval);
      kfree(gui_info->tbattrs->copyright->short_copyright);
      gui_info->tbattrs->copyright->short_copyright = kstrdup(attrval);
   }
   

   if (kcms_get_attribute(toolbox, KCMS_TB_COPYRIGHT_LONG, &attrval))
   {
      xvf_set_attribute(gui_info->tbattrs->copyright->long_copyright_struct,
			XVF_STRING_VAL, attrval);
      kfree(gui_info->tbattrs->copyright->long_copyright);
      gui_info->tbattrs->copyright->long_copyright = kstrdup(attrval);
   }

   if (kcms_get_attribute(toolbox, KCMS_TB_STATUS, &status))
   {
      xvf_set_attribute(gui_info->tbattrs->flags->tbstatus_struct,
                        XVF_TOGGLE_NUM, status + 1);
   }
}
