/* 
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>         Functionality routines for pane script
   >>>> 
   >>>>  Private: 
   >>>>         script_create_script
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "craftsman.h"

/*-----------------------------------------------------------
| Routine Name:	script_create_script
| 
| Purpose:	Do routine which is called when
|		pane action button create_script is used
| 
| Input:	script_info - ptr to PaneInfo struct for script pane
| 
| Written By:	Neil Bowers
| Date:		Jun 01, 1993
------------------------------------------------------------*/
void
script_create_script(
   template_script * script_info)
{
   static int langtypes[4] =
   {KCMS_CSH, KCMS_SH, KCMS_KSH, KCMS_PERL};


   create_object(KCMS_SCRIPT, gui_info->template->bname,
		 langtypes[script_info->lang_num - 1],
		 script_info->incantata_num - 1);
}
