/* 
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/* 
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>         Functionality routines for pane kroutine
   >>>> 
   >>>>  Private: 
   >>>>         kroutine_lib_routine
   >>>>         kroutine_lib_list
   >>>>         kroutine_create_kroutine
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "craftsman.h"

/*-----------------------------------------------------------
| Routine Name:	kroutine_lib_routine
| 
| Purpose:	Do routine which is called when
|		logical selection lib_routine is used
| 
| Input:	kroutine_info - ptr to PaneInfo struct for kroutine pane
| 
| Output:	None
| Written By:	Neil Bowers
| Date:		Jun 01, 1993
------------------------------------------------------------*/
void
kroutine_lib_routine(
   template_kroutine * kroutine_info)
{
   xvf_set_attribute(kroutine_info->lib_list_struct, XVF_ACTIVATE,
		     (kroutine_info->lib_routine_val == 2) ? 1 : 0);
}


/*-----------------------------------------------------------
| Routine Name:	kroutine_lib_list
| 
| Purpose:	Do routine which is called when
|		list selection lib_list is used
| 
| Input:	kroutine_info - ptr to PaneInfo struct for kroutine pane
| 
| Written By:	
| Date:		Jun 01, 1993
------------------------------------------------------------*/
void
kroutine_lib_list(
   template_kroutine * kroutine_info)
{
   /* 
    * CLEANUP if the following call fails, it should do something besides
    * just return.. (perhaps clear the illegal lname from the form?)
    * verify_lib_list does do a kerror..
    * SJ -- Sep 13, 1993
    */
   verify_lib_list(kroutine_info->lib_list);
}


/*-----------------------------------------------------------
| Routine Name:	kroutine_create_kroutine
| 
| Purpose:	Do routine which is called when
|		pane action button create_kroutine is used
| 
| Input:	kroutine_info - ptr to PaneInfo struct for kroutine pane
| 
| Output:	None
| Written By:	Neil Bowers
| Date:		Jun 01, 1993
------------------------------------------------------------*/
void
kroutine_create_kroutine(
   template_kroutine * kroutine_info)
{
   create_object(KCMS_KROUTINE, gui_info->template->bname,
		 KCMS_NOLANG, kroutine_info->incantata_val - 1);
}
