/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane keywords
   >>>> 
   >>>>  Private: 
   >>>> 	keywords_delete
   >>>> 	keywords_addkey
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "craftsman.h"

/*-----------------------------------------------------------
| Routine Name:	keywords_delete
| 
| Purpose:	Callback routine for the "Delete Selected Keyword" action
|		button.
| 
| Input:	keywords_info - ptr to PaneInfo struct for keywords pane
| 
| Written By:	Neil Bowers
| Date:		6-jul-94
------------------------------------------------------------*/
void
keywords_delete(
   tbattrs_keywords *keywords_info)
{
   int      selected;
   kstring  keyword;


   if (cmsToolbox == NULL)
      kerror(NULL, "keywords_delete", "You have not selected a toolbox.");
   else if (xvf_get_attribute(keywords_info->keylist_struct,
			 XVF_LIST_INDEX, &selected)
       && selected >= 0)
   {
      keyword = keywords_info->keylist_label;
      kcms_remove_keyword(cmsToolbox, keyword);
      update_keywords(cmsToolbox, NULL);
      xvf_set_attributes(keywords_info->chkey_struct,
			 XVF_ACTIVATE,   FALSE,
			 XVF_STRING_VAL, NULL,
			 NULL);
      kfree(keywords_info->chkey);
      keywords_info->chkey = NULL;
      xvf_set_attribute(keywords_info->delete_struct,
			XVF_ACTIVATE,    FALSE);
   }
}


/*-----------------------------------------------------------
| Routine Name:	keywords_addkey - add a new keyword
| 
| Purpose:	Do routine which is called when
|		string selection addkey is used
| 
| Input:	keywords_info - ptr to PaneInfo struct for keywords pane
| 
| Written By:	Neil Bowers
| Date:		6-jul-94
------------------------------------------------------------*/
void
keywords_addkey(
   tbattrs_keywords *keywords_info)
{
   if (cmsToolbox == NULL)
   {
      kerror(NULL, "keywords_delete", "You have not selected a toolbox.");
      return;
   }

   kcms_add_keyword(cmsToolbox, keywords_info->addkey);
   update_keywords(cmsToolbox, keywords_info->addkey);

   xvf_set_attribute(keywords_info->addkey_struct, XVF_STRING_VAL, NULL);
   kfree(keywords_info->addkey);
   keywords_info->addkey = NULL;

   xvf_set_attribute(keywords_info->delete_struct, XVF_ACTIVATE, TRUE);
   xvf_set_attributes(keywords_info->chkey_struct,
		      XVF_STRING_VAL, keywords_info->addkey,
		      XVF_ACTIVATE,   TRUE,
		      NULL);
    kfree(keywords_info->chkey);
    keywords_info->chkey = kstrdup(keywords_info->addkey);
}

/*-----------------------------------------------------------
| Routine Name:	keywords_keylist - user selected keyword in keyword list
| 
| Purpose:	This routine is invoked when the user selects a keyword.
| 
| Input:	keywords_info - ptr to PaneInfo struct for keywords pane
| 
| Written By:	Neil Bowers
| Date:		21-nov-94
------------------------------------------------------------*/
void
keywords_keylist(
   tbattrs_keywords *keywords_info)
{
   if (cmsToolbox == NULL)
   {
      kerror(NULL, "keywords_delete", "You have not selected a toolbox.");
      return;
   }

   xvf_set_attributes(keywords_info->chkey_struct,
		      XVF_ACTIVATE,   TRUE,
		      XVF_STRING_VAL, keywords_info->keylist_label,
		      NULL);
   kfree(keywords_info->chkey);
   keywords_info->chkey = kstrdup(keywords_info->keylist_label);

   xvf_set_attribute(keywords_info->delete_struct, XVF_ACTIVATE, TRUE);
}


/*-----------------------------------------------------------
| Routine Name: keywords_chkey - change selected keyword
| 
| Purpose:	This routine is invoked when the user enters a new string
|		for the currently selected keyword and presses RETURN.
| 
| Input:	keywords_info - ptr to PaneInfo struct for keywords pane
| 
| Written By:	Neil Bowers
| Date:		21-nov-94
------------------------------------------------------------*/
void
keywords_chkey(
   tbattrs_keywords *keywords_info)
{
   if (cmsToolbox == NULL)
   {
      kerror(NULL, "keywords_delete", "You have not selected a toolbox.");
      return;
   }

   kcms_remove_keyword(cmsToolbox, keywords_info->keylist_label);
   kcms_add_keyword(cmsToolbox, keywords_info->chkey);
   update_keywords(cmsToolbox, keywords_info->chkey);
   xvf_set_attribute(keywords_info->delete_struct, XVF_ACTIVATE, TRUE);
}
