 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane addref
   >>>> 
   >>>>  Private: 
   >>>> 	addref_addit
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "craftsman.h"

/*-----------------------------------------------------------
| Routine Name:	addref_addit - add a toolbox reference to KHOROS_TOOLBOX
| 
| Purpose:	This function is invoked when the user hits the
|		"Add Toolbox Reference" button.  The specified toolbox
|		is added to the user's environment, updating the first
|		toolbox file listed in the KHOROS_TOOLBOX environment
|		variable.
| 
| Input:	addref_info - ptr to PaneInfo struct for addref pane
| 
| Written By:	Neil Bowers
| Date:		30-nov-94
------------------------------------------------------------*/
/* ARGSUSED */
void
addref_addit(
   tbaddref_addref *addref_info)
{
   kobject  toolbox;


   if (addref_info->tbname == NULL || addref_info->tbpath == NULL)
   {
      kerror(NULL, "addref_addit()", "You must specify BOTH the toolbox "
	     "name and path to top of the toolbox structure.");
      return;
   }

   xvw_set_attribute(xvoNotifier, XVW_NOTIFYWINDOW_VISIBLE, TRUE);
   xvw_format_attribute(xvoNotifier, XVW_NOTIFYWINDOW_MESSAGE,
			"Adding reference to toolbox `%s'",
			addref_info->tbname);

   toolbox = kcms_add_toolbox(addref_info->tbname, addref_info->tbpath);
   if (toolbox != NULL)
   {
      update_tblist();
      select_toolbox(toolbox);
   }

   xvw_set_attribute(xvoNotifier, XVW_NOTIFYWINDOW_VISIBLE, FALSE);
}


