 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for craftsman
   >>>> 
   >>>>    Written By: 
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _craftsman_h_
#define _craftsman_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <design.h>
#include <xvinclude.h>
#include "form_info.h"

/* -include_includes */
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
#ifdef CRAFTSMAN_GLOBALS
#	define _GLOBAL
#else
#	define _GLOBAL	extern
#endif

#define NUM_TB_ATTRS		3
#define NUM_OBJ_ATTRS		6

#define QUIT_BUTTON		gui_info->quit_struct
/* -include_defines_end */

#define PANEPATH "$DESIGN/objects/xvroutine/craftsman/uis/craftsman.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Alternate UIS file (optional infile)
 */
char	*form_file;	/* Alternate UIS file FILENAME */
int	 form_flag;	/* Alternate UIS file FLAG */

/*
 *  (x,y) position for automatic GUI placement */

int	 x_int;		/* x position INT */
int	 x_flag;	/* x position FLAG */

int	 y_int;		/* y position INT */
int	 y_flag;	/* y position FLAG */

/*
 *  toolbox name (optional string)
 */
char	*tb_string;	/* toolbox name STRING */
int	 tb_flag;   	/* toolbox name FLAG */

/*
 *  object name (optional string)
 */
char	*oname_string;	/* object name STRING */
int	 oname_flag;   	/* object name FLAG */

} clui_info_struct;

/* -include_typedefs */
typedef struct _xvlist
{
	xvobject	object;
	xvobject	inner;
	char		**strings;
	int		nstrings;
	int		selected;
	void		(*callback) PROTO((struct _xvlist *,char *,int));
} xvlist;
typedef void (*xvl_cb_func)	PROTO((xvlist *,char *,int));

typedef struct _AttributeSelection
{
	char		*field;		/*-- what the field is		--*/
	kform_struct	**selection;	/*-- structure for selection	--*/
	char		**selvalue;	/*-- pointer into gui struct	--*/
	int		attribute;	/*-- attribute identifier	--*/
} AttributeSelection;

typedef struct _InfoFile
{
	int		attribute;	/*-- attribute id for info file	--*/
	kbool		present;	/*-- is file present in object?	--*/
	kform_struct *	button;		/*-- action button for file	--*/
	kform_struct *	cr_button;	/*-- create/delete button	--*/
	kstring		path;		/*-- path to info file, or NULL	--*/
	kstring		suffix;		/*-- suffix for info file	--*/
	int		subtype;	/*-- subtype of file object	--*/
	int		template_id;	/*-- identifier for template	--*/
} InfoFile;
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
extern gui_info_struct *gui_info;

/* -include_variables */
	_GLOBAL kobject		cmsToolbox;
	_GLOBAL kstring         strToolbox;

	_GLOBAL	kstring         strObject;

        _GLOBAL kstring        *object_names;
	_GLOBAL kstring        *toolbox_names;

	_GLOBAL int		countObjects;
	_GLOBAL int		countToolboxes;

	_GLOBAL int		tbstatus;

	_GLOBAL xvobject	xvoNotifier;
	_GLOBAL xvobject	xvoConsole;

	_GLOBAL kstring        *pstrCategories;
	_GLOBAL int             nCategories;
	_GLOBAL kstring        *pstrSubcategories;
	_GLOBAL int             nSubcategories;

	/*-- convenience references into the form structure --*/
	_GLOBAL template_kroutine	   *paneKroutine;
	_GLOBAL obj_attributes_obj_attrs   *paneObjAttrs;
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void craftsman_get_args PROTO((kform *));
void craftsman_usage_additions PROTO((void));
void craftsman_free_args PROTO((int, kaddr));

/* -include_routines */
void	update_tb_props			PROTO((kobject));


/*-- initialize.c routines --*/
int	initialize			PROTO((void));


/*-- object.c routines --*/
void	delete_object			PROTO((void));
void	edit_object			PROTO((void));
int	select_object			PROTO((char *));
void	update_object_list		PROTO((void));
void	create_object			PROTO((int,char *,int,int));
int	check_object_selected		PROTO((char *));
void	update_info_files		PROTO(( kobject ));


/*-- utilities.c routines --*/
int	 verify_lib_list		PROTO((char *));
void	 change_lib_list		PROTO((void));
void	 update_categories		PROTO((void));
int	 our_announce_handler		PROTO((kstring, kstring, kstring,
					       kstring, kstring));
void     update_keywords		PROTO((kobject, kstring));
kstring *keylist_to_array		PROTO((klist *, int *));
int      craftsman_load_categories	PROTO((kobject));
void     merge_category_strings		PROTO((kstring, kstring));

/*-- toolbox.c --*/
void	select_toolbox			PROTO((kobject));
void	update_tblist			PROTO((void));
void	delete_toolbox			PROTO((void));

/* -include_routines_end */

#endif
