 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	FormInfo Extraction Routines
   >>>> 
   >>>>  Private: 
   >>>> 	_xvf_get_composer
   >>>> 
   >>>>   Static: 
   >>>> 	_xvf_get_addfile
   >>>> 	_xvf_get_add_pane
   >>>> 	_xvf_get_renamefile
   >>>> 	_xvf_get_rename_pane
   >>>> 	_xvf_get_printfile
   >>>> 	_xvf_get_printpane
   >>>> 	_xvf_get_obj_attributes
   >>>> 	_xvf_get_obj_attrs
   >>>> 	_xvf_get_obj_keywords
   >>>> 	_xvf_get_paneattrs
   >>>> 	_xvf_get_logform
   >>>> 	_xvf_get_logging
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "composer.h"


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_composer
| 
|       Purpose: Extracts information from GUI
| 
|         Input: forminfo - pointer to gui_info_struct
| 
|        Output: none
|    Written By: conductor -name composer -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_composer(
     gui_info_struct *forminfo)
{
	kselection *selection;
	ksubform   *subform;
	if (forminfo->quit_struct != NULL)
	{
	    selection = forminfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->quit));

	}

	if (forminfo->file_type_struct != NULL)
	{
	    char *value_string;
	    selection = forminfo->file_type_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(forminfo->file_type_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    forminfo->file_type_val = atoi(value_string);
	    kfree(value_string);
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->file_type_selected));
	    }

	}

	if (forminfo->filelist_struct != NULL)
	{
	    selection = forminfo->filelist_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(forminfo->filelist));
	    if (forminfo->filelist_label != NULL) kfree(forminfo->filelist_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(forminfo->filelist_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->filelist_selected));
	    forminfo->filelist_dblclick = selection->prev_selected;
	    }

	}

	if (forminfo->save_struct != NULL)
	{
	    selection = forminfo->save_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->save));

	}

	if (forminfo->spawntty_struct != NULL)
	{
	    selection = forminfo->spawntty_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->spawntty));

	}

	if (forminfo->interactive_struct != NULL)
	{
	    selection = forminfo->interactive_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->interactive));

	}

	if (forminfo->edit_struct != NULL)
	{
	    selection = forminfo->edit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->edit));

	}

	if (forminfo->view_struct != NULL)
	{
	    selection = forminfo->view_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->view));

	}

	if (forminfo->rmfile_struct != NULL)
	{
	    selection = forminfo->rmfile_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->rmfile));

	}

	if (forminfo->addfile_struct != NULL)
	{
	    subform = forminfo->addfile_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->addfile_selected));
	    _xvf_get_addfile(forminfo->addfile);

	}
	if (forminfo->renamefile_struct != NULL)
	{
	    subform = forminfo->renamefile_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->renamefile_selected));
	    _xvf_get_renamefile(forminfo->renamefile);

	}
	if (forminfo->printfile_struct != NULL)
	{
	    subform = forminfo->printfile_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->printfile_selected));
	    _xvf_get_printfile(forminfo->printfile);

	}
	if (forminfo->obj_attributes_struct != NULL)
	{
	    subform = forminfo->obj_attributes_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->obj_attributes_selected));
	    _xvf_get_obj_attributes(forminfo->obj_attributes);

	}
	if (forminfo->logform_struct != NULL)
	{
	    subform = forminfo->logform_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->logform_selected));
	    _xvf_get_logform(forminfo->logform);

	}

}

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_addfile
| 
|       Purpose: Extracts information from addfile subform
| 
|         Input: subforminfo - pointer to composer_addfile structure
| 
|        Output: none
|    Written By: conductor -name composer -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_addfile(
     composer_addfile *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->add_pane_struct != NULL)
	{
	    pane = subforminfo->add_pane_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->add_pane_selected));
	    _xvf_get_add_pane(subforminfo->add_pane);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_add_pane
| 
|       Purpose: Extracts information from add_pane pane
| 
|         Input: paneinfo - pointer to addfile_add_pane structure
| 
|        Output: none
|    Written By: conductor -name composer -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_add_pane(
     addfile_add_pane *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'composer->addfile->add_pane' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->add_file_struct != NULL)
	{
	    selection = paneinfo->add_file_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->add_file != NULL) kfree(paneinfo->add_file);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->add_file));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->add_file_selected));
	    }

	}

	if (paneinfo->add_struct != NULL)
	{
	    selection = paneinfo->add_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->add));

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_renamefile
| 
|       Purpose: Extracts information from renamefile subform
| 
|         Input: subforminfo - pointer to composer_renamefile structure
| 
|        Output: none
|    Written By: conductor -name composer -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_renamefile(
     composer_renamefile *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->rename_pane_struct != NULL)
	{
	    pane = subforminfo->rename_pane_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->rename_pane_selected));
	    _xvf_get_rename_pane(subforminfo->rename_pane);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_rename_pane
| 
|       Purpose: Extracts information from rename_pane pane
| 
|         Input: paneinfo - pointer to renamefile_rename_pane structure
| 
|        Output: none
|    Written By: conductor -name composer -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_rename_pane(
     renamefile_rename_pane *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'composer->renamefile->rename_pane' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->rename_to_struct != NULL)
	{
	    selection = paneinfo->rename_to_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->rename_to != NULL) kfree(paneinfo->rename_to);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->rename_to));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->rename_to_selected));
	    }

	}

	if (paneinfo->rename_struct != NULL)
	{
	    selection = paneinfo->rename_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->rename));

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_printfile
| 
|       Purpose: Extracts information from printfile subform
| 
|         Input: subforminfo - pointer to composer_printfile structure
| 
|        Output: none
|    Written By: conductor -name composer -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_printfile(
     composer_printfile *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->printpane_struct != NULL)
	{
	    pane = subforminfo->printpane_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->printpane_selected));
	    _xvf_get_printpane(subforminfo->printpane);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_printpane
| 
|       Purpose: Extracts information from printpane pane
| 
|         Input: paneinfo - pointer to printfile_printpane structure
| 
|        Output: none
|    Written By: conductor -name composer -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_printpane(
     printfile_printpane *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'composer->printfile->printpane' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->printer_struct != NULL)
	{
	    selection = paneinfo->printer_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->printer != NULL) kfree(paneinfo->printer);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->printer));
	    }

	}

	if (paneinfo->printcmd_struct != NULL)
	{
	    selection = paneinfo->printcmd_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->printcmd != NULL) kfree(paneinfo->printcmd);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->printcmd));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->printcmd_optsel));
	    }

	}

	if (paneinfo->print_struct != NULL)
	{
	    selection = paneinfo->print_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->print));

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_obj_attributes
| 
|       Purpose: Extracts information from obj_attributes subform
| 
|         Input: subforminfo - pointer to composer_obj_attributes structure
| 
|        Output: none
|    Written By: conductor -name composer -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_obj_attributes(
     composer_obj_attributes *subforminfo)
{
	kselection *selection;
	kcontrol   *pane;
	if (subforminfo->quit_struct != NULL)
	{
	    selection = subforminfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->quit));

	}

	if (subforminfo->obj_attrs_struct != NULL)
	{
	    pane = subforminfo->obj_attrs_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->obj_attrs_selected));
	    _xvf_get_obj_attrs(subforminfo->obj_attrs);
	}

	if (subforminfo->obj_keywords_struct != NULL)
	{
	    pane = subforminfo->obj_keywords_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->obj_keywords_selected));
	    _xvf_get_obj_keywords(subforminfo->obj_keywords);
	}

	if (subforminfo->paneattrs_struct != NULL)
	{
	    pane = subforminfo->paneattrs_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->paneattrs_selected));
	    _xvf_get_paneattrs(subforminfo->paneattrs);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_obj_attrs
| 
|       Purpose: Extracts information from obj_attrs pane
| 
|         Input: paneinfo - pointer to obj_attributes_obj_attrs structure
| 
|        Output: none
|    Written By: conductor -name composer -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_obj_attrs(
     obj_attributes_obj_attrs *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'composer->obj_attributes->obj_attrs' Pane Info structure
	 */

	if (paneinfo->description_struct != NULL)
	{
	    selection = paneinfo->description_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->description != NULL) kfree(paneinfo->description);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->description));
	    }

	}

	if (paneinfo->category_struct != NULL)
	{
	    selection = paneinfo->category_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->category != NULL) kfree(paneinfo->category);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->category));
	    }

	}

	if (paneinfo->subcategory_struct != NULL)
	{
	    selection = paneinfo->subcategory_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->subcategory != NULL) kfree(paneinfo->subcategory);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->subcategory));
	    }

	}

	if (paneinfo->icon_name_struct != NULL)
	{
	    selection = paneinfo->icon_name_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->icon_name != NULL) kfree(paneinfo->icon_name);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->icon_name));
	    }

	}

	if (paneinfo->name_struct != NULL)
	{
	    selection = paneinfo->name_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->name != NULL) kfree(paneinfo->name);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->name));
	    }

	}

	if (paneinfo->email_struct != NULL)
	{
	    selection = paneinfo->email_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->email != NULL) kfree(paneinfo->email);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->email));
	    }

	}

	if (paneinfo->install_in_cantata_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->install_in_cantata_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->install_in_cantata_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->install_in_cantata_val = atoi(value_string);
	    kfree(value_string);
	    }

	}

	if (paneinfo->apply_struct != NULL)
	{
	    selection = paneinfo->apply_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->apply));

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_obj_keywords
| 
|       Purpose: Extracts information from obj_keywords pane
| 
|         Input: paneinfo - pointer to obj_attributes_obj_keywords structure
| 
|        Output: none
|    Written By: conductor -name composer -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_obj_keywords(
     obj_attributes_obj_keywords *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'composer->obj_attributes->obj_keywords' Pane Info structure
	 */

	if (paneinfo->keylist_struct != NULL)
	{
	    selection = paneinfo->keylist_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->keylist));
	    if (paneinfo->keylist_label != NULL) kfree(paneinfo->keylist_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->keylist_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->keylist_selected));
	    }

	}

	if (paneinfo->delete_struct != NULL)
	{
	    selection = paneinfo->delete_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->delete));

	}

	if (paneinfo->addkey_struct != NULL)
	{
	    selection = paneinfo->addkey_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->addkey != NULL) kfree(paneinfo->addkey);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->addkey));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->addkey_selected));
	    }

	}

	if (paneinfo->chkey_struct != NULL)
	{
	    selection = paneinfo->chkey_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->chkey != NULL) kfree(paneinfo->chkey);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->chkey));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->chkey_selected));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_paneattrs
| 
|       Purpose: Extracts information from paneattrs pane
| 
|         Input: paneinfo - pointer to obj_attributes_paneattrs structure
| 
|        Output: none
|    Written By: conductor -name composer -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_paneattrs(
     obj_attributes_paneattrs *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'composer->obj_attributes->paneattrs' Pane Info structure
	 */

	if (paneinfo->tbname_struct != NULL)
	{
	    selection = paneinfo->tbname_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->tbname != NULL) kfree(paneinfo->tbname);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->tbname));
	    }

	}

	if (paneinfo->oname_struct != NULL)
	{
	    selection = paneinfo->oname_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->oname != NULL) kfree(paneinfo->oname);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->oname));
	    }

	}

	if (paneinfo->args_struct != NULL)
	{
	    selection = paneinfo->args_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->args != NULL) kfree(paneinfo->args);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->args));
	    }

	}

	if (paneinfo->genexec_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->genexec_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->genexec_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->genexec_val = atoi(value_string);
	    kfree(value_string);
	    }

	}

	if (paneinfo->apply_struct != NULL)
	{
	    selection = paneinfo->apply_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->apply));

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_logform
| 
|       Purpose: Extracts information from logform subform
| 
|         Input: subforminfo - pointer to composer_logform structure
| 
|        Output: none
|    Written By: conductor -name composer -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_logform(
     composer_logform *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->logging_struct != NULL)
	{
	    pane = subforminfo->logging_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->logging_selected));
	    _xvf_get_logging(subforminfo->logging);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_logging
| 
|       Purpose: Extracts information from logging pane
| 
|         Input: paneinfo - pointer to logform_logging structure
| 
|        Output: none
|    Written By: conductor -name composer -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_logging(
     logform_logging *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'composer->logform->logging' Pane Info structure
	 */

	if (paneinfo->clear_struct != NULL)
	{
	    selection = paneinfo->clear_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->clear));

	}

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->gen_code_struct != NULL)
	{
	    selection = paneinfo->gen_code_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->gen_code));

	}

	if (paneinfo->force_struct != NULL)
	{
	   selection = paneinfo->force_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->force));
	    }

	}

	if (paneinfo->make_target_struct != NULL)
	{
	    selection = paneinfo->make_target_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->make_target));

	}

	if (paneinfo->make_install_struct != NULL)
	{
	    selection = paneinfo->make_install_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->make_install));

	}

	if (paneinfo->make_Imakefile_struct != NULL)
	{
	    selection = paneinfo->make_Imakefile_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->make_Imakefile));

	}

	if (paneinfo->make_Makefile_struct != NULL)
	{
	    selection = paneinfo->make_Makefile_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->make_Makefile));

	}

	if (paneinfo->make_klint_struct != NULL)
	{
	    selection = paneinfo->make_klint_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->make_klint));

	}

	if (paneinfo->make_clean_struct != NULL)
	{
	    selection = paneinfo->make_clean_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->make_clean));

	}

	if (paneinfo->lib_make_target_struct != NULL)
	{
	    selection = paneinfo->lib_make_target_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->lib_make_target));

	}

	if (paneinfo->lib_make_install_struct != NULL)
	{
	    selection = paneinfo->lib_make_install_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->lib_make_install));

	}

	if (paneinfo->lib_make_Imakefile_struct != NULL)
	{
	    selection = paneinfo->lib_make_Imakefile_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->lib_make_Imakefile));

	}

	if (paneinfo->lib_make_Makefile_struct != NULL)
	{
	    selection = paneinfo->lib_make_Makefile_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->lib_make_Makefile));

	}

	if (paneinfo->lib_make_klint_struct != NULL)
	{
	    selection = paneinfo->lib_make_klint_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->lib_make_klint));

	}

	if (paneinfo->lib_make_clean_struct != NULL)
	{
	    selection = paneinfo->lib_make_clean_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->lib_make_clean));

	}

	if (paneinfo->workspace_struct != NULL)
	{
	    selection = paneinfo->workspace_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(paneinfo->workspace));
	    }

	}

	if (paneinfo->grep_struct != NULL)
	{
	    selection = paneinfo->grep_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->grep != NULL) kfree(paneinfo->grep);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->grep));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->grep_selected));
	    }

	}

}


