/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>         Routines related to editing of files
   >>>> 
   >>>>  Private: 
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "composer.h"


/*-----------------------------------------------------------
| Routine Name:	edit_file_object - spawn editor on a specified file object
|
| Purpose:	This function tries to spawn a text editor to edit a
|		specified text file.
|
| Input:	filename	- explanation
|		file_type	- explanation
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Neil Bowers
| Date:		19-oct-93
------------------------------------------------------------*/
int
edit_file_object(
   kobject  fileobj,
   int      edit_type)
{
   kstring        routine = "Edit File Object";
   kstring        editor;
   char           path[KLENGTH];
   kstring        filename;
   kstring        basename;
   kstring        command;
   int            ftype;
   int            fsubtype;
   EditFileInfo  *edit_info;
   FileInfo      *finfo = cur_file_info;
   int            findex;


   if (fileobj == NULL)
   {
      errno = KCMS_EINTERNAL;
      kerror(NULL, routine,
	     "Attempt to edit NULL file object.  Please report this.");
      return FALSE;
   }
   if (!kcms_get_attributes(fileobj,
			    KCMS_FOBJ_TYPE,     &ftype,
			    KCMS_FOBJ_SUBTYPE,  &fsubtype,
			    KCMS_FOBJ_FULLNAME, &filename,
			    KCMS_FOBJ_BASENAME, &basename,
			    KCMS_END))
      return FALSE;

   if ((edit_info = get_edit_info(ftype, fsubtype)) == NULL)
   {
      kerror(NULL, routine,
	     "Internal Error: couldn't get file info.");
      return FALSE;
   }

   for (findex = 0; findex < finfo->nfiles; findex++)
   {
      if (finfo->fileobjs[findex] == fileobj)
	 break;
   }
   if (findex > finfo->nfiles)
   {
      kerror(NULL, routine, "Internal Error: lost file object.");
      return FALSE;
   }

   if (edit_type == EDIT_DOUBLECLICK)
   {
      edit_type = (edit_info->edit.command != NULL
		   ? EDIT_SPECIAL
		   : EDIT_ASCII);
   }

   switch (edit_type)
   {
      case EDIT_VIEW:
	 if (edit_info->view.command == NULL)
	 {
	    (void)xvu_create_display(filename, basename, (float)0.0);
	    return TRUE;
	 }
	 else
	    editor = edit_info->view.command;
	 break;

      case EDIT_SPECIAL:
	 /*-- shouldn't hit this code --*/
	 /*-- the special (interactive) edit button should --*/
	 /*-- be disabled *unless* there is a command --*/

	 if (ftype == KCMS_FOBJ_TYPE_MAN ||
	     ftype == KCMS_FOBJ_TYPE_HELP ||
	     ftype == KCMS_FOBJ_TYPE_MANUAL)
	 {
	    if (xvoHelp == NULL)
	    {
	       xvoHelp = xvw_create_help(NULL,
					 "composerTextDisplay");
	       xvw_set_attributes(xvoHelp,
				  XVW_HELP_DESTROY_ON_QUIT, FALSE,
				  XVW_HELP_QUITLABEL, "CLOSE",
				  NULL);
	       xvw_set_attribute(xvw_toplevel(xvoHelp),
				 XVW_SHELL_TITLE,
				 "Composer: Formatted Text Display");
	    }
	    xvw_map(xvw_toplevel(xvoHelp));
	    XFlush(xvw_display(xvoHelp));
	    xvw_sync(FALSE);
	    xvw_set_attributes(xvoHelp,
			       XVW_HELP_TITLE,    basename,
			       XVW_HELP_FILENAME, filename,
			       NULL);
	    return TRUE;
	 }

	 if (edit_info->edit.command == NULL)
	    return FALSE;

	 editor = edit_info->edit.command;
	 break;

      case EDIT_ASCII:
	 keditfile(filename, TRUE,
		   KEDITOR_GEOMETRY, (ftype == KCMS_FOBJ_TYPE_UIS
				      ? "132x24"
				      : "80x48"),
		   KEDITOR_CHDIR,    TRUE,
		   NULL);
	 return TRUE;

      default:
	 kerror(NULL, routine, "Unknown editor type (%d)",
		edit_type);
	 return FALSE;
   }

   kdirname(filename, path);
   kchdir(path);
   command = interpolate_editor_string(editor, fileobj);

   xvw_fork(command, (kfunc_void) NULL, (kaddr) NULL);
   if (strCwd != NULL)
      kchdir(strCwd);
   return TRUE;
}

/*-----------------------------------------------------------
| Routine Name:	interpolate_editor_string - substitute % editor interpolations
|
| Purpose:	This function takes a string and performs substitutions
|		for specific % interpolations.  The interpolations
|		currently performed are:
|		%f	basename of the file
|		%g	geometry string (WIDTHxHEIGHT+X+Y)
|
| Input:	editstring	- the string to interpolate
|		fobj		- file object to be edited
|
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Neil Bowers
| Date:		
------------------------------------------------------------*/
char *
interpolate_editor_string(
   kstring  editstring,
   kobject  fileobj)
{
   kobject  toolbox;
   kobject  object;
   kstring  tbname;
   kstring  oname;
   kstring  geometry;
   char     path[KLENGTH];
   char     basename[KLENGTH];
   kstring  tmp;
   kstring  tmp2;
   kstring  filename;
   int      file_type;


   /*-- get attributes from the file object to be edited --*/
   if (!kcms_get_attributes(fileobj,
			    KCMS_PARENT,    &object,
			    KCMS_FOBJ_TYPE, &file_type,
			    KCMS_PATH,      &filename,
			    KCMS_END)
       || !kcms_get_attributes(object,
			       KCMS_NAME,   &oname,
			       KCMS_PARENT, &toolbox,
			       KCMS_END)
       || !kcms_get_attribute(toolbox, KCMS_NAME, &tbname))
      return NULL;


   kdirname(filename, path);
   kbasename(filename, basename);
   geometry = (file_type == KCMS_FOBJ_TYPE_UIS ? "132x24" : "80x48");

   /*-----------------------------------------------------------\
   | %f	basename of file, must occur at least once		|
   \-----------------------------------------------------------*/
   if ((tmp = kstring_replace(editstring, "%f", basename, NULL)) == NULL)
      return NULL;

#if 0
   if (!kstrcmp(tmp, editstring))
   {
      kfree(tmp);
      kerror(NULL, "Edit File",
	     "Your editor string (\"%s\") must include a %%f.",
	     editstring);
      return NULL;
   }
#endif

   /*-----------------------------------------------------------\
   | %T	replaced with toolbox name				|
   \-----------------------------------------------------------*/
   if ((tmp2 = kstring_replace(tmp, "%T", tbname, NULL)) == NULL)
      return NULL;
   kfree(tmp);
   tmp = tmp2;

   /*-----------------------------------------------------------\
   | %O	replaced with software object name	       		|
   \-----------------------------------------------------------*/
   if ((tmp2 = kstring_replace(tmp, "%O", oname, NULL)) == NULL)
      return NULL;
   kfree(tmp);
   tmp = tmp2;

   /*-----------------------------------------------------------\
   | %g	geometry specification, eg UIS files get wide window	|
   \-----------------------------------------------------------*/
   tmp2 = kstring_replace(tmp, "%g", geometry, NULL);
   kfree(tmp);

   return tmp2;
}
