/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane printpane
   >>>> 
   >>>>  Private: 
   >>>> 	printpane_print
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "composer.h"

/*-----------------------------------------------------------
| Routine Name:	printpane_print - handler routine for Print button
| 
| Purpose:	This function is called when the user hits the Print
|		button on the "Print File" subform.
| 
| Input:	printpane_info - ptr to PaneInfo struct for printpane pane
| 
| Written By:	Neil Bowers
| Date:		17-oct-94
------------------------------------------------------------*/
void
printpane_print(
   printfile_printpane *printpane_info)
{
   kstring  routine = "Print File";
   char     buffer[KLENGTH];
   char *   filepath = NULL;
   char     fullpath[KLENGTH];
   char     dirpath[KLENGTH];
   char     fbasename[KLENGTH];


   if (cur_fileobj == NULL)
      kerror(NULL, routine,
	     "No file selected.  You shouldn't see this error.");
   else if (printpane_info->printcmd_optsel)
   {
      /*-- export PRINTER variable before running command --*/
      if (printpane_info->printer != NULL)
      {
	 ksprintf(buffer, "PRINTER=%s", printpane_info->printer);
	 if (kputenv(buffer) != 0)
	    kwarn(NULL, "Print File",
		  "Failed to set the PRINTER variable "
		  "File may appear in a strange place.");

	 if (!kcms_get_attribute(cur_fileobj,
				 KCMS_FOBJ_FULLNAME, &filepath) ||
	     filepath == NULL)
	    return;

	 if (kfullpath(filepath, NULL, fullpath) == NULL)
	    return;

	 if (kdirname(fullpath, dirpath) == NULL ||
	     kbasename(fullpath, fbasename) == NULL)
	    return;

	 if (kchdir(dirpath) != 0)
	    return;

	 ksprintf(buffer, "%s %s", printpane_info->printcmd,
		  fbasename);
	 xvw_system(buffer);

	 if (kchdir(strCwd) != 0)
	    kwarn(NULL, routine, "Could not return to "
		  "current directory after printing.");
      }
   }
   else
   {
      print_file_object(cur_fileobj);
   }
}


