/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>         Functionality routines for master composer
   >>>> 
   >>>>  Private: 
   >>>>         composer_src_files
   >>>>         composer_uis_files
   >>>>         composer_doc_files
   >>>>         composer_misc_files
   >>>>         composer_all_files
   >>>>         composer_gen_code
   >>>>         composer_compile
   >>>>         composer_obj_info
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "composer.h"

/*-----------------------------------------------------------
| Routine Name:	composer_file_type
| 
| Purpose:	Do routine which is called when
|		toggle selection file_type is used
| 
| Input:	composer_info - ptr to FormInfo struct for composer
| 
| Written By:	Neil Bowers and Conductor
| Date:		7-oct-93
------------------------------------------------------------*/
void
composer_file_type(
   gui_info_struct  *composer_info)
{
   /*-- KLUDGE: use table look-up for this --*/
   switch (composer_info->file_type_val)
   {
      case 1:
	 change_list_contents(COMP_UIS_LIST);
	 break;
      case 2:
	 change_list_contents(COMP_SRC_LIST);
	 break;
      case 3:
	 change_list_contents(COMP_DOC_LIST);
	 break;
      case 4:
	 change_list_contents(COMP_CONFIG_LIST);
	 break;
      case 5:
	 change_list_contents(COMP_INFO_LIST);
	 break;
      case 6:
	 change_list_contents(COMP_MISC_LIST);
	 break;
      case 7:
	 change_list_contents(COMP_ALL_LIST);
	 break;
   }
}

/*-----------------------------------------------------------
| Routine Name:	composer_edit
| 
| Purpose:	Do routine which is called when
|		pane action button edit is used
| 
| Input:	master_info - ptr to FormInfo struct for composer
| 
| Written By:	Neil Bowers
| Date:		17-oct-93
------------------------------------------------------------*/
/* ARGSUSED */
void
composer_edit(
   gui_info_struct  *master_info)
{
   /*-- check to see if there is a file selected --*/
   if (cur_fileobj != NULL)
      edit_file_object(cur_fileobj, EDIT_ASCII);
}

/*-----------------------------------------------------------
| Routine Name:	composer_view
| 
| Purpose:	Do routine which is called when
|		pane action button view is used
| 
| Input:	master_info - ptr to FormInfo struct for composer
| 
| Written By:	Neil Bowers
| Date:		17-oct-93
------------------------------------------------------------*/
/* ARGSUSED */
void
composer_view(
   gui_info_struct  *master_info)
{
   /*-- check to see if there is a file selected --*/
   if (cur_fileobj != NULL)
      edit_file_object(cur_fileobj, EDIT_VIEW);
}

/*-----------------------------------------------------------
| Routine Name:	composer_interactive
| 
| Purpose:	Do routine which is called when
|		pane action button interactive is used
| 
| Input:	master_info - ptr to FormInfo struct for composer
| 
| Written By:	Neil Bowers
| Date:		4-dec-93
------------------------------------------------------------*/
/* ARGSUSED */
void
composer_interactive(
   gui_info_struct  *master_info)
{
   /*-- check to see if there is a file selected --*/
   if (cur_fileobj != NULL)
      edit_file_object(cur_fileobj, EDIT_SPECIAL);
}

/*-----------------------------------------------------------
| Routine Name:	composer_filelist - callback for file list
| 
| Purpose:	This function is called when the user clicks on a file in the
|		display-list which is lists files of the selected type.
| 
| Input:	master_info - ptr to FormInfo struct for composer
| 
| Written By:	Neil Bowers
| Date:		15-aug-94
------------------------------------------------------------*/
void
composer_filelist(
   gui_info_struct  *master_info)
{
   xvlist_context  *context  = cur_file_info->context;
   int              selected = master_info->filelist - 1;


   context->selected = selected;
   context->callback(context, context->strings[selected], selected);
}

/*-----------------------------------------------------------
| Routine Name: composer_rmfile
| 
| Purpose:	Do routine which is called when
|                  pane action button rmfile is used
| 
| Input:	master_info - ptr to FormInfo struct for composer
| 
| Output:	None
| Written By:	Neil Bowers
| Date:		17-oct-94
------------------------------------------------------------*/
/* ARGSUSED */
void
composer_rmfile(
     gui_info_struct *master_info)
{
   kstring           filename;
   xvlist_context   *context;


   context = cur_file_info->context;
   if (context->selected == -1)
   {
      kerror(NULL, "Delete File",
	     "No file selected.  This error should not occur.");
      return;
   }

   filename = context->strings[context->selected];

   /*-- prompt the user for confirmation --*/
   if (!kprompt(KSTANDARD, "Yes", "No", FALSE,
		"Operation: delete file from software object\n\n"
		"\tToolbox: %s\n"
		"\tObject:  %s\n"
		"\tFile:    %s\n\n"
		"Do you want to delete this file?",
		strToolbox, strObject, filename))
      return;

   xvw_format_attribute(xvoNotifier, XVW_NOTIFYWINDOW_MESSAGE,
			"Deleting file \"%s\" from object.", filename);
   xvw_format_attribute(xvoNotifier, XVW_NOTIFYWINDOW_MESSAGE,
			"Deleting file \"%s\" from object.", filename);
   xvw_set_attribute(xvoNotifier, XVW_NOTIFYWINDOW_VISIBLE, TRUE);

   if (!kcms_destroy(cur_fileobj))
      kerror(NULL, "Delete File",
	     "Delete File was unsuccesful, file may remain.");

   /*-- pick a remaining file object to be selected --*/
   cur_file_info->nfiles = -1;

   reload_object();
   xvw_set_attribute(xvoNotifier, XVW_NOTIFYWINDOW_VISIBLE, FALSE);
}

/*-----------------------------------------------------------
| Routine Name:	composer_filelist_dblclick - handle double-click on file
| 
| Purpose:	Do routine which is called when
|		user double-clicks on filelist item
| 
| Input:	master_info - ptr to FormInfo struct for composer
| 
| Written By:	Neil Bowers
| Date:		24-oct-94
------------------------------------------------------------*/
/* ARGSUSED */
void composer_filelist_dblclick(
     gui_info_struct *master_info)
{
   if (cur_fileobj != NULL)
      edit_file_object(cur_fileobj, EDIT_DOUBLECLICK);
}

/*-----------------------------------------------------------
| Routine Name: composer_save - handler for "Save" button (sync object)
| 
| Purpose:	This function is invoked when the user hits the "Save"
|		button on the composer master form.  This saves the object,
|		calling kcms_sync() to synchronize the in-memory version of
|		the object with its database.
| 
| Input:	master_info - ptr to FormInfo struct for composer
| 
| Written By:	Neil Bowers
| Date:		25-oct-94
------------------------------------------------------------*/
/* ARGSUSED */
void
composer_save(
   gui_info_struct *master_info)
{
   kcms_sync(cmsObject);
}

/*-----------------------------------------------------------
| Routine Name:	composer_spawntty - spawn a shell in a tty
| 
| Purpose:	Do routine which is called when
|		pane action button spawntty is used
| 
| Input:	master_info - ptr to FormInfo struct for composer
| 
| Written By:	Neil Bowers
| Date:		10-mar-1995
------------------------------------------------------------*/
/* ARGSUSED */
void
composer_spawntty(
   gui_info_struct *master_info)
{
   kstring  routine = "composer_spawntty()";
   char     envbuffer[KLENGTH];
   char     buffer[KLENGTH];
   kstring  ldlibpath;
   kstring  tbpath;


   if ((ldlibpath = kgetenv("LD_LIBRARY_PATH")) != NULL)
   {
      if (!kcms_get_attribute(cmsToolbox, KCMS_PATH, &tbpath))
	 kerror(NULL, routine,
		"Operation: Spawn shell\n\n"
		"Unable to determine toolbox path.\n"
		"The LD_LIBRARY_PATH environment variable "
		"will not be updated.\n");
      else
      {
	 ksprintf(envbuffer, "%s/lib:%s", tbpath, ldlibpath);
      }
      
   }

   ksprintf(buffer,
	    "/bin/sh -c 'LD_LIBRARY_PATH=%s; export LD_LIBRARY_PATH; "
	    "cd %s/src; xterm'", envbuffer, cmobj_opath);
   if (kspawn(buffer) == -1)
      kerror(NULL, routine,
	     "Failed to spawn a shell window.\n[Command was: %s]\n", buffer);
}
