 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "cantata.h"
/*-----------------------------------------------------------
| 
|  Routine Name: cantata_get_args
| 
|       Purpose: Gets command line args for cantata
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname cantata
|          Date: Apr 12, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void cantata_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for cantata is out of sync with arguments specified in cantata's *.pane file; please rerun ghostwriter on cantata.";


	/*
	 * allocate the cantata structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_logical(pane, "tbmenus",
			  &(clui_info->tbmenus_logic),
			  &(clui_info->tbmenus_flag))))
	{
	    kerror(NULL, "cantata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "wksp",
			  &(clui_info->wksp_file),
			  &(clui_info->wksp_flag))))
	{
	    kerror(NULL, "cantata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "tb",
			  &(clui_info->tb_string),
			  &(clui_info->tb_flag))))
	{
	    kerror(NULL, "cantata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "oname",
			  &(clui_info->oname_string),
			  &(clui_info->oname_flag))))
	{
	    kerror(NULL, "cantata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "form",
	                &(clui_info->form_file),
	                &(clui_info->form_flag))))
	{
	    kerror(NULL, "cantata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}
	if (!(kclui_get_int(pane, "x",
	                &(clui_info->x_int),
	                &(clui_info->x_flag))))
	{
	    kerror(NULL, "cantata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}
	if (!(kclui_get_int(pane, "y",
	                &(clui_info->y_int),
	                &(clui_info->y_flag))))
	{
	    kerror(NULL, "cantata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

}



