 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	FormInfo Extraction Routines
   >>>> 
   >>>>  Private: 
   >>>> 	_xvf_get_cantata
   >>>> 
   >>>>   Static: 
   >>>> 	_xvf_get_consoleform
   >>>> 	_xvf_get_console
   >>>> 	_xvf_get_preferences
   >>>> 	_xvf_get_customize
   >>>> 	_xvf_get_create
   >>>> 	_xvf_get_program
   >>>> 	_xvf_get_annotationform
   >>>> 	_xvf_get_annotations
   >>>> 	_xvf_get_dir
   >>>> 	_xvf_get_files
   >>>> 	_xvf_get_list
   >>>> 	_xvf_get_routines
   >>>> 	_xvf_get_find
   >>>> 	_xvf_get_finder
   >>>> 	_xvf_get_var
   >>>> 	_xvf_get_variables
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "cantata.h"


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_cantata
| 
|       Purpose: Extracts information from GUI
| 
|         Input: forminfo - pointer to gui_info_struct
| 
|        Output: none
|    Written By: conductor -name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_cantata(
     gui_info_struct *forminfo)
{
	kselection *selection;
	ksubform   *subform;
	if (forminfo->quit_struct != NULL)
	{
	    selection = forminfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->quit));

	}

	if (forminfo->workspace_struct != NULL)
	{
	    selection = forminfo->workspace_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(forminfo->workspace));
	    }

	}

	if (forminfo->wksp_attributes_struct != NULL)
	{
	    selection = forminfo->wksp_attributes_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->wksp_attributes));

	}

	if (forminfo->run_struct != NULL)
	{
	    selection = forminfo->run_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->run));

	}

	if (forminfo->reset_struct != NULL)
	{
	    selection = forminfo->reset_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->reset));

	}

	if (forminfo->clear_struct != NULL)
	{
	    selection = forminfo->clear_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->clear));

	}

	if (forminfo->check_struct != NULL)
	{
	    selection = forminfo->check_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->check));

	}

	if (forminfo->redraw_struct != NULL)
	{
	    selection = forminfo->redraw_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->redraw));

	}

	if (forminfo->wksp_info_struct != NULL)
	{
	    selection = forminfo->wksp_info_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->wksp_info));

	}

	if (forminfo->panel_struct != NULL)
	{
	    selection = forminfo->panel_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->panel));

	}

	if (forminfo->export_struct != NULL)
	{
	    selection = forminfo->export_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->export));

	}

	if (forminfo->create_procedure_struct != NULL)
	{
	    selection = forminfo->create_procedure_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->create_procedure));

	}

	if (forminfo->create_countloop_struct != NULL)
	{
	    selection = forminfo->create_countloop_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->create_countloop));

	}

	if (forminfo->create_whileloop_struct != NULL)
	{
	    selection = forminfo->create_whileloop_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->create_whileloop));

	}

	if (forminfo->copy_struct != NULL)
	{
	    selection = forminfo->copy_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->copy));

	}

	if (forminfo->cut_struct != NULL)
	{
	    selection = forminfo->cut_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->cut));

	}

	if (forminfo->paste_struct != NULL)
	{
	    selection = forminfo->paste_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->paste));

	}

	if (forminfo->duplicate_struct != NULL)
	{
	    selection = forminfo->duplicate_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->duplicate));

	}

	if (forminfo->raise_struct != NULL)
	{
	    selection = forminfo->raise_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->raise));

	}

	if (forminfo->lower_struct != NULL)
	{
	    selection = forminfo->lower_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->lower));

	}

	if (forminfo->delete_struct != NULL)
	{
	    selection = forminfo->delete_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->delete));

	}

	if (forminfo->undo_struct != NULL)
	{
	    selection = forminfo->undo_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->undo));

	}

	if (forminfo->select_struct != NULL)
	{
	    selection = forminfo->select_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->select));

	}

	if (forminfo->unselect_struct != NULL)
	{
	    selection = forminfo->unselect_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->unselect));

	}

	if (forminfo->show_clipboard_struct != NULL)
	{
	    selection = forminfo->show_clipboard_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->show_clipboard));

	}

	if (forminfo->consoleform_struct != NULL)
	{
	    subform = forminfo->consoleform_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->consoleform_selected));
	    _xvf_get_consoleform(forminfo->consoleform);

	}
	if (forminfo->preferences_struct != NULL)
	{
	    subform = forminfo->preferences_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->preferences_selected));
	    _xvf_get_preferences(forminfo->preferences);

	}
	if (forminfo->create_struct != NULL)
	{
	    subform = forminfo->create_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->create_selected));
	    _xvf_get_create(forminfo->create);

	}
	if (forminfo->annotationform_struct != NULL)
	{
	    subform = forminfo->annotationform_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->annotationform_selected));
	    _xvf_get_annotationform(forminfo->annotationform);

	}
	if (forminfo->dir_struct != NULL)
	{
	    subform = forminfo->dir_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->dir_selected));
	    _xvf_get_dir(forminfo->dir);

	}
	if (forminfo->list_struct != NULL)
	{
	    subform = forminfo->list_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->list_selected));
	    _xvf_get_list(forminfo->list);

	}
	if (forminfo->find_struct != NULL)
	{
	    subform = forminfo->find_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->find_selected));
	    _xvf_get_find(forminfo->find);

	}
	if (forminfo->var_struct != NULL)
	{
	    subform = forminfo->var_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->var_selected));
	    _xvf_get_var(forminfo->var);

	}

}

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_consoleform
| 
|       Purpose: Extracts information from consoleform subform
| 
|         Input: subforminfo - pointer to cantata_consoleform structure
| 
|        Output: none
|    Written By: conductor -name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_consoleform(
     cantata_consoleform *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->console_struct != NULL)
	{
	    pane = subforminfo->console_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->console_selected));
	    _xvf_get_console(subforminfo->console);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_console
| 
|       Purpose: Extracts information from console pane
| 
|         Input: paneinfo - pointer to consoleform_console structure
| 
|        Output: none
|    Written By: conductor -name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_console(
     consoleform_console *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'cantata->consoleform->console' Pane Info structure
	 */

	if (paneinfo->clear_struct != NULL)
	{
	    selection = paneinfo->clear_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->clear));

	}

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->wksp_struct != NULL)
	{
	    selection = paneinfo->wksp_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(paneinfo->wksp));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_preferences
| 
|       Purpose: Extracts information from preferences subform
| 
|         Input: subforminfo - pointer to cantata_preferences structure
| 
|        Output: none
|    Written By: conductor -name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_preferences(
     cantata_preferences *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->customize_struct != NULL)
	{
	    pane = subforminfo->customize_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->customize_selected));
	    _xvf_get_customize(subforminfo->customize);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_customize
| 
|       Purpose: Extracts information from customize pane
| 
|         Input: paneinfo - pointer to preferences_customize structure
| 
|        Output: none
|    Written By: conductor -name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_customize(
     preferences_customize *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'cantata->preferences->customize' Pane Info structure
	 */

	if (paneinfo->change_struct != NULL)
	{
	    selection = paneinfo->change_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->change));

	}

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->toolboxes_struct != NULL)
	{
	    selection = paneinfo->toolboxes_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->toolboxes));
	    if (paneinfo->toolboxes_label != NULL) kfree(paneinfo->toolboxes_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->toolboxes_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->toolboxes_selected));
	    }

	}

	if (paneinfo->objects_struct != NULL)
	{
	    selection = paneinfo->objects_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->objects));
	    if (paneinfo->objects_label != NULL) kfree(paneinfo->objects_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->objects_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->objects_selected));
	    }

	}

	if (paneinfo->tbname_struct != NULL)
	{
	    selection = paneinfo->tbname_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->tbname != NULL) kfree(paneinfo->tbname);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->tbname));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->tbname_selected));
	    }

	}

	if (paneinfo->oname_struct != NULL)
	{
	    selection = paneinfo->oname_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->oname != NULL) kfree(paneinfo->oname);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->oname));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->oname_selected));
	    }

	}

	if (paneinfo->icon_name_struct != NULL)
	{
	    selection = paneinfo->icon_name_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->icon_name != NULL) kfree(paneinfo->icon_name);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->icon_name));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->icon_name_selected));
	    }

	}

	if (paneinfo->category_struct != NULL)
	{
	    selection = paneinfo->category_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->category != NULL) kfree(paneinfo->category);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->category));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->category_selected));
	    }

	}

	if (paneinfo->subcategory_struct != NULL)
	{
	    selection = paneinfo->subcategory_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->subcategory != NULL) kfree(paneinfo->subcategory);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->subcategory));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->subcategory_selected));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_create
| 
|       Purpose: Extracts information from create subform
| 
|         Input: subforminfo - pointer to cantata_create structure
| 
|        Output: none
|    Written By: conductor -name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_create(
     cantata_create *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->program_struct != NULL)
	{
	    pane = subforminfo->program_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->program_selected));
	    _xvf_get_program(subforminfo->program);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_program
| 
|       Purpose: Extracts information from program pane
| 
|         Input: paneinfo - pointer to create_program structure
| 
|        Output: none
|    Written By: conductor -name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_program(
     create_program *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'cantata->create->program' Pane Info structure
	 */

	if (paneinfo->create_struct != NULL)
	{
	    selection = paneinfo->create_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->create));

	}

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->toolboxes_struct != NULL)
	{
	    selection = paneinfo->toolboxes_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->toolboxes));
	    if (paneinfo->toolboxes_label != NULL) kfree(paneinfo->toolboxes_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->toolboxes_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->toolboxes_selected));
	    }

	}

	if (paneinfo->objects_struct != NULL)
	{
	    selection = paneinfo->objects_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->objects));
	    if (paneinfo->objects_label != NULL) kfree(paneinfo->objects_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->objects_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->objects_selected));
	    }

	}

	if (paneinfo->tbname_struct != NULL)
	{
	    selection = paneinfo->tbname_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->tbname != NULL) kfree(paneinfo->tbname);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->tbname));
	    }

	}

	if (paneinfo->oname_struct != NULL)
	{
	    selection = paneinfo->oname_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->oname != NULL) kfree(paneinfo->oname);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->oname));
	    }

	}

	if (paneinfo->icon_name_struct != NULL)
	{
	    selection = paneinfo->icon_name_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->icon_name != NULL) kfree(paneinfo->icon_name);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->icon_name));
	    }

	}

	if (paneinfo->category_struct != NULL)
	{
	    selection = paneinfo->category_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->category != NULL) kfree(paneinfo->category);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->category));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->category_selected));
	    }

	}

	if (paneinfo->subcategory_struct != NULL)
	{
	    selection = paneinfo->subcategory_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->subcategory != NULL) kfree(paneinfo->subcategory);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->subcategory));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_annotationform
| 
|       Purpose: Extracts information from annotationform subform
| 
|         Input: subforminfo - pointer to cantata_annotationform structure
| 
|        Output: none
|    Written By: conductor -name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_annotationform(
     cantata_annotationform *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->annotations_struct != NULL)
	{
	    pane = subforminfo->annotations_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->annotations_selected));
	    _xvf_get_annotations(subforminfo->annotations);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_annotations
| 
|       Purpose: Extracts information from annotations pane
| 
|         Input: paneinfo - pointer to annotationform_annotations structure
| 
|        Output: none
|    Written By: conductor -name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_annotations(
     annotationform_annotations *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'cantata->annotationform->annotations' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->restore_struct != NULL)
	{
	    selection = paneinfo->restore_struct->Selptr;
	    if (selection->modified)
	    {
		if (paneinfo->restore != NULL) kfree(paneinfo->restore);
		kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
		                  &(paneinfo->restore));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->restore_selected));
	    }
	}

	if (paneinfo->save_struct != NULL)
	{
	    selection = paneinfo->save_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->save != NULL) kfree(paneinfo->save);
	    kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
	                    &(paneinfo->save));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->save_selected));
	    }
	}

	if (paneinfo->wksp_struct != NULL)
	{
	    selection = paneinfo->wksp_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(paneinfo->wksp));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_dir
| 
|       Purpose: Extracts information from dir subform
| 
|         Input: subforminfo - pointer to cantata_dir structure
| 
|        Output: none
|    Written By: conductor -name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_dir(
     cantata_dir *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->files_struct != NULL)
	{
	    pane = subforminfo->files_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->files_selected));
	    _xvf_get_files(subforminfo->files);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_files
| 
|       Purpose: Extracts information from files pane
| 
|         Input: paneinfo - pointer to dir_files structure
| 
|        Output: none
|    Written By: conductor -name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_files(
     dir_files *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'cantata->dir->files' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->restore_workspace_struct != NULL)
	{
	    selection = paneinfo->restore_workspace_struct->Selptr;
	    if (selection->modified)
	    {
		if (paneinfo->restore_workspace != NULL) kfree(paneinfo->restore_workspace);
		kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
		                  &(paneinfo->restore_workspace));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->restore_workspace_selected));
	    }
	}

	if (paneinfo->save_workspace_struct != NULL)
	{
	    selection = paneinfo->save_workspace_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->save_workspace != NULL) kfree(paneinfo->save_workspace);
	    kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
	                    &(paneinfo->save_workspace));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->save_workspace_selected));
	    }
	}

	if (paneinfo->save_glyphs_struct != NULL)
	{
	    selection = paneinfo->save_glyphs_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->save_glyphs != NULL) kfree(paneinfo->save_glyphs);
	    kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
	                    &(paneinfo->save_glyphs));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->save_glyphs_selected));
	    }
	}

	if (paneinfo->tmpdir_struct != NULL)
	{
	    selection = paneinfo->tmpdir_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->tmpdir != NULL) kfree(paneinfo->tmpdir);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->tmpdir));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->tmpdir_selected));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_list
| 
|       Purpose: Extracts information from list subform
| 
|         Input: subforminfo - pointer to cantata_list structure
| 
|        Output: none
|    Written By: conductor -name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_list(
     cantata_list *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->routines_struct != NULL)
	{
	    pane = subforminfo->routines_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->routines_selected));
	    _xvf_get_routines(subforminfo->routines);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_routines
| 
|       Purpose: Extracts information from routines pane
| 
|         Input: paneinfo - pointer to list_routines structure
| 
|        Output: none
|    Written By: conductor -name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_routines(
     list_routines *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'cantata->list->routines' Pane Info structure
	 */

	if (paneinfo->open_struct != NULL)
	{
	    selection = paneinfo->open_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->open));

	}

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->rlists_struct != NULL)
	{
	    selection = paneinfo->rlists_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(paneinfo->rlists));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_find
| 
|       Purpose: Extracts information from find subform
| 
|         Input: subforminfo - pointer to cantata_find structure
| 
|        Output: none
|    Written By: conductor -name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_find(
     cantata_find *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->finder_struct != NULL)
	{
	    pane = subforminfo->finder_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->finder_selected));
	    _xvf_get_finder(subforminfo->finder);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_finder
| 
|       Purpose: Extracts information from finder pane
| 
|         Input: paneinfo - pointer to find_finder structure
| 
|        Output: none
|    Written By: conductor -name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_finder(
     find_finder *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'cantata->find->finder' Pane Info structure
	 */

	if (paneinfo->open_struct != NULL)
	{
	    selection = paneinfo->open_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->open));

	}

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->flist_struct != NULL)
	{
	    selection = paneinfo->flist_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(paneinfo->flist));
	    }

	}

	if (paneinfo->expr_struct != NULL)
	{
	    selection = paneinfo->expr_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->expr != NULL) kfree(paneinfo->expr);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->expr));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->expr_selected));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_var
| 
|       Purpose: Extracts information from var subform
| 
|         Input: subforminfo - pointer to cantata_var structure
| 
|        Output: none
|    Written By: conductor -name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_var(
     cantata_var *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->variables_struct != NULL)
	{
	    pane = subforminfo->variables_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->variables_selected));
	    _xvf_get_variables(subforminfo->variables);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_variables
| 
|       Purpose: Extracts information from variables pane
| 
|         Input: paneinfo - pointer to var_variables structure
| 
|        Output: none
|    Written By: conductor -name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_variables(
     var_variables *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'cantata->var->variables' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->expression_struct != NULL)
	{
	    selection = paneinfo->expression_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->expression != NULL) kfree(paneinfo->expression);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->expression));
	    }

	}

	if (paneinfo->evaluate_struct != NULL)
	{
	    selection = paneinfo->evaluate_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->evaluate));

	}

	if (paneinfo->scope_struct != NULL)
	{
	    selection = paneinfo->scope_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->scope));
	    if (paneinfo->scope_label != NULL) kfree(paneinfo->scope_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->scope_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->scope_selected));
	    }

	}

	if (paneinfo->vardef_struct != NULL)
	{
	    selection = paneinfo->vardef_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->vardef));
	    if (paneinfo->vardef_label != NULL) kfree(paneinfo->vardef_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->vardef_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->vardef_selected));
	    }

	}

	if (paneinfo->delete_struct != NULL)
	{
	    selection = paneinfo->delete_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->delete));

	}

}


