 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	GUI Drivers for 'cantata'
   >>>> 
   >>>>  Private: 
   >>>> 	run_cantata
   >>>> 	run_consoleform
   >>>> 	run_console
   >>>> 	run_preferences
   >>>> 	run_customize
   >>>> 	run_create
   >>>> 	run_program
   >>>> 	run_annotationform
   >>>> 	run_annotations
   >>>> 	run_dir
   >>>> 	run_files
   >>>> 	run_list
   >>>> 	run_routines
   >>>> 	run_find
   >>>> 	run_finder
   >>>> 	run_var
   >>>> 	run_variables
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "cantata.h"

/*-----------------------------------------------------------
| 
|  Routine Name: run_cantata
| 
|       Purpose: Main GUI Driver for cantata
| 
|         Input: None
| 
|        Output: Returns TRUE on success, FALSE on failure
|    Written By: conductor -oname cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void run_cantata(
     kform    *form,
     ksubform *subform,
     kaddr    client_data)
{
	/*
	 * GUI info structure passed in as client_data 
	 */
	gui_info_struct *master_info = (gui_info_struct *) client_data;

	/*
	 * Get information from the forms
	 */
	_xvf_get_cantata(master_info);

	if (form->quit)
	{
	    xvf_destroy_allforms();
	    _xvf_free_cantata(master_info);
	    return;
	}

	    /*
	     * user clicked on master action button selection 'wksp_attributes'
	     */
	    if (master_info->wksp_attributes)
	        cantata_wksp_attributes(master_info);
	    /*
	     * user clicked on master action button selection 'run'
	     */
	    else if (master_info->run)
	        cantata_run(master_info);
	    /*
	     * user clicked on master action button selection 'reset'
	     */
	    else if (master_info->reset)
	        cantata_reset(master_info);
	    /*
	     * user clicked on master action button selection 'clear'
	     */
	    else if (master_info->clear)
	        cantata_clear(master_info);
	    /*
	     * user clicked on master action button selection 'check'
	     */
	    else if (master_info->check)
	        cantata_check(master_info);
	    /*
	     * user clicked on master action button selection 'redraw'
	     */
	    else if (master_info->redraw)
	        cantata_redraw(master_info);
	    /*
	     * user clicked on master action button selection 'wksp_info'
	     */
	    else if (master_info->wksp_info)
	        cantata_wksp_info(master_info);
	    /*
	     * user clicked on master action button selection 'panel'
	     */
	    else if (master_info->panel)
	        cantata_panel(master_info);
	    /*
	     * user clicked on master action button selection 'export'
	     */
	    else if (master_info->export)
	        cantata_export(master_info);
	    /*
	     * user clicked on master action button selection 'create_procedure'
	     */
	    else if (master_info->create_procedure)
	        cantata_create_procedure(master_info);
	    /*
	     * user clicked on master action button selection 'create_countloop'
	     */
	    else if (master_info->create_countloop)
	        cantata_create_countloop(master_info);
	    /*
	     * user clicked on master action button selection 'create_whileloop'
	     */
	    else if (master_info->create_whileloop)
	        cantata_create_whileloop(master_info);
	    /*
	     * user clicked on master action button selection 'copy'
	     */
	    else if (master_info->copy)
	        cantata_copy(master_info);
	    /*
	     * user clicked on master action button selection 'cut'
	     */
	    else if (master_info->cut)
	        cantata_cut(master_info);
	    /*
	     * user clicked on master action button selection 'paste'
	     */
	    else if (master_info->paste)
	        cantata_paste(master_info);
	    /*
	     * user clicked on master action button selection 'duplicate'
	     */
	    else if (master_info->duplicate)
	        cantata_duplicate(master_info);
	    /*
	     * user clicked on master action button selection 'raise'
	     */
	    else if (master_info->raise)
	        cantata_raise(master_info);
	    /*
	     * user clicked on master action button selection 'lower'
	     */
	    else if (master_info->lower)
	        cantata_lower(master_info);
	    /*
	     * user clicked on master action button selection 'delete'
	     */
	    else if (master_info->delete)
	        cantata_delete(master_info);
	    /*
	     * user clicked on master action button selection 'undo'
	     */
	    else if (master_info->undo)
	        cantata_undo(master_info);
	    /*
	     * user clicked on master action button selection 'select'
	     */
	    else if (master_info->select)
	        cantata_select(master_info);
	    /*
	     * user clicked on master action button selection 'unselect'
	     */
	    else if (master_info->unselect)
	        cantata_unselect(master_info);
	    /*
	     * user clicked on master action button selection 'show_clipboard'
	     */
	    else if (master_info->show_clipboard)
	        cantata_show_clipboard(master_info);
	/*
	 * action came from the 'consoleform' subform
	 */
	if (master_info->consoleform_selected)
	    run_consoleform(master_info->consoleform);
	/*
	 * action came from the 'preferences' subform
	 */
	if (master_info->preferences_selected)
	    run_preferences(master_info->preferences);
	/*
	 * action came from the 'create' subform
	 */
	if (master_info->create_selected)
	    run_create(master_info->create);
	/*
	 * action came from the 'annotationform' subform
	 */
	if (master_info->annotationform_selected)
	    run_annotationform(master_info->annotationform);
	/*
	 * action came from the 'dir' subform
	 */
	if (master_info->dir_selected)
	    run_dir(master_info->dir);
	/*
	 * action came from the 'list' subform
	 */
	if (master_info->list_selected)
	    run_list(master_info->list);
	/*
	 * action came from the 'find' subform
	 */
	if (master_info->find_selected)
	    run_find(master_info->find);
	/*
	 * action came from the 'var' subform
	 */
	if (master_info->var_selected)
	    run_var(master_info->var);

	xvf_clear_selections(form);

}

/*-----------------------------------------------------------
| 
|  Routine Name: run_consoleform
| 
|       Purpose: GUI Driver for subform 'consoleform'
| 
|         Input: form      - pointer to the form tree
|                consoleform_info - pointer to cantata_consoleform struct
| 
|        Output: None
|    Written By: conductor -program_name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_consoleform(
     cantata_consoleform *consoleform_info)
{

	/*
	 * action came from the 'console' pane
	 */
	if (consoleform_info->console_selected)
	    run_console(consoleform_info->console);


}   /* end run_consoleform */



/*-----------------------------------------------------------
| 
|  Routine Name: run_console
| 
|       Purpose: GUI Driver for pane 'console'
| 
|         Input: form - pointer to the form tree
|                console_info - pointer to consoleform_console struct
| 
|        Output: None
|    Written By: conductor -program_name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_console(
     consoleform_console *console_info)

{

	/*
	 * user clicked on pane action button selection 'clear'
	 */
	if (console_info->clear)
	{
	    console_clear(console_info);
	    console_info->clear = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_preferences
| 
|       Purpose: GUI Driver for subform 'preferences'
| 
|         Input: form      - pointer to the form tree
|                preferences_info - pointer to cantata_preferences struct
| 
|        Output: None
|    Written By: conductor -program_name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_preferences(
     cantata_preferences *preferences_info)
{

	/*
	 * action came from the 'customize' pane
	 */
	if (preferences_info->customize_selected)
	    run_customize(preferences_info->customize);


}   /* end run_preferences */



/*-----------------------------------------------------------
| 
|  Routine Name: run_customize
| 
|       Purpose: GUI Driver for pane 'customize'
| 
|         Input: form - pointer to the form tree
|                customize_info - pointer to preferences_customize struct
| 
|        Output: None
|    Written By: conductor -program_name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_customize(
     preferences_customize *customize_info)

{

	/*
	 * user clicked on pane action button selection 'change'
	 */
	if (customize_info->change)
	{
	    customize_change(customize_info);
	    customize_info->change = FALSE;
	}
	/*
	 * user selected 'live' list selection 'toolboxes'
	 */
	else if (customize_info->toolboxes_selected)
	{
	    customize_toolboxes(customize_info);
	    customize_info->toolboxes_selected = FALSE;
	}
	/*
	 * user selected 'live' list selection 'objects'
	 */
	else if (customize_info->objects_selected)
	{
	    customize_objects(customize_info);
	    customize_info->objects_selected = FALSE;
	}
	/*
	 * user selected 'live' string selection 'tbname'
	 */
	else if (customize_info->tbname_selected)
	{
	    customize_tbname(customize_info);
	    customize_info->tbname_selected = FALSE;
	}
	/*
	 * user selected 'live' string selection 'oname'
	 */
	else if (customize_info->oname_selected)
	{
	    customize_oname(customize_info);
	    customize_info->oname_selected = FALSE;
	}
	/*
	 * user selected 'live' string selection 'icon_name'
	 */
	else if (customize_info->icon_name_selected)
	{
	    customize_icon_name(customize_info);
	    customize_info->icon_name_selected = FALSE;
	}
	/*
	 * user selected 'live' string selection 'category'
	 */
	else if (customize_info->category_selected)
	{
	    customize_category(customize_info);
	    customize_info->category_selected = FALSE;
	}
	/*
	 * user selected 'live' string selection 'subcategory'
	 */
	else if (customize_info->subcategory_selected)
	{
	    customize_subcategory(customize_info);
	    customize_info->subcategory_selected = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_create
| 
|       Purpose: GUI Driver for subform 'create'
| 
|         Input: form      - pointer to the form tree
|                create_info - pointer to cantata_create struct
| 
|        Output: None
|    Written By: conductor -program_name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_create(
     cantata_create *create_info)
{

	/*
	 * action came from the 'program' pane
	 */
	if (create_info->program_selected)
	    run_program(create_info->program);


}   /* end run_create */



/*-----------------------------------------------------------
| 
|  Routine Name: run_program
| 
|       Purpose: GUI Driver for pane 'program'
| 
|         Input: form - pointer to the form tree
|                program_info - pointer to create_program struct
| 
|        Output: None
|    Written By: conductor -program_name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_program(
     create_program *program_info)

{

	/*
	 * user clicked on pane action button selection 'create'
	 */
	if (program_info->create)
	{
	    program_create(program_info);
	    program_info->create = FALSE;
	}
	/*
	 * user selected 'live' list selection 'toolboxes'
	 */
	else if (program_info->toolboxes_selected)
	{
	    program_toolboxes(program_info);
	    program_info->toolboxes_selected = FALSE;
	}
	/*
	 * user selected 'live' list selection 'objects'
	 */
	else if (program_info->objects_selected)
	{
	    program_objects(program_info);
	    program_info->objects_selected = FALSE;
	}
	/*
	 * user selected 'live' string selection 'category'
	 */
	else if (program_info->category_selected)
	{
	    program_category(program_info);
	    program_info->category_selected = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_annotationform
| 
|       Purpose: GUI Driver for subform 'annotationform'
| 
|         Input: form      - pointer to the form tree
|                annotationform_info - pointer to cantata_annotationform struct
| 
|        Output: None
|    Written By: conductor -program_name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_annotationform(
     cantata_annotationform *annotationform_info)
{

	/*
	 * action came from the 'annotations' pane
	 */
	if (annotationform_info->annotations_selected)
	    run_annotations(annotationform_info->annotations);


}   /* end run_annotationform */



/*-----------------------------------------------------------
| 
|  Routine Name: run_annotations
| 
|       Purpose: GUI Driver for pane 'annotations'
| 
|         Input: form - pointer to the form tree
|                annotations_info - pointer to annotationform_annotations struct
| 
|        Output: None
|    Written By: conductor -program_name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_annotations(
     annotationform_annotations *annotations_info)

{

	/*
	 * user selected 'live' input file selection 'restore'
	 */
	if (annotations_info->restore_selected)
	{
	    annotations_restore(annotations_info);
	    annotations_info->restore_selected = FALSE;
	}
	/*
	 * user selected 'live' output file selection 'save'
	 */
	else if (annotations_info->save_selected)
	{
	    annotations_save(annotations_info);
	    annotations_info->save_selected = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_dir
| 
|       Purpose: GUI Driver for subform 'dir'
| 
|         Input: form      - pointer to the form tree
|                dir_info - pointer to cantata_dir struct
| 
|        Output: None
|    Written By: conductor -program_name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_dir(
     cantata_dir *dir_info)
{

	/*
	 * action came from the 'files' pane
	 */
	if (dir_info->files_selected)
	    run_files(dir_info->files);


}   /* end run_dir */



/*-----------------------------------------------------------
| 
|  Routine Name: run_files
| 
|       Purpose: GUI Driver for pane 'files'
| 
|         Input: form - pointer to the form tree
|                files_info - pointer to dir_files struct
| 
|        Output: None
|    Written By: conductor -program_name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_files(
     dir_files *files_info)

{

	/*
	 * user selected 'live' input file selection 'restore_workspace'
	 */
	if (files_info->restore_workspace_selected)
	{
	    files_restore_workspace(files_info);
	    files_info->restore_workspace_selected = FALSE;
	}
	/*
	 * user selected 'live' output file selection 'save_workspace'
	 */
	else if (files_info->save_workspace_selected)
	{
	    files_save_workspace(files_info);
	    files_info->save_workspace_selected = FALSE;
	}
	/*
	 * user selected 'live' output file selection 'save_glyphs'
	 */
	else if (files_info->save_glyphs_selected)
	{
	    files_save_glyphs(files_info);
	    files_info->save_glyphs_selected = FALSE;
	}
	/*
	 * user selected 'live' string selection 'tmpdir'
	 */
	else if (files_info->tmpdir_selected)
	{
	    files_tmpdir(files_info);
	    files_info->tmpdir_selected = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_list
| 
|       Purpose: GUI Driver for subform 'list'
| 
|         Input: form      - pointer to the form tree
|                list_info - pointer to cantata_list struct
| 
|        Output: None
|    Written By: conductor -program_name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_list(
     cantata_list *list_info)
{

	/*
	 * action came from the 'routines' pane
	 */
	if (list_info->routines_selected)
	    run_routines(list_info->routines);


}   /* end run_list */



/*-----------------------------------------------------------
| 
|  Routine Name: run_routines
| 
|       Purpose: GUI Driver for pane 'routines'
| 
|         Input: form - pointer to the form tree
|                routines_info - pointer to list_routines struct
| 
|        Output: None
|    Written By: conductor -program_name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_routines(
     list_routines *routines_info)

{

	/*
	 * user clicked on pane action button selection 'open'
	 */
	if (routines_info->open)
	{
	    routines_open(routines_info);
	    routines_info->open = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_find
| 
|       Purpose: GUI Driver for subform 'find'
| 
|         Input: form      - pointer to the form tree
|                find_info - pointer to cantata_find struct
| 
|        Output: None
|    Written By: conductor -program_name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_find(
     cantata_find *find_info)
{

	/*
	 * action came from the 'finder' pane
	 */
	if (find_info->finder_selected)
	    run_finder(find_info->finder);


}   /* end run_find */



/*-----------------------------------------------------------
| 
|  Routine Name: run_finder
| 
|       Purpose: GUI Driver for pane 'finder'
| 
|         Input: form - pointer to the form tree
|                finder_info - pointer to find_finder struct
| 
|        Output: None
|    Written By: conductor -program_name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_finder(
     find_finder *finder_info)

{

	/*
	 * user clicked on pane action button selection 'open'
	 */
	if (finder_info->open)
	{
	    finder_open(finder_info);
	    finder_info->open = FALSE;
	}
	/*
	 * user selected 'live' string selection 'expr'
	 */
	else if (finder_info->expr_selected)
	{
	    finder_expr(finder_info);
	    finder_info->expr_selected = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_var
| 
|       Purpose: GUI Driver for subform 'var'
| 
|         Input: form      - pointer to the form tree
|                var_info - pointer to cantata_var struct
| 
|        Output: None
|    Written By: conductor -program_name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_var(
     cantata_var *var_info)
{

	/*
	 * action came from the 'variables' pane
	 */
	if (var_info->variables_selected)
	    run_variables(var_info->variables);


}   /* end run_var */



/*-----------------------------------------------------------
| 
|  Routine Name: run_variables
| 
|       Purpose: GUI Driver for pane 'variables'
| 
|         Input: form - pointer to the form tree
|                variables_info - pointer to var_variables struct
| 
|        Output: None
|    Written By: conductor -program_name cantata -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_variables(
     var_variables *variables_info)

{

	/*
	 * user clicked on pane action button selection 'evaluate'
	 */
	if (variables_info->evaluate)
	{
	    variables_evaluate(variables_info);
	    variables_info->evaluate = FALSE;
	}
	/*
	 * user selected 'live' list selection 'scope'
	 */
	else if (variables_info->scope_selected)
	{
	    variables_scope(variables_info);
	    variables_info->scope_selected = FALSE;
	}
	/*
	 * user selected 'live' list selection 'vardef'
	 */
	else if (variables_info->vardef_selected)
	{
	    variables_vardef(variables_info);
	    variables_info->vardef_selected = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'delete'
	 */
	else if (variables_info->delete)
	{
	    variables_delete(variables_info);
	    variables_info->delete = FALSE;
	}


}


