 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane variables
   >>>> 
   >>>>  Private: 
   >>>> 	variables_evaluate
   >>>> 	variables_scope
   >>>> 	variables_vardef
   >>>> 	variables_delete
   >>>> 
   >>>>   Static: 
   >>>> 	find_selected_workspace_from_name
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "cantata.h"

static xvobject find_selected_workspace_from_name PROTO((char *));

/*-----------------------------------------------------------
| 
|  Routine Name: variables_evaluate
| 
|       Purpose: Do routine which is called when
|                  pane action button evaluate is used
| 
|         Input: variables_info - ptr to PaneInfo struct for variables pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Dec 13, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void variables_evaluate(
     var_variables *variables_info)
{
        char     value[KLENGTH];
	char     *selected_name;
	xvobject current_workspace;

	selected_name = variables_info->scope_label;
	current_workspace = find_selected_workspace_from_name(selected_name);
        if (kexpr_evaluate_string((long)current_workspace, 
				  variables_info->expression, value, NULL))
        {
           xvf_set_attribute(variables_info->blank2_struct, XVF_TITLE, value);
	   update_vardef_displaylist(current_workspace);
        }
	else
           xvf_set_attribute(variables_info->blank2_struct, XVF_TITLE, NULL);
}


/*-----------------------------------------------------------
| 
|  Routine Name: variables_scope
| 
|       Purpose: Do routine which is called when
|                  displaylist selection scope is used
| 
|         Input: variables_info - ptr to PaneInfo struct for variables pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Dec 13, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void variables_scope(
     var_variables *variables_info)
{
	xvobject *subworkspaces;
	char     **workspace_names;
	int      num;

	update_varscope_displaylist(variables_info->scope_label);
}
/*-----------------------------------------------------------
| 
|  Routine Name: variables_vardef
| 
|       Purpose: Do routine which is called when
|                  displaylist selection vardef is used
| 
|         Input: variables_info - ptr to PaneInfo struct for variables pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Dec 13, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void variables_vardef(
     var_variables *variables_info)
{
	xvf_set_attribute(variables_info->expression_struct,
			  XVF_STRING_VAL, variables_info->vardef_label);
}


/*-----------------------------------------------------------
| 
|  Routine Name: variables_delete
| 
|       Purpose: Do routine which is called when
|                  pane action button delete is used
| 
|         Input: variables_info - ptr to PaneInfo struct for variables pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Dec 13, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void variables_delete(
     var_variables *variables_info)
{
	xvobject        selected_workspace;
	char            *selected_name;
	char            **variable_names;
	xvw_list_struct **list_return;
	int             i, num;
	char            *prompt = "Select variable(s) to delete";
	char            *label  = "Variables";


	/* selected workspace (workspace defining variables) defined 
	   by the "Scope" list, NOT necessarily the active workspace */
	selected_name = variables_info->scope_label;
	selected_workspace = find_selected_workspace_from_name(selected_name);

        /* get the variables defined in the scope of the selected workspace */
        variable_names = kexpr_variables_list((long) selected_workspace, 
					      0, &num);

	/* display list of variables defined in selected workspace */
	list_return = xvu_run_list_multsel_wait(variable_names, num, prompt,
                                                label, FALSE, FALSE, &num);
	
	/* delete specified variables from selected workspace */
	for (i = 0; i < num; i++)
	    kexpr_variable_delete((long) selected_workspace, 	
				  list_return[i]->string);

	/* update displaylist of variables & values */
	update_vardef_displaylist(selected_workspace);
}

static xvobject find_selected_workspace_from_name(
    char *name)
{
	int      i, num;
	char     *current_name;
	char     **variable_names;
	xvobject selected_workspace;
	xvobject *subworkspaces;

	/* specified name NULL => return active workspace */
	if (name == NULL)
	    return(workspace);

	/* see if specified name is for main workspace */
        current_name = xvw_name(main_workspace);
	if (kstrcmp(current_name, name) == 0) return(main_workspace);

	/* see if specified name is for active workspace */
	if (workspace != main_workspace)
	{
           xvw_get_attribute(workspace, XVW_WORKSPACE_NAME, &current_name);
	   if (kstrcmp(current_name, name) == 0) return(workspace);
	}

	/* look for specified name among all subworkspaces */
        subworkspaces = xvw_children(main_workspace, xvwWorkspaceWidgetClass,
                                     &num);
        for (i = 0; i < num; i++)
        {
            xvw_get_attribute(subworkspaces[i], XVW_WORKSPACE_NAME, 
			      &current_name);
            if (kstrcmp(name, current_name) == 0)
		return(subworkspaces[i]);
        }

	/* give up */
	return(NULL);
}
