 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for master cantata
   >>>> 
   >>>>  Private: 
   >>>> 	cantata_run
   >>>> 	cantata_reset
   >>>> 	cantata_redraw
   >>>> 	cantata_undo
   >>>> 	cantata_duplicate
   >>>> 	cantata_copy
   >>>> 	cantata_paste
   >>>> 	cantata_cut
   >>>> 	cantata_raise
   >>>> 	cantata_lower
   >>>> 	cantata_delete
   >>>> 	cantata_select
   >>>> 	cantata_unselect
   >>>> 	cantata_distribute
   >>>> 	cantata_clear
   >>>> 	cantata_check
   >>>> 	cantata_wksp_info
   >>>> 	cantata_show_clipboard
   >>>> 	cantata_wksp_attributes
   >>>> 	cantata_create_procedure
   >>>> 	cantata_create_countloop
   >>>> 	cantata_create_whileloop
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */



#include "cantata.h"


/*-----------------------------------------------------------
| 
|  Routine Name: cantata_run
| 
|       Purpose: Do routine which is called when
|                  master action button run is used
| 
|         Input: master_info - ptr to FormInfo struct for cantata
| 
|        Output: None
|    Written By: Mark Young 
|          Date: Nov 20, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void cantata_run(
     gui_info_struct *master_info)
{
	int run = FALSE;

	xvw_get_attribute(workspace, XVW_WORKSPACE_RUN, &run);
	run = !run;
	xvw_set_attribute(workspace, XVW_WORKSPACE_RUN, run);
}


/*-----------------------------------------------------------
| 
|  Routine Name: cantata_reset
| 
|       Purpose: Do routine which is called when
|                  master action button reset is used
| 
|         Input: master_info - ptr to FormInfo struct for cantata
| 
|        Output: None
|    Written By: Mark Young 
|          Date: Nov 20, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void cantata_reset(
     gui_info_struct *master_info)
{
	xvw_set_attribute(workspace, XVW_WORKSPACE_RESET, TRUE);
}


/*-----------------------------------------------------------
| 
|  Routine Name: cantata_redraw
| 
|       Purpose: Do routine which is called when
|                  master action button redraw is used
| 
|         Input: master_info - ptr to FormInfo struct for cantata
| 
|        Output: None
|    Written By: Mark Young 
|          Date: Nov 20, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void cantata_redraw(
     gui_info_struct *master_info)
{
	xvw_set_attribute(workspace, XVW_WORKSPACE_REDRAW, TRUE);
}

/*-----------------------------------------------------------
| 
|  Routine Name: cantata_undo
| 
|       Purpose: Do routine which is called when
|                  master action button undo is used
| 
|         Input: master_info - ptr to FormInfo struct for cantata
| 
|        Output: None
|    Written By: Mark Young 
|          Date: Nov 20, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void cantata_undo(
     gui_info_struct *master_info)
{
	xvw_set_attribute(workspace, XVW_CANVAS_UNDO, TRUE);
}


/*-----------------------------------------------------------
| 
|  Routine Name: cantata_duplicate
| 
|       Purpose: Do routine which is called when
|                  master action button duplicate is used
| 
|         Input: master_info - ptr to FormInfo struct for cantata
| 
|        Output: None
|    Written By: Mark Young 
|          Date: Nov 20, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void cantata_duplicate(
     gui_info_struct *master_info)
{
	xvw_set_attribute(workspace, XVW_CANVAS_DUPLICATE, TRUE);
}


/*-----------------------------------------------------------
| 
|  Routine Name: cantata_copy
| 
|       Purpose: Do routine which is called when
|                  master action button copy is used
| 
|         Input: master_info - ptr to FormInfo struct for cantata
| 
|        Output: None
|    Written By: Mark Young 
|          Date: Nov 20, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void cantata_copy(
     gui_info_struct *master_info)
{
	xvw_set_attribute(workspace, XVW_CANVAS_COPY, TRUE);
}


/*-----------------------------------------------------------
| 
|  Routine Name: cantata_paste
| 
|       Purpose: Do routine which is called when
|                  master action button paste is used
| 
|         Input: master_info - ptr to FormInfo struct for cantata
| 
|        Output: None
|    Written By: Mark Young 
|          Date: Nov 20, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void cantata_paste(
     gui_info_struct *master_info)
{
	xvw_set_attribute(workspace, XVW_CANVAS_PASTE, TRUE);
}


/*-----------------------------------------------------------
| 
|  Routine Name: cantata_cut
| 
|       Purpose: Do routine which is called when
|                  master action button cut is used
| 
|         Input: master_info - ptr to FormInfo struct for cantata
| 
|        Output: None
|    Written By: Mark Young 
|          Date: Nov 20, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void cantata_cut(
     gui_info_struct *master_info)
{
	xvw_set_attribute(workspace, XVW_CANVAS_CUT, TRUE);
}


/*-----------------------------------------------------------
| 
|  Routine Name: cantata_raise
| 
|       Purpose: Do routine which is called when
|                  master action button raise is used
| 
|         Input: master_info - ptr to FormInfo struct for cantata
| 
|        Output: None
|    Written By: Mark Young 
|          Date: Nov 20, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void cantata_raise(
     gui_info_struct *master_info)
{
	xvw_set_attribute(workspace, XVW_CANVAS_RAISE, TRUE);
}


/*-----------------------------------------------------------
| 
|  Routine Name: cantata_lower
| 
|       Purpose: Do routine which is called when
|                  master action button lower is used
| 
|         Input: master_info - ptr to FormInfo struct for cantata
| 
|        Output: None
|    Written By: Mark Young 
|          Date: Nov 20, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void cantata_lower(
     gui_info_struct *master_info)
{
	xvw_set_attribute(workspace, XVW_CANVAS_LOWER, TRUE);
}


/*-----------------------------------------------------------
| 
|  Routine Name: cantata_delete
| 
|       Purpose: Do routine which is called when
|                  master action button delete is used
| 
|         Input: master_info - ptr to FormInfo struct for cantata
| 
|        Output: None
|    Written By: Mark Young 
|          Date: Nov 20, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void cantata_delete(
     gui_info_struct *master_info)
{
	xvw_set_attribute(workspace, XVW_CANVAS_DELETE, TRUE);
}


/*-----------------------------------------------------------
| 
|  Routine Name: cantata_select
| 
|       Purpose: Do routine which is called when
|                  master action button select is used
| 
|         Input: master_info - ptr to FormInfo struct for cantata
| 
|        Output: None
|    Written By: Mark Young 
|          Date: Nov 20, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void cantata_select(
     gui_info_struct *master_info)
{
	xvw_set_attribute(workspace, XVW_CANVAS_SELECTALL, TRUE);
}


/*-----------------------------------------------------------
| 
|  Routine Name: cantata_unselect
| 
|       Purpose: Do routine which is called when
|                  master action button unselect is used
| 
|         Input: master_info - ptr to FormInfo struct for cantata
| 
|        Output: None
|    Written By: Mark Young 
|          Date: Nov 20, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void cantata_unselect(
     gui_info_struct *master_info)
{
	xvw_set_attribute(workspace, XVW_CANVAS_UNSELECTALL, TRUE);
}


/*-----------------------------------------------------------
| 
|  Routine Name: cantata_distribute
| 
|       Purpose: Do routine which is called when
|                  master action button distribute is used
| 
|         Input: master_info - ptr to FormInfo struct for cantata
| 
|        Output: None
|    Written By: Mark Young 
|          Date: Nov 20, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void cantata_distribute(
     gui_info_struct *master_info)
{
	/* PUT YOUR CODE HERE ! */
}

/*-----------------------------------------------------------
| 
|  Routine Name: cantata_clear
| 
|       Purpose: Do routine which is called when
|                  master action button clear is used
| 
|         Input: master_info - ptr to FormInfo struct for cantata
| 
|        Output: None
|    Written By: Mark Young 
|          Date: Nov 20, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void cantata_clear(
     gui_info_struct *master_info)
{
	if (kprompt(KSTANDARD, "Clear", "Cancel", 1, "Clear the cantata \
workspace of all Glyphs?") == TRUE)
	{
	   xvw_set_attribute(workspace, XVW_WORKSPACE_CLEAR, TRUE);
	}
}


/*-----------------------------------------------------------
| 
|  Routine Name: cantata_check
| 
|       Purpose: Do routine which is called when
|                  master action button check is used
| 
|         Input: master_info - ptr to FormInfo struct for cantata
| 
|        Output: None
|    Written By: Mark Young 
|          Date: Nov 20, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void cantata_check(
     gui_info_struct *master_info)
{
	xvw_set_attribute(workspace, XVW_WORKSPACE_CHECK, TRUE);
}


/*-----------------------------------------------------------
| 
|  Routine Name: cantata_wksp_info
| 
|       Purpose: Do routine which is called when
|                  master action button wksp_info is used
| 
|         Input: master_info - ptr to FormInfo struct for cantata
| 
|        Output: None
|    Written By: Mark Young 
|          Date: Nov 20, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void cantata_wksp_info(
     gui_info_struct *master_info)
{
	xvw_set_attribute(workspace, XVW_WORKSPACE_INFO, TRUE);
}


/*-----------------------------------------------------------
| 
|  Routine Name: cantata_wksp_attributes
| 
|       Purpose: Do routine which is called when
|                  master action button wksp_attributes is used
| 
|         Input: master_info - ptr to FormInfo struct for cantata
| 
|        Output: None
|    Written By: Mark Young 
|          Date: Oct 11, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void cantata_wksp_attributes(
     gui_info_struct *master_info)
{
	xvw_activate_menu(workspace);
}
/*-----------------------------------------------------------
| 
|  Routine Name: cantata_show_clipboard
| 
|       Purpose: Do routine which is called when
|                  master action button show_clipboard is used
| 
|         Input: master_info - ptr to FormInfo struct for cantata
| 
|        Output: None
|    Written By: Mark Young
|          Date: Dec 09, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void cantata_show_clipboard(
     gui_info_struct *master_info)
{
	xvw_set_attribute(workspace, XVW_WORKSPACE_SHOW_CLIPBOARD, TRUE);
}


/*-----------------------------------------------------------
| 
|  Routine Name: cantata_panel
| 
|       Purpose: Do routine which is called when
|                  master action button panel is used
| 
|         Input: master_info - ptr to FormInfo struct for cantata
| 
|        Output: None
|    Written By: Mark Young
|          Date: Jul 04, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void cantata_panel(
     gui_info_struct *master_info)
{
	xvw_set_attribute(workspace, XVW_WORKSPACE_SHOW_WKSPGUI, TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: cantata_exit
|
|       Purpose: Routine which is called before
|                exiting cantata, to prompt user to save
|                workspace.  Note that this is NOT a "do" routine,
|                is a callback added to the QUIT button with
|                the use of xvf_add_extra_call().
|
|         Input: client_data  
|        Output: None
|    Written By: Danielle Argiro
|          Date: Oct 18, 1994
| Modifications:
|
------------------------------------------------------------*/

void cantata_timeout(
     xvobject object, 
     kaddr    client_data,
     int      *dispatch)
{
	kexit(KEXIT_SUCCESS);
}

/* ARGSUSED */
void cantata_exit(
     kaddr client_data)
{
	static char *prompt = "REALLY exit from cantata?";
	static char *options[] = {"Cancel action (don't exit)",
				  "Save workspace, then exit",
				  "Exit without saving workspace"};
	char *answer, temp[KLENGTH];
	int  return_index;
	xvobject plane;
	int  num_glyphs, exit_cantata = FALSE;

	xvw_get_attribute(main_workspace, XVW_VP_PLANE_OBJECT, &plane);
	(void) xvw_children(plane, NodeWidgetClass, &num_glyphs);

	if (num_glyphs == 0)
	{
	   xvw_add_timeout(NULL, 0.0, cantata_timeout, NULL);
	   xvf_destroy_form(cantata_form);
	   return;
	}
	(void) kchoose(KSTANDARD, options, knumber(options),
		       1, temp, &return_index, prompt);

	/*
	 * don't quit after all
	 */
	if ((return_index == 0) || (return_index == 1))
	   return;

	/*
	 * save workspace, then quit
	 */
	else if (return_index == 2)
	{
	   answer = temp;
	   temp[0] = '\0';
	   if (!(xvu_query_wait("Specify Filename for Saved Workspace",
                                 NULL, "ok", &answer, 1, 50)))
           {
              return;
           }

	   if (kstrlen(answer) > 0)
	   {
	      save_workspace(answer, TRUE);
	      if (!(kprompt(KSTANDARD, "Exit", "Cancel", 0, 
		             "Current workspace saved to %s; exiting.", 
		              answer)))
	      {
		 return;
	      }
	   }
	   exit_cantata = TRUE;
	}

	/*
	 * quit straight out
	 */
	else
	{
	   exit_cantata = TRUE;
	}

	if (exit_cantata == TRUE)
	{
	   xvw_add_timeout(NULL, 0.0, cantata_timeout, NULL);
	   xvf_destroy_form(cantata_form);
	}
}

/*-----------------------------------------------------------
| 
|  Routine Name: cantata_export
| 
|       Purpose: Do routine which is called when
|                  master action button export is used
| 
|         Input: master_info - ptr to FormInfo struct for cantata
| 
|        Output: None
|    Written By: Mark Young
|          Date: Nov 07, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void cantata_export(
     gui_info_struct *master_info)
{
	xvw_set_attribute(workspace, XVW_WORKSPACE_EXPORT_SELECTIONS, TRUE);
}
/*-----------------------------------------------------------
| 
|  Routine Name: cantata_create_procedure
| 
|       Purpose: Do routine which is called when
|                  master action button create_procedure is used
| 
|         Input: master_info - ptr to FormInfo struct for cantata
| 
|        Output: None
|    Written By: Mark Young
|          Date: Nov 23, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void cantata_create_procedure(
     gui_info_struct *master_info)
{
	xvw_set_attribute(workspace, XVW_WORKSPACE_CREATE_PROCEDURE, TRUE);
}


/*-----------------------------------------------------------
| 
|  Routine Name: cantata_create_countloop
| 
|       Purpose: Do routine which is called when
|                  master action button create_countloop is used
| 
|         Input: master_info - ptr to FormInfo struct for cantata
| 
|        Output: None
|    Written By: Mark Young
|          Date: Nov 23, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void cantata_create_countloop(
     gui_info_struct *master_info)
{
	xvw_set_attribute(workspace, XVW_WORKSPACE_CREATE_COUNTLOOP, TRUE);
}


/*-----------------------------------------------------------
| 
|  Routine Name: cantata_create_whileloop
| 
|       Purpose: Do routine which is called when
|                  master action button create_whileloop is used
| 
|         Input: master_info - ptr to FormInfo struct for cantata
| 
|        Output: None
|    Written By: Mark Young
|          Date: Nov 23, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void cantata_create_whileloop(
     gui_info_struct *master_info)
{
	xvw_set_attribute(workspace, XVW_WORKSPACE_CREATE_WHILELOOP, TRUE);
}
