 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>                  View xvobject			      <<<<
   >>>>                                                       <<<<
   >>>>  Private:                                             <<<<
   >>>>                xvu_create_view()		      <<<<              
   >>>>   Static:                                             <<<<
   >>>>                xvu_quit_view()			      <<<<              
   >>>>   Public:                                             <<<<
   >>>>                xvu_view_wait()			      <<<<              
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"	

static int  xvu_view_count = 0;
static int  xvu_view_done  = FALSE;

static void xvu_quit_view PROTO((xvobject, kaddr, int));

/************************************************************
*
*  Routine Name: xvu_view_wait - pop up read-only viewer object; wait for acknowledgement
*
*       Purpose: Creates and pops up a viewer object; the viewer
*                object must be acknowledged by the user before control
*                is returned to the application program.
*
*         Input: filename - character string containing the name
*                            (and path) of the ascii file to be displayed
*                            in help object.  
*
*                label    - short label for top of viewer;
*			    NULL gives default of "VIEW".
*
*        Output:
*	Returns: TRUE on success, FALSE on failure.
*  Restrictions:
*    Written By: Danielle Argiro & Stephanie Hallett
*          Date: May 27, 1992 15:12
*      Verified:
*  Side Effects:
* Modifications: Converted from Khoros 1.0 (DA)
*
*************************************************************/

int xvu_view_wait(
   char *filename,
   char *label)
{
	xvu_view_done = FALSE;

        /*
         *  xvu_view_wait supports non-X displays
         */
	if (xvw_display(NULL) == NULL)
	{
	    kinfo(KSTANDARD, "see file '%s'\n", filename);
	    return(TRUE);
	}

	if (!(xvu_create_view(filename, label)))
	    return(FALSE);

	while(!xvu_view_done)
	    xvw_process_event();  

	return(TRUE);
}


/*-----------------------------------------------------------
|
|  Routine Name: xvu_create_view()
|
|       Purpose: Creates a viewer object,  with the label specified,
|		 text object for displaying the file, and a quit button.
|
|         Input: filename   - name and full path of file to be displayed
|                view_label - short label for top of object;
|                             NULL will give default of "VIEWER"
|
|        Output: Returns TRUE on success, FALSE on failure.
|    Written By: Danielle Argiro & Stephanie Hallett
|          Date: Jul 9, 1992
| Modifications: Converted from Khoros 1.0 (DA)
|
------------------------------------------------------------*/

#define VIEWWER_WIDTH  60
#define VIEWWER_HEIGHT 40

int xvu_create_view(
   char *filename,
   char *view_label)
{
	xvobject toplevel;	/* toplevel object for view */
	xvobject back;		/* backplane for view */
	xvobject label;	        /* label describing type of view */
	xvobject quit;		/* quit button to get rid of view */
	xvobject view;		/* view object */
	float  label_width, width, height;
	char   name[KLENGTH], temp[KLENGTH];

	if (filename == NULL)
	{
	    errno = KNULL_PARAMETER;
	    kerror("xvutils", "xvu_create_view",
		   "'filename' cannot be NULL");
	    return(FALSE);
	}

	if(view_label == NULL)
	   view_label = kstring_copy("VIEWER", NULL);

	if (kaccess(filename, R_OK) != 0)
	{
	    ksprintf(temp, "Unable to find file '%s' to view");
	    kerror("xvutils", "xvu_create_view", temp);
	    return(FALSE);
	}

	/*
	 * create identifying object name
	 */
	ksprintf(name, "%d_view", xvu_view_count++);

	/* 
	 * create the view box's toplevel object and add it to the list of 
	 * toplevels that is used with journal playback. 
	 */
        toplevel = xvw_create_transient_shell(name, NULL, NULL);

	/* 
	 * create the backplane object 
	 */
	back = xvw_create_manager(toplevel, "back");

	/* 
	 * create label object 
	 */
	label_width = VIEWWER_WIDTH - 12.0;
	label = xvw_create_label(back, "label");
        xvw_set_attributes(label,
		XVW_LABEL,          view_label,        /* label      */
		XVW_CHAR_WIDTH,     label_width,       /* set width */
                XVW_BORDER_WIDTH,   0,                 /* no border */
                XVW_MAP_WHEN_MANAGED,         TRUE,    /* mapped    */
		XVW_LABEL_JUSTIFY, KLABEL_JUSTIFY_CENTER, /* centered  */
                NULL);
	/* 
	 * create text object 
	 */
	width  = (float) VIEWWER_WIDTH;
	height = (float) VIEWWER_HEIGHT;
	view = xvw_create_text(back, "view_text");
        xvw_set_attributes(view,
		XVW_TEXT_MULTILINE, TRUE,	    /* multi-line    */
		XVW_TEXT_STRING,    filename,	    /* text          */
                XVW_CHAR_WIDTH,     width,          /* set width     */
                XVW_CHAR_HEIGHT,    height,         /* set height    */
                XVW_MAP_WHEN_MANAGED, TRUE,         /* mapped        */
                XVW_BELOW,           label,          /* below label   */
                XVW_TEXT_EDIT_TYPE, KTEXT_READ,     /* read-only     */
                XVW_TEXT_WRAP,      KTEXT_WRAP_WORD,  /* wrap on word  */
                XVW_TEXT_SCROLL_VERT, KSCROLLBAR_IFNEEDED, /* scrollbar */
                NULL);

	/* 
	 * create quit button 
	 */
	width = 5.0;
	quit = xvw_create_button(back, "quit");
        xvw_set_attributes(quit,
		XVW_LABEL,      "QUIT",  /* button label   */
		XVW_RIGHT_OF,   label,   /* R of label   */
                XVW_CHAR_WIDTH, width,   /* set width     */
                NULL);

	xvw_add_callback(quit, XVW_BUTTON_SELECT, 
			xvu_quit_view, toplevel);
	xvw_add_protocol(toplevel, "WM_DELETE_WINDOW", 
			 xvu_quit_view, toplevel);
	return(TRUE);
}


/*-----------------------------------------------------------
|
|  Routine Name: xvu_quit_view()
|
|       Purpose: Destroys the viewer object when the user clicks 
|                on the acknowledgement button.
|
|         Input: object     - the quit button
|                client_data - toplevel object
|
|        Output: none
|       Returns: none
|    Written By: Danielle Argiro
|          Date: Jul 9, 1992
| Modifications: Converted from Khoros 1.0 (DA)
|
------------------------------------------------------------*/
/* ARGSUSED */
static void xvu_quit_view(
   xvobject object,
   kaddr  client_data,
   int    call_data)
{
	xvobject toplevel = (xvobject) client_data;

	xvw_remove_protocol(toplevel, "WM_DELETE_WINDOW", 
			    xvu_quit_view, toplevel);
	xvw_unmap(toplevel);
	xvw_destroy(toplevel);
	xvu_view_done = TRUE;
}
