 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>		   Utilities for List xvobjects                 <<<<
   >>>>                                                       <<<<
   >>>>  Private:					      <<<<
   >>>>             xvu_add_list_entry()                      <<<<
   >>>>             xvu_delete_list_entry()                   <<<<
   >>>>   Static:					      <<<<
   >>>>   Public:					      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"

extern xvu_list_entry  *list_head, *list_tail;

/*--------------------------------------------------------------
|
|  Routine Name: xvu_add_list_entry()
|
|       Purpose: Creates a new entry for the xvu_list 
|
|         Input: none
|        Output: Returns a pointer to the new xvu_list_entry on success, 
|                NULL on failure
|
|    Written By: Mark Young
|          Date: May 20, 1992
| Modifications: Converted from Khoros 1.0 (DA)
|
----------------------------------------------------------------*/

xvu_list_entry *xvu_add_list_entry(void)
{
        xvu_list_entry *new;

        new = (xvu_list_entry *) kmalloc(sizeof(xvu_list_entry));
        new->entry =(xvw_list_struct *) kmalloc(sizeof(xvw_list_struct));
        new->count = 1;

        if (list_head == NULL)
        {
           list_head = list_tail = new;
           list_head->next = list_tail->next = NULL;
           list_head->prev = list_tail->prev = NULL;
        }
        else if (list_head == list_tail)
        {
           list_head->next = new;
           new->prev = list_head;
           new->next = NULL;
           list_tail = new;
        }
        else
        {
           list_tail->next = new;
           new->prev = list_tail;
           new->next = NULL;
           list_tail = new;
        }
        return(new);
}


/*--------------------------------------------------------------
|
|  Routine Name: xvu_delete_list_entry()
|
|       Purpose: Deletes an old entry from the xvu_list 
|
|         Input: entry - the entry to be deleted
|        Output: none
|
|    Written By: Mark Young
|          Date: May 20, 1992
| Modifications: Converted from Khoros 1.0 (DA)
|
----------------------------------------------------------------*/
void xvu_delete_list_entry(
   xvu_list_entry *entry)
{
        if (entry == NULL)
           return;

        if (list_tail == list_head)
        {
           list_head = list_tail = NULL;
        }
        else if (entry == list_head)
        {
           list_head = list_head->next;
           list_head->prev = NULL;
        }
        else if (entry == list_tail)
        {
           list_tail = list_tail->prev;
           list_tail->next = NULL;
        }
        else
        {
           entry->next->prev = entry->prev;
           entry->prev->next = entry->next;
        }

        if (entry->entry->string != NULL)
           kfree(entry->entry->string);
        if (entry->entry != NULL)
           kfree(entry->entry);
        if (entry != NULL)
           kfree(entry);
}

