 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>	              Khoros OutputFile GUI Widget
   >>>>  Private:
   >>>>   Static:
   >>>> 		ClassInitialize()
   >>>>			Initialize()
   >>>>			SetValues()
   >>>> 		ActionCallback()
   >>>> 		BrowserCallback()
   >>>>   Public:
   >>>>			xvw_create_outputfile()
   >>>>	
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <X11/keysym.h>
#include <xvobjects/OutputFileP.h>

static void     ClassInitialize PROTO((void));
static void	Initialize	PROTO((Widget, Widget, ArgList, Cardinal *));
static Boolean  SetValues  PROTO((Widget, Widget, Widget, ArgList, Cardinal *));
static void	ActionCallback  PROTO((xvobject, kaddr, XEvent *));
static void     BrowserCallback PROTO((xvobject, kaddr, kaddr));



/*-------------------------------------------------------------------*
|
|   Full class attributes
|
--------------------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_OUTPUTFILE_DISPLAY_BUTTON,   NULL,   XtRInt,      XtRBoolean},
{XVW_OUTPUTFILE_BUTTON_OBJECT,    NULL,   XtRPointer,  NULL},
{XVW_OUTPUTFILE_TEXT_OBJECT,      NULL,   XtRPointer,  NULL},
{XVW_OUTPUTFILE_CRLABEL_OBJECT,   NULL,   XtRPointer,  NULL},
{XVW_OUTPUTFILE_BROWSER_OBJECT,   NULL,   XtRPointer,  NULL},
{XVW_OUTPUTFILE_CALLBACK,	  NULL,   XtRCallback, NULL},
};


/*-------------------------------------------------------------------*
|
|   Full class record constant
|
--------------------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwOutputFileWidgetRec, outputfile.field)

static XtResource resources[] = { 
{XVW_OUTPUTFILE_DISPLAY_BUTTON, NULL, XtRBoolean, sizeof(Boolean),
        offset(display_button), XtRImmediate, (XtPointer) TRUE},
{XVW_OUTPUTFILE_BUTTON_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(button), XtRImmediate, (XtPointer) NULL},
{XVW_OUTPUTFILE_TEXT_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(text), XtRImmediate, (XtPointer) NULL},
{XVW_OUTPUTFILE_CRLABEL_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(crlabel), XtRImmediate, (XtPointer) NULL},
{XVW_OUTPUTFILE_BROWSER_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(browser), XtRImmediate, (XtPointer) NULL},
{XVW_OUTPUTFILE_CALLBACK, NULL, XtRCallback, sizeof(XtPointer),
      offset(outputfile_callback), XtRCallback, (XtPointer) NULL},

{XVW_WIDTH, NULL, XtRDimension, sizeof(Dimension),
        XtOffsetOf(XvwOutputFileWidgetRec, core.width),
        XtRImmediate, (XtPointer) 300 },
{XVW_BORDER_WIDTH, NULL, XtRDimension, sizeof(Dimension),
        XtOffsetOf(XvwOutputFileWidgetRec, core.border_width),
        XtRImmediate, (XtPointer) 0 },
{XVW_BUFFER_DIST, NULL, XtRDimension, sizeof(Dimension),
        XtOffsetOf(XvwOutputFileWidgetRec, manager.buffer_dist),
        XtRImmediate, (XtPointer) 0 },
};
#undef offset


/*-------------------------------------------------------------------*
|
|   Class Declaration for OutputFile Widget
|
--------------------------------------------------------------------*/

#define superclass (&xvwManagerWidgetClassRec)

XvwOutputFileWidgetClassRec xvwOutputFileWidgetClassRec =
{
  {
    (WidgetClass) superclass,		/* superclass		  */	
    "OutputFile",			/* class_name		  */
    sizeof(XvwOutputFileWidgetRec),	/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    XtInheritQueryGeometry,		/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,				    /* subresources	  */
    0,					    /* subresources_count */
    sizeof(XvwOutputFileWidgetConstraintsRec),  /* constraint_size	  */
    NULL,				    /* initialize	  */
    NULL,				    /* destroy		  */
    NULL,				    /* set_values	  */
    NULL,				    /* extension	  */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,                        /* child layout routine  */
    XtInheritChangeSel,			    /* change selected proc   */
    XtInheritEraseSel,			    /* erase selected proc    */
    XtInheritRefreshSel,		    /* refresh selection proc */
    XtInheritResize,			    /* resize		      */
    XtInheritGeometryManager,		    /* geometry_manager	      */
  },  /* XvwManagerWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwOutputFileWidgetClass fields initialization */
};
#undef superclass

  /* for public consumption */
WidgetClass xvwOutputFileWidgetClass = (WidgetClass) &xvwOutputFileWidgetClassRec;


/*-------------------------------------------------------------------*
|
|   Miscelleanous defines for widget definition
|
--------------------------------------------------------------------*/

#undef  kwidget
#define kwidget(widget)	     (XvwOutputFileWidget) (widget)


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an
|                instance of a XvwOutputFileWidget class has been created.
|                This is where the attributes for the class are
|		 initialized. 
|
|         Input:
|
|        Output:
|       Returns: 
|
|    Written By: Mark Young
|          Date: Nov 01, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassInitialize(void)
{
	xvw_init_attributes(xvwOutputFileWidgetClass, attributes,
		XtNumber(attributes), NULL, 0, NULL);
	xvw_load_resources("$DESIGN/objects/library/xvobjects/app-defaults/OutputFile");
}


/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|	Purpose: This method will set up the initial outputfile widget instance.
|
|	  Input: request - not used
|                new     - widget instance after initialization
|
|	 Output: None
|
|    Written By: Mark Young
|          Date: Nov 01, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwOutputFileWidget xwid = kwidget(new);
	xvobject button, object = xvw_object(new);


	xwid->outputfile.button = xvw_create_button(object, "button");
	xvw_set_attributes(xwid->outputfile.button,
		XVW_LABEL,	      "OutputFile:",
		XVW_CHAR_MAX_HEIGHT,  1.0,
		XVW_LABEL_JUSTIFY,    KLABEL_JUSTIFY_LEFT,
		XVW_BORDER_WIDTH,     0,
		XVW_RIGHT_OF,	      NULL,
		XVW_ABOVE,	      NULL,
		XVW_BELOW,	      NULL,
		XVW_MAP_WHEN_MANAGED, xwid->outputfile.display_button,
		NULL);

	xwid->outputfile.crlabel = xvw_create_pixmap(object, "cr_pixmap");
	xvw_set_attributes(xwid->outputfile.crlabel,
		XVW_BORDER_WIDTH,     0,
		XVW_LEFT_OF,	      NULL,
		XVW_ABOVE,	      NULL,
		XVW_BELOW,	      NULL,
		NULL);

	if (xwid->outputfile.display_button == TRUE)
	   button = xwid->outputfile.button;
	else
	   button = NULL;

	xwid->outputfile.text = xvw_create_text(object, "text");
	xvw_set_attributes(xwid->outputfile.text,
		XVW_TEXT_MULTILINE,   FALSE,
		XVW_CHAR_MAX_HEIGHT,  1.0,
		XVW_CHAR_WIDTH,	      10.0,
		XVW_BORDER_WIDTH,     2,
		XVW_LEFT_OF,	      xwid->outputfile.crlabel,
		XVW_RIGHT_OF,	      button,
		XVW_TACK_EDGE,	      KMANAGER_TACK_HORIZ,
		XVW_ABOVE,	      NULL,
		XVW_BELOW,	      NULL,
		NULL);

	xvw_set_attributes(object,
		XVW_CHAR_MAX_HEIGHT, 1.0,
		XVW_CHAR_MIN_HEIGHT, 1.0,
		XVW_BORDER_WIDTH,    0,
		NULL);

	xvw_add_action(xwid->outputfile.text, "<Key>Tab", ActionCallback,
		object, TRUE);
	xvw_add_action(xwid->outputfile.text, "<Key>Return", ActionCallback,
		object, TRUE);
	xvw_add_action(xwid->outputfile.text, "Ctrl<Key>d", ActionCallback,
		object, TRUE);
	xvw_insert_callback(xwid->outputfile.button, XVW_BUTTON_SELECT, TRUE,
		BrowserCallback, object);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues 
|
|       Purpose: This method is used to set the public values 
|                of a XvwOutputFileWidget instance.  The public values
|		 which can be changed are the current directory and
|		 the filter being used.
|
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|    Written By: Mark Young
|          Date: Dec 13, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwOutputFileWidget cxwid = kwidget(current);
	XvwOutputFileWidget nxwid = kwidget(new);


	if (cxwid->outputfile.display_button!=nxwid->outputfile.display_button)
	{
	   if (nxwid->outputfile.display_button == FALSE)
	   {
	      xvw_set_attribute(nxwid->outputfile.text, XVW_RIGHT_OF, NULL);
	      xvw_unmap(nxwid->outputfile.button);
	   }
	   else
	   {
	      xvw_map(nxwid->outputfile.button);
	      xvw_set_attribute(nxwid->outputfile.text, XVW_RIGHT_OF,
			nxwid->outputfile.button);
	   }
	}
	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: ActionCallback
|
|       Purpose: This routine will be called when the user presses return
|		 within the text window.
|
|         Input: text      - which text being manipulated
|                client_data - the outputfile gui object
|                event	     - the event that triggered us
|
|        Output: None
|       Returns: None
|
|    Written By: Mark Young
|          Date: Nov 01, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ActionCallback(
   xvobject text,
   kaddr    client_data,
   XEvent   *event)
{
	xvobject object = (xvobject) client_data;

	XKeyEvent *xkey;
        KeySym	  keysym;
	int	  i, num;
        char	  temp[KLENGTH], new[KLENGTH]; 
	char      **names, *istr, *ostr, *filename = NULL;


	if (event->type != KeyPress)
	   return;

	xkey = (XKeyEvent *) &(event->xkey);
	(void) XLookupString(xkey, temp, KLENGTH, &keysym, NULL);
	xvw_get_attribute(text, XVW_TEXT_STRING, &filename);

	if (keysym == XK_Return)
	{
	   XtCallCallbacks(xvw_widget(object), XVW_OUTPUTFILE_CALLBACK,
			   &filename);
	}
	else if (keysym == XK_Tab)
	{
	   if ((names = karray_dirlist(filename, NULL, NULL, KFILE|KDIR,
		TRUE, &num)) == NULL)
	   {
	      XBell(xvw_display(object), 0);
	      return;
	   }

	   for (i = 1; i < num && *names[0] != '\0'; i++)
	   {
	      istr = names[0];
	      ostr = names[i];
	      while (*istr == *ostr && *istr != '\0' && *ostr != '\0')
	      {
		 istr++; ostr++;
	      }
	      *istr = '\0';
	   }

	   if (!kdirname(filename, temp))
	      kstrcpy(new, names[0]);
	   else
	      ksprintf(new, "%s/%s", temp, names[0]);
	   
	   xvw_set_attribute(text, XVW_TEXT_STRING, new);
	   karray_free(names, num, NULL);
	}
	else
	{
	   if ((names = karray_dirlist(filename, NULL,NULL, KFILE|KDIR, FALSE,
					&num)) == NULL)
	   {
	      XBell(xvw_display(object), 0);
	      return;
	   }
	   for (i = 0; i < num; i++)
	       kprintf("%s  ", names[i]);

	   kprintf("\n");
	   karray_free(names, num, NULL);
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: BrowserCallback
|
|       Purpose: This routine will change the text and update the
|	 	 scrollbar according to the value paased in.
|
|         Input: button      - the button object itself
|		 call_data   - none
|		 client_data - the outputfile gui object
|
|        Output: None
|       Returns: None 
|
|    Written By: Mark Young 
|          Date: Jun 06, 1993 10:58
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void BrowserCallback(
   xvobject button,
   kaddr    client_data,
   kaddr    call_data)
{
	xvobject object = (xvobject) client_data;

	char temp[KLENGTH];
	char *filename = NULL;


	/*
	 *  Get the label and the filename associated with the outputfile.
	 */
	xvw_get_attribute(object, XVW_OUTPUTFILE_FILENAME, &filename);

	/*
	 *  Browse for the new filename...
	 */
	if (kstring_cleanup(filename, temp) != NULL)
	   filename = kdirname(filename, temp);

	if ((filename = xvu_run_browser(filename)) == NULL)
	   return;

	xvw_set_attribute(object, XVW_OUTPUTFILE_FILENAME, filename);
	XtCallCallbacks(xvw_widget(object), XVW_OUTPUTFILE_CALLBACK, &filename);
}

/************************************************************
*
*  Routine Name: xvw_create_outputfile - create a outputfile GUI object
*
*       Purpose: The outputfile GUI object
*                allows the user to enter an output file.  It features a 
*                text box in which the user may type in the filename;  
*                the filename is registered when the user hits <cr>.  
*                The label of the outputfile GUI object is really a button,
*                which may be used to display the file browser.  The
*                file browser provides an alternate way for output file
*                selection.
*                
*                The outputfile GUI object consists of a manager object 
*                with three children: a button object, a text object, 
*                and a pixmap object.
*
*                A callback can be installed on the outputfile object, which
*                will be fired when the user enters a new filename.
*
*         Input: parent - parent of the outputfile widget; NULL will cause
*                         a default toplevel to be created automatically
*                name   - name with which to reference outputfile object
*
*        Output:
*       Returns: The outputfile object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Nov 01, 1993
*      Verified: 
*  Side Effects:
* Modifications:
*
*******************************************************************/

xvobject xvw_create_outputfile(
   xvobject parent,
   char     *name)
{
	xvobject object;


	object = xvw_create(parent, FALSE, TRUE, name, OutputFileWidgetClass);
	return(object);
}
