 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>	               Manager Gadget Subclass
   >>>>  Private:
   >>>>   Static:
   >>>>			ClassInitialize()
   >>>>			ClassPartInitialize()
   >>>>			Initialize()
   >>>>			GetGC()
   >>>>			Realize()
   >>>>			SetValues()
   >>>>			Destroy()
   >>>>			ManagerObjForceRedisplay()
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvobjects/ManagerP.h>
#include <xvobjects/ManagerObjP.h>

static void ClassInitialize     PROTO((void));
static void ClassPartInitialize PROTO((WidgetClass));
static void Initialize          PROTO((Widget, Widget, ArgList, Cardinal *));
static void GetGC               PROTO((Widget));
static void Realize             PROTO((Widget));
static void Destroy             PROTO((Widget));

static Boolean SetValues           PROTO((Widget, Widget, Widget, ArgList,
					  Cardinal *));

/*-------------------------------------------------------------------*
|
|   Full class attribute
|
--------------------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_MAPPED,	      NULL, XtRBoolean, NULL},
{XVW_FORCE_REDISPLAY, NULL, XtRInt,	XtRBoolean},
};


/*-------------------------------------------------------------------*
|
|   Full class record constant
|
--------------------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwManagerGadgetRec, manager.field)

static XtResource resources[] = { 
{XVW_FOREGROUND_PIXEL, NULL, XtRPixel, sizeof(Pixel),
      offset(foreground), XtRString, XtDefaultForeground},
{XVW_BACKGROUND_PIXEL, NULL, XtRPixel, sizeof(Pixel),
      offset(background), XtRString, XtDefaultBackground},
{XVW_FONT, NULL, XtRFontStruct, sizeof(XFontStruct *),
      offset(font), XtRString, XtDefaultFont},
{XVW_MAPPED, NULL, XtRBoolean, sizeof(Boolean),
      offset(mapped), XtRImmediate, (XtPointer) TRUE},
{XVW_FORCE_REDISPLAY, NULL, XtRBoolean, sizeof(Boolean),
      offset(force_redisplay), XtRImmediate, (XtPointer) FALSE},
#if  0
    {XtNdepth, XtCDepth, XtRInt,sizeof(int),
         XtOffsetOf(CoreRec,core.depth),
         XtRCallProc, (XtPointer)_XtCopyFromParent},
    {XtNcolormap, XtCColormap, XtRColormap, sizeof(Colormap),
         XtOffsetOf(CoreRec,core.colormap),
         XtRCallProc,(XtPointer)_XtCopyFromParent},
    {XtNbackgroundPixmap, XtCPixmap, XtRPixmap, sizeof(Pixmap),
         XtOffsetOf(CoreRec,core.background_pixmap),
         XtRImmediate, (XtPointer)XtUnspecifiedPixmap},
    {XtNborderColor, XtCBorderColor, XtRPixel,sizeof(Pixel),
         XtOffsetOf(CoreRec,core.border_pixel),
         XtRString,(XtPointer)"XtDefaultForeground"},
    {XtNborderPixmap, XtCPixmap, XtRPixmap, sizeof(Pixmap),
         XtOffsetOf(CoreRec,core.border_pixmap),
         XtRImmediate, (XtPointer)XtUnspecifiedPixmap},
    {XtNmappedWhenManaged, XtCMappedWhenManaged, XtRBoolean, sizeof(Boolean),
         XtOffsetOf(CoreRec,core.mapped_when_managed),
         XtRImmediate, (XtPointer)True},
    {XtNtranslations, XtCTranslations, XtRTranslationTable,
        sizeof(XtTranslations), XtOffsetOf(CoreRec,core.tm.translations),
        XtRTranslationTable, (XtPointer)NULL},
    {XtNaccelerators, XtCAccelerators, XtRAcceleratorTable,
        sizeof(XtTranslations), XtOffsetOf(CoreRec,core.accelerators),
        XtRTranslationTable, (XtPointer)NULL}
    };
#endif
};
#undef offset


/*-------------------------------------------------------------------*
|
|   Class Declaration for Manager Gadget
|
--------------------------------------------------------------------*/

#define superclass (&rectObjClassRec)

XvwManagerGadgetClassRec xvwManagerGadgetClassRec =
{
  {
    (WidgetClass) superclass,		/* superclass		  */	
    "ManagerObj",			/* class_name		  */
    sizeof(XvwManagerGadgetRec),		/* size			  */
    ClassInitialize,			/* class_initialize	  */
    ClassPartInitialize,		/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    (XtProc) Realize,			/* not used - obj	  */
    NULL,				/* not used - obj	  */
    0,					/* not used - obj	  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    FALSE,				/* not used - obj	  */
    FALSE,				/* not used - obj	  */
    FALSE,				/* not used - obj    	  */
    FALSE,				/* not used - obj	  */
    Destroy,				/* destroy		  */
    NULL,				/* not used - obj	  */
    NULL,				/* not used - obj	  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* not used - obj	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* not used - obj	  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* not used - obj	  */
    NULL,				/* not used - obj	  */
    NULL,				/* not used - obj	  */
    NULL				/* extension		  */
  },  /* RectObjClass fields initialization */
  {
    NULL, 		                /* pick object proc    	  */
    DefaultEraseSelection,   		/* erase selected proc    */
    DefaultRefreshSelection,		/* refresh selection proc */
    NULL,				/* change geometry proc   */
  },  /* XvwManagerGadgetClass fields initialization */
};
#undef superclass

  /* for public consumption */
WidgetClass xvwManagerGadgetClass = (WidgetClass) &xvwManagerGadgetClassRec;


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an
|		 instance of a managerGadget class has been 
|		 created.  This is where the attributes for
|		 the class are initialized.
|
|         Input: None
|
|        Output: None 
|       Returns: None 
|
|    Written By: Mark Young
|          Date: Aug 19, 1992 9:13
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassInitialize(void)
{
	xvw_init_attributes(xvwManagerGadgetClass, attributes,
		XtNumber(attributes), NULL, 0, NULL);
	xvw_load_resources("$DESIGN/objects/library/xvobjects/app-defaults/ManagerObj");
}

/*-----------------------------------------------------------
|
|  Routine Name: ClassPartInitialize
|
|       Purpose: This method is called when the first time an
|                instance of XvwManagerGadgetClass or a subclass of
|                the XvwManagerGadgetClass is created.  It handles the
|                inheritence of the picking, erasing, and refresh
|		 selection routines to the subclass. 
|
|         Input: wclass - the widget class  
|
|        Output: None
|       Returns: None 
|
|    Written By: Mark Young
|          Date: Aug 19, 1992 9:13
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassPartInitialize(
   WidgetClass wclass)
{
        XvwManagerGadgetClass mclass = (XvwManagerGadgetClass) wclass;
        XvwManagerGadgetClass sclass = (XvwManagerGadgetClass)
                                        wclass->core_class.superclass;


	if (wclass != xvwManagerGadgetClass)
	{
           if (mclass->manager_class.pick_selection == XtInheritPicking)
	   {
              mclass->manager_class.pick_selection =
			sclass->manager_class.pick_selection;
	   }

           if (mclass->manager_class.erase_selection == XtInheritEraseSel)
	   {
              mclass->manager_class.erase_selection =
			sclass->manager_class.erase_selection;
	   }

           if (mclass->manager_class.refresh_selection == XtInheritRefreshSel)
	   {
              mclass->manager_class.refresh_selection =
			sclass->manager_class.refresh_selection;
	   }

           if (mclass->manager_class.change_geometry == XtInheritChangeGeometry)
	   {
              mclass->manager_class.change_geometry =
			sclass->manager_class.change_geometry;
	   }
	}
}


/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|       Purpose: This will initialize the gc for a new XvwManagerGadget.
|                
|         Input: request - not used 
|                new     - widget instance after initialization, with 
|                          gc initialized 
|
|        Output: None 
|       Returns: None 
|
|    Written By: Mark Young
|          Date: Aug 19, 1992 9:13
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget request,
   Widget new,
   ArgList args,
   Cardinal *num_args)
{
	XvwManagerGadget xobj = (XvwManagerGadget) new;
	Widget parent = XtParent(new);

        xobj->manager.screen = parent->core.screen;
        xobj->manager.name = XrmNameToString(new->core.xrm_name);
        xobj->manager.tm.translations = NULL;
	xobj->manager.gc = NULL;
	xobj->manager.realized = FALSE;
	GetGC(new);
}

/*-----------------------------------------------------------
|
|  Routine Name: GetGC
|
|       Purpose: This routine will set up a new gc
|		 for a given XvwManagerGadget.  The new gc
|		 will inherit the the foreground and background
|		 colors as well as the font from the  
|		 XvwManagerGadget.
|                
|         Input: widget - the XvwManagerGadget being assigned a gc 
|
|        Output: None 
|       Returns: None 
|
|    Written By: Mark Young
|          Date: Aug 19, 1992 9:13
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void GetGC(
   Widget widget)
{
	XvwManagerGadget xobj = (XvwManagerGadget) widget;

	XGCValues values;
	unsigned long mask;


	/*
	 *  Release the previous GC
	 */
	if (xobj->manager.gc != NULL)
	   XtReleaseGC(widget, xobj->manager.gc);

	/*
	 *  Create the gc to be used with the refresh mechanism
	 */
        values.foreground = xobj->manager.foreground;
        values.background = xobj->manager.background;
	mask = GCForeground | GCBackground;

	if (xobj->manager.font)
	{
           values.font = xobj->manager.font->fid;
	   mask |= GCFont;
	}
        xobj->manager.gc = XtGetGC(widget, mask, &values);
}


/*-----------------------------------------------------------
|
|  Routine Name: Realize
|
|       Purpose: This routine is superfluous since an
|		 object is not realized by itself. 
|		 I THINK, THEREFORE I'M CONFUSED	-SK
|
|         Input: widget - the object being realized
|
|        Output: None
|       Returns: None 
|
|    Written By: Mark Young
|          Date: Oct 19, 1992 9:13
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Realize(
   Widget widget)
{
	XvwManagerGadget xobj = (XvwManagerGadget) widget;
	Widget parent = XtParent(widget);

	xobj->manager.colormap = parent->core.colormap;
	xobj->manager.window   = parent->core.window;
	xobj->manager.depth    = parent->core.depth;
	xobj->manager.background_pixel  = parent->core.background_pixel;
	xobj->manager.background_pixmap = parent->core.background_pixmap;
	GetGC(widget);
}


/*-----------------------------------------------------------
|
|  Routine Name: SetValues 
|
|       Purpose: This method is used to set the public attributes
|		 of a XvwManagerGadget.  These attributes are
|		 the font, foreground, and background colors.
|
|         Input: current - the object containing current settings
|                request - the object containing requested settings
|                new     - the object processed through all set values methods
|
|        Output: None directly
|       Returns: None 
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Aug 19, 1992 9:13
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwManagerGadget cobj = (XvwManagerGadget) current;
	XvwManagerGadget nobj = (XvwManagerGadget) new;
	XvwManagerGadgetClass mclass = (XvwManagerGadgetClass)
                                                new->core.widget_class;
	Boolean redisplay = FALSE;


	if (nobj->manager.font == NULL)
	   nobj->manager.font = cobj->manager.font;

	if (cobj->manager.font	     != nobj->manager.font 	 ||
            cobj->manager.foreground != nobj->manager.foreground ||
	    cobj->manager.background != nobj->manager.background)
	{
	   GetGC(new);
	   redisplay = TRUE;
	}

	if (cobj->manager.mapped != nobj->manager.mapped)
	   redisplay = TRUE;

	if (cobj->rectobj.x      != nobj->rectobj.x            ||
            cobj->rectobj.y      != nobj->rectobj.y            ||
            cobj->rectobj.width  != nobj->rectobj.width        ||
            cobj->rectobj.height != nobj->rectobj.height)
	{
	   if (mclass->manager_class.change_geometry != NULL)
	      mclass->manager_class.change_geometry(new);
	}

	if (nobj->manager.force_redisplay && (redisplay == TRUE ||
	    cobj->rectobj.x      != nobj->rectobj.x            ||
	    cobj->rectobj.y      != nobj->rectobj.y            ||
	    cobj->rectobj.width  != nobj->rectobj.width        ||
	    cobj->rectobj.height != nobj->rectobj.height))
	{
	   ManagerObjForceRedisplay(current, new, TRUE, &redisplay);
	}
	return(redisplay);
}


/*-----------------------------------------------------------
|
|  Routine Name: Destroy 
|
|       Purpose: This method will deallocate the gc used 
|                by the XvwManagerGadget before it is destroyed. 
|
|         Input: widget - the widget being destroyed
|
|        Output: None
|       Returns: None 
|
|    Written By: Mark Young
|          Date: Aug 19, 1992 9:13
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Destroy(
   Widget widget)
{
	XvwManagerGadget xobj = (XvwManagerGadget) widget;

	XtReleaseGC(widget, xobj->manager.gc);
}

/*-----------------------------------------------------------
|
|  Routine Name: ManagerObjForceRedisplay - 
|
|       Purpose: For the manager object, if the force redisplay is set
|                then we want to call the refresh directly rather than
|		 letting Xt do this via an expose proc.
|
|         Input: current - the current manager object
|		 new     - the new manager object that is forcing a redisplay
|
|       Returns: 0 if we dispatched the redisplay, 1 if we need Xt to do it.
|    Written By: Mark Young
|          Date: Jun 05, 1994
| Modifications:
|
------------------------------------------------------------*/

void ManagerObjForceRedisplay(
   Widget  current,
   Widget  new,
   int     clear_area,
   Boolean *redisplay)
{
        XvwManagerGadget cobj = (XvwManagerGadget) current;
        XvwManagerGadget nobj = (XvwManagerGadget) new;

        XEvent  event;
        Region  region;
	WidgetClass wclass;
	int     x, y, w, h;
	XtWidgetGeometry temp;


	if (XtWindowOfObject(new) == 0)
	   return;

	if (cobj->rectobj.x      != nobj->rectobj.x	 ||
            cobj->rectobj.y      != nobj->rectobj.y	 || 
            cobj->rectobj.width  != nobj->rectobj.width  ||
            cobj->rectobj.height != nobj->rectobj.height)
	{
	   temp.request_mode = CWWidth | CWHeight | CWX | CWY;
	   temp.x = nobj->rectobj.x;
	   temp.y = nobj->rectobj.y;
	   temp.width  = nobj->rectobj.width;
	   temp.height = nobj->rectobj.height;
	   (void) XtMakeGeometryRequest(current, &temp, &temp);
	}
	else if (clear_area)
	{
	   x = cobj->rectobj.x; y = cobj->rectobj.y;
	   w = cobj->rectobj.width; h = cobj->rectobj.height;
	   XClearArea(XtDisplay(new), XtWindowOfObject(new), x, y, w, h, FALSE);
	}

	if (nobj->manager.realized == FALSE)
	   ManagerRealizeObject(XtClass(new), new);

	/*
	 *  Now let's see whether we have to call the object's redisplay
	 *  method.  This is done by actually calling it directly, rather
	 *  than having Xt do an expose...
	 */
	wclass = XtClass(new);
	if (wclass->core_class.expose != NULL)
	{
	   /*
	    *  Create an expose region for the object that is the same that Xt
	    *  would create.
	    */
	   event.type = Expose;
           event.xexpose.x = event.xexpose.y = 0;
           event.xexpose.width  = new->core.width;
           event.xexpose.height = new->core.height;

	   region = XCreateRegion();
           XtAddExposureToRegion(&event, region);

	   /*
	    *  Call the class's redisplay method, since it ain't NULL
	    */
	   (*wclass->core_class.expose) (new, &event, region);
	   XDestroyRegion(region);
	}
	XFlush(XtDisplay(new));
	*redisplay = FALSE;
}
