 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>	              Khoros Workspace Widget
   >>>>  Private:
   >>>>   Static:
   >>>> 		ClassInitialize()
   >>>> 		ConstraintInitialize()
   >>>> 		Initialize()
   >>>> 		SetValues()
   >>>> 		SetValuesHook()
   >>>> 		Destroy()
   >>>> 		ActionCallback()
   >>>> 		WorkspaceGUIFormCallback()
   >>>>   Public:
   >>>>			xvw_create_workspace()
   >>>>	
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvlang/WorkspaceP.h>

#define XK_LATIN1
#include <X11/keysymdef.h>

static void ClassInitialize        PROTO((void));
static void ConstraintInitialize   PROTO((Widget, Widget, ArgList, Cardinal *));
static void Initialize             PROTO((Widget, Widget, ArgList, Cardinal *));
static Boolean SetValues	   PROTO((Widget, Widget, Widget, ArgList,
					  Cardinal *));
static Boolean SetValuesHook	   PROTO((Widget, ArgList, Cardinal *));
static void    Destroy		   PROTO((Widget));

static void ActionCallback          PROTO((xvobject, kaddr, XEvent *));
static void WorkspaceGUIFormCallback  PROTO((kform *, ksubform *, kaddr));

/*-------------------------------------------------------------------*
|
|   Full class attributes
|
--------------------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_WORKSPACE_INHERIT,		NULL,   XtRInt,  XtRBoolean},
{XVW_WORKSPACE_PARALLEL,	NULL,   XtRInt,  XtRBoolean},
{XVW_WORKSPACE_RESPONSIVE,	NULL,   XtRInt,  XtRBoolean},
{XVW_WORKSPACE_VARIABLES,	NULL,   XtRInt,  NULL},
{XVW_WORKSPACE_WKSPGUI,		NULL,   XtRPointer,  NULL},
{XVW_WORKSPACE_FILENAME,	NULL,   XtRString,   NULL},
{XVW_WORKSPACE_RUN,	        NULL,   XtRInt,      NULL},
{XVW_WORKSPACE_RUN_CALLBACK,    NULL,   XtRCallback, NULL},
{XVW_WORKSPACE_ACTIVE_CALLBACK, NULL,   XtRCallback, NULL},
{XVW_WORKSPACE_PROCEDURE_OBJECT,NULL,   XtRPointer,  NULL},

{XVW_GLYPH_ECHO,	 NULL,   XtRInt,     XtRBoolean},
{XVW_GLYPH_REPORTING,	 NULL,   XtRInt,     XtRBoolean},
{XVW_NODE_PLACEMENT,     NULL,   XtRInt,     XtRBoolean},
{XVW_NODE_LEAVE,         NULL,   XtRInt,     XtRBoolean},
{XVW_NODE_SHOW_DAV,      NULL,   XtRInt,     XtRBoolean},
{XVW_NODE_SHOW_MODIFIED, NULL,   XtRInt,     XtRBoolean},
{XVW_NODE_REMOTE_ENABLE, NULL,   XtRInt,     XtRBoolean},
{XVW_CONNECTION_TYPE,    NULL,   XtRInt,     NULL},
};


/*-------------------------------------------------------------------*
|
|   Full class record constant
|
--------------------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwWorkspaceWidgetRec, workspace.field)

static XtResource resources[] = { 
{XVW_WORKSPACE_INHERIT, NULL, XtRBoolean, sizeof(Boolean),
        offset(inherit), XtRImmediate, (XtPointer) TRUE},
{XVW_WORKSPACE_PARALLEL, NULL, XtRBoolean, sizeof(Boolean),
        offset(parallel), XtRImmediate, (XtPointer) TRUE},
{XVW_WORKSPACE_VARIABLES, NULL, XtRInt, sizeof(int),
        offset(variables), XtRImmediate,(XtPointer)KWORKSPACE_VARIABLES_GLOBAL},
{XVW_WORKSPACE_WKSPGUI, NULL, XtRPointer, sizeof(XtPointer),
        offset(wkspgui), XtRImmediate, (XtPointer) NULL},
{XVW_WORKSPACE_FILENAME, NULL, XtRString, sizeof(String),
        offset(filename), XtRImmediate, (XtPointer) NULL},
{XVW_WORKSPACE_RUN, NULL, XtRInt, sizeof(int),
        offset(running), XtRImmediate,(XtPointer) FALSE},
{XVW_WORKSPACE_RUN_CALLBACK, NULL, XtRCallback, sizeof(XtPointer),
        offset(run_callback), XtRImmediate, (XtPointer) NULL},
{XVW_WORKSPACE_ACTIVE_CALLBACK, NULL, XtRCallback, sizeof(XtPointer),
        offset(active_callback), XtRImmediate, (XtPointer) NULL},
{XVW_WORKSPACE_RESPONSIVE, NULL, XtRBoolean, sizeof(Boolean),
        offset(responsive), XtRImmediate, (XtPointer) TRUE},
{XVW_WORKSPACE_PROCEDURE_OBJECT, NULL, XtRPointer, sizeof(xvobject),
        offset(procedure), XtRImmediate, (XtPointer) NULL},

{XVW_GLYPH_ECHO, NULL, XtRBoolean, sizeof(Boolean),
        offset(glyph_echo), XtRImmediate, (XtPointer) TRUE},
{XVW_GLYPH_REPORTING, NULL, XtRBoolean, sizeof(Boolean),
        offset(glyph_reporting), XtRImmediate, (XtPointer) TRUE},
{XVW_NODE_PLACEMENT, NULL, XtRBoolean, sizeof(Boolean),
        offset(icon_placement), XtRImmediate, (XtPointer) TRUE},
{XVW_NODE_LEAVE, NULL, XtRBoolean, sizeof(Boolean),
        offset(icon_leave), XtRImmediate, (XtPointer) TRUE},
{XVW_NODE_SHOW_DAV, NULL, XtRBoolean, sizeof(Boolean),
        offset(icon_show_dav), XtRImmediate, (XtPointer) TRUE},
{XVW_NODE_SHOW_MODIFIED, NULL, XtRBoolean, sizeof(Boolean),
        offset(icon_show_modified), XtRImmediate, (XtPointer) TRUE},
{XVW_NODE_REMOTE_ENABLE, NULL, XtRBoolean, sizeof(Boolean),
        offset(icon_remote_enable), XtRImmediate, (XtPointer) FALSE},
{XVW_CONNECTION_TYPE, NULL, XtRInt, sizeof(int), 
      offset(connection_type), XtRImmediate,
	(XtPointer) KCONNECTION_TYPE_MANHATTAN},
};
#undef offset


/*-------------------------------------------------------------------*
|
|   Class Declaration for Workspace Widget
|
--------------------------------------------------------------------*/

#define superclass (&xvwCanvasWidgetClassRec)

XvwWorkspaceWidgetClassRec xvwWorkspaceWidgetClassRec =
{
  {
    (WidgetClass) superclass,		/* superclass		  */	
    "Workspace",			/* class_name		  */
    sizeof(XvwWorkspaceWidgetRec),	/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    Destroy,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    SetValuesHook,			/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    XtInheritQueryGeometry,		/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,				    /* subresources	  */
    0,					    /* subresources_count */
    sizeof(XvwWorkspaceWidgetConstraintsRec),  /* constraint_size	  */
    ConstraintInitialize,		    /* initialize	  */
    NULL,				    /* destroy		  */
    NULL,				    /* set_values	  */
    NULL,				    /* extension	  */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,                        /* child layout routine  */
    XtInheritChangeSel,			    /* change selected proc   */
    XtInheritEraseSel,			    /* erase selected proc    */
    XtInheritRefreshSel,		    /* refresh selection proc */
    XtInheritResize,			    /* resize		      */
    XtInheritGeometryManager,		    /* geometry_manager	      */
  },  /* XvwManagerWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwViewportWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwCanvasWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwWorkspaceWidgetClass fields initialization */
};
#undef superclass

  /* for public consumption */
WidgetClass xvwWorkspaceWidgetClass = (WidgetClass) &xvwWorkspaceWidgetClassRec;


/*-------------------------------------------------------------------*
|
|   Miscelleanous defines for Class and Constraint Declarations
|
--------------------------------------------------------------------*/

#undef  kwidget
#define kwidget(widget)	    (XvwWorkspaceWidget) (widget)


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an
|                instance of a XvwWorkspaceWidget class has been created.
|                This is where the attributes for the class are
|		 initialized. 
|
|    Written By: Mark Young
|          Date: Oct 19, 1992 9:54
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassInitialize(void)
{
	xvw_init_attributes(xvwWorkspaceWidgetClass, attributes,
		XtNumber(attributes), NULL, 0, 
		"$DESIGN/objects/library/xvlang/uis/Workspace.pane");
	xvw_load_resources("$DESIGN/objects/library/xvlang/app-defaults/Workspace");

	xvw_define_attributes(xvwWorkspaceWidgetClass,
		XVW_CANVAS_DUPLICATE, XtRInt, WorkspaceActions, NULL,
		XVW_CANVAS_UNDO,      XtRInt, WorkspaceActions, NULL,
		XVW_CANVAS_DELETE,    XtRInt, WorkspaceActions, NULL,
		XVW_CANVAS_COPY,      XtRInt, WorkspaceActions, NULL,
		XVW_CANVAS_PASTE,     XtRInt, WorkspaceActions, NULL,
		XVW_CANVAS_CUT,       XtRInt, WorkspaceActions, NULL,
		XVW_WORKSPACE_RUN,    XtRInt, WorkspaceActions, NULL,
		XVW_WORKSPACE_STEP,   XtRInt, WorkspaceActions, NULL,
		XVW_WORKSPACE_RESET,  XtRInt, WorkspaceActions, NULL,
		XVW_WORKSPACE_REDRAW, XtRInt, WorkspaceActions, NULL,
		XVW_WORKSPACE_CLEAR,  XtRInt, WorkspaceActions, NULL,
		XVW_WORKSPACE_CHECK,  XtRInt, WorkspaceActions, NULL,
		XVW_WORKSPACE_INFO,   XtRInt, WorkspaceActions, NULL,
		XVW_WORKSPACE_SAVE,   XtRString, WorkspaceActions, NULL,
		XVW_WORKSPACE_SAVEALL,XtRString, WorkspaceActions, NULL,
		XVW_WORKSPACE_RESTORE,XtRString, WorkspaceActions, NULL,
		XVW_WORKSPACE_CREATE_PROCEDURE,  XtRInt, WorkspaceActions, NULL,
		XVW_WORKSPACE_CREATE_WHILELOOP,  XtRInt, WorkspaceActions, NULL,
		XVW_WORKSPACE_CREATE_COUNTLOOP,  XtRInt, WorkspaceActions, NULL,
		XVW_WORKSPACE_EXPORT_SELECTIONS, XtRInt, WorkspaceActions, NULL,
		XVW_WORKSPACE_SHOW_WKSPGUI,  XtRInt, WorkspaceActions, NULL,
		XVW_WORKSPACE_SAVE_WKSPGUI, XtRString, WorkspaceActions,NULL,
		XVW_WORKSPACE_SHOW_CLIPBOARD, XtRInt, WorkspaceActions,NULL,
		NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|       Purpose: This method is called the first time an
|                instance of a XvwWorkspaceWidget class has been created.
|                This is where the attributes for the class are
|                initialized.
|
|    Written By: Mark Young
|          Date: Oct 19, 1992 9:54
|
------------------------------------------------------------*/

#define FORMFILE "$DESIGN/objects/library/xvlang/uis/wkspgui.subform"

/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwWorkspaceWidget xwid = kwidget(new);
	xvobject object = xvw_object(new);

	kguide *guide;

	/*
	 *  Initialize the indicator that the workspace is running to FALSE
	 */ 
	xwid->workspace.saved_num = 0;
	xwid->workspace.saved     = NULL;
	xwid->workspace.scheduling = FALSE;

	/*
	 *  Create our wkspgui and substitute the run button to call
	 *  WorkspaceRun() in order to run a workspace.
	 */
	xwid->workspace.wkspgui = kvf_create_form(FORMFILE, NONE,
			WorkspaceGUIFormCallback, NULL);
	guide = kvf_search_sel_guide(xwid->workspace.wkspgui->subform);
	if (guide != NULL)
	{
           xwid->workspace.selections = kvf_get_selection_kformstructs(
			guide->pane, NONE, &xwid->workspace.num_selections);
	}
	xwid->workspace.created_form = TRUE;
	xwid->workspace.wkspgui_initialized = FALSE;

	xwid->viewport.override = TRUE;
	if (xvw_check_subclass(xvw_parent(object), WorkspaceWidgetClass))
	{
#if 0
	   xwid->workspace.titlebar = xvw_create_titlebar(object, "TitleBar");
	   xvw_set_attributes(xwid->workspace.titlebar,
		XVW_TACK_EDGE,  KMANAGER_TACK_HORIZ,
		XVW_BELOW,	NULL,
		NULL);
	   xwid->viewport.top = xwid->workspace.titlebar;
	   xvw_insert_callback(xwid->workspace.titlebar, XVW_TITLEBAR_CALLBACK,
		TRUE, WorkspaceCallbacks, object);
#else
	   xwid->workspace.titlebar = xvw_create_button(object, "quit");
	   xvw_set_attributes(xwid->workspace.titlebar,
		XVW_VERT_DIST,  3,
		XVW_HORIZ_DIST, 3,
		XVW_LABEL, "Close",
		XVW_LEFT_OF,  (xwid->viewport.use_right ?
				xwid->viewport.vertical : NULL),
		NULL);
	   xvw_insert_callback(xwid->workspace.titlebar, XVW_BUTTON_SELECT,
		TRUE, WorkspaceCallbacks, object);

#if 0
	   xwid->workspace.output = xvw_create_button(object, "output");
	   xvw_set_attributes(xwid->workspace.output,
		XVW_VERT_DIST,  3,
		XVW_HORIZ_DIST, 3,
		XVW_LABEL, "New External Output",
		XVW_BELOW, xwid->workspace.titlebar,
		XVW_LEFT_OF,  (xwid->viewport.use_right ?
				xwid->viewport.vertical : NULL),
		NULL);
	   xvw_insert_callback(xwid->workspace.output, XVW_BUTTON_SELECT,
		TRUE, WorkspaceCallbacks, object);

	   xwid->workspace.input = xvw_create_button(object, "input");
	   xvw_set_attributes(xwid->workspace.input,
		XVW_VERT_DIST,  3,
		XVW_HORIZ_DIST, 3,
		XVW_LABEL, "New External Input",
		XVW_BELOW, xwid->workspace.titlebar,
		XVW_RIGHT_OF,  (!xwid->viewport.use_right ?
				xwid->viewport.vertical : NULL),
		NULL);
	   xvw_insert_callback(xwid->workspace.input, XVW_BUTTON_SELECT,
		TRUE, WorkspaceCallbacks, object);
#endif
#endif
	}
	else
	   xwid->workspace.titlebar = NULL;

	xwid->viewport.override = FALSE;

        xvw_add_action(xwid->viewport.plane, "Ctrl<Key>r", ActionCallback,
                        object, TRUE);
        xvw_add_action(xwid->viewport.plane, "Ctrl<Key>s", ActionCallback,
                        object, TRUE);
        xvw_add_action(xwid->viewport.plane, "Ctrl<Key>p", ActionCallback,
                        object, TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: ConstraintInitialize
|
|       Purpose: When a new child of the canvas is created,
|		 tell the child who its parent is. 
|                
|         Input: request  - widget child with requested constraints
|                new      - widget child with actual constraints
|		 args     - not used
|		 num_args - not used
|    Written By: Mark Young
|          Date: Nov 26, 1993
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ConstraintInitialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num)
{
	XvwWorkspaceWidget xwid = kwidget(XtParent(request));
	xvobject object    = xvw_object(new);
	xvobject workspace = xvw_object((Widget) xwid);


	if (xvw_check_subclass(object, GlyphWidgetClass) == TRUE)
	{
	   xvw_set_attributes(object,
		XVW_GLYPH_EXPRESSION_ID,     workspace,
		XVW_GLYPH_CONNECTION_PARENT, workspace,
		XVW_GLYPH_WKSPGUI, xwid->workspace.wkspgui,
		XVW_GLYPH_ECHO, xwid->workspace.glyph_echo,
		XVW_GLYPH_REPORTING, xwid->workspace.glyph_reporting,
		NULL);
	}

	if (xvw_check_subclass(object, NodeWidgetClass) == TRUE)
	{
	   xvw_insert_callback(object, XVW_NODE_RUN_CALLBACK, FALSE,
                        WorkspaceGlyphRunCallback, workspace);
	   xvw_insert_callback(object, XVW_NODE_MODIFIED_CALLBACK, FALSE,
                        WorkspaceGlyphModifiedCallback, workspace);
	   xvw_set_attributes(object,
		XVW_NODE_PLACEMENT, xwid->workspace.icon_placement,
		XVW_NODE_LEAVE,     xwid->workspace.icon_leave,
		XVW_NODE_SHOW_DAV,  xwid->workspace.icon_show_dav,
		XVW_NODE_SHOW_MODIFIED,  xwid->workspace.icon_show_modified,
		XVW_NODE_REMOTE_ENABLE,  xwid->workspace.icon_remote_enable,
		NULL);
	}

	if (xvw_check_subclass(object, ConnectionGadgetClass) == TRUE)
	{
	   xvw_set_attributes(object,
		XVW_CONNECTION_TYPE, xwid->workspace.connection_type,
		NULL);
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: This method is used to set the public values
|                of a XvwWorkspaceWidget instance.  The public values
|                which can be changed are all related to the display
|		 of the workspace.
|
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|    Written By: Mark Young
|          Date: Aug 19, 1992 9:13
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues (
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num)
{
	XvwWorkspaceWidget cxwid = kwidget(current);
	XvwWorkspaceWidget nxwid = kwidget(new);


	if (cxwid->workspace.filename != nxwid->workspace.filename)
	{
	   kfree(cxwid->workspace.filename);
	   nxwid->workspace.filename = kstrdup(nxwid->workspace.filename);
	}

	if (cxwid->workspace.wkspgui != nxwid->workspace.wkspgui)
	   nxwid->workspace.created_form = FALSE;

	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValuesHook
|
|       Purpose: This method is called to set the public values
|                of the childred attributes.
|         Input: widget   - the object containing the subpart
|                           to set the values on
|                args     - the list of args to set
|                num_args - the number of args being set
|    Written By: Mark Young
|          Date: Dec 21, 1993
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValuesHook(
   Widget   widget,
   ArgList  args,
   Cardinal *num_args)
{
	int i, num;
	Arg temp[MAX_ARGS];
	XvwWorkspaceWidget xwid = kwidget(widget);
	xvobject object         = xwid->viewport.plane;
	XvwManagerWidget xman   = (XvwManagerWidget) xvw_widget(object);


	for (i = num = 0; i < *num_args; i++)
	{
	   if (kstrcmp(args[i].name, XVW_NODE_PLACEMENT) == 0     ||
	       kstrcmp(args[i].name, XVW_NODE_LEAVE) == 0         ||
	       kstrcmp(args[i].name, XVW_NODE_SHOW_DAV) == 0      ||
	       kstrcmp(args[i].name, XVW_NODE_SHOW_MODIFIED) == 0 ||
	       kstrcmp(args[i].name, XVW_NODE_REMOTE_ENABLE) == 0 ||
	       kstrcmp(args[i].name, XVW_GLYPH_ECHO) == 0 ||
	       kstrcmp(args[i].name, XVW_GLYPH_REPORTING) == 0 ||
	       kstrcmp(args[i].name, XVW_CONNECTION_TYPE) == 0)
	   {
	      temp[num++] = args[i];
	   }
	}

	if (num > 0)
	{
	   for (i = 0; i < xman->composite.num_children; i++)
	      XtSetValues(xman->composite.children[i], temp, num);
	}
	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: Destroy
|
|       Purpose: destroy the workspace...
|         Input: widget - the workspace widget being destroyed 
|    Written By: Mark Young
|          Date: Nov 8, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Destroy(
   Widget widget)
{
	XvwWorkspaceWidget xwid = kwidget(widget);

	if (xwid->workspace.wkspgui != NULL && xwid->workspace.created_form)
	   xvf_destroy_form(xwid->workspace.wkspgui);

	kfree(xwid->workspace.selections);
}

/*-----------------------------------------------------------
|
|  Routine Name: ActionCallback - action handler for quick bindings to the
|				 different workspace attributes.
|
|       Purpose: This routine is used to perform quick key bindings on the
|                workspace.
|
|         Input: object - object in which the object was invoked
|		 client_data - the workspace widget
|		 XEvent      - the event (action) which is desired
|    Written By: Mark Young
|          Date: Nov 26, 1993
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static void ActionCallback(
   xvobject object,
   kaddr    client_data,
   XEvent   *event)
{
	xvobject workspace = (xvobject) client_data;

	XKeyEvent *xkey;
        KeySym    keysym;
	char      temp[KLENGTH];


	/*
	 *  Make sure only KeyPress events get registered...
	 */
	if (event->type != KeyPress)
	   return;

	xkey = (XKeyEvent *) &(event->xkey);
	(void) XLookupString(xkey, temp, KLENGTH, &keysym, NULL);
	switch (keysym)
	{
	   case XK_r:
	   case XK_R:
		xvw_set_attribute(workspace, XVW_WORKSPACE_RUN, TRUE);
		break;

	   case XK_s:
	   case XK_S:
		xvw_set_attribute(workspace, XVW_WORKSPACE_RUN, FALSE);
		break;

	   case XK_p:
	   case XK_P:
		xvw_set_attribute(workspace, XVW_WORKSPACE_CREATE_PROCEDURE,
				  TRUE);
		break;

	   default:
	        kerror(XVLANG, "ActionCallback",  "Internal Error.  Unknown \
action associated with internal key bindings for keysym '%d'", keysym);
		break;
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: WorkspaceGUIFormCallback - form callback routine
|
|
|       Purpose: This routine is used to process the user's form
|                changes to the workspace GUI.   
|
|         Input: object - object to be used to build the form
|    Written By: Mark Young & Danielle Argiro
|          Date: Nov 26, 1993
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static void WorkspaceGUIFormCallback(
   kform    *form,
   ksubform *subform,
   kaddr    client_data)
{
	int	   i, num;
        kform_list *entry;
        kselection *selection, **extensions;


	/*
	 *  Make sure closing the form or subform doesn't destroy our form...
	 */
	if (form->quit)
	   form->quit = subform->quit = 0;

	/*
	 *  at this time, workspace GUI can only have a single pane
	 */
        if (!(kvf_check_for_single_pane(form, "WorkspaceGUIFormCallback")))
	    return;

	/*
	 *  go through all selections on workspace GUI, firing the callbacks
	 *  associated with the glyph form extensions of the selections
         *  on the workspace GUI.
	 */
	selection = form->subform->guide->pane->sel_list;
	while (selection != NULL)
	{
	    if (selection->extensions == NULL || selection->modified == FALSE)
	    {
	       selection = selection->next;
	       continue;
	    }
	    selection->modified = FALSE;

	    num = selection->extension_num;
	    extensions = selection->extensions;
	    for (i = 0; i < num; i++)
	    {
               entry = kvf_get_entry((kaddr) extensions[i]->back_form);
	       if (entry != NULL)
               {
                  if (entry->routine != NULL)
                     (void) entry->routine(extensions[i]->back_form, 
					   extensions[i]->back_subform,
                                           entry->client_data);
               }
            }
        }
}


/************************************************************
*
*  Routine Name: xvw_create_workspace - create a workspace object
*
*       Purpose: The workspace visual programming object provides a canvas 
*		 in which other visual programming objects may be placed 
*		 and combined into a visual program.  The workspace object 
*		 supports the saving, restoring, execution, and management 
*		 of visual programs.  It also serves as a visual programming
*		 editor. 
*
*		 The workspace object does not directly support visual
*		 programming, but rather provides a canvas in which other
*		 visual programming components can be combined in which to
*		 create a visual program.  Its role is similar to that
*		 of the manager object; however, instead of allowing the
*		 creation and management of GUI objects, the workspace object
*		 allows the creation and management of visual programming
*		 objects.
*
*		 The workspace object allows (1) specification of an internal 
*		 routine to be used for saving a network, and (2) specification 
*                of an internal routine to be used for restoring a network.
*
*		 The workspace object can be used to create new visual 
*		 programming models other than the one used in \fHcantata\fP;  
*		 all that is necessary is to provide different routines for 
*		 saving and restoring of networks.
*
*		 Moreover, the workspace object has the capability to 
*		 manipulate any other visual programming object that is 
*		 subclassed from the node object, such as glyphs, conditionals, 
*		 loops, and procedures.  However, if the visual programming 
*		 toolkit is extended to include other visual programming 
*		 objects that are subclassed from the node object, they will 
*		 automatically be usable in a workspace object.
*
*		 As a visual programming editor, the workspace object comes
*		 with a full suite of capabilities including running
*		 a network, stopping a network, single stepping through
*		 a network, resetting the network, redrawing the network,
*		 clearing the network, checking the network, and providing
*		 information about the network.
*
*         Input: parent - the parent object; NULL will cause a
*                         default toplevel to be created automatically
*                name   - the name with which to reference the object
*        Output: None
*       Returns: The workspace object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Jan 14, 1993 16:47
*      Verified:
*  Side Effects:
* Modifications:
*
*******************************************************************/

xvobject xvw_create_workspace(
   xvobject parent,
   char     *name)
{
	xvobject workspace;


	workspace = xvw_create(parent, FALSE, TRUE, name, WorkspaceWidgetClass);
	xvw_set_attribute(workspace, XVW_SELECTABLE, TRUE);
	return(workspace);
}
