 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>	              Khoros Port Gadget
   >>>>  Private:
   >>>> 		PortGetInfo()
   >>>> 		PortCreateConnection()
   >>>>   Static:
   >>>> 		ClassInitialize()
   >>>>			Initialize()
   >>>> 		SetValues()
   >>>> 		Destroy()
   >>>> 		ConnectionHandler()
   >>>> 		ConnectionDestroyed()
   >>>> 		ConnectionCallback()
   >>>> 		TransportCallback()
   >>>>   Public:
   >>>>			xvw_create_port()
   >>>>	
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvlang/PortP.h>

static void     ClassInitialize PROTO((void));
static void	Initialize	PROTO((Widget, Widget, ArgList, Cardinal *));
static Boolean	SetValues       PROTO((Widget, Widget, Widget, ArgList,
				       Cardinal *));
static void     Destroy		PROTO((Widget));

static void ConnectionHandler     PROTO((xvobject, kaddr, XEvent *, int *));
static void ConnectionDestroyed   PROTO((xvobject, kaddr, kaddr));
static void ConnectionCallback	  PROTO((xvobject, kaddr, kaddr));
static void TransportCallback 	  PROTO((int, int, kaddr));
static int  SetModified		  PROTO((xvobject, char *, kaddr));

static klist *portlist = NULL;

static   xvobject iportobj = NULL;
static   xvobject oportobj = NULL;
static   XvwPortGadget xobj1 = NULL;
static   XvwPortGadget xobj2 = NULL;

/*-------------------------------------------------------------------*
|
|   Define Default Pixmap Paths
|
--------------------------------------------------------------------*/

#define DAV_PIXMAP "$DESIGN/objects/library/xvlang/misc/glyph/dav.xpm"
#define OPTIONAL_PIXMAP "$DESIGN/objects/library/xvlang/misc/glyph/io_optional.xpm"
#define REQUIRED_PIXMAP "$DESIGN/objects/library/xvlang/misc/glyph/io_required.xpm"
#define SELECTED_PIXMAP "$DESIGN/objects/library/xvlang/misc/glyph/io_selected.xpm"

/*-------------------------------------------------------------------*
|
|   Full class attributes
|
--------------------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_PORT_SELECTION,	  NULL,	  XtRPointer,  NULL},
{XVW_PORT_DAV,		  NULL,	  XtRInt,      XtRBoolean},
{XVW_PORT_SHOWDAV,	  NULL,	  XtRInt,      XtRBoolean},
{XVW_PORT_SELECTED,	  NULL,	  XtRInt,      XtRBoolean},
{XVW_PORT_TYPE,		  NULL,	  XtRInt,      NULL},
{XVW_PORT_CONNECTION_PARENT,NULL, XtRPointer,  NULL},
{XVW_PORT_FILENAME,	  NULL,   XtRString,   NULL},
{XVW_PORT_DAV_CALLBACK,	  NULL,   XtRCallback, NULL},
{XVW_PORT_SELECTED_CALLBACK,NULL, XtRCallback, NULL},
{XVW_PORT_FILENAME_CALLBACK,NULL, XtRCallback, NULL},

{XVW_PORT_OPTIONAL_PIXMAP, NULL, XtRPixmap, NULL},
{XVW_PORT_REQUIRED_PIXMAP, NULL, XtRPixmap, NULL},
{XVW_PORT_SELECTED_PIXMAP, NULL, XtRPixmap, NULL},
{XVW_PORT_DAV_PIXMAP, NULL, XtRPixmap, NULL},
};


/*-------------------------------------------------------------------*
|
|   Full class record constant
|
--------------------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwPortGadgetRec, port.field)

static XtResource resources[] = { 
{XVW_PORT_SELECTION, NULL, XtRPointer, sizeof(XtPointer),
        offset(selection), XtRImmediate, (XtPointer) NULL},
{XVW_PORT_DAV, NULL, XtRBoolean, sizeof(Boolean),
        offset(dav), XtRImmediate, (XtPointer) FALSE},
{XVW_PORT_SHOWDAV, NULL, XtRBoolean, sizeof(Boolean),
        offset(showdav), XtRImmediate, (XtPointer) TRUE},
{XVW_PORT_SELECTED, NULL, XtRBoolean, sizeof(Boolean),
        offset(selected), XtRImmediate, (XtPointer) FALSE},
{XVW_PORT_SELECTED_CALLBACK, NULL, XtRCallback, sizeof(XtPointer),
      offset(selected_callback), XtRCallback, (XtPointer) NULL},
{XVW_PORT_TYPE, NULL, XtRInt, sizeof(int),
        offset(type), XtRImmediate, (XtPointer) KPORT_TYPE_UNKNOWN},
{XVW_PORT_CONNECTION_PARENT, NULL, XtRInt, sizeof(XtPointer),
        offset(connection_parent), XtRImmediate, (XtPointer) NULL},
{XVW_PORT_DAV_CALLBACK, NULL, XtRCallback, sizeof(XtPointer),
      offset(dav_callback), XtRCallback, (XtPointer) NULL},
{XVW_PORT_FILENAME, NULL, XtRString, sizeof(String),
      offset(filename), XtRImmediate, (XtPointer) NULL},
{XVW_PORT_FILENAME_CALLBACK, NULL, XtRCallback, sizeof(XtPointer),
      offset(filename_callback), XtRCallback, (XtPointer) NULL},

{XVW_PORT_OPTIONAL_PIXMAP, NULL, XtRPixmap, sizeof(Pixmap),
        offset(optional_pixmap), XtRString, (XtPointer) OPTIONAL_PIXMAP},
{XVW_PORT_REQUIRED_PIXMAP, NULL, XtRPixmap, sizeof(Pixmap),
        offset(required_pixmap), XtRString, (XtPointer) REQUIRED_PIXMAP},
{XVW_PORT_SELECTED_PIXMAP, NULL, XtRPixmap, sizeof(Pixmap),
        offset(selected_pixmap), XtRString, (XtPointer) SELECTED_PIXMAP},
{XVW_PORT_DAV_PIXMAP, NULL, XtRPixmap, sizeof(Pixmap),
        offset(dav_pixmap), XtRString, (XtPointer) DAV_PIXMAP},
};
#undef offset


/*-------------------------------------------------------------------*
|
|   Class Declaration for Port Gadget
|
--------------------------------------------------------------------*/

#define superclass (&xvwPixmapGadgetClassRec)

XvwPortGadgetClassRec xvwPortGadgetClassRec =
{
  {
    (WidgetClass) superclass,		/* superclass		  */	
    "Port",			/* class_name		  */
    sizeof(XvwPortGadgetRec),	/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    NULL,				/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    Destroy,				/* destroy		  */
    XtInheritResize,			/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    NULL,				/* query_geometry	  */
    NULL,				/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    XtInheritPicking,                       /* pick object proc       */
    XtInheritEraseSel,                      /* erase selected proc    */
    XtInheritRefreshSel,                    /* refresh selection proc */
    XtInheritChangeGeometry,                /* change geometry proc   */
  },  /* XvwManagerGadgetClass fields initialization */
  {
    NULL,                               /* extension - not used   */
  },  /* XvwPixmapGadgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwPortGadgetClass fields initialization */
};
#undef superclass

  /* for public consumption */
WidgetClass xvwPortGadgetClass = (WidgetClass) &xvwPortGadgetClassRec;


/*-------------------------------------------------------------------*
|
|   Miscelleanous defines for Class and Constraint Declarations
|
--------------------------------------------------------------------*/

#undef kwidget
#undef kwidgetclass
#undef kconstraint

#define kwidget(widget)	     (XvwPortGadget) (widget)
#define kwidgetclass(widget) (XvwPortGadgetClass) (widget)->core.widget_class
#define kconstraint(widget)  (XvwPortGadgetConstraints) (widget)->core.constraints


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an
|                instance of a XvwPortGadget class has been created.
|                This is where the attributes for the class are
|		 initialized. 
|
|    Written By: Mark Young
|          Date: Nov 22, 1993
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassInitialize(void)
{
	int     inum;
	kfile   *ifile;


	xvw_init_attributes(xvwPortGadgetClass, attributes,
		XtNumber(attributes), NULL, 0, NULL);
	xvw_load_resources("$DESIGN/objects/library/xvlang/app-defaults/Port");
	xvw_define_attributes(xvwPortGadgetClass,
                XVW_PORT_MODIFIED, XtRInt, SetModified,  NULL,
                NULL);

#if 0
	if (kipc_start(KIPC_TRANSPORT) == -1)
	   return;

	knegotiate_transport(FALSE);
	if (kipc_getdescriptors(KIPC_TRANSPORT, &ifile, NULL) == -1 ||
	    kgetdescriptors(ifile, &inum, NULL) == -1)
	{
	   kipc_stop(KIPC_TRANSPORT);
	   return;
	}
	xvw_add_detectfid(NULL, inum, TransportCallback, NULL);
#endif
}

/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|	Purpose: This method will set up the initial port widget instance.
|
|	  Input: request - not used
|                new     - widget instance after initialization
|    Written By: Mark Young
|          Date: Nov 22, 1993
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwPortGadget xobj = kwidget(new);
	xvobject object = xvw_object(new);
	xvobject parent = xvw_parent(object);


	/*
	 *  Initialize the
	 */
	xobj->port.num = 0;
	xobj->port.temporary   = FALSE;
	xobj->port.connections = NULL;
	xobj->port.connection_start = FALSE;

	xvw_set_attribute(object, XVW_PIXMAP, xobj->port.optional_pixmap);
	xobj->port.dav_obj = xvw_create_pixmap(parent, "dav");
	xvw_set_attributes(xobj->port.dav_obj,
                XVW_BORDER_WIDTH, 0,
                XVW_MAPPED,       FALSE,
		XVW_ABOVE,	  object,
		XVW_BELOW,	  object,
		XVW_HORIZ_DIST,	  -3,
                XVW_PIXMAP,       xobj->port.dav_pixmap,
                NULL);
#if 0
/*
 *  Start of creating iconic glyphs...
 */
xvw_unmanage(xobj->port.dav_obj);
#endif
	xvw_insert_event(object, ButtonPressMask | ButtonReleaseMask,
			ConnectionHandler, (kaddr) object, KLIST_HEAD);
	portlist = klist_add(portlist, (kaddr) new, NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: This method is used to set the public values
|                of a XvwPortGadget instance.  The public values
|                which can be changed are all related to the display
|		 of the port.
|
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|    Written By: Mark Young
|          Date: Nov 22, 1993
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num)
{
	XvwPortGadget cxobj = kwidget(current);
	XvwPortGadget nxobj = kwidget(new);

	char *filename;
	int  i, selected, opt, dav;
	xvobject iport, object, *connections;


	if (cxobj->port.type != nxobj->port.type)
	{
	   /*
	    *  Stupid, but i want the dav label to be right of
	    *  the io button when the type is an input, and left of
	    *  when the io button is an output.
	    */
	   object = xvw_object(new);
	   if (nxobj->port.type == KPORT_TYPE_INPUT)
	   {
	      xvw_set_attributes(nxobj->port.dav_obj,
			XVW_RIGHT_OF, object,
			XVW_LEFT_OF,  KMANAGER_UNDEFINED,
			NULL);
	   }
	   else if (nxobj->port.type == KPORT_TYPE_OUTPUT)
	   {
	      xvw_set_attributes(nxobj->port.dav_obj,
			XVW_RIGHT_OF, KMANAGER_UNDEFINED,
			XVW_LEFT_OF,  object,
			NULL);
	   }
	}

	if (cxobj->port.dav_pixmap != nxobj->port.dav_pixmap)
        {
           xvw_set_attribute(nxobj->port.dav_obj, XVW_PIXMAP,
                        nxobj->port.dav_pixmap);
        }

	if (cxobj->port.selection != nxobj->port.selection ||
	    cxobj->port.selected  != nxobj->port.selected)
	{
	   xvf_get_attribute(nxobj->port.selection, XVF_OPTSEL, &selected);
	   selected = (selected == 1);
	   xvf_set_attribute(nxobj->port.selection, XVF_FILE_CHECK, FALSE);
	   if (cxobj->port.selection != nxobj->port.selection)
	   {
	      nxobj->port.selected = selected;
	   }
	   else if (selected != nxobj->port.selected)
	   {
	      xvf_get_attribute(nxobj->port.selection, XVF_OPTIONAL, &opt);
	      if (nxobj->port.selected || opt)
	      {
	         xvf_set_attribute(nxobj->port.selection, XVF_OPTSEL,
			nxobj->port.selected);
	         xvf_get_attribute(nxobj->port.selection, XVF_OPTSEL,&selected);
		 nxobj->port.selected = (selected == 1);
	      }
	      else if (!opt)
		 nxobj->port.selected = TRUE;
	   }

	   if (cxobj->port.selected != nxobj->port.selected)
	   {
	      object = xvw_object(new);
	      if (nxobj->port.selected)
	         xvw_set_attribute(object, XVW_PIXMAP,
			nxobj->port.required_pixmap);
	      else
	         xvw_set_attribute(object, XVW_PIXMAP,
			nxobj->port.optional_pixmap);

	      selected = nxobj->port.selected;
	      XtCallCallbacks(new, XVW_PORT_SELECTED_CALLBACK,
				(XtPointer) &selected);
	   }
	}

	if (cxobj->port.showdav  != nxobj->port.showdav  ||
	    cxobj->port.dav      != nxobj->port.dav      ||
	    cxobj->port.selected != nxobj->port.selected ||
	    cxobj->port.filename != nxobj->port.filename)
	{
	   if (nxobj->port.showdav && nxobj->port.dav && nxobj->port.selected)
	      xvw_map(nxobj->port.dav_obj);
	   else
	      xvw_unmap(nxobj->port.dav_obj);

	   if (cxobj->port.dav != nxobj->port.dav &&
	       nxobj->port.type == KPORT_TYPE_OUTPUT)
	   {
	      for (i = 0; i < nxobj->port.num; i++)
	      {
		 iport = NULL;
		 xvw_get_attribute(nxobj->port.connections[i],
				XVW_CONNECTION_END, &iport);
		 if (iport)
		    xvw_set_attribute(iport, XVW_PORT_DAV, nxobj->port.dav);
	      }
	   }

	   if (cxobj->port.dav != nxobj->port.dav)
	   {
	      dav = nxobj->port.dav;
	      XtCallCallbacks(new, XVW_PORT_DAV_CALLBACK,(XtPointer) &dav);
	   }

	   if (cxobj->port.filename != nxobj->port.filename)
	   {
	      filename = nxobj->port.filename;
	      XtCallCallbacks(new, XVW_PORT_FILENAME_CALLBACK,
			(XtPointer) &filename);
	   }
	}

	if (nxobj->port.connection_start == TRUE)
	{
	   connections = nxobj->port.connections;
	   for (i = 0; i < nxobj->port.num; i++)
	      xvw_set_attribute(connections[i], XVW_CONNECTION_STOP, TRUE);
	}
	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: Destroy
|
|       Purpose: destroy the connections...
|
|         Input: widget - the image widget being destroyed 
|    Written By: Mark Young
|          Date: Nov 21, 1993
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Destroy(
   Widget widget)
{
	XvwPortGadget xobj = kwidget(widget);

	Widget   parent;
	int      i, num = xobj->port.num;
	xvobject *connections = xobj->port.connections;

	/*
	 *  Destroy all the connections and free the memory...
	 */
	xobj->port.num = 0;
	xobj->port.connections = NULL;

	parent = xvw_widget(xobj->port.connection_parent);
	if (!parent->core.being_destroyed)
	{
	   for (i = 0; i < num; i++)
	   {
	      xvw_remove_callback(connections[i], XVW_DESTROY,
                        ConnectionDestroyed, xobj);
	      xvw_destroy(connections[i]);
	   }
	}
	kfree(connections);

	if (xobj->port.type == KPORT_TYPE_OUTPUT)
	{
	   if (xobj->port.temporary == TRUE)
	      kunlink(xobj->port.filename);
	}
	kfree(xobj->port.filename);
	portlist = klist_delete(portlist, (kaddr) widget);
	if (xobj == xobj1)
	{
	   iportobj = NULL;
	   xobj1 = NULL;
	}
	else if (xobj == xobj2)
	{
	   oportobj = NULL;
	   xobj2 = NULL;
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: SetModified
|
|       Purpose: SetModified is used to update the port from the specified
|		 selection.
|
|         Input: port  - the port object in which was modified
|                attribute - the modified attribute
|                calldata  - the filename to be set
|       Returns: TRUE (1) if successful, FALSE (0) otherwise
|    Written By: Mark Young
|          Date: Nov 21, 1993
|
------------------------------------------------------------*/
/* ARGSUSED */
static int SetModified(
   xvobject port,
   char     *attribute,
   kaddr    calldata)
{
	char *filename;
	xvobject iport;
	int  i, selected, dav;
	XvwPortGadget tmp, xobj = kwidget(xvw_widget(port));


	if (xobj->port.selection == NULL)
	   return(TRUE);

	xvf_get_attribute(xobj->port.selection, XVF_FILE_NAME, &filename);
	kstring_cleanup(filename, filename);
#if 0
	if (kstrcmp(xobj->port.filename, filename) == 0)
	{
	   kfree(filename);
	   return;
	}
#endif

	if (xobj->port.type == KPORT_TYPE_OUTPUT)
	{
	   for (i = 0; i < xobj->port.num; i++)
	   {
	      iport = NULL;
	      if (!xvw_get_attribute(xobj->port.connections[i],
			XVW_CONNECTION_END, &iport) || !iport)
	      {
	         continue;
	      }

	      tmp = (XvwPortGadget) xvw_widget(iport);
	      if (kstrcmp(tmp->port.filename, filename) != 0)
	      {
	         tmp->port.filename = kstrdup(filename);
	         xvf_set_attribute(tmp->port.selection, XVF_LITERAL, filename);
	         XtCallCallbacks((Widget) tmp, XVW_PORT_FILENAME_CALLBACK,
			(XtPointer) &tmp->port.filename);
	      }
	   }
	}
	dav = xobj->port.dav;
	xvf_get_attribute(xobj->port.selection, XVF_OPTSEL, &selected);
	selected = (selected == 1);

	/*
	 *  Gotta see if the we have an input and our port connection
	 *  count is 0, which means that we have a connection.  If
	 *  our port is an output then we have to check to make sure
	 *  that this isn't a temporary file.
	 */
	if (xobj->port.type == KPORT_TYPE_INPUT && xobj->port.num == 0)
	{
	   dav = (kstrlen(filename) == 0 ? FALSE : TRUE);
	}
	else if (xobj->port.type == KPORT_TYPE_OUTPUT)
	{
	   if (kstrcmp(xobj->port.filename, filename) != 0 &&
	       xobj->port.filename != NULL)
	   {
	      dav = TRUE;
	      if (xobj->port.temporary == TRUE)
                 kunlink(xobj->port.filename);

	      xobj->port.temporary = FALSE;
	   }
	}
	kfree(xobj->port.filename);
	xobj->port.filename = filename;

	xvw_set_attributes(port,
		XVW_PORT_DAV,      dav,
		XVW_PORT_SELECTED, selected,
		NULL);
	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: ConnectionDestroyed
|
|       Purpose: This routine is called when the connection is destroyed
|         Input: connection - the connection to be destroyed.
|    Written By: Mark Young
|          Date: Nov 22, 1993
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ConnectionDestroyed(
   xvobject connection,
   kaddr    client_data,
   kaddr    call_data)
{
	XvwPortGadget xobj = (XvwPortGadget) client_data;


	if (karray_locate((char **) xobj->port.connections,
		(kaddr) connection, xobj->port.num) != -1)
	{
	   xobj->port.connections = (xvobject *) karray_delete((char **)
                xobj->port.connections, (kaddr) connection, xobj->port.num--);
	}
	else
	   return;

	if (xobj->port.type == KPORT_TYPE_INPUT && xobj->port.num == 0)
	{
	   xvobject port = xvw_object((Widget) xobj);

	   if (port != NULL)
	   {
	      xvf_set_attribute(xobj->port.selection, XVF_LITERAL, NULL);
	      xvw_set_attribute(port, XVW_PORT_SELECTED, FALSE);
	   }
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: ConnectionCallback
|
|       Purpose: This routine is called when the connection is activated
|         Input: object      - connection being destroyed
|                client_data - the glyph widget
|                call_data   - not used
|    Written By: Mark Young
|          Date: Nov 22, 1993
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ConnectionCallback(
   xvobject connection,
   kaddr    client_data,
   kaddr    call_data)
{
	xvobject port = (xvobject) client_data;
	XvwPortGadget xobj = (XvwPortGadget) xvw_widget(port);

	int    i, size;
	char   *filename, **list, temp[KLENGTH], identifier[KLENGTH];

	static int  num;
	static char *choice[] =
	{
		"Delete Connection",
		"Save Data to File",
		"Connection Options",
		"",
	};
	static char **transports = NULL;


	if (xobj->port.temporary)
	{
	   if (!transports)
	      transports = ktransport_list(TRUE, TRUE, FALSE, &num);

	   list = karray_merge(choice, transports, knumber(choice), num, FALSE);
	   size = num + knumber(choice);
	}
	else
	{
	   list = karray_copy(choice, knumber(choice), FALSE);
	   size = knumber(choice);
	}

	if (!kchoose(KFORCE, list, size, 0, NULL, &i, xobj->port.filename))
	   i = -1;
	else
	   i--;

	if (i != -1)
	{
	   kinfo(KDEBUG, "entry '%s' selected for filename '%s'\n", list[i],
			xobj->port.filename);
	   if (i == 0)
	   {
	      xvw_destroy(connection);
	   }
	   else if (i == 1)
	   {
	      char   *prompt = "Filename:", *answer = temp;
	     
	      /* prompt for file from user... */
	      answer[0] = '\0';
	      if (xvu_query_wait("Please enter filename", &prompt, "Ok",
		    &answer, 1, 55) == TRUE && kstrlen(answer) > 0 &&
	          kcopyfile(xobj->port.filename, answer) == -1)
	      {
		 kinfo(KSTANDARD, "Unable to existing copy data from file '%s' \
to the new transport '%s'", xobj->port.filename, answer);
	      }
	   }
	   else if (i == 2)
	   {
	      xvw_activate_menu(connection);
	   }
	   else if (i > num && xobj->port.temporary)
	   {
	      i -= knumber(choice);
	      if (ksscanf(transports[i], "%s", identifier) != 1)
	      {
		 kinfo(KSTANDARD, "Unable to get identifer from the transport \
list '%s'", transports[i]);
		 kfree(list);
		 return;
	      }

              ksprintf(temp,"%s=io", identifier);
	      filename = ktempnam(NULL, temp);
	      if (kcopyfile(xobj->port.filename, filename) == -1)
	      {
		 kinfo(KSTANDARD, "Unable to existing copy data from file '%s' \
to the new transport '%s'", xobj->port.filename, filename);
		 kunlink(filename); kfree(filename); kfree(list);
		 return;
	      }
	      xvf_set_attribute(xobj->port.selection, XVF_LITERAL, filename);
	      kfree(filename);

	      if (xobj->port.temporary)
	         kunlink(xobj->port.filename);
	      kfree(xobj->port.filename);
	      xvw_set_attribute(port, XVW_PORT_MODIFIED, TRUE);
	   }
	}
	kfree(list);
}

/*-----------------------------------------------------------
|
|  Routine Name: ConnectionHandler
|
|       Purpose: This routine is called when the input or output
|		 of an io port is activated.
|         Input: object      - remote button being activated
|                client_data - the glyph widget
|                event       - event the activated us
|		 dispatch    - whether to continue dispatch the event
|    Written By: Mark Young
|          Date: Nov 22, 1993
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ConnectionHandler(
   xvobject object,
   kaddr    client_data,
   XEvent   *event,
   int	    *dispatch)
{
	xvobject port = (xvobject) client_data;
	XvwPortGadget xobj = (XvwPortGadget) xvw_widget(port);

	Pixmap pixmap = xobj->port.selected_pixmap;


	*dispatch = FALSE;
	if (event->type != ButtonRelease)
	   return;

	/*
	 *  Check to see if the object is an input or output
	 */
	xvw_set_attribute(port, XVW_PIXMAP, xobj->port.selected_pixmap);
	if (xobj->port.type == KPORT_TYPE_INPUT)
	{
	   if (iportobj != NULL)
	   {
	      pixmap = xobj->port.selected ? xobj->port.required_pixmap :
				xobj->port.optional_pixmap;
	      xvw_set_attribute(iportobj, XVW_PIXMAP, pixmap);
	   }
	   iportobj = (iportobj == port) ? NULL : port;
	   xobj1 = (XvwPortGadget) xvw_widget(iportobj);
	}
	else if (xobj->port.type == KPORT_TYPE_OUTPUT)
	{
	   if (oportobj != NULL)
	   {
	      pixmap = xobj->port.selected ? xobj->port.required_pixmap :
				xobj->port.optional_pixmap;
	      xvw_set_attribute(oportobj, XVW_PIXMAP, pixmap);
	   }
	   oportobj = (oportobj == port) ? NULL : port;
	   xobj2 = (XvwPortGadget) xvw_widget(oportobj);
	}

	/*
	 *  If either both input or output port are set then create the
	 *  connection
	 */
	if (iportobj && oportobj)
	{
	   if (xobj1->port.connection_parent == xobj2->port.connection_parent)
	   {
	      PortCreateConnection(iportobj, oportobj);
	      xvw_set_attribute(iportobj,XVW_PIXMAP,xobj->port.required_pixmap);
	      xvw_set_attribute(oportobj,XVW_PIXMAP,xobj->port.required_pixmap);
	      iportobj = oportobj = NULL;
	   }
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: TransportCallback - routine for handling transports negotiation
|
|       Purpose: This routine is called when one of the sub-process wants to
|		 inform or negotiate a new transport.
|
|         Input: id  - the callback id
|                fid - the input file descriptor
|		 client_data - not used
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|    Written By: Mark Young
|          Date: Dec 12, 1993
|
------------------------------------------------------------*/
/* ARGSUSED */
static void TransportCallback(
   int id,
   int fid, 
   kaddr client_data)
{
	klist *list;
	XvwPortGadget xobj;
	kfile *ifile, *ofile;
	int   i, flags, pid, permanence;
	xvobject *connections, object = NULL;
	char  buffer[KLENGTH],command[KLENGTH],filename[KLENGTH],type[KLENGTH];


        if (kipc_getdescriptors(KIPC_TRANSPORT, &ifile, &ofile) == -1)
           return;
 
        if (kfgets(buffer, KLENGTH, ifile) == NULL)
           return;
 
        if (ksscanf(buffer,
		"%d%*[:]%*[ ]%[^' ]%*[ ]%*[']%[^']%*[']%*[ ]%*[']%[^']%*[']",
		&pid, command, filename, type) != 4)
        {
           kfputs(buffer, ofile);
           return;
        }
        /*kinfo(KDEBUG, "cantata: '%s'\n", buffer);*/
        /*kprintf("TransportCallback: '%s'\n", buffer);*/

	flags = ktype_to_flags(type);
        permanence = kfile_getpermanence(filename);
        if (((flags & O_WRONLY) != 0 || (flags & O_RDWR) != 0) &&
	    (kstrcmp("open", command) == 0 && permanence == TRUE) ||
            (kstrcmp("close", command) == 0 && permanence == TRUE))
        {
	   list = portlist;
	   while (list != NULL)
	   {
	      xobj = (XvwPortGadget) klist_identifier(list);
	      if (xobj->port.type == KPORT_TYPE_OUTPUT &&
		  kstrcmp(xobj->port.filename, filename) == 0)
	      {
		 object = xvw_object((Widget) xobj);
		 break;
	      }
	      list = klist_next(list);
	   }
        }
        kfputs("yes", ofile);
	if (object == NULL)
	   return;

	connections = xobj->port.connections;
	if (kstrcmp("open", command) == 0)
	{
	   xvw_set_attribute(object, XVW_PORT_DAV, FALSE);
	   for (i = 0; i < xobj->port.num; i++)
	      xvw_set_attribute(connections[i], XVW_CONNECTION_START, TRUE);

	   xobj->port.connection_start = TRUE;
	}
	else
	   xvw_set_attribute(object, XVW_PORT_DAV, TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: PortGetInfo - routine for getting port information
|
|       Purpose: This routine is called when we want to get port information
|         Input: port - the port
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|    Written By: Mark Young
|          Date: Dec 12, 1993
|
------------------------------------------------------------*/
/* ARGSUSED */
int PortGetInfo(
   xvobject port,
   char     **varname,
   char     **filename,
   int	    *temporary,
   int	    *selected,
   int      *num,
   xvobject **connections)
{
	XvwPortGadget xobj = (XvwPortGadget) xvw_widget(port);


	if (varname)
	{
	   *varname = NULL;
	   if (xobj->port.selection)
	      xvf_get_attribute(xobj->port.selection, XVF_VARIABLE, varname);
	}
	if (num) *num = xobj->port.num;
	if (temporary) *temporary = xobj->port.temporary;
	if (selected)  *selected  = xobj->port.selected;
	if (filename)  *filename  = xobj->port.filename;
	if (connections) *connections = xobj->port.connections;
	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: PortCreateConnection - routine for creating connections
|					between two ports
|
|       Purpose: This routine is called when we want to create a connection
|         Input: iport - the input port
|                oport - the output port
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|    Written By: Mark Young
|          Date: Dec 12, 1993
|
------------------------------------------------------------*/
/* ARGSUSED */
int PortCreateConnection(
   xvobject iport,
   xvobject oport)
{
	XvwPortGadget ixobj = (XvwPortGadget) xvw_widget(iport);
	XvwPortGadget oxobj = (XvwPortGadget) xvw_widget(oport);

	int      i;
	xvobject connection, parent;
	char     *filename, temp[KLENGTH];


	parent = oxobj->port.connection_parent;
	if (parent == NULL)
	   parent = xvw_parent(oport);

	connection = xvw_create_connection(parent, "PortConnection");
	xvw_set_attributes(connection,
		XVW_CONNECTION_END,   iport,
		XVW_CONNECTION_BEGIN, oport,
		NULL);

        xvw_insert_callback(connection, XVW_DESTROY, FALSE,
			ConnectionDestroyed, ixobj);
        xvw_insert_callback(connection, XVW_DESTROY, FALSE,
			ConnectionDestroyed, oxobj);
	xvw_add_callback(connection, XVW_CONNECTION_CALLBACK,
			ConnectionCallback, oport);

	/*
	 *  Here is where we prevent multiple input connections...
	 */
	for (i = ixobj->port.num-1; i >= 0; i--)
	   xvw_destroy((xvobject) ixobj->port.connections[i]);

	ixobj->port.connections = (xvobject *) karray_add((char **)
		ixobj->port.connections, (kaddr) connection, ixobj->port.num++);
	oxobj->port.connections = (xvobject *) karray_add((char **)
		oxobj->port.connections, (kaddr) connection, oxobj->port.num++);

	/*
	 *  Do the output side of the connection.  What we want to do is see
	 *  if no filename exists.  If so then we have to create a temporary
	 *  file for this connection.
	 */
	filename = NULL;
	xvf_get_attribute(oxobj->port.selection, XVF_FILE_NAME, &filename);
	if (!kstring_cleanup(filename, filename))
	{
	   ksprintf(temp,"io");
	   filename = ktempnam(NULL, temp);
	   xvw_set_attribute(oport, XVW_PORT_DAV, FALSE);
	   xvf_set_attribute(oxobj->port.selection, XVF_LITERAL, filename);
	   oxobj->port.temporary = TRUE;
	}

	/*
	 *  Now for the input side of things...
	 */
	xvf_set_attributes(oxobj->port.selection,
		XVF_OPTSEL,  TRUE,
		XVF_LITERAL, filename,
		NULL);
	xvw_set_attributes(oport,
		XVW_PORT_SELECTED, TRUE,
		XVW_PORT_MODIFIED, TRUE,
		NULL);

	/*
	 *  Now for the input side of things...
	 */
	xvf_set_attributes(ixobj->port.selection,
		XVF_OPTSEL,    TRUE,
		XVF_LITERAL, filename,
		NULL);
	xvw_set_attributes(iport,
		XVW_PORT_SELECTED, TRUE,
		XVW_PORT_MODIFIED, TRUE,
		XVW_PORT_DAV, oxobj->port.dav,
		NULL);
	return(TRUE);
}


/************************************************************
*
*  Routine Name: xvw_create_port - create a port object
*
*       Purpose: The purpose of the Port object is to provide a general
*		 mechanism for representing a "port" within a visual program.
*		 Typically these are used by the glyph to represent input
*		 and output connections within the visual program.  Normally
*		 the port is created by other visual programming components,
*		 such as the Node object, but is provided so that other
*		 styles of visual programs can be created.
*
*		 The Port object is really available to reduce the complexity
*		 of the application programmer in dealing with the user
*		 interactions of connecting Glyphs together.  It also
*		 manages the complexity of representing the connections
*		 and the UIS that is used to represent the Port.  So
*		 if the user updates the filename represented by the
*		 Port, and the Port is an output, then the contains
*		 of the Ports connected to the output, are updated
*		 appropriately.
*
*         Input: parent - the parent object; NULL will cause a
*                         default toplevel to be created automatically
*                name   - the name with which to reference the object
*        Output: None
*       Returns: The port object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Nov 22, 1993
*      Verified:
*  Side Effects:
* Modifications:
*
*******************************************************************/

xvobject xvw_create_port(
   xvobject parent,
   char     *name)
{
	xvobject object;


	object = xvw_create(parent, FALSE, TRUE, name, PortGadgetClass);
	return(object);
}
