 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>	              Khoros Node Widget
   >>>>  Private:
   >>>>   Static:
   >>>> 		ClassInitialize()
   >>>> 		ClassPartInitialize()
   >>>> 		Initialize()
   >>>> 		Destroy()
   >>>> 		Realize()
   >>>> 		SetValues()
   >>>>
   >>>>			ChangeSelection()
   >>>>			NodeReverseColors()
   >>>>			DispatchNode()
   >>>>			ResetNode()
   >>>>			GetExecute()
   >>>>			SetExecute()
   >>>>			NodeHandler()
   >>>>   Public:
   >>>>			xvw_create_node()
   >>>>	
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvlang/NodeP.h>

static void ClassInitialize     PROTO((void));
static void ClassPartInitialize PROTO((WidgetClass));
static void Initialize	        PROTO((Widget, Widget, ArgList, Cardinal *));
static void Destroy             PROTO((Widget));
static void Realize      PROTO((Widget, XtValueMask *, XSetWindowAttributes *));
static Boolean SetValues PROTO((Widget, Widget, Widget, ArgList, Cardinal *));

static void ChangeSelection     PROTO((Widget, int));
static void NodeReverseColors   PROTO((xvobject, int));
static void DispatchNode        PROTO((XtPointer, XtIntervalId *));
static int  ResetNode	        PROTO((xvobject, char *, kaddr));
static int  SetExecute	        PROTO((xvobject, char *, kaddr));
static int  GetExecute	        PROTO((xvobject, char *, kaddr));
static void NodeHandler	        PROTO((xvobject, kaddr, XEvent *, int *));


klist *frontier = NULL;
static XtIntervalId dispatch_id = 0;

/*-------------------------------------------------------------------*
|
|   Full class attributes
|
--------------------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_NODE_NAME,          NULL,     XtRString,   NULL},
{XVW_NODE_PLACEMENT,     NULL,     XtRInt,      XtRBoolean},
{XVW_NODE_LEAVE,         NULL,     XtRInt,      XtRBoolean},
{XVW_NODE_SHOW_DAV,      NULL,     XtRInt,      XtRBoolean},
{XVW_NODE_SHOW_MODIFIED, NULL,     XtRInt,      XtRBoolean},
{XVW_NODE_MODIFIED,      NULL,     XtRInt,      XtRBoolean},
{XVW_NODE_REMOTE_ENABLE, NULL,     XtRInt,      XtRBoolean},
{XVW_NODE_TYPE,          NULL,     XtRInt,      NULL},
{XVW_NODE_RUN_CALLBACK,  NULL,     XtRCallback, NULL},
{XVW_NODE_MODIFIED_CALLBACK, NULL, XtRCallback, NULL},

{XVW_NODE_PIXMAP,     NULL,   XtRPixmap, NULL},
{XVW_NODE_PIXMAPFILE, XVW_NODE_PIXMAP, XtRFilename, XtRPixmap},
};


/*-------------------------------------------------------------------*
|
|   Full class record constant
|
--------------------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwNodeWidgetRec, node.field)

static XtResource resources[] = { 
{XVW_NODE_NAME, NULL, XtRString, sizeof(String),
        offset(name), XtRImmediate, (XtPointer) NULL},
{XVW_NODE_TYPE, NULL, XtRInt, sizeof(int),
        offset(type), XtRImmediate, (XtPointer) KNODE_TYPE_UNKNOWN},
{XVW_NODE_PLACEMENT, NULL, XtRBoolean, sizeof(Boolean),
        offset(placement), XtRImmediate, (XtPointer) TRUE},
{XVW_NODE_LEAVE, NULL, XtRBoolean, sizeof(Boolean),
        offset(leave), XtRImmediate, (XtPointer) TRUE},
{XVW_NODE_MODIFIED, NULL, XtRBoolean, sizeof(Boolean),
        offset(modified), XtRImmediate, (XtPointer) TRUE},
{XVW_NODE_SHOW_DAV, NULL, XtRBoolean, sizeof(Boolean),
        offset(show_dav), XtRImmediate, (XtPointer) TRUE},
{XVW_NODE_SHOW_MODIFIED, NULL, XtRBoolean, sizeof(Boolean),
        offset(show_modified), XtRImmediate, (XtPointer) TRUE},
{XVW_NODE_REMOTE_ENABLE, NULL, XtRBoolean, sizeof(Boolean),
        offset(remote_enable), XtRImmediate, (XtPointer) FALSE},
{XVW_NODE_RUN_CALLBACK, NULL, XtRCallback, sizeof(XtPointer),
        offset(run_callback), XtRImmediate, (XtPointer) NULL},
{XVW_NODE_MODIFIED_CALLBACK, NULL, XtRCallback, sizeof(XtPointer),
        offset(modified_callback), XtRImmediate, (XtPointer) NULL},
{XVW_NODE_PIXMAP, NULL, XtRPixmap, sizeof(Pixmap),
        offset(pixmap), XtRImmediate, (XtPointer) None},

{XVW_CANVAS_GRIDSIZE, NULL, XtRInt, sizeof(int),
        XtOffsetOf(XvwNodeWidgetRec, manager.gridsize),
        XtRImmediate, (XtPointer) 3},
};
#undef offset


/*-------------------------------------------------------------------*
|
|   Class Declaration for Node Widget
|
--------------------------------------------------------------------*/

#define superclass (&xvwManagerWidgetClassRec)

XvwNodeWidgetClassRec xvwNodeWidgetClassRec =
{
  {
    (WidgetClass) superclass,		/* superclass		  */	
    "Node",				/* class_name		  */
    sizeof(XvwNodeWidgetRec),		/* size			  */
    ClassInitialize,			/* class_initialize	  */
    ClassPartInitialize,		/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    Realize,				/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    Destroy,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    XtInheritQueryGeometry,		/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,				    /* subresources	  */
    0,					    /* subresources_count */
    sizeof(XvwNodeWidgetConstraintsRec),  /* constraint_size	  */
    NULL,				    /* initialize	  */
    NULL,				    /* destroy		  */
    NULL,				    /* set_values	  */
    NULL,				    /* extension	  */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,                        /* child layout routine  */
    ChangeSelection,			    /* change selected proc   */
    NULL,				    /* erase selected proc    */
    NULL,	 		   	    /* refresh selection proc */
    XtInheritResize,			    /* resize		      */
    XtInheritGeometryManager,		    /* geometry_manager	      */
  },  /* XvwManagerWidgetClass fields initialization */
  {
    NULL,  		                    /* firing rule check  */
    NULL,  		                    /* execute node       */
    NULL,  		                    /* extension	  */
  },  /* XvwNodeWidgetClass fields initialization */
};
#undef superclass

  /* for public consumption */
WidgetClass xvwNodeWidgetClass = (WidgetClass) &xvwNodeWidgetClassRec;


/*-------------------------------------------------------------------*
|
|   Miscelleanous defines for Class and Constraint Declarations
|
--------------------------------------------------------------------*/

#undef  kwidget
#define kwidget(widget)	     (XvwNodeWidget) (widget)


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an
|                instance of a XvwNodeWidget class has been created.
|                This is where the attributes for the class are
|		 initialized. 
|
|         Input:
|
|        Output:
|       Returns: 
|
|    Written By: Mark Young
|          Date: Oct 19, 1992 9:54
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassInitialize(void)
{
	xvw_init_attributes(xvwNodeWidgetClass, attributes,
		XtNumber(attributes), NULL, 0, NULL);
	xvw_load_resources("$DESIGN/objects/library/xvlang/app-defaults/Node");

	xvw_define_attributes(xvwNodeWidgetClass,
		XVW_NODE_RESET,    XtRInt,    ResetNode,   NULL,
		XVW_NODE_TEST,     XtRInt,    SetExecute,  GetExecute,
		XVW_NODE_EXECUTE,  XtRInt,    SetExecute,  GetExecute,
		XVW_NODE_RUNNABLE, XtRInt,    NULL,        GetExecute,
		NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: ClassPartInitialize
|
|       Purpose: This method is called when the first time an
|                instance of XvwOperatorWidgetClass or a subclass of
|                the XvwOperatorWidgetClass is created.  It handles the
|                inheritence of the run_operator method from the superclass
|                to the subclass.
|
|         Input: wclass - the widget class
|
|    Written By: Mark Young
|          Date: Jul 30, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassPartInitialize(
   WidgetClass wclass)
{
        XvwNodeWidgetClass mclass = (XvwNodeWidgetClass) wclass;
        XvwNodeWidgetClass sclass = (XvwNodeWidgetClass)
                                                wclass->core_class.superclass;
 
        if (wclass != xvwNodeWidgetClass)
        {
           if (mclass->node_class.exec_node == XtInheritExecNode)
              mclass->node_class.exec_node = sclass->node_class.exec_node;

           if (mclass->node_class.check_node == XtInheritCheckNode)
              mclass->node_class.check_node = sclass->node_class.check_node;
        }
}

/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|       Purpose: This method will set up the initial node
|                widget instance.
|
|         Input: request - not used
|                new     - widget instance after initialization
|
|        Output:
|
|    Written By: Mark Young
|          Date: May 26, 1993 13:28
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwNodeWidget xwid = kwidget(new);
	xvobject object = xvw_object(new);
	xvobject parent = xvw_parent(object);


	xwid->node.name = kstrdup("none");
	xwid->core.x = -1;
	xwid->core.y = -1;
	xwid->node.runnable = TRUE;
	xwid->node.testing = FALSE;
	xwid->node.running = KNODE_STOPPED;

        xwid->node.label = xvw_create_labelstr(parent, "Label");
	xvw_set_attributes(xwid->node.label,
		XVW_BELOW,      object,
		XVW_LEFT_OF,    object,
		XVW_RIGHT_OF,   object,
		XVW_SELECTABLE, FALSE,
		XVW_RESIZABLE,  FALSE,
		XVW_MENUABLE,   FALSE,
		XVW_VERT_DIST,  new->core.border_width,
		NULL);

        xwid->node.icon = xvw_create_pixmap(object, "Icon");
	xvw_set_attributes(xwid->node.icon,
		XVW_PIXMAP,     xwid->node.pixmap,
		XVW_BELOW,      NULL,
		XVW_LEFT_OF,    NULL,
		XVW_RIGHT_OF,   NULL,
		XVW_ABOVE,      NULL,
		XVW_SELECTABLE, FALSE,
		XVW_RESIZABLE,  FALSE,
		XVW_MENUABLE,   FALSE,
		NULL);

	xvw_insert_event(xwid->node.label, ButtonPressMask | ButtonReleaseMask,
		NodeHandler, object, KLIST_HEAD);
}

/*-----------------------------------------------------------
|
|  Routine Name: Realize
|
|       Purpose: This method will set up the window attributes
|                and create a window for the XvwNodeWidget.
|                The desired initial window attributes are passed
|                in via a mask and list of specification attributes.
|                The gc is also initialized here.
|
|         Input: widget     - the widget to realize
|                valuemask  - determines the window attributes being passed in
|                attributes - the list of window attributes to be set
|
|        Output:
|       Returns:
|
|    Written By: Mark Young
|          Date: Oct 19, 1992 9:13
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Realize(
   Widget               widget,
   XtValueMask          *valuemask,
   XSetWindowAttributes *attrib)
{
        XvwNodeWidget xwid = kwidget(widget);

	Window   rw, cw;
	unsigned int mask;
	int      x, y, bw, rx, ry, wx, wy, xsnap = 10, ysnap = 10, dist = 0;
 
 
	if (xwid->core.x == -1 && xwid->core.y == -1)
	{
	   if (xwid->node.placement == FALSE ||
	       xvw_check_visible(xvw_object(XtParent(widget))) == FALSE)
	   {
	      XQueryPointer(XtDisplay(widget), XtWindow(XtParent(widget)), &rw,
		&cw, &rx, &ry, &wx, &wy, &mask);

	      x = wx - ((int) xwid->core.width/2);
	      if (x < 0) x = 0;

	      y = wy - ((int) xwid->core.height/2);
	      if (y < 0) y = 0;
	   }
	   else
	   {
	      xvw_getposition(xvw_object(widget), &x, &y);
	   }
/*
 *  temporary kludge.  really need to make this part of the layout method...
 */
	   bw = xwid->core.border_width;
	   xvw_get_attributes(xvw_parent(xvw_object(widget)),
		  XVW_XSNAP, &xsnap, XVW_YSNAP, &ysnap, XVW_BUFFER_DIST, &dist,
		  NULL);
	   x += (((x-bw) % xsnap > xsnap/2) ? xsnap : 0) - (x % xsnap);
	   y += (((y-bw) % ysnap > ysnap/2) ? ysnap : 0) - (y % ysnap);
	   xwid->core.x = x+bw+dist;
	   xwid->core.y = y+bw+dist;
	}

	/*
	 *  Now do the important thing.  Realize the Node so that we can
	 *  get on with it.
	 */
        (*xvwNodeWidgetClass->core_class.superclass->core_class.realize)
                (widget, valuemask, attrib);
	xvw_set_attribute(xwid->node.label, XVW_LABEL, xwid->node.name);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: This method is used to set the public values
|                of a XvwNodeWidget instance.  The public values
|                which can be changed are all related to the display
|		 of the node.
|
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|
|        Output:
|       Returns:
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Aug 19, 1992 9:13
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues (
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num)
{
	XvwNodeWidget cxwid = kwidget(current);
	XvwNodeWidget nxwid = kwidget(new);

	int modified;


	/*
	 *  set the name of the node
	 */
	if (cxwid->node.name != nxwid->node.name)
	{
	   kfree(cxwid->node.name);
	   nxwid->node.name = kstrdup(nxwid->node.name);
	   if (XtWindowOfObject(new))
	      xvw_set_attribute(nxwid->node.label, XVW_LABEL, nxwid->node.name);
	}

	if (cxwid->node.pixmap != nxwid->node.pixmap)
	{
	   xvw_set_attribute(nxwid->node.icon, XVW_PIXMAP, nxwid->node.pixmap);
	}

	if (cxwid->node.modified      != nxwid->node.modified ||
	    cxwid->node.show_modified != nxwid->node.show_modified)
	{
	   if (nxwid->node.modified && nxwid->node.show_modified)
	      xvw_set_attribute(xvw_object(new), XVW_CANVAS_GRID,
			KMANAGER_GRID_ON);
	   else
	      xvw_set_attribute(xvw_object(new), XVW_CANVAS_GRID,
			KMANAGER_GRID_OFF);

	   modified = nxwid->node.modified;
	   XtCallCallbacks(new, XVW_NODE_MODIFIED_CALLBACK, &modified);
	}
	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: Destroy
|
|       Purpose: destroy the node...
|         Input: widget - the node widget being destroyed
|        Output:
|
|    Written By: Mark Young
|          Date: Nov 21, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Destroy(
   Widget widget)
{
        XvwNodeWidget xwid = kwidget(widget);
	Widget parent =  XtParent(widget);


        if (!parent->core.being_destroyed)
        {
           if (xwid->node.label)
              xvw_destroy(xwid->node.label);
        }
        kfree(xwid->node.name);
	xwid->node.label = NULL;
}

/*-----------------------------------------------------------
|
|  Routine Name: ChangeSelection
|
|       Purpose: Reduce or increase the border width depending on whether
|		 we are selected or not.
|         Input: widget - the node object which is having it's selection
|			  changed
|    Written By: Mark Young
|          Date: Dec 08, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ChangeSelection(
   Widget widget,
   int	  selected)
{
	int x  = widget->core.x;
	int y  = widget->core.y;
	int offset, bw = widget->core.border_width;
        XvwNodeWidget xwid = (XvwNodeWidget) widget;


	if (selected == TRUE)
	{
	   xvw_set_attributes(xvw_object(widget),
			XVW_BORDER_WIDTH, bw * 2,
			XVW_XPOSITION, x - bw,
			XVW_YPOSITION, y - bw,
			NULL);
	    offset = 0;
	    xvw_set_attribute(xwid->node.label, XVW_VERT_DIST, offset);
	}
	else
	{
	   xvw_set_attributes(xvw_object(widget),
			XVW_BORDER_WIDTH, bw/2,
			XVW_XPOSITION, x + bw/2,
			XVW_YPOSITION, y + bw/2,
			NULL);
	    offset = bw/2;
	    xvw_set_attribute(xwid->node.label, XVW_VERT_DIST, offset);
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: NodeReverseColors - reverses the color of the node.
|
|       Purpose: This routine reverses the color of the node.  This
|		 is used to indicate the node is doing something.
|		 Typically this means executing.
|
|         Input: node    - the node to reverse colors for.
|		 reverse - whether to reverse the colors of not.
|
|    Written By: Mark Young
|          Date: Jul 20, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void NodeReverseColors(
   xvobject node,
   int      reverse)
{
	XvwNodeWidget xwid = (XvwNodeWidget) xvw_widget(node);

	Pixel bg = xwid->core.background_pixel;
	Pixel fg = xwid->manager.foreground_pixel;

	xvw_set_attributes(node,
		XVW_FOREGROUND, bg,
		XVW_BACKGROUND, fg,
		NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: RequestDispatchNode
|
|       Purpose: Request the dispatching of nodes.
|
|    Written By: Mark Young
|          Date: Oct 24, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
void RequestDispatchNode(void)
{
	if (dispatch_id != 0)
	  return;

	dispatch_id = XtAppAddTimeOut(xvw_appcontext(NULL), 0,
				DispatchNode, NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: DispatchNode
|
|       Purpose: Dispatches node's depending if they are ready to be run.
|
|    Written By: Mark Young
|          Date: Nov 26, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void DispatchNode(
   XtPointer    calldata,
   XtIntervalId *id)
{
	xvobject node;
	Widget   widget;
        XvwNodeWidget xwid;
	XvwNodeWidgetClass class;

	klist    *entry, *list = frontier;
	int	 check, running = KNODE_RUNNING;


	dispatch_id = 0;
	while (list != NULL)
	{
	   entry  = list;
	   node   = (xvobject) klist_identifier(entry);
	   widget = xvw_widget(node);
	   xwid   = (XvwNodeWidget) widget;

	   /*
	    *  Check to see if the current node is running...  If so
	    *  then skip to the next node.
	    */
	   if (xwid->node.running == KNODE_RUNNING)
	   {
	      list = klist_next(list);
	      continue;
	   }
	   list = klist_next(list);
	   class = (XvwNodeWidgetClass) widget->core.widget_class;

	   if (class->node_class.check_node != NULL)
	      check = class->node_class.check_node(widget);
	   else
	      check = TRUE;

	   if (check)
	   {
	      if (class->node_class.exec_node != NULL)
	      {
		 xwid->node.running = KNODE_RUNNING;
	         NodeReverseColors(node, TRUE);

		 class->node_class.exec_node(widget, KNODE_RUNNING);
		 XtCallCallbacks(widget, XVW_NODE_RUN_CALLBACK, &running);
	      }
	      else
	      {
	         frontier = klist_delete(frontier, (kaddr) node);
		 xwid->node.running = KNODE_STOPPED;
		 xwid->node.testing = FALSE;
	      }
	   }
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: ResetNode
|
|       Purpose: ResetNode is used to reset the node.
|         Input: node  - the object in which we will be resetting
|		 attribute - the XVW_NODE_RESET attribute
|		 calldata  - not used
|
|        Output:
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Nov 21, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static int ResetNode(
   xvobject node,
   char     *attribute,
   kaddr    calldata)
{
	Widget widget = xvw_widget(node);
	XvwNodeWidget xwid = (XvwNodeWidget) widget;


	xwid->node.modified = FALSE;
	xvw_set_attribute(node, XVW_NODE_MODIFIED, TRUE);
	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: GetExecute
|
|       Purpose: GetExecute is used to get whether the node is currently
|		 running or not.
|
|         Input: node      - the object in which we will be getting the
|			     status for
|		 attribute - the execute attribute
|        Output: calldata  - pointer to retrieve the status for
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Nov 21, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static int GetExecute(
   xvobject node,
   char     *attribute,
   kaddr    calldata)
{
	int *execute = (int *) calldata;
	XvwNodeWidget xwid = (XvwNodeWidget) xvw_widget(node);


	if (kstrcmp(attribute, XVW_NODE_TEST) != 0 &&
	    kstrcmp(attribute, XVW_NODE_EXECUTE) != 0 &&
	    kstrcmp(attribute, XVW_NODE_RUNNABLE) != 0)
	{
	   kerror(XVLANG, "GetExecute", "invalid attribute %s", attribute);
	   return(FALSE);
	}

	if (kstrcmp(attribute, XVW_NODE_TEST) == 0)
	{
	   *execute = xwid->node.testing;
	}
	else if (kstrcmp(attribute, XVW_NODE_RUNNABLE) == 0)
	{
	   XvwNodeWidgetClass class;

	   class = (XvwNodeWidgetClass) xwid->core.widget_class;

	   if (xwid->node.runnable == FALSE || xwid->node.modified == FALSE ||
	       xwid->node.running != KNODE_STOPPED)
	   {
	      *execute = FALSE;
	   }
	   else if (class->node_class.check_node != NULL)
	      *execute = class->node_class.check_node((Widget) xwid);
	   else
	      *execute = TRUE;
	}
	else
	{
	   *execute = xwid->node.running;
	}
	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetExecute
|
|       Purpose: GetExecute is used to whether we should execute the node
|		 or not
|
|         Input: node  - the object in which we will be setting whether
|			     to execute or not
|		 attribute - the old object to be closed
|		 calldata  - the filename to be set
|
|        Output:
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Nov 21, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static int SetExecute(
   xvobject node,
   char     *attribute,
   kaddr    calldata)
{
	Widget widget = xvw_widget(node);
	int    execute = *((int *) calldata);
	XvwNodeWidget xwid = (XvwNodeWidget) widget;

	XvwNodeWidgetClass class;
	int  running, exec_status;


	if (kstrcmp(attribute, XVW_NODE_TEST) != 0 &&
	    kstrcmp(attribute, XVW_NODE_EXECUTE) != 0)
	{
	   kerror(XVLANG, "SetExecute", "invalid attribute %s", attribute);
	   return(FALSE);
	}

	/*
	 *  Execute the sucker if ain't modified and it ain't currently
	 *  being executed or waiting to be executed...
	 */
	if (execute == TRUE && xwid->node.modified == FALSE)
	   return(TRUE);
	 
	xvw_get_attribute(node, XVW_NODE_EXECUTE, &exec_status);
	if (exec_status == KNODE_SCHEDULED || exec_status == KNODE_RUNNING)
	   running = TRUE;
	else
	   running = FALSE;

	if (running == execute)
	   return(TRUE);

	if (kstrcmp(attribute, XVW_NODE_TEST) == 0)
	   xwid->node.testing = execute;

	if (execute)
	{
	   running = xwid->node.running = KNODE_SCHEDULED;
	   frontier = klist_add(frontier, (kaddr) node, NULL);
	   XtCallCallbacks(widget, XVW_NODE_RUN_CALLBACK, &running);
	   RequestDispatchNode();
	}
	else
	{
	   if (xwid->node.running == KNODE_RUNNING)
	      NodeReverseColors(node, FALSE);

	   xwid->node.testing = FALSE;
	   running = xwid->node.running = KNODE_STOPPED;
	   frontier = klist_delete(frontier, (kaddr) node);

	   /*
	    *  Stop the sucker...
	    */
	   class = (XvwNodeWidgetClass) widget->core.widget_class;
	   if (class->node_class.exec_node != NULL)
	      class->node_class.exec_node(widget, FALSE);

	   XtCallCallbacks(widget, XVW_NODE_RUN_CALLBACK, &running);
	   RequestDispatchNode();
	}
	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: NodeHandler
|
|       Purpose: This routine will perform the changing of the node name.
|
|         Input: object      - the button being activated
|                client_data - the node widget
|                event       - event the activated us
|		 dispatch    - whether to continue dispatch the event
|
|    Written By: Mark Young
|          Date: Apr 18, 1995
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static void NodeHandler(
   xvobject object,
   kaddr    client_data,
   XEvent   *event,
   int      *dispatch)
{
	xvobject node = (xvobject) client_data;
	XvwNodeWidget xwid = (XvwNodeWidget) xvw_widget(node);

	static xvobject selected_object = NULL;
	char   *prompt = "Node Name: ", temp[KLENGTH], *answer = temp;


	*dispatch = FALSE;
	if (event->type == ButtonPress)
	{
	   selected_object = object;
	   return;
	}
	else if (event->type != ButtonRelease || object != selected_object)
	   return;

	if (object == xwid->node.label)
	{
	   kstrcpy(answer, xwid->node.name);
	   if (xvu_query_wait("Please enter new Icon Name", &prompt, "OK",
                              &answer, 1, 35) && kstrlen(answer) > 0)
           {
	      xvw_set_attribute(node, XVW_NODE_NAME, answer);
           }
	}
}


/************************************************************
*
*  Routine Name: xvw_create_node - create an node object
*
*       Purpose: The node object provides the base class which is 
*		 used to create iconic representations of textual
*		 language routines.  The node object is the object from 
*		 which the \fIglyph\fP objects are subclassed, and should
*		 be used as the base class for any new visual programming
*		 objects that might be created for textual code 
*		 representation.
*		
*		 The node object consists of a small window
*		 with an optional pixmap in the middle, and a 
*		 name that appears below the window.
*		 The node object supports interactive placement;
*		 the user can place the node using a shadow outline,
*		 or the (x, y) position may be specified by the
*		 application.
*
*		 A node object allows (1) specification of the 
*		 corresponding routine to be executed, and (2) rules 
*		 for determining when that routine may be executed.
*
*		 When the routine to be executed is specified as an
*		 external process, the Node object does "large grain"
*		 execution, or distributed execution of operators 
*		 representing individual programs, as the Glyph object does.
*		 On the other hand, when the routine to be executed is
*		 specified as an internally defined function, the node object 
*		 does ""fine grain" execution, or the calling of a subroutine 
*		 or function internal to the visual programming language itself.
*		 Thus, the Node object can support both large grain and
*		 fine grain visual programming.
*
*		 The node object can be used to create new iconic 
*		 representations; thus, it allows the \fIxvlang\fP library 
*		 to be extended to support visual programming constructs 
*		 other than the ones currently used in \fHcantata\fP.
*
*		 When the Node object is used as the base class for iconic 
*		 representation of modules and the Workspace object is utilized 
*		 as the visual editor, any new visual object that is written
*		 to be subclassed off the Node will automatically be supported 
*		 by the existing system.
*
*		 In addition, any such new visual programming objects will be 
*		 capable of coexisting with existing visual programming 
*		 objects. They can be combined in a visual network as desired; 
*		 allowed combinations are only restricted by the visual 
*		 programming model, as appropriate, but not by the visual 
*		 programming objects themselves.
*
*         Input: parent - parent of the node object; NULL will cause
*                         a default toplevel to be created automatically
*                name   - name with which to reference node object
*
*        Output: 
*       Returns: The node widget on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Jan 14, 1993 16:47
*      Verified: 
*  Side Effects: 
* Modifications:
*
*******************************************************************/

xvobject xvw_create_node(
   xvobject parent,
   char     *name)
{
	xvobject node;


	node = xvw_create(parent, FALSE, TRUE, name, NodeWidgetClass);
	xvw_set_attributes(node,
		XVW_SELECTABLE, TRUE,
		XVW_RESIZABLE, FALSE,
		XVW_MENUABLE, FALSE,
		NULL);
	return(node);
}
