 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>	              Khoros Conditional Widget
   >>>>  Private:
   >>>>   Static:
   >>>> 		ClassInitialize()
   >>>> 		Initialize()
   >>>> 		SetValues()
   >>>> 		Destroy()
   >>>> 		ConditionalCheck()
   >>>> 		ConditionalExec()
   >>>>   Public:
   >>>>			xvw_create_conditional()
   >>>>	
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvlang/ConditionalP.h>
#include <xvlang/WorkspaceP.h>

static void ClassInitialize PROTO((void));
static void Initialize      PROTO((Widget, Widget, ArgList, Cardinal *));
static Boolean SetValues    PROTO((Widget, Widget, Widget, ArgList,Cardinal *));
static void    Destroy	    PROTO((Widget));

static int  ConditionalCheck	    PROTO((Widget));
static void ConditionalExec	    PROTO((Widget, int));


/*-------------------------------------------------------------------*
|
|   Define Default Pixmap Paths
|
--------------------------------------------------------------------*/
 
#define DAV_PIXMAP     "$DESIGN/objects/library/xvlang/misc/control/cdav.xpm"

/*-------------------------------------------------------------------*
|
|   Full class attributes
|
--------------------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_CONDITIONAL_TYPE,   NULL,   XtRInt,  NULL},
};


/*-------------------------------------------------------------------*
|
|   Full class record constant
|
--------------------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwConditionalWidgetRec, conditional.field)

static XtResource resources[] = { 
{XVW_CONDITIONAL_TYPE, NULL, XtRInt, sizeof(int),
        offset(type), XtRImmediate, (XtPointer) 0},

{XVW_GLYPH_DAV_PIXMAP, NULL, XtRPixmap, sizeof(Pixmap),
        XtOffsetOf(XvwConditionalWidgetRec, glyph.dav_pixmap),
        XtRString, (XtPointer) DAV_PIXMAP},

};
#undef offset


/*-------------------------------------------------------------------*
|
|   Class Declaration for Conditional Widget
|
--------------------------------------------------------------------*/

#define superclass (&xvwGlyphWidgetClassRec)

XvwConditionalWidgetClassRec xvwConditionalWidgetClassRec =
{
  {
    (WidgetClass) superclass,		/* superclass		  */	
    "Conditional",			/* class_name		  */
    sizeof(XvwConditionalWidgetRec),	/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    Destroy,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    XtInheritQueryGeometry,		/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,				    /* subresources	  */
    0,					    /* subresources_count */
    sizeof(XvwConditionalWidgetConstraintsRec),/* constraint_size	  */
    NULL,				    /* initialize	  */
    NULL,				    /* destroy		  */
    NULL,				    /* set_values	  */
    NULL,				    /* extension	  */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,                        /* child layout routine  */
    XtInheritChangeSel,			    /* change selected proc   */
    XtInheritEraseSel,			    /* erase selected proc    */
    XtInheritRefreshSel,		    /* refresh selection proc */
    XtInheritResize,			    /* resize		      */
    XtInheritGeometryManager,		    /* geometry_manager	      */
  },  /* XvwManagerWidgetClass fields initialization */
  {
    ConditionalCheck,	                    /* firing rule check  */
    ConditionalExec,	                    /* execute node       */
    NULL, 		                    /* extension          */
  },  /* XvwNodeWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwGlyphWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwConditionalWidgetClass fields initialization */
};
#undef superclass

  /* for public consumption */
WidgetClass xvwConditionalWidgetClass = (WidgetClass) &xvwConditionalWidgetClassRec;


/*-------------------------------------------------------------------*
|
|   Miscelleanous defines for Class and Constraint Declarations
|
--------------------------------------------------------------------*/

#undef  kwidget
#define kwidget(widget)	    (XvwConditionalWidget) (widget)


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an
|                instance of a XvwConditionalWidget class has been created.
|                This is where the attributes for the class are
|		 initialized. 
|
|    Written By: Mark Young
|          Date: Oct 19, 1992
| Modifications:
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
	xvw_init_attributes(xvwConditionalWidgetClass, attributes,
		XtNumber(attributes), NULL, 0, 
		"$DESIGN/objects/library/xvlang/uis/Conditional.pane");
	xvw_load_resources("$DESIGN/objects/library/xvlang/app-defaults/Conditional");
}

/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|       Purpose: This method will set up the initial conditional
|                widget instance.
|
|         Input: request - not used
|                new     - widget instance after initialization
|
|        Output:
|
|    Written By: Mark Young
|          Date: May 26, 1993 13:28
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
        XvwConditionalWidget xwid = kwidget(new);


	/*
	 *  Want the pixmap icon to be below the destroy button
	 */
	xvw_set_attribute(xwid->node.icon, XVW_BELOW, xwid->glyph.destroy);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: This method is used to set the public values
|                of a XvwConditionalWidget instance.  The public values
|                which can be changed are all related to the display
|		 of the conditional.
|
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|
|        Output:
|       Returns:
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Aug 19, 1992 9:13
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues (
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num)
{
	XvwConditionalWidget cxwid = kwidget(current);
	XvwConditionalWidget nxwid = kwidget(new);

	int  h, bw;
	char *icon = NULL, *file = NULL;


	if (cxwid->glyph.oname != nxwid->glyph.oname)
	{
	   if (kstrcmp(nxwid->glyph.oname, "if_else") == 0)
	      nxwid->conditional.type = KCONDITIONAL_TYPE_IF_ELSE;
	   else if (kstrcmp(nxwid->glyph.oname, "switch") == 0)
	      nxwid->conditional.type = KCONDITIONAL_TYPE_SWITCH;
	   else if (kstrcmp(nxwid->glyph.oname, "expr") == 0)
	      nxwid->conditional.type = KCONDITIONAL_TYPE_EXPRESSION;
	   else if (kstrcmp(nxwid->glyph.oname, "trigger") == 0)
	      nxwid->conditional.type = KCONDITIONAL_TYPE_TRIGGER;
	   else if (kstrcmp(nxwid->glyph.oname, "merge") == 0)
	      nxwid->conditional.type = KCONDITIONAL_TYPE_MERGE;
	   else if (kstrcmp(nxwid->glyph.oname, "break") == 0)
	      nxwid->conditional.type = KCONDITIONAL_TYPE_BREAK;
	   else if (kstrcmp(nxwid->glyph.oname, "continue") == 0)
	      nxwid->conditional.type = KCONDITIONAL_TYPE_CONTINUE;
	}

	if (cxwid->conditional.type != nxwid->conditional.type)
	{
	   if (nxwid->conditional.type == KCONDITIONAL_TYPE_IF_ELSE)
	   {
	      icon = "$DESIGN/objects/library/xvlang/misc/control/ifthen.xpm";
	      file = "$DESIGN/objects/library/xvlang/uis/control/if_else.pane";
	   }
	   else if (nxwid->conditional.type == KCONDITIONAL_TYPE_SWITCH)
	   {
	      icon = "$DESIGN/objects/library/xvlang/misc/control/switch.xpm";
	      file = "$DESIGN/objects/library/xvlang/uis/control/switch.pane";
	   }
	   else if (nxwid->conditional.type == KCONDITIONAL_TYPE_EXPRESSION)
	   {
	      icon = "$DESIGN/objects/library/xvlang/misc/control/expr.xpm";
	      file = "$DESIGN/objects/library/xvlang/uis/control/expr.pane";
	   }
	   else if (nxwid->conditional.type == KCONDITIONAL_TYPE_TRIGGER)
	   {
	      icon = "$DESIGN/objects/library/xvlang/misc/control/trigger.xpm";
	      file = "$DESIGN/objects/library/xvlang/uis/control/trigger.pane";
	   }
	   else if (nxwid->conditional.type == KCONDITIONAL_TYPE_MERGE)
	   {
	      icon = "$DESIGN/objects/library/xvlang/misc/control/merge.xpm";
	      file = "$DESIGN/objects/library/xvlang/uis/control/merge.pane";
	   }
	   else if (nxwid->conditional.type == KCONDITIONAL_TYPE_BREAK)
	   {
	      icon = "$DESIGN/objects/library/xvlang/misc/control/break.xpm";
	      file = "$DESIGN/objects/library/xvlang/uis/control/break.pane";
	   }
	   else if (nxwid->conditional.type == KCONDITIONAL_TYPE_CONTINUE)
	   {
	      icon ="$DESIGN/objects/library/xvlang/misc/control/continue.xpm";
	      file ="$DESIGN/objects/library/xvlang/uis/control/continue.pane";
	   }

	   if (icon != NULL)
	      xvw_set_attribute(xvw_object(new), XVW_NODE_PIXMAPFILE, icon);

	   if (file != NULL && nxwid->glyph.form == NULL)
	      xvw_set_attribute(xvw_object(new), XVW_GLYPH_FORMFILE, file);

	   xvw_set_attributes(nxwid->node.icon,
			XVW_BORDER_WIDTH, 0,
			XVW_VERT_DIST, 3,
			NULL);
	   if (nxwid->glyph.isize == 1)
	   {
	      xvw_set_attributes(nxwid->glyph.iports[0],
			XVW_ABOVE, nxwid->node.icon,
			XVW_BELOW, nxwid->node.icon,
                        XVW_VERT_DIST, 0,
			XVW_BORDER_WIDTH, 0,
			NULL);
	   }
	   else if (nxwid->glyph.isize == 2)
	   {
	      xvw_geometry(nxwid->glyph.iports[0], NULL, NULL, NULL,
			(unsigned int *) &h, (unsigned int *) &bw);

	      xvw_set_attributes(nxwid->glyph.iports[0],
                        XVW_ABOVE, nxwid->node.icon,
                        /*XVW_VERT_DIST, (h + bw*2),*/
			XVW_BORDER_WIDTH, 0,
                        NULL);

	      xvw_set_attributes(nxwid->glyph.iports[1],
                        XVW_BELOW, nxwid->node.icon,
                        XVW_VERT_DIST, - (h/2 + bw*2),
			XVW_BORDER_WIDTH, 0,
                        NULL);
	   }

	   if (nxwid->glyph.osize == 1)
	   {
	      xvw_set_attributes(nxwid->glyph.oports[0],
			XVW_ABOVE, nxwid->node.icon,
			XVW_BELOW, nxwid->node.icon,
                        XVW_VERT_DIST, 0,
			XVW_BORDER_WIDTH, 0,
			NULL);
	   }
	   else if (nxwid->glyph.osize == 2)
	   {
	      xvw_geometry(nxwid->glyph.oports[0], NULL, NULL, NULL,
			(unsigned int *) &h, (unsigned int *) &bw);

	      xvw_set_attributes(nxwid->glyph.oports[0],
                        XVW_ABOVE, nxwid->node.icon,
                        /*XVW_VERT_DIST, (h + bw*2),*/
			XVW_BORDER_WIDTH, 0,
                        NULL);

	      xvw_set_attributes(nxwid->glyph.oports[1],
                        XVW_BELOW, nxwid->node.icon,
                        XVW_VERT_DIST, - (h/2 + bw*2),
			XVW_BORDER_WIDTH, 0,
                        NULL);
	   }
	}
	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: Destroy
|
|       Purpose: destroy the conditional...
|         Input: widget - the conditional widget being destroyed 
|        Output: 
|
|    Written By: Mark Young
|          Date: Nov 21, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Destroy(
   Widget widget)
{
	XvwConditionalWidget xwid = kwidget(widget);


}

/*-----------------------------------------------------------
|
|  Routine Name: ConditionalCheck
|
|       Purpose: This routine will check to see if a glyph is ready to run.
|         Input: widget      - the glyph widget to be checked
|
|    Written By: Mark Young
|          Date: Jul 30, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static int ConditionalCheck(
   Widget   widget)
{
        XvwConditionalWidget xwid = (XvwConditionalWidget) widget;

	xvobject temp;
	int i, test, test1, test2, executing, modified, selected;


	if (xwid->conditional.type == KCONDITIONAL_TYPE_MERGE)
	{
	   xvw_get_attribute(xwid->glyph.iports[0], XVW_PORT_DAV, &test1);
	   xvw_get_attribute(xwid->glyph.iports[1], XVW_PORT_DAV, &test2);
	   if (!test1 && !test2)
	      return(FALSE);
	}
	else
	{
	   for (i = 0; i < xwid->glyph.isize; i++)
	   {
	      xvw_get_attributes(xwid->glyph.iports[i],
			XVW_PORT_DAV,      &test,
	      		XVW_PORT_SELECTED, &selected,
			NULL);
	      if (test == FALSE && selected == TRUE)
	         return(FALSE);
	   }
	}

	for (i = 0; i < xwid->glyph.inum; i++)
	{
	   temp = NULL;
	   xvw_get_attribute(xwid->glyph.iconnections[i],
			XVW_CONNECTION_BEGIN, &temp);

	   temp = xvw_parent(temp);
	   xvw_get_attributes(temp,
			XVW_NODE_EXECUTE, &executing,
			XVW_NODE_MODIFIED, &modified,
			NULL);
	   if (executing == TRUE || modified == TRUE)
	      return(FALSE);
	}
	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: ConditionalExec
|
|       Purpose: This routine will run or stop the execution of a conditional.
|         Input: widget      - the conditional widget to be run
|                exec        - whether we wish to run or stop the conditional
|
|    Written By: Mark Young
|          Date: Jul 30, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static void ConditionalExec(
   Widget   widget,
   int      exec)
{
	XvwConditionalWidget xwid = kwidget(widget);
	xvobject glyph = xvw_object(widget);

	kselection *selection;
	int	   value, test;
	xvobject   iport, oport;
	char	   *text, *infile = NULL, *outfile = NULL;


	if (exec == KNODE_STOPPED)
	{
	   xvw_set_attribute(xwid->glyph.execute, XVW_PIXMAP,
			xwid->glyph.off_pixmap);
	   return;
	}
	else if (exec == KNODE_RUNNING)
	{
	   xvw_set_attribute(xwid->glyph.execute, XVW_PIXMAP,
			xwid->glyph.on_pixmap);
	}

	if (xwid->conditional.type == KCONDITIONAL_TYPE_IF_ELSE)
	{
	   selection = kvf_variable_sel_search(xwid->glyph.form, "condition");
	   if (selection == NULL)
	      return;

	   iport = xwid->glyph.iports[0];
	   xvf_get_attribute(selection->back_kformstruct, XVF_INT_VAL, &value);
	   if (value)
	      oport = xwid->glyph.oports[0];
	   else
	      oport = xwid->glyph.oports[1];
	}
	else if (xwid->conditional.type == KCONDITIONAL_TYPE_SWITCH)
	{
	   selection = kvf_variable_sel_search(xwid->glyph.form, "condition");
	   if (selection == NULL)
	      return;

	   oport = xwid->glyph.oports[0];
	   xvf_get_attribute(selection->back_kformstruct, XVF_INT_VAL, &value);
	   if (value)
	      iport = xwid->glyph.iports[0];
	   else
	      iport = xwid->glyph.iports[1];
	}
	else if (xwid->conditional.type == KCONDITIONAL_TYPE_EXPRESSION)
	{
           long id = (long) xwid->glyph.expression_id;

	   selection = kvf_variable_sel_search(xwid->glyph.form, "expression");
	   if (selection == NULL)
	      return;

	   oport = xwid->glyph.oports[0];
	   iport = xwid->glyph.iports[0];
	   xvf_get_attribute(selection->back_kformstruct,XVF_STRING_VAL, &text);
	   (void) kexpr_evaluate_int(id, text, &value, NULL);
	}
	else if (xwid->conditional.type == KCONDITIONAL_TYPE_TRIGGER)
	{
	   oport = xwid->glyph.oports[0];
	   iport = xwid->glyph.iports[0];
	}
	else if (xwid->conditional.type == KCONDITIONAL_TYPE_MERGE)
	{
	   oport = xwid->glyph.oports[0];
	   xvw_get_attribute(xwid->glyph.iports[0], XVW_PORT_DAV, &test);
	   if (test == TRUE)
	      iport = xwid->glyph.iports[0];
	   else
	      iport = xwid->glyph.iports[1];
	}
	else return;

	xvw_get_attribute(iport, XVW_PORT_FILENAME, &infile);
	xvw_get_attribute(oport, XVW_PORT_FILENAME, &outfile);
	if (infile != NULL && outfile != NULL && xwid->node.testing == FALSE)
	   kcopyfile(infile, outfile);

	xvw_set_attribute(oport, XVW_PORT_DAV, TRUE);
	xvw_set_attributes(glyph,
		XVW_NODE_EXECUTE,  FALSE,
		XVW_NODE_MODIFIED, FALSE,
		NULL);
}


/************************************************************
*
*  Routine Name: xvw_create_conditional - create a conditional object
*
*       Purpose: The purpose of the Conditional GUI object is to provide a
*		 visual programming component in which to implement
*		 conditional flow constructs.  Conditional flow constructs
*		 include such configurations as "if then else", "switch", etc.
*
*         Input: parent - the parent object; NULL will cause a
*			  default toplevel to be created automatically
*                name   - the name with which to reference the object
*        Output: none
*       Returns: The image object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Jan 14, 1994
*      Verified:
*  Side Effects:
* Modifications:
*
*******************************************************************/

xvobject xvw_create_conditional(
   xvobject parent,
   char     *name)
{
	xvobject conditional;


	conditional = xvw_create(parent, FALSE, TRUE, name,
			ConditionalWidgetClass);
	xvw_set_attributes(conditional,
		XVW_SELECTABLE, TRUE,
		XVW_RESIZABLE, FALSE,
		XVW_MENUABLE, FALSE,
		NULL);
	return(conditional);
}
