 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */



/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>               String Gadget Routines
   >>>>
   >>>>	 Private:
   >>>>	  Static:
   >>>>			ClassInitialize()
   >>>>			Initialize()
   >>>>			Destroy()
   >>>>			Redisplay()
   >>>>			SetValues()
   >>>>			RecomputeSize()
   >>>>			ChangeGeometry()
   >>>>			CompileString()
   >>>>   Public:
   >>>>			xvw_create_string()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"
#include <xvisual/StringP.h>


static void ClassInitialize	 PROTO((void));
static void Initialize		 PROTO((Widget, Widget, ArgList, Cardinal *));
static void Destroy   		 PROTO((Widget));
static void Redisplay		 PROTO((Widget, XEvent *, Region));
static Boolean SetValues	 PROTO((Widget, Widget, Widget, ArgList,
					Cardinal *));
static void RecomputeSize	 PROTO((Widget));
static void ChangeGeometry	 PROTO((Widget));
static void CompileString	 PROTO((Widget));


/*--------------------------------------------------------
|
|   Full class attributes
|
--------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_STRING_XPLACEMENT,         NULL,    XtRDouble,    NULL}, 
{XVW_STRING_YPLACEMENT,         NULL,    XtRDouble,    NULL}, 
{XVW_STRING_STRING,             NULL,    XtRString,    NULL}, 
{XVW_STRING_EMPHASIZE,		NULL,    XtRInt,       XtRBoolean}, 
{XVW_STRING_JUSTIFICATION,      NULL,    XtRInt,       NULL}, 
};

/*--------------------------------------------------------
|
|   Full class record constant
|
--------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwStringGadgetRec, string.field)

static XtResource resources[] = { 
{XVW_STRING_XPLACEMENT, NULL, XtRDouble, sizeof(double), 
      offset(placement.x), XtRString, (XtPointer) "0.0"},
{XVW_STRING_YPLACEMENT, NULL, XtRDouble, sizeof(double), 
      offset(placement.y), XtRString, (XtPointer) "0.0"},
{XVW_STRING_JUSTIFICATION, NULL, XtRInt, sizeof(int), 
      offset(justification), XtRImmediate, (XtPointer) KSTRING_JUSTIFY_LEFT},
{XVW_STRING_STRING, NULL, XtRString, sizeof(String),
      offset(string), XtRImmediate, (XtPointer) NULL},
{XVW_STRING_EMPHASIZE, NULL, XtRBoolean, sizeof(Boolean),
      offset(emphasize), XtRImmediate, (XtPointer) FALSE},
{XVW_STRING_STRING, NULL, XtRString, sizeof(String),
      offset(string), XtRImmediate, (XtPointer) NULL},
};
#undef offset


#define SUPERCLASS (&xvwGraphicsGadgetClassRec)

XvwStringGadgetClassRec xvwStringGadgetClassRec =
{
  {
    (WidgetClass) SUPERCLASS,		/* superclass		  */	
    "String",				/* class_name		  */
    sizeof(XvwStringGadgetRec),		/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    NULL,				/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    knumber(resources),			/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    FALSE,				/* compress_motion	  */
    FALSE,				/* compress_exposure	  */
    FALSE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    Destroy,				/* destroy		  */
    XtInheritResize,			/* resize		  */
    Redisplay,				/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    NULL,				/* query_geometry	  */
    NULL,				/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* RectObjClass fields initialization */
  {
    XtInheritPicking,			/* pick object proc       */
    XtInheritEraseSel,			/* erase selected proc    */
    XtInheritRefreshSel,		/* refresh selection proc */
    ChangeGeometry,			/* change geometry proc   */
  },  /* XvwManagerGadgetClass fields initialization */
  {
    NULL,		/* recompute position proc    */
  },  /* XvwGraphicsGadgetClass fields initialization */
  {
    NULL,				/* extension - not used   */
  },  /* XvwStringGadgetClass fields initialization */
};
#undef SUPERCLASS

/*
 * xvwStringGadgetClass for public consumption
 */
WidgetClass xvwStringGadgetClass = (WidgetClass) &xvwStringGadgetClassRec;


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an  
|                instance of string object class has been created.
|                It will initialize all the class attributes. 
|
|    Written By: Mark Young
|          Date: Aug 03, 1994
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
        xvw_init_attributes(xvwStringGadgetClass, attributes,
		knumber(attributes), NULL, 0, 
		"$DESIGN/objects/library/xvisual/uis/String.pane");
	xvw_load_resources("$DESIGN/objects/library/xvisual/app-defaults/String");
}

/*-----------------------------------------------------------
|
|  Routine Name: Initialize 
|
|       Purpose: This method will set up the initial values 
|                for the fields of a string object instance.
|                The width, height, ascent, and placement are
|		 all initialized to sane values. 
|
|         Input: request - not used 
|                new     - object instance after initialization, with
|                          date initialized 
|    Written By: Mark Young
|          Date: Aug 03, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwStringGadget nobj = (XvwStringGadget) new;

	/*
	 *  Compute the position of the object in device coordinates
	 */
	nobj->string.lines = NULL;
	nobj->string.numlines = 0;
	nobj->string.string_width   =
	nobj->string.string_height  = 0;
	nobj->string.string_ascent  = 0;
	nobj->string.string_descent = 0;
	nobj->string.placement.x = 0.0;
	nobj->string.placement.y = 0.0;
	nobj->string.placement.z = 0.0;
}

/*-----------------------------------------------------------
|
|  Routine Name: Destroy
|
|       Purpose: This routine will free the memory associated
|		 with the string before the string is destroyed
|
|         Input: widget - the string object being destroyed
|        Output:
|    Written By: Danielle Argiro & Mark Young
|          Date: Feb 22, 1995
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Destroy(
   Widget widget)
{
        XvwStringGadget xobj = (XvwStringGadget) widget;

	/* free memory associated with String object */
	karray_free(xobj->string.lines, xobj->string.numlines, NULL);

}

/*-----------------------------------------------------------
|
|  Routine Name: Redisplay
|
|       Purpose: This routine will redraw the string object in response
|                to an expose event. 
|
|         Input: widget - the string object that was exposed 
|                event  - the event that caused the redraw
|                region - the region that was exposed 
|
|    Written By: Mark Young
|          Date: Aug 03, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Redisplay(
   Widget widget,
   XEvent *event,
   Region region)
{
	XvwStringGadget xobj = (XvwStringGadget) widget;

	unsigned int w, h;
	int  i, x, y, length, numlines;

	String  *lines;
	GC      gc = xobj->manager.gc;
	Display *display = XtDisplay(widget);
	Window  window   = XtWindowOfObject(widget);


	/*
	 *  Check to see if this if there is a string to draw
	 */
	if (kstrlen(xobj->string.string) == 0 ||  
            !xvw_check_visible(xvw_object(widget)))
	   return;

	/*
	 *  Compute position using the string's current position
	 */
	x = xobj->rectobj.x;
	y = xobj->rectobj.y;
	w = xobj->rectobj.width;
	h = xobj->rectobj.height;

	lines = xobj->string.lines;
	numlines = xobj->string.numlines;
	if (xobj->graphics.filled)
	{
	   XSetForeground(display, gc, xobj->manager.background);
	   XFillRectangle(display, window, gc, x, y, w, h);
	   XSetForeground(display, gc, xobj->manager.foreground);
	}

	y += xobj->string.string_ascent;
	for (i = 0; i < numlines; i++)
	{
	   length = kstrlen(lines[i]);
	   if (xobj->string.emphasize)
	   {
	      XSetForeground(display, gc, xobj->manager.background);
	      XDrawString(display, window, gc, x+1, y, lines[i], length);
	      XSetForeground(display, gc, xobj->manager.foreground);
	   }
	   XDrawString(display, window, gc, x, y, lines[i], length);

	   y += xobj->string.string_ascent+xobj->string.string_descent;
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: If the the justification or postion of the 
|		 string as changed, recalculate the new position. 
|
|         Input: current - the object containing current settings 
|                request - the object containing requested settings
|                new     - the object processed through all set values methods 
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|    Written By: Mark Young
|          Date: Aug 03, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwStringGadget cobj = (XvwStringGadget) current;
	XvwStringGadget nobj = (XvwStringGadget) new;

	Boolean clear_area, redisplay = FALSE;


	if (cobj->manager.font != nobj->manager.font ||
	    !GraphicsCheckCoord(cobj->string.placement, nobj->string.placement))
	{
	   RecomputeSize(new);
	   redisplay = TRUE;
	}

	if (cobj->string.justification != nobj->string.justification ||
	    cobj->string.emphasize     != nobj->string.emphasize)
	{
	   RecomputeSize(new);
	   redisplay = TRUE;
	}

	if (cobj->string.string != nobj->string.string)
	{
	   /*
	    *  Free the previously allocated private string
	    */
	   kfree(cobj->string.string);
	   nobj->string.string = kstrdup(nobj->string.string);
	   CompileString(new);
	   RecomputeSize(new);
	   redisplay = TRUE;
	}

	if (redisplay && nobj->manager.force_redisplay)
	{
	   clear_area = !nobj->graphics.filled;
	   ManagerObjForceRedisplay(current, new, clear_area, &redisplay);
	}
	return(redisplay && nobj->manager.mapped);
}

/*-----------------------------------------------------------
|
|  Routine Name: RecomputeSize
|
|       Purpose: Given a new world coordinate position,  
|                recompute the new device coordinate position 
|		 of the string. 
|
|         Input: widget - the string object 
|    Written By: Mark Young
|          Date: Aug 03, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static void RecomputeSize(
   Widget widget)
{
	XvwStringGadget xobj = (XvwStringGadget) widget;

	String *lines;
	XtWidgetGeometry temp;
	int i, numlines, len, ascent, descent, width;


	/*
	 *  Get the extent of the string
	 */
	len = kstrlen(xobj->string.string);
	if (len > 0 && xobj->manager.font != NULL)
	{
	   lines = xobj->string.lines;
	   numlines = xobj->string.numlines;
	   ascent  = xobj->manager.font->max_bounds.ascent;
	   descent = xobj->manager.font->max_bounds.descent;
	   xobj->string.string_ascent  = ascent;
	   xobj->string.string_descent = descent;
	   xobj->string.string_height  = (ascent + descent) * numlines;

	   for (i = 0, width = 0; i < numlines; i++)
	   {
	      len = XTextWidth(xobj->manager.font, lines[i], kstrlen(lines[i]));
	      if (len > width) width = len;
	   }
	   xobj->string.string_width = width;
	}
	else
	{
	   xobj->string.string_width   =
	   xobj->string.string_height  =
	   xobj->string.string_ascent  =
	   xobj->string.string_descent = 0;
	}

	/*
	 *  Request the new size....
	 */
	temp.request_mode = CWWidth | CWHeight;
	temp.width  = (Dimension) xobj->string.string_width;
	temp.height = (Dimension) xobj->string.string_height;
	(void) XtMakeGeometryRequest(widget, &temp, &temp);
}

/*-----------------------------------------------------------
|
|  Routine Name: ChangeGeometry
|
|       Purpose: Given a new device coordinate description of the
|                string, recompute the world coordinate position of 
|                the string.
|
|         Input: widget - the string object
|    Written By: Mark Young
|          Date: Aug 03, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ChangeGeometry(
   Widget widget)
{
	XvwStringGadget xobj = (XvwStringGadget) widget;

	Real x, y;
	int  justify, id = xobj->graphics.id;


	x = xobj->rectobj.x;
	y = xobj->rectobj.y;

	/*
	 * Adjust the position according to the string justification
	 */
	justify = xobj->string.justification;
	if (justify == KSTRING_JUSTIFY_CENTER ||
	    justify == KSTRING_JUSTIFY_BOTTOM ||
	    justify == KSTRING_JUSTIFY_TOP)
	   x += (Real) xobj->string.string_width/2.0;
	else if (justify == KSTRING_JUSTIFY_RIGHT ||
		 justify == KSTRING_JUSTIFY_TOPRIGHT ||
		 justify == KSTRING_JUSTIFY_BOTTOMRIGHT)
	   x += (Real) xobj->string.string_width;

	if (justify == KSTRING_JUSTIFY_CENTER ||
	    justify == KSTRING_JUSTIFY_LEFT ||
	    justify == KSTRING_JUSTIFY_RIGHT)
	   y += (Real) xobj->string.string_height/2.0;
	else if (justify == KSTRING_JUSTIFY_BOTTOM ||
		 justify == KSTRING_JUSTIFY_BOTTOMLEFT ||
		 justify == KSTRING_JUSTIFY_BOTTOMRIGHT)
	   y += (Real) xobj->string.string_height;

	X2D_convert_point_dc_to_wc(id, x, y, &xobj->string.placement);
}

/*-----------------------------------------------------------
|
|  Routine Name: CompileString - this routine compiles the string
|
|       Purpose: This routine actually compiles the string into a
|		 multiline detab'ed string.
|
|         Input: widget - the string gadet
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|    Written By: Mark Young
|          Date: Nov 24, 1993
|
------------------------------------------------------------*/
/* ARGSUSED */
static void CompileString(
   Widget widget)
{
	XvwStringGadget xobj = (XvwStringGadget) widget;

	int    i, size, len = 0, numlines = 0;
	char   temp[KLENGTH], *string, *tmp, **lines = NULL;

	string = xobj->string.string;
	do
	{
	    tmp = kstrpbrk(string, "\t\r\n");
	    if (!tmp)
	       size = kstrlen(string);
	    else
	       size = tmp-string;

	    kstring_ncopy(string, size, &temp[len]); len += size;
	    if (tmp && *tmp == '\t')
	    {
	       size = 8 - (len % 8);
	       for (i = 0; i < size; i++)
		   temp[len++] = ' ';
	       temp[len] = '\0'; tmp++;
	    }
	    else if (!tmp || *tmp == '\n' || *tmp == '\r')
	    {
	       len = 0;
	       lines = karray_add(lines, kstrdup(temp), numlines++);
	       if (tmp) tmp++;
	    }
	    string = tmp;
	} while (string != NULL);

	/*
	 * Save the text and number of lines...
	 */
	karray_free(xobj->string.lines, xobj->string.numlines, NULL);
	xobj->string.lines    = lines;
	xobj->string.numlines = numlines;
}

/************************************************************
*
*  Routine Name: xvw_create_string - create a string annotation
*
*       Purpose: A string visual object supports the display of a string 
*                annotation.  The (x, y) placement of the string is
*                specified in world coordinates.  The world
*                coordinates are specified by the parent.  By default, these
*                world coordinates are from 0 to 1 unless otherwise specified.
*                So, for example, if the string is created as the child of
*                a manager object, its world coordinates are from 0 to 1.
*                In contrast, if the string is created as the child of an image,
*                the world coordinates will be dictated by the size of the
*                image; if it created as the child of a plot object, the world
*                coordinates will be dictated by the plot.
*
*                Note that the string object is for display of
*                \fInon-editable\fP strings; if the user is to be
*                allowed to edit the text, a textstring object should
*                be used.
*
*         Input: parent - the parent object; NULL will cause a
*                         default toplevel to be created automatically
*                name   - the name with which to reference the object 
*        Output:
*	Returns: The string object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young
*  	   Date: Apr 10, 1994
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

xvobject xvw_create_string(
   xvobject parent,
   char     *name)
{
	xvobject  object;


	/*
	 *  Call the xvw_create() routine to do the actual creation.
	 */
	object = xvw_create(parent, FALSE, TRUE, name, StringGadgetClass);
	if (object != NULL)
	{
	   xvw_set_attributes(object,
		XVW_MENUABLE,     TRUE,     /* menuable       */
		XVW_RESIZABLE,    FALSE,    /* resizable      */
		XVW_SELECTABLE,   TRUE,     /* selectable     */
		NULL);
	}
	return(object);
}
