 /*
  * Khoros: $Id$
  */
#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>               Indicator Gadget Routines
   >>>>
   >>>>	Private:
   >>>>  Static:
   >>>>			ClassInitialize()
   >>>>			Initialize()
   >>>>			InitializeHook()
   >>>>			SetValues()
   >>>>			SetValuesHook()
   >>>>			GetValuesHook()
   >>>>   Public:
   >>>>			xvw_create_indicator()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"
#include <xvisual/IndicatorP.h>
#include <xvisual/StringValueP.h>


static void ClassInitialize	PROTO((void));
static void InitializeHook      PROTO((Widget, ArgList, Cardinal *));
static Boolean SetValues	PROTO((Widget, Widget, Widget, ArgList,
				       Cardinal *));
static Boolean SetValuesHook    PROTO((Widget, ArgList, Cardinal *));
static void GetValuesHook       PROTO((Widget, ArgList, Cardinal *));


/*------------------------------------------------------- 
|
|   Full class attributes
|
--------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_INDICATOR_CONSTRAINT,     NULL,     XtRInt,     NULL},
{XVW_INDICATOR_XPOS,           NULL,     XtRObject,  NULL},
{XVW_INDICATOR_YPOS,           NULL,     XtRObject,  NULL},
{XVW_INDICATOR_XPOS_VALUE,     NULL,     XtRDouble,  NULL},
{XVW_INDICATOR_YPOS_VALUE,     NULL,     XtRDouble,  NULL},
{XVW_INDICATOR_LINE,           NULL,     XtRInt,     NULL},
{XVW_INDICATOR_SHOW_XPOS,      NULL,     XtRInt,     XtRBoolean},
{XVW_INDICATOR_SHOW_YPOS,      NULL,     XtRInt,     XtRBoolean},
};

/*------------------------------------------------------- 
|
|   Full class record constant
|
--------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwIndicatorGadgetRec, indicator.field)

static double value = 0.0;

static XtResource resources[] = { 
{XVW_INDICATOR_CONSTRAINT, NULL, XtRInt, sizeof(int),
     offset(constraint), XtRImmediate, (XtPointer) KINDICATOR_CONSTRAINT_NONE},
{XVW_INDICATOR_XPOS, NULL, XtRObject, sizeof(xvobject),
     offset(xpos), XtRImmediate, (XtPointer) NULL},
{XVW_INDICATOR_YPOS, NULL, XtRObject, sizeof(xvobject),
     offset(ypos), XtRImmediate, (XtPointer) NULL},
{XVW_INDICATOR_XPOS_VALUE, NULL, XtRDouble, sizeof(double),
     offset(xpos_value), XtRDouble, (XtPointer) &value},
{XVW_INDICATOR_YPOS_VALUE, NULL, XtRDouble, sizeof(double),
     offset(ypos_value), XtRDouble, (XtPointer) &value},
{XVW_INDICATOR_LINE, NULL, XtRInt, sizeof(int),
     offset(indicator_line), XtRImmediate, (XtPointer) KINDICATOR_LINE_NONE},
{XVW_INDICATOR_SHOW_XPOS, NULL, XtRBoolean, sizeof(Boolean),
     offset(show_xpos), XtRImmediate, (XtPointer)  TRUE},
{XVW_INDICATOR_SHOW_YPOS, NULL, XtRBoolean, sizeof(Boolean),
     offset(show_ypos), XtRImmediate, (XtPointer)  TRUE},
};
#undef offset


#define SUPERCLASS (&xvwMarkerGadgetClassRec)

XvwIndicatorGadgetClassRec xvwIndicatorGadgetClassRec =
{
  {
    (WidgetClass) SUPERCLASS,		/* superclass		  */	
    "Indicator",		        /* class_name		  */
    sizeof(XvwIndicatorGadgetRec),		/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    NULL,				/* initialize		  */
    InitializeHook,			/* initialize_hook	  */
    NULL,				/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    knumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    FALSE,				/* compress_motion	  */
    FALSE,				/* compress_exposure	  */
    FALSE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    XtInheritResize,			/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    SetValuesHook,			/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    GetValuesHook,			/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    NULL,				/* query_geometry	  */
    NULL,				/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* RectObjClass fields initialization */
  {
    XtInheritPicking,			/* pick object proc       */
    XtInheritEraseSel,			/* erase selected proc    */
    XtInheritRefreshSel,		/* refresh selection proc */
    XtInheritChangeGeometry,		/* change geometry proc   */
  },  /* XvwManagerGadgetClass fields initialization */
  {
    XtInheritRecomputePosition,		/* recompute position proc    */
  },  /* XvwGraphicsGadgetClass fields initialization */
  {
    NULL,				/* extension - not used   */
  },  /* XvwMarkerGadgetClass fields initialization */
  {
    NULL,				/* extension - not used   */
  },  /* XvwIndicatorGadgetClass fields initialization */
};
#undef SUPERCLASS

/*
 * xvwIndicatorGadgetClass for public consumption
 */
WidgetClass xvwIndicatorGadgetClass = (WidgetClass) &xvwIndicatorGadgetClassRec;


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an  
|                instance of indicator object class has been created.
|                It will initialize all the class attributes. 
|
|         Input: None 
|        Output: None
|    Written By: Mark Young, John M. Salas, Danielle Argiro
|          Date: Aug 15, 1992
| Modifications:
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
        xvw_init_attributes(xvwIndicatorGadgetClass, attributes,
		knumber(attributes), NULL, 0, 
		"$DESIGN/objects/library/xvisual/uis/Indicator.pane");
	xvw_load_resources("$DESIGN/objects/library/xvisual/app-defaults/Indicator");
}

/*-----------------------------------------------------------
|
|  Routine Name: InitializeHook
|
|       Purpose: This method will initialize the subparts of
|                the indicator object.
|
|         Input: new      - the indicator object being created
|                args     - some initial settings for the subparts
|                num_args - the number of initial settings
|
|        Output: None
|    Written By: Mark Young, John M. Salas, Danielle Argiro
|          Date: Mar 12, 1993 17:50
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void InitializeHook(
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwIndicatorGadget xobj = (XvwIndicatorGadget) new;
	xvobject	xpos, ypos, xline, yline;

	xpos = xvw_create_stringvalue(xvw_object(XtParent(new)), "xpos");
	ypos = xvw_create_stringvalue(xvw_object(XtParent(new)), "ypos");

	xline = xvw_create_line(xvw_object(XtParent(new)), "xline");
	xvw_set_attributes(xline,
			XVW_MAPPED,      FALSE,
			XVW_ABOVE,       new,
			XVW_BELOW,       new,
			XVW_TACK_EDGE,   KMANAGER_TACK_HORIZ,
                        XVW_LINE_XBEGIN, xobj->graphics.wcmin.x,
                        XVW_LINE_XEND,   xobj->graphics.wcmax.x,
                        XVW_LINE_YBEGIN, xobj->indicator.ypos_value,
                        XVW_LINE_YEND,   xobj->indicator.ypos_value,
			NULL);

	yline = xvw_create_line(xvw_object(XtParent(new)), "yline");
	xvw_set_attributes(yline,
			XVW_MAPPED,      FALSE,
                        XVW_LEFT_OF,     new,
                        XVW_RIGHT_OF,    new,
                        XVW_TACK_EDGE,   KMANAGER_TACK_VERT,
                        XVW_LINE_XBEGIN, xobj->indicator.xpos_value,
                        XVW_LINE_XEND,   xobj->indicator.xpos_value,
                        XVW_LINE_YBEGIN, xobj->graphics.wcmin.y,
                        XVW_LINE_YEND,   xobj->graphics.wcmax.y,
			NULL);

	xvw_set_attributes(xpos,
			XVW_ABOVE,         new,
			XVW_LEFT_OF,       new,
			XVW_RIGHT_OF,      new,
			XVW_STRING_FORMAT, "%0.2f",
			XVW_SELECTABLE,    FALSE,
			NULL);

	xvw_set_attributes(ypos,
			XVW_RIGHT_OF,      new,
			XVW_ABOVE,         new,
			XVW_BELOW,         new,
			XVW_STRING_FORMAT, "%0.2f",
			XVW_SELECTABLE,    FALSE,
			NULL);

	if (!(xobj->indicator.constraint & KINDICATOR_CONSTRAINT_X))
	   xvw_set_attribute(xpos, XVW_MAPPED, TRUE);
	else
	   xvw_set_attribute(xpos, XVW_MAPPED, FALSE);

	if (!(xobj->indicator.constraint & KINDICATOR_CONSTRAINT_Y))
	   xvw_set_attribute(ypos, XVW_MAPPED, TRUE);
	else
	   xvw_set_attribute(ypos, XVW_MAPPED, FALSE);

	xobj->indicator.xpos  = xpos;
	xobj->indicator.ypos  = ypos;
	xobj->indicator.xline = xline;
	xobj->indicator.yline = yline;
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: Update if the the postion of the indicator or if the
|		 indicator type has changed, 
|
|         Input: current - the object containing current settings 
|                request - the object containing requested settings
|                new     - the object processed through all set values methods 
|
|        Output: None directly 
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young, John M. Salas, Danielle Argiro
|          Date: March 10, 1995
| Modifications: 
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	Boolean redisplay = FALSE, recompute = FALSE;
	XvwGraphicsGadgetClass gclass = (XvwGraphicsGadgetClass)
                                                new->core.widget_class;


	XvwIndicatorGadget cobj = (XvwIndicatorGadget) current;
	XvwIndicatorGadget nobj = (XvwIndicatorGadget) new;


	if (cobj->indicator.constraint != nobj->indicator.constraint)
	{
	   if (!(nobj->indicator.constraint & KINDICATOR_CONSTRAINT_X))
              xvw_set_attribute(nobj->indicator.xpos, XVW_MAPPED, TRUE);
           else
              xvw_set_attribute(nobj->indicator.xpos, XVW_MAPPED, FALSE);

           if (!(nobj->indicator.constraint & KINDICATOR_CONSTRAINT_Y))
              xvw_set_attribute(nobj->indicator.ypos, XVW_MAPPED, TRUE);
           else
              xvw_set_attribute(nobj->indicator.ypos, XVW_MAPPED, FALSE);
	}

	if (cobj->indicator.show_xpos != nobj->indicator.show_xpos)
	{
	   xvw_set_attribute(nobj->indicator.xpos, XVW_MAPPED,
			nobj->indicator.show_xpos);
	}

	if (cobj->indicator.show_ypos != nobj->indicator.show_ypos)
	{
	   xvw_set_attribute(nobj->indicator.ypos, XVW_MAPPED,
			nobj->indicator.show_ypos);
	}

	if (cobj->rectobj.x != nobj->rectobj.x)
	{
	   xvw_set_attribute(nobj->indicator.xpos, XVW_STRING_VALUE,
			nobj->marker.placement.x);
	   recompute = TRUE;
	}

	if (cobj->rectobj.y != nobj->rectobj.y)
	{
	   xvw_set_attribute(nobj->indicator.ypos, XVW_STRING_VALUE,
			nobj->marker.placement.y);
	   recompute = TRUE;
	}

	if (cobj->marker.placement.x != nobj->marker.placement.x)
	{
	    nobj->indicator.xpos_value = nobj->marker.placement.x;
	}
	if (cobj->marker.placement.y != nobj->marker.placement.y)
	{
	    nobj->indicator.ypos_value = nobj->marker.placement.y;
	}

	if (cobj->indicator.xpos_value != nobj->indicator.xpos_value)
	{
	   xvw_set_attribute(xvw_object(new),
			XVW_MARKER_XPLACEMENT, nobj->indicator.xpos_value);
	   xvw_set_attribute(nobj->indicator.xpos,
			XVW_STRING_VALUE, nobj->indicator.xpos_value);
	}

	if (cobj->indicator.ypos_value != nobj->indicator.ypos_value)
	{
	   xvw_set_attribute(xvw_object(new),
			XVW_MARKER_YPLACEMENT, nobj->indicator.ypos_value);
	   xvw_set_attribute(nobj->indicator.ypos,
			XVW_STRING_VALUE, nobj->indicator.ypos_value);
	}

	if (cobj->indicator.indicator_line != nobj->indicator.indicator_line)
	{
            if (nobj->indicator.indicator_line == KINDICATOR_LINE_NONE)
            {
                xvw_set_attribute(nobj->indicator.xline, XVW_MAPPED, FALSE );
                xvw_set_attribute(nobj->indicator.yline, XVW_MAPPED, FALSE );
            }

            else if (nobj->indicator.indicator_line==KINDICATOR_LINE_HORIZONTAL)
	    {
                xvw_set_attribute(nobj->indicator.xline, XVW_MAPPED, TRUE);
                xvw_set_attribute(nobj->indicator.yline, XVW_MAPPED, FALSE);
 	    }

            else if (nobj->indicator.indicator_line==KINDICATOR_LINE_VERTICAL) 
            {
                xvw_set_attribute(nobj->indicator.xline, XVW_MAPPED, FALSE);
                xvw_set_attribute(nobj->indicator.yline, XVW_MAPPED, TRUE);
            }
            else if (nobj->indicator.indicator_line == KINDICATOR_LINE_BOTH)
	    {
		xvw_set_attribute(nobj->indicator.xline, XVW_MAPPED, TRUE);
		xvw_set_attribute(nobj->indicator.yline, XVW_MAPPED, TRUE);
	    }
	}

	/*
         *  Recompute the widget's position from it currently set coordinates
         */
        if (recompute && gclass->graphics_class.recompute_position != NULL)
           gclass->graphics_class.recompute_position(new);

	return(redisplay);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValuesHook
|
|       Purpose: This method is called to set the public values
|                of the subparts of the indicator. 
|
|         Input: widget   - the object containing the subpart
|                           to set the values on
|                args     - the list of args to set
|                num_args - the number of args being set
|
|        Output: None
|
|    Written By: Mark Young, John M. Salas, Danielle Argiro
|          Date: Mar 10, 1995
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValuesHook(
   Widget   widget,
   ArgList  args,
   Cardinal *num_args)
{
        XvwIndicatorGadget xobj = (XvwIndicatorGadget) widget;

        XtSetValues((Widget) xvw_widget(xobj->indicator.xpos), args, *num_args);
        XtSetValues((Widget) xvw_widget(xobj->indicator.ypos), args, *num_args);
        XtSetValues((Widget) xvw_widget(xobj->indicator.xline),args, *num_args);
        XtSetValues((Widget) xvw_widget(xobj->indicator.yline),args, *num_args);

        return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: GetValuesHook
|
|       Purpose: This method is called to get the public values
|                of the subparts of the indicator. 
|
|         Input: widget - the object with the subparts that we
|                         are getting from
|
|        Output: args   - the arguments we are getting
|                num_args - the number of arguments successfully gotten
|
|    Written By: Mark Young, John M. Salas, Danielle Argiro
|          Date: Mar 10, 1995
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void GetValuesHook(
   Widget   widget,
   ArgList  args,
   Cardinal *num_args)
{
        XvwIndicatorGadget xobj = (XvwIndicatorGadget) widget;

        XtGetValues(xvw_widget(xobj->indicator.xpos), args, *num_args);
        XtGetValues(xvw_widget(xobj->indicator.ypos), args, *num_args);
        XtGetValues(xvw_widget(xobj->indicator.xline), args, *num_args);
        XtGetValues(xvw_widget(xobj->indicator.yline), args, *num_args);
}

/************************************************************
*
*  Routine Name: xvw_create_indicator - creates an indicator object
*
*       Purpose: An indicator is a marker with the additional capability of 
*                displaying the X and/or Y world coordinates of the location 
*                at which the marker is placed.  If desired, the indicator 
*                may also include a vertical line (most often used with 
*                displaying X values) and/or a horizontal line (most often 
*                used with displaying Y values).
*                An indicator object is often used in conjunction with a 2D or
*                3D axis object to highlight a specific data point.
*
*         Input: parent - the parent object; NULL will cause a
*                         default toplevel to be created automatically
*                name   - the name with which to reference the object 
*
*        Output: None 
*
*	Returns: The indicator object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Feb 17, 1993 15:48
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

xvobject xvw_create_indicator(
   xvobject parent,
   char     *name)
{
	xvobject  object;


	/*
	 *  Create the indicator object
	 */
	object = xvw_create(parent, FALSE, TRUE, name, IndicatorGadgetClass);
	if (object != NULL)
	{
	   xvw_set_attributes(object,
                XVW_MENUABLE,     TRUE,     /* menuable       */
                XVW_RESIZABLE,    FALSE,    /* resizable      */
                XVW_SELECTABLE,   TRUE,     /* selectable     */
		NULL);
	}
	return(object);
}
