 /* 
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */



/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>               Animate Widget Routines
   >>>>
   >>>>	 Private:
   >>>>   Static:
   >>>>			ClassInitialize()
   >>>>			Initialize()
   >>>>			SetValues()
   >>>>			Destroy()
   >>>>			AdvanceFrame()
   >>>>			ReverseFrame()
   >>>>			UpdateAnimate()
   >>>>			SetAnimate()
   >>>>			GetAnimate()
   >>>>   Public:
   >>>>			xvw_create_animate()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"
#include <xvisual/AnimateP.h>

static void ClassInitialize	PROTO((void));
static void Initialize		PROTO((Widget, Widget, ArgList, Cardinal *));
static Boolean SetValues	PROTO((Widget, Widget, Widget, ArgList,
				       Cardinal *));
static void Destroy		PROTO((Widget));
static void AdvanceFrame	PROTO((XvwAnimateWidget));
static void ReverseFrame	PROTO((XvwAnimateWidget));
static void UpdateAnimate 	PROTO((XtPointer, XtIntervalId *));
static int GetAnimate		PROTO((xvobject, String, kaddr));
static int SetAnimate		PROTO((xvobject, String, kaddr));

#define STOP	0
#define REVERSE 1
#define FORWARD 2

/*--------------------------------------------------------
|
|   Full class attributes
|
--------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_ANIMATE_UPDATETIME,	NULL,	 XtRDouble,   NULL},
{XVW_ANIMATE_CONTROL,		NULL,	 XtRInt,      NULL},
{XVW_ANIMATE_CALLBACK,		NULL,	 XtRCallback, NULL},
};

/*--------------------------------------------------------
|
|   Full class record constant 
|
--------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwAnimateWidgetRec, animate.field)

static XtResource resources[] = { 
{XVW_ANIMATE_UPDATETIME, NULL, XtRDouble, sizeof(double),
      offset(update_time), XtRString, (XtPointer) "1.0"},
{XVW_ANIMATE_CONTROL, NULL, XtRInt, sizeof(int),
      offset(control), XtRImmediate, (XtPointer) KANIMATE_CONTROL_LOOP},
{XVW_ANIMATE_CALLBACK, NULL, XtRCallback, sizeof(XtPointer),
      offset(update_callback), XtRCallback, (XtPointer) NULL},

{XVW_IMAGE_BACKING, NULL, XtRBoolean, sizeof(Boolean),
        XtOffsetOf(XvwImageWidgetRec, image.backing),
        XtRImmediate, (XtPointer) FALSE},
};
#undef offset

#define SUPERCLASS (&xvwImageWidgetClassRec)

XvwAnimateWidgetClassRec xvwAnimateWidgetClassRec =
{
  {
    (WidgetClass) SUPERCLASS,		/* superclass		  */	
    "Animate",			        /* class_name		  */
    sizeof(XvwAnimateWidgetRec),	/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    knumber(resources),			/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    Destroy,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    XtInheritTranslations,		/* tm_table		  */
    NULL,				/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,	            		/* subresources       */
    0,					/* subresources_count */
    sizeof(XvwManagerWidgetConstraintsRec),/* constraint_size    */
    NULL,				/* initialize         */
    NULL,                               /* destroy            */
    NULL,				/* set_values         */
    NULL,                               /* extension          */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,			/* child layout routine  */
    XtInheritChangeSel,		        /* change selected proc   */
    XtInheritEraseSel,			/* erase selected proc    */
    XtInheritRefreshSel,		/* refresh selection proc */
    XtInheritResize,			/* resize		  */
    XtInheritGeometryManager,  		/* geometry_manager	  */
  }, /* XvwManagerWidgetClass fields initialization */
  {
    NULL,                                     /* field not used    */
  },  /* XvwGraphicsWidgetClass fields initialization */
  {
    XtInheritColorReload,		/* reload color proc             */
  },  /* XvwColorWidgetClass fields initialization */
  {
    NULL,                                     /* field not used    */
  },  /* XvwImageWidgetClass fields initialization */
  {
    NULL,                                     /* field not used    */
  },  /* XvwAnimateWidgetClass fields initialization */
};
#undef SUPERCLASS

/*
 * xvwAnimateWidgetClass for public consumption
 */
WidgetClass xvwAnimateWidgetClass = (WidgetClass) &xvwAnimateWidgetClassRec;


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an 
|                instance of animate widget class has been created. 
|                This is where class attributes are initialized. 
|
|         Input: None
|
|        Output: None
|
|    Written By: Mark Young 
|          Date: Oct 22, 1992 12:20
| Modifications:
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
	xvw_init_attributes(xvwAnimateWidgetClass, attributes,
		knumber(attributes), NULL, 0, 
		"$DESIGN/objects/library/xvisual/uis/Animate.pane");
	xvw_load_resources("$DESIGN/objects/library/xvisual/app-defaults/Animate");

	xvw_define_attribute(xvwAnimateWidgetClass,
		XVW_ANIMATE_DIRECTION, XtRInt, SetAnimate, GetAnimate);
}

/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|       Purpose: This method will set up the initial values 
|                for all the fields for a animate widget instance.
|		 I DON'T REALLY KNOW WHAT ITS DOING BEYOND THAT -SK
|
|         Input: request - widget instance with requested public settings
|                new     - widget instance after initialization, with
|                          private settings initialized and public 
|                          settings verified 
|
|        Output: none
|
|    Written By: Mark Young 
|          Date: Oct 22, 1992 12:21
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwAnimateWidget xwid = (XvwAnimateWidget) new;

	/*
	 *  Call UpdateAnimate() to start the timer and initially
	 *  set the image being displayed.
	 */
	xwid->animate.time_id = 0;
	xwid->animate.continous = FALSE;
	xwid->animate.direction = FORWARD;
	UpdateAnimate((XvwAnimateWidget) new, NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: This method is used to set the public values
|                of a animate widget instance.  
|		 This routine doesn't actually do anything right now...  -SK
|                 
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|
|        Output: none 
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Oct 26, 1992 22:09
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num)
{
	XvwAnimateWidget cxwid = (XvwAnimateWidget) current;
	XvwAnimateWidget nxwid = (XvwAnimateWidget) new;

	if (cxwid->animate.update_time != nxwid->animate.update_time ||
	    cxwid->animate.control     != nxwid->animate.control)
	{
           if (nxwid->animate.time_id != 0)
	      XtRemoveTimeOut(nxwid->animate.time_id);

	   UpdateAnimate(nxwid, NULL);
	}
	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: Destroy
|
|       Purpose: This method will remove the animation timeout
|                from the animate widget before it is destroyed. 
|
|         Input: widget - the widget being destroyed
|
|        Output: none
|
|    Written By: Mark Young
|          Date: Oct 22, 1992 12:24
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Destroy(
   Widget widget)
{
	XvwAnimateWidget xwid = (XvwAnimateWidget) widget;

	if (xwid->animate.time_id != 0)
	   XtRemoveTimeOut(xwid->animate.time_id);
}

/*-----------------------------------------------------------
|
|  Routine Name: AdvanceFrame
|
|       Purpose: This routine will advance the animation widget by
|		 a single frame. 
|
|         Input: xwid - the animate widget whose frame is being advanced
|
|        Output: None
|
|    Written By: Mark Young
|          Date: Oct 22, 1992 12:26
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void AdvanceFrame(
   XvwAnimateWidget xwid)
{
	int band = xwid->image.band_number;


	if (band >= xwid->image.band_maxnum)
	{
	   if (xwid->animate.control == KANIMATE_CONTROL_AUTOREVERSE)
	   {
	      xwid->animate.direction = REVERSE;
	      if (band > 0) band--;
	   }
	   else
	   {
	      if (xwid->animate.control == KANIMATE_CONTROL_SINGLE)
		 xwid->animate.continous = FALSE;
	      else band = 0;
	   }
	}
	else band++;

	if (xwid->image.band_number != band)
	   xvw_set_attribute(xvw_object((Widget)xwid), XVW_IMAGE_BANDNUM, band);
}

/*-----------------------------------------------------------
|
|  Routine Name: ReverseFrame
|
|       Purpose: This routine will reverse the animation widget by 
|                a single frame.
|
|         Input: xwid - the animate widget whose frame is being reversed
|
|        Output: None
|
|    Written By: Mark Young
|          Date: Oct 22, 1992 12:26
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ReverseFrame(
   XvwAnimateWidget xwid)
{
	int band = xwid->image.band_number;


        if (band <= 0)
        {
           if (xwid->animate.control == KANIMATE_CONTROL_AUTOREVERSE)
           {
              xwid->animate.direction = FORWARD;
              if (band < xwid->image.band_maxnum)
                 band++;
           }
           else
           {
              if (xwid->animate.control == KANIMATE_CONTROL_SINGLE)
                 xwid->animate.continous = FALSE;
              else band = xwid->image.band_maxnum;
           }
        }
	else band--;

	if (xwid->image.band_number != band)
	   xvw_set_attribute(xvw_object((Widget)xwid), XVW_IMAGE_BANDNUM, band);
}

/*-----------------------------------------------------------
|
|  Routine Name: UpdateAnimate
|
|       Purpose: This routine will, depending on the direction
|		 of the animation, either advance or reverse by
|		 a single frame, and will then update the animation
|		 screen.  This routine is then reinstalled as a
|		 timeout, so the frame will be updated again after
|		 an appropriate amount of time. 
|
|         Input: xwid - the animate widget whose frame is being updated
|		 id   - the id of the timeout interval 
|
|        Output: None
|
|    Written By: Mark Young
|          Date: Oct 22, 1992 12:26
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void UpdateAnimate(
   XtPointer	 calldata,
   XtIntervalId  *id)
{
	XvwAnimateWidget xwid = (XvwAnimateWidget) calldata;
	unsigned long speed;
	XtAppContext app_context;


	/*
	 *  Band Advancement according to the current direction
	 */
	if (xwid->animate.direction == FORWARD)
	   AdvanceFrame(xwid);
	else if (xwid->animate.direction == REVERSE)
	   ReverseFrame(xwid);

	/*
	 *  Compute the position of the object in device coordinates
	 */
	if (xwid->animate.continous == TRUE)
	{
	   speed = xwid->animate.update_time * 1000;
	   app_context = XtWidgetToApplicationContext((Widget) xwid);

           xwid->animate.time_id = XtAppAddTimeOut(app_context, speed,
			UpdateAnimate, (XtPointer) xwid);
	}
	else xwid->animate.time_id = 0;

	/*
	 *  Call the animation update callback if the list is not NULL
	 */
	if (xwid->animate.update_callback != NULL)
	{
	   XtCallCallbacks((Widget) xwid, XVW_ANIMATE_CALLBACK,
			&xwid->image.band_number);
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: GetAnimate - gets the direction of the animation
|
|       Purpose: This routine will get the direction of the animation.
|
|         Input: widget - the widget in which we will be getting the
|			  direction
|                attribute - the attribute to be set
|                calldata  - the calldata to be used with the attribute
|
|        Output: None
|
|    Written By: Mark Young
|          Date: Oct 22, 1992 12:26
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static int GetAnimate(
   xvobject object,
   String   attribute,
   kaddr    calldata)
{
	XvwAnimateWidget xwid = (XvwAnimateWidget) xvw_widget(object);
	int *direction = (int *) calldata;


	if (xwid->animate.continous == FALSE)
	   *direction = KANIMATE_DIRECTION_STOP;
	else if (xwid->animate.direction == FORWARD)
	{
	   if (xwid->animate.continous == TRUE)
	      *direction = KANIMATE_DIRECTION_FORWARD;
	   else
	      *direction = KANIMATE_DIRECTION_NEXT;
	}
	else if (xwid->animate.direction == REVERSE)
	{
	   if (xwid->animate.continous == TRUE)
	      *direction = KANIMATE_DIRECTION_REVERSE;
	   else
	      *direction = KANIMATE_DIRECTION_PREVIOUS;
	}
	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetAnimate - sets the direction of the animation 
|
|       Purpose: This routine will set the direction of the animation.
|
|         Input: widget - the widget in which we will be setting the
|			  direction
|		 attribute - the attribute to be set
|		 calldata  - the calldata to be used with the attribute
|
|        Output: None
|
|    Written By: Mark Young
|          Date: Dec 14, 1992 17:34
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static int SetAnimate(
   xvobject object,
   String   attribute,
   kaddr    calldata)
{
	XvwAnimateWidget xwid = (XvwAnimateWidget) xvw_widget(object);
	int *direction = (int *) calldata;

	if (*direction == KANIMATE_DIRECTION_STOP)
	{
	   xwid->animate.direction = STOP;
	   xwid->animate.continous = FALSE;
	}
	else if (*direction == KANIMATE_DIRECTION_FORWARD)
	{
	   xwid->animate.direction = FORWARD;
	   xwid->animate.continous = TRUE;
	}
	else if (*direction == KANIMATE_DIRECTION_REVERSE)
	{
	   xwid->animate.direction = REVERSE;
	   xwid->animate.continous = TRUE;
	}
	else if (*direction == KANIMATE_DIRECTION_PREVIOUS)
	{
	   xwid->animate.direction = REVERSE;
	   xwid->animate.continous = FALSE;
	}
	else if (*direction == KANIMATE_DIRECTION_NEXT)
	{
	   xwid->animate.direction = FORWARD;
	   xwid->animate.continous = FALSE;
	}

        if (xwid->animate.time_id != 0)
           XtRemoveTimeOut(xwid->animate.time_id);

        UpdateAnimate(xwid, NULL);
	return(TRUE);
}


/************************************************************
*
*  Routine Name: xvw_create_animate - create a slide animation visual object
*
*       Purpose: An animation visual object provides a mechanism with which 
*                a sequence of images may be animated.  When stored in a K2 
*                VIFF file, image frames may be organized down depth, time, 
*                or elements.  Attributes offer control over the speed with
*                which the image frames are changed, and the direction of the 
*                animation.  Animations may run in a single loop (one pass 
*                through the frames), a continuous loop (continual forward 
*                passes through the frames), or an autoreverse loop (continual 
*                passes forward through the frames, first forwards, then 
*                backwards).
*
*         Input: parent - the parent object; NULL will cause a
*                         default toplevel to be created automatically
*                name   - the name with which to reference the object 
*
*        Output: None
*
*	Returns: The animate object on success, NULL on failure
*
*  Restrictions: 
*    Written By: Mark Young
*          Date: Oct 22, 1992 12:33
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

xvobject xvw_create_animate(
   xvobject parent,
   char     *name)
{
	xvobject object;

	/*
	 *  Call the xvw_create() routine to do the actual creation.
	 */
	object = xvw_create(parent, FALSE, TRUE, name, AnimateWidgetClass);
	return(object);
}
