/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>   		2D conversion routines           
   >>>>
   >>>>  Private:
   >>>>                  
   >>>>			_X2D_convert_wc_to_dc()	      	
   >>>>			_X2D_convert_wc_to_dc_seg()   	 
   >>>>			_X2D_convert_wc_coord_to_dc_seg() 
   >>>>			X2D_convert_point_wc_to_dc() 
   >>>>			X2D_convert_point_dc_to_wc() 
   >>>>   Static:
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "graphics.h"


/*-----------------------------------------------------------
|
|  Routine Name: _X2D_convert_wc_to_dc
|
|       Purpose: Converts a array of 2D world coordinate points
|		 to device coordinates and stores them as XPoints
|		 for later calls to X11 routines
|
|         Input: graphics - the graphics structure
|                coords   - array of world coordinates input
|                size     - number of points to convert
|
|        Output: points   - XPoint array of device coordinates
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: 
| Modifications:
|
------------------------------------------------------------*/

int _X2D_convert_wc_to_dc (
   X3DGraphics *graphics,
   Coord       *coords,
   XPoint      *points,
   int         size)
{
	int	i;
	Real	x, y, w;
	Coord	*scale;

	if((_X2D_scale_wc_coords(graphics->scale, coords,&scale,size)) == FALSE)
	   return(FALSE);

	for (i = 0; i < size; i++)
	{
	    _X2D_vector_mult(scale[i], graphics->matrix2D, x, y, w);
	    points[i].x = (short) x;
	    points[i].y = (short) y;
	}

	if (coords != scale)
	   kfree(scale);

	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: _X2D_convert_wc_to_dc_seg
|
|       Purpose: Converts a array of 2D world coordinate segments
|		 to device coordinates and stores them as XSegments
|		 for later calls to X11 routines
|
|         Input: graphics - the graphics structure
|		 coords   - array of world coordinates input
|		 size     - number of points to convert
|
|        Output: segments - XSegment array of device coordinates
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: 
| Modifications:
|
------------------------------------------------------------*/

int _X2D_convert_wc_to_dc_seg (
   X3DGraphics *graphics,
   Coord       *coords,
   XSegment    *segments,
   int         size)
{
	int	i, j;
	Real	x, y, w;
	Coord	*scale;

	if(!(_X2D_scale_wc_coords(graphics->scale, coords, &scale, size)))
	   return(FALSE);

	j = 0;
	for (i = 0; i < size; i += 2)
	{
	    _X2D_vector_mult(scale[i], graphics->matrix2D, x, y, w);
	    segments[j].x1 = (short) x;
	    segments[j].y1 = (short) y;

	    _X2D_vector_mult(scale[i +1], graphics->matrix2D, x, y, w);
	    segments[j].x2 = (short) x;
	    segments[j].y2 = (short) y;

	    j++;
	}

	if (coords != scale)
	   kfree(scale);

	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: _X2D_convert_wc_coord_to_dc_seg
|
|       Purpose: Converts a array of 2D world coordinate polylines 
|		 to device coordinates and stores them as XSegments 
|		 for later calls to X11 routines.
|
|         Input: graphics - the graphics structure
|		 coords   - array of world coordinates input
|		 size     - number of points to convert
|
|        Output: segments - XSegment array of device coordinates
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: 
| Modifications:
|
------------------------------------------------------------*/

int _X2D_convert_wc_coord_to_dc_seg (
   X3DGraphics *graphics,
   Coord       *coords,
   XSegment    *segments,
   int         size)
{
	int	i, j;
	Real	x, y, w;
	Coord	*scale;

	if(!(_X2D_scale_wc_coords(graphics->scale, coords, &scale, size)))
	   return(FALSE);

	j = 0;
	for (i = 0; i < (size-1); i ++)
	{
	    _X2D_vector_mult(scale[i], graphics->matrix2D, x, y, w);
	    segments[j].x1 = (short) x;
	    segments[j].y1 = (short) y;

	    _X2D_vector_mult(scale[i +1], graphics->matrix2D, x, y, w);
	    segments[j].x2 = (short) x;
	    segments[j].y2 = (short) y;

	    j++;
	}

	if (coords != scale)
	   kfree(scale);

	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: X2D_convert_point_wc_to_dc
|
|       Purpose: Converts a 2D world coordinate point
|		 to device coordinates and stores it the
|		 X and Y variables.
|
|         Input: id      - the graphics structure
|		 coord   - array of world coordinates input
|
|        Output: x_out - array of x corresponding dc values of the
|			 world coordinate points
|		 y_out - array of y corresponding dc values of the
|			 world coordinate point
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: 
| Modifications:
|
------------------------------------------------------------*/

int X2D_convert_point_wc_to_dc (
   int   id,
   Coord coord,
   Real  *x_out,
   Real  *y_out)
{
	Real	    w;
	Coord	    scale;
	X3DGraphics *graphics;

        if ((graphics = _X3D_get_graphics(id)) == NULL)
        {
           (void) kfprintf (kstderr,"X2D_convert_point_wc_to_dc:");
           (void) kfprintf (kstderr,"\t unknown graphics id %d\n",id);
           return(FALSE);
        }

	if(!(_X2D_scale_wc_coord(graphics->scale, coord, &scale)))
	   return(FALSE);

        _X2D_vector_mult(scale, graphics->matrix2D, *x_out, *y_out, w);
	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: X2D_convert_point_dc_to_wc
|
|       Purpose: Converts a device coordinates point to a 2D
|		 world coordinate point and stores it in the
|		 supplied coordinate array.
|
|         Input: id    - the X2D graphics structure
|		 x     - x array of dc values 
|		 y     - y array of dc values.
|
|        Output: coord - array of world coordinates
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: 
| Modifications:
|
------------------------------------------------------------*/

int X2D_convert_point_dc_to_wc (
   int   id,
   Real  x,
   Real  y,
   Coord *coord)
{
	X3DGraphics *graphics;

	Real	    w;
	Coord	    temp;
	Matrix_2D   imatrix;


        if ((graphics = _X3D_get_graphics(id)) == NULL)
        {
           (void) kfprintf (kstderr,"X2D_convert_point_dc_to_wc:");
           (void) kfprintf (kstderr,"\t unknown graphics id %d\n",id);
           return(FALSE);
        }

	temp.x = x; temp.y = y;
	if (X2D_matrix_set_inverse(graphics->matrix2D, imatrix) == FALSE)
	   return(FALSE);
        else
	   _X2D_vector_mult(temp, imatrix, coord->x, coord->y, w);

	return(TRUE);
}
