 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

 

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private include file for xvforms library
   >>>>
   >>>>    Written By: Danielle Argiro
   >>>>
   >>>>          Date: Jul 16, 1992
   >>>>
   >>>> Modifications: Updated to Khoros 2.0 (DA)
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _xvforms_internals_h_
#define _xvforms_internals_h_

        /*-------------------------------------*
        |       #include
        ---------------------------------------*/

#include <design.h>
#include <xvinclude.h>

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/

/*
 *  specifies whether or not GUI is editable
 */
#define KUIS_GUI_STATIC   1
#define KUIS_GUI_DYNAMIC  2


        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

extern int  xvf_expr;
extern int  xvf_desensitize_optionals;  

extern kform      *xvf_current_form;
extern ksubform   *xvf_current_subform;

extern kform_struct *kformstruct_hdr;    /* also defined in the kforms lib */
extern kform_struct *kformstruct_tail;   /* also defined in the kforms lib */

        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Inform callback for when geometry changes
 */
void xvf_inform_geometry PROTO((xvobject, char *, kaddr));

/*
 *   Action Handlers for "live" selections (actions.c)
 */
void xvf_update_int_scroll     PROTO((xvobject, kaddr));
void xvf_update_float_scroll   PROTO((xvobject, kaddr));
void xvf_update_double_scroll  PROTO((xvobject, kaddr));
void xvf_return_live_selection PROTO((xvobject, kaddr, XEvent *));
void xvf_mark_modified         PROTO((xvobject, kaddr, XEvent *));

/*
 *   Routines to handle GUI answer files (answer.c)
 */
void xvf_update_forms_from_answerfile PROTO((xvobject, kaddr));
void xvf_update_answerfile_from_forms PROTO((xvobject, kaddr));

int xvf_read_answerfile  PROTO((kselection *, int, char *));
int xvf_write_answerfile PROTO((kselection *, int, char *));

/*
 *   Callbacks (callbacks.c)
 */
void xvf_gen_opt_cb           PROTO((xvobject, kaddr, kaddr));
void xvf_quit_master_cb       PROTO((xvobject, kaddr, kaddr));
void xvf_quit_subform_cb      PROTO((xvobject, kaddr, kaddr));
void xvf_quit_pane_cb         PROTO((xvobject, kaddr, kaddr));
void xvf_guide_cb             PROTO((xvobject, kaddr, kaddr));
void xvf_subform_cb           PROTO((xvobject, kaddr, kaddr));
void xvf_logic_val_cb         PROTO((xvobject, kaddr, kaddr));
void xvf_cycle_val_cb         PROTO((xvobject, kaddr, kaddr));
void xvf_list_val_cb          PROTO((xvobject, kaddr, kaddr));
void xvf_stringlist_val_cb    PROTO((xvobject, kaddr, kaddr));
void xvf_original_list_val_cb PROTO((xvobject, kaddr, kaddr));
void xvf_int_scroll_cb        PROTO((xvobject, kaddr, kaddr));
void xvf_float_scroll_cb      PROTO((xvobject, kaddr, kaddr));
void xvf_double_scroll_cb     PROTO((xvobject, kaddr, kaddr));
void xvf_pseudo_label_cb      PROTO((xvobject, kaddr, kaddr));
void xvf_action_cb            PROTO((xvobject, kaddr, kaddr));
void xvf_help_button_cb       PROTO((xvobject, kaddr, kaddr));
void xvf_routine_cb           PROTO((xvobject, kaddr, kaddr));
void xvf_displaylist_val_doubleclick_cb PROTO((xvobject, kaddr, kaddr));

int  xvf_do_group             PROTO((kselection *, kselection *, int, int));



/*
 *   Utilities for changing the GUI (change_util.c)
 */
void  xvf_add_opt_button        PROTO((kform_struct *));
void  xvf_delete_opt_button     PROTO((kform_struct *));
void  xvf_delete_scrollbar      PROTO((kselection *));
char *xvf_get_line              PROTO((kform_struct *));
int   xvf_change_intbounds      PROTO((kform_struct *, char *));
int   xvf_change_floatbounds    PROTO((kform_struct *, char *));
int   xvf_change_doublebounds   PROTO((kform_struct *, char *));

/*
 *   Value Collection Routines (collect.c)
 */
void xvf_update_form_tree   PROTO((kselection *));
int  xvf_collect_value      PROTO((kselection *));
int  xvf_collect_check_sel  PROTO((kselection *));

/*
 *  Utilities to create widgets associated with form tree (createform.c)
 */
int xvf_create_mainform  PROTO((kform *, int, int));

/*
 *   Utilities for GUI Creation (create_util.c)
 */
void   xvf_set_text_buffer            PROTO((char *, Line_Info *));
char  *xvf_create_gen_selname         PROTO((char *, kselection *, int *));
char  *xvf_get_comments               PROTO((char **, int *));
int    xvf_append_selection_scrollbar PROTO((kselection *, Line_Info *));
void   xvf_highlight_objects          PROTO((kselection *));
void   xvf_highlight_group            PROTO((kselection *));
double xvf_calculate_remaining_width  PROTO((double, int, int, char *));
double xvf_calculate_text_width       PROTO((double, double, int, int));
double xvf_calculate_sb_width         PROTO((double, int, int, char *, 
					     double, double, int, int ));
void  xvf_object_creation_error_mesg PROTO((char *, char *));

/*
 *   GUI Item Creation Routines (createwid.c)
 */
xvobject xvf_create_submenu_sel        PROTO((kselection *, xvobject));
xvobject xvf_create_subform_sel        PROTO((ksubform *,   xvobject));
xvobject xvf_create_guide_sel          PROTO((kguide *,     xvobject));
xvobject xvf_create_quit_sel           PROTO((kselection *, xvobject, int));
xvobject xvf_create_workspace_sel      PROTO((kselection *, xvobject));
xvobject xvf_create_master_action_sel  PROTO((kselection *, xvobject));
xvobject xvf_create_subform_action_sel PROTO((kselection *, xvobject));
xvobject xvf_create_help_sel           PROTO((kselection *, xvobject));
xvobject xvf_create_input_sel          PROTO((kselection *, xvobject));
xvobject xvf_create_output_sel         PROTO((kselection *, xvobject));
xvobject xvf_create_std_sel            PROTO((kselection *, xvobject));
xvobject xvf_create_int_sel            PROTO((kselection *, xvobject));
xvobject xvf_create_float_sel          PROTO((kselection *, xvobject));
xvobject xvf_create_double_sel         PROTO((kselection *, xvobject));
xvobject xvf_create_logic_sel          PROTO((kselection *, xvobject));
xvobject xvf_create_flag_sel           PROTO((kselection *, xvobject));
xvobject xvf_create_string_sel         PROTO((kselection *, xvobject));
xvobject xvf_create_stringlist_sel     PROTO((kselection *, xvobject));
xvobject xvf_create_cycle_sel          PROTO((kselection *, xvobject));
xvobject xvf_create_routine_sel        PROTO((kselection *, xvobject));
xvobject xvf_create_toggle_sel         PROTO((kselection *, xvobject));
xvobject xvf_create_blank_sel          PROTO((kselection *, xvobject));
xvobject xvf_create_list_sel           PROTO((kselection *, xvobject));
xvobject xvf_create_displaylist_sel    PROTO((kselection *, xvobject));
xvobject xvf_create_ansinfile_sel      PROTO((kselection *, xvobject));
xvobject xvf_create_ansoutfile_sel     PROTO((kselection *, xvobject));
xvobject xvf_create_pane_action_sel    PROTO((kselection *, xvobject));

/*
 * GUI Destruction Routines (destroy.c)
 */
void xvf_destroy_selection    PROTO((kselection *));
void xvf_destroy_control      PROTO((kcontrol *));

/*
 *  Routines to get xvobjects given kformstructs (get.c)
 */
xvobject xvf_get_backplane      PROTO(( kform_struct *, int));

/*
 *  Routines to handle groups (group.c)
 */ 
void xvf_call_do_group       PROTO((kselection *));
void xvf_set_group_selection PROTO((kselection *, int));


/*
 *  Mapping & Unmapping of Forms (mapform.c)
 */
void xvf_iconify_object PROTO((xvobject));

/*
 *   General Utilities (utilities.c)
 */
void xvf_set_optional_sensitivity        PROTO((kselection *, int));
void xvf_set_toggle_optional_sensitivity PROTO((kselection *));
void xvf_update_toggle_literal           PROTO((kselection *));
void xvf_call_gui_callbacks              PROTO((kform_struct *, char *, kaddr));
int xvf_call_extra_calls                 PROTO((klist *, int));
int xvf_synchronize                      PROTO((void));
int xvf_switch_toggle_value              PROTO((kselection *, int, int));
float xvf_list_button_width              PROTO((char **, int));
void xvf_set_selections_sensitive        PROTO((kselection *, int));


/*
 *  General GUI Element Creation Routines (wid_util.c)
 */
xvobject xvf_create_formback        PROTO((xvobject, double, double, 
					   double, double, char *, int));
xvobject xvf_create_selback         PROTO((xvobject, double, double, 
                                           double, double, char *, int));
xvobject xvf_create_menubutton      PROTO((xvobject, xvobject, double, double, 
                                           double, double, char *, char *, 
                                           char **, int, xvobject **));
xvobject xvf_create_button          PROTO((xvobject, double, double, double, 
                                           double, char *, char *));
xvobject xvf_create_menu_button     PROTO((xvobject, char *, char *));
xvobject xvf_create_optional_button PROTO((xvobject));
xvobject xvf_create_boolean_button  PROTO((xvobject, double, double, xvobject, 
                                           char *, char *));
xvobject xvf_create_label           PROTO((xvobject, double, double, xvobject, 
					   char *, char *, int, int));
xvobject xvf_create_menu_label      PROTO((xvobject, char *, char *));
xvobject xvf_create_pseudo_label    PROTO((xvobject, double, double, xvobject, 
                                           char *));
xvobject xvf_create_text            PROTO((xvobject, double, double, xvobject, 
                                           char *, int));
xvobject xvf_create_cr_pixmap       PROTO((xvobject));
xvobject xvf_create_scroll          PROTO((xvobject, xvobject, char *));

/*
 * (manip.c)
 */
int xvf_delete_guide        PROTO((kguide *));
int xvf_delete_subform      PROTO((kform *, ksubform *));
int xvf_transfer_selections PROTO((kcontrol *, kcontrol *));

/*
 * (get_util.c)
 */
int xvf_check_item_part            PROTO((kform_struct *, int));
int xvf_set_object_label_or_pixmap PROTO((xvobject, int, char *));

/*
 * (runform.c)
 */
void xvf_run_done        PROTO((int));

#endif /* _xvforms_internals_h_ */
/* Don't add after this line */
