 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>> Utility Routines For Getting Components of GUI items  <<<<
   >>>>                                                       <<<<
   >>>>  Private:      xvf_check_item_part()                  <<<<
   >>>>                                                       <<<<
   >>>>   Static:      xvf_get_xvobject_error_mesg()          <<<<
   >>>>                xvf_ascii_item_part()                  <<<<
   >>>>                                                       <<<<
   >>>>   Public:                                             <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */

#include "internals.h"

static void  xvf_get_xvobject_error_mesg PROTO((kform_struct *, int));
static char  *xvf_ascii_item_part        PROTO((int));

/*------------------------------------------------------------
|
|  Routine Name: xvf_check_item_part
|
|       Purpose: Given an kformstruct and an item_part, checks to
|                make sure that the item_part applies to the 
|                UIS line in question.  Used for error checking
|                in xvf_get_xvobject().
|
|         Input: kformstruct - generic kform_struct
|                item_part   - the item_part
|        Output: TRUE if combination is OK, FALSE otherwise
|          Date: June 2, 1993
|    Written By: Danielle Argiro
| Modifications:
|
-------------------------------------------------------------*/
int xvf_check_item_part(
   kform_struct *kformstruct,
   int          item_part)
{
	int status = FALSE;

	switch(item_part)
	{
	    /* can get the backplane on most UIS lines, a few exceptions */
	    case XVF_BACKPLANE:
		 switch(kformstruct->flag)
		 {
		     case KUIS_INCLUDEPANE:
		     case KUIS_INCLUDESUBFORM:
		     case KUIS_END:
		     case KUIS_MUTEXCL:
		     case KUIS_MUTINCL:
			  xvf_get_xvobject_error_mesg(kformstruct, item_part);
			  status = FALSE;
		          break;
		
		     default:
			  status = TRUE;
			  break;
		 }
		 break;

	    /* can get optional box only on optional selections */
	    case XVF_OPT_OBJ:
		 switch(kformstruct->flag)
                 {
		     case KUIS_INPUTFILE:
		     case KUIS_OUTPUTFILE:
		     case KUIS_STDIN:
		     case KUIS_STDOUT:
		     case KUIS_INTEGER:
		     case KUIS_FLOAT:
		     case KUIS_DOUBLE:
		     case KUIS_STRING:
		     case KUIS_CYCLE:
		     case KUIS_FLAG:
		     case KUIS_STRINGLIST:
		     case KUIS_LIST:
		     case KUIS_DISPLAYLIST:
		          status = TRUE;
			  break;

		     default:
		          xvf_get_xvobject_error_mesg(kformstruct, item_part);
		          status = FALSE;
			  break;
	         }
		 break;

	    /* can get button box only on selections w/ buttons */
	    case XVF_BUTTON_OBJ:
		 switch(kformstruct->flag)
                 {
		     case KUIS_CYCLE:
		     case KUIS_LIST:
		     case KUIS_DISPLAYLIST:
		     case KUIS_STARTSUBMENU:
		     case KUIS_STRINGLIST:
		     case KUIS_LOGICAL:
		     case KUIS_MASTERACTION:
		     case KUIS_SUBFORMACTION:
		     case KUIS_PANEACTION:
		     case KUIS_SUBFORMBUTTON:
		     case KUIS_GUIDEBUTTON:
		     case KUIS_STARTPANE:
		     case KUIS_QUIT:
		     case KUIS_HELP:
		     case KUIS_ROUTINE:
		          status = TRUE;
			  break;

		     default:
		          xvf_get_xvobject_error_mesg(kformstruct, item_part);
		          status = FALSE;
			  break;
	         }
		 break;

	    /* can get label on all GUI items w/ label */
	    case XVF_LABEL_OBJ:
		 switch(kformstruct->flag)
                 {
		     case KUIS_INCLUDEPANE:
		     case KUIS_INCLUDESUBFORM:
		     case KUIS_END:
		          xvf_get_xvobject_error_mesg(kformstruct, item_part);
		          status = FALSE;
			  break;

		     default:
		          status = TRUE;
			  break;
	         }
		 break;

	    /* can get text box only on selections w/ text*/
	    case XVF_TEXT_OBJ:
		 switch(kformstruct->flag)
                 {
		     case KUIS_INPUTFILE:
		     case KUIS_OUTPUTFILE:
		     case KUIS_INTEGER:
		     case KUIS_FLOAT:
		     case KUIS_DOUBLE:
		     case KUIS_STRING:
		     case KUIS_STRINGLIST:
		          status = TRUE;
			  break;

		     default:
		          xvf_get_xvobject_error_mesg(kformstruct, item_part);
		          status = FALSE;
			  break;
	         }
		 break;

	    /* can get scrollbar only on number selections */
	    case XVF_SCROLL_OBJ:
		 switch(kformstruct->flag)
                 {
		     case KUIS_INTEGER:
		     case KUIS_FLOAT:
		     case KUIS_DOUBLE:
		          status = TRUE;
			  break;

		     default:
		          xvf_get_xvobject_error_mesg(kformstruct, item_part);
		          status = FALSE;
			  break;
	         }
		 break;

            /* can get <cr> pixmap only on live selections */
            case XVF_PIXMAP_OBJ:
                 switch(kformstruct->flag)
                 {
                     case KUIS_INPUTFILE:
                     case KUIS_OUTPUTFILE:
                     case KUIS_INTEGER:
                     case KUIS_FLOAT:
                     case KUIS_DOUBLE:
                     case KUIS_STRING:
                     case KUIS_CYCLE:
                     case KUIS_FLAG:
                     case KUIS_STRINGLIST:
                     case KUIS_LIST:
                     case KUIS_DISPLAYLIST:
                          status = TRUE;
			  break;

                     default:
                          xvf_get_xvobject_error_mesg(kformstruct, item_part);
                          status = FALSE;
			  break;
                 }
                 break;
	
	}

        if (status == FALSE)
	    xvf_get_xvobject_error_mesg(kformstruct, item_part);

	return(status);
}


/*------------------------------------------------------------
|
|  Routine Name: xvf_get_xvobject_error_mesg
|
|       Purpose: Given an kformstruct and an item_part #define that
|                cannot be used together with xvf_get_xvobject,
|                calls kerror() with an appropriate error message
|
|         Input: kformstruct - generic kform_struct
|                item_part   - the item part
|        Output: none
|          Date: June 3, 1993
|    Written By: Danielle Argiro
| Modifications:
|
-------------------------------------------------------------*/
static void xvf_get_xvobject_error_mesg(
   kform_struct *kformstruct,
   int          item_part)
{
        char temp[2*KLENGTH];

        sprintf(temp, "Incorrect call to xvf_get_xvobject(); kformstruct of type %s conflicts with change_code of %s",
                kvf_ascii_typeflag(kformstruct->flag),
                xvf_ascii_item_part(item_part) );
	errno = KCALL;
        kerror("xvforms", "xvf_get_xvobject", temp);
}



/*------------------------------------------------------------
|
|  Routine Name: xvf_ascii_item_part
|
|       Purpose: Given an item_part #define, returns the
|                ascii string representation the #define
|
|         Input: item_part - the item_part
|        Output: 
|       Returns: The ascii string representation of the #define
|                Note! Do not modify or free this string!
|          Date: June 3, 1993
|    Written By: Danielle Argiro
| Modifications:
|
-------------------------------------------------------------*/
static char *xvf_ascii_item_part(
   int item_part)
{
	char *item = "NULL";

	switch (item_part)
	{
	    case XVF_BACKPLANE:   item = "XVF_BACKPLANE";   break;
            case XVF_OPT_OBJ:     item = "XVF_OPT_OBJ";     break;
            case XVF_BUTTON_OBJ:  item = "XVF_BUTTON_OBJ";  break;
            case XVF_LABEL_OBJ:   item = "XVF_LABEL_OBJ";   break;
            case XVF_TEXT_OBJ:    item = "XVF_TEXT_OBJ";    break;
            case XVF_SCROLL_OBJ:  item = "XVF_SCROLL_OBJ";  break;
            case XVF_PIXMAP_OBJ:  item = "XVF_PIXMAP_OBJ";  break;
	}
	return(item);
}



