 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Declarations of routines to 
   >>>>                set and get xvforms attributes
   >>>>
   >>>>    Written By: Danielle Argiro
   >>>>
   >>>>          Date: Nov 13, 1992
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvf_attributes_h_
#define _xvf_attributes_h_


#define xvf_check_boolean(val)  (((val != 0) && (val != 1))? 0 : 1)

	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/*
 *  attrib_gen.c - general set & get routines
 */
int xvf_get_activate         PROTO((kform_struct *, char *, kaddr));
int xvf_set_activate         PROTO((kform_struct *, char *, kaddr));
int xvf_get_selected         PROTO((kform_struct *, char *, kaddr));
int xvf_set_selected         PROTO((kform_struct *, char *, kaddr));
int xvf_get_optional         PROTO((kform_struct *, char *, kaddr));
int xvf_set_optional         PROTO((kform_struct *, char *, kaddr));
int xvf_get_optsel           PROTO((kform_struct *, char *, kaddr));
int xvf_set_optsel           PROTO((kform_struct *, char *, kaddr));
int xvf_get_live             PROTO((kform_struct *, char *, kaddr));
int xvf_set_live             PROTO((kform_struct *, char *, kaddr));

int xvf_get_variable         PROTO((kform_struct *, char *, kaddr));
int xvf_set_variable         PROTO((kform_struct *, char *, kaddr));
int xvf_get_description      PROTO((kform_struct *, char *, kaddr));
int xvf_set_description      PROTO((kform_struct *, char *, kaddr));
int xvf_get_title            PROTO((kform_struct *, char *, kaddr));
int xvf_set_title            PROTO((kform_struct *, char *, kaddr));
int xvf_get_buttontitle      PROTO((kform_struct *, char *, kaddr));
int xvf_set_buttontitle      PROTO((kform_struct *, char *, kaddr));
int xvf_get_guidepanetitle   PROTO((kform_struct *, char *, kaddr));
int xvf_set_guidepanetitle   PROTO((kform_struct *, char *, kaddr));
int xvf_get_literal          PROTO((kform_struct *, char *, kaddr));
int xvf_set_literal          PROTO((kform_struct *, char *, kaddr));
int xvf_get_modified         PROTO((kform_struct *, char *, kaddr));
int xvf_set_modified         PROTO((kform_struct *, char *, kaddr));
int xvf_get_clientdata       PROTO((kform_struct *, char *, kaddr));
int xvf_set_clientdata       PROTO((kform_struct *, char *, kaddr));

int xvf_get_width            PROTO((kform_struct *, char *, kaddr));
int xvf_set_width            PROTO((kform_struct *, char *, kaddr));
int xvf_get_height           PROTO((kform_struct *, char *, kaddr));
int xvf_set_height           PROTO((kform_struct *, char *, kaddr));
int xvf_get_x                PROTO((kform_struct *, char *, kaddr));
int xvf_set_x                PROTO((kform_struct *, char *, kaddr));
int xvf_get_y                PROTO((kform_struct *, char *, kaddr));
int xvf_set_y                PROTO((kform_struct *, char *, kaddr));
int xvf_get_buttonwidth      PROTO((kform_struct *, char *, kaddr));
int xvf_set_buttonwidth      PROTO((kform_struct *, char *, kaddr));
int xvf_get_buttonheight     PROTO((kform_struct *, char *, kaddr));
int xvf_set_buttonheight     PROTO((kform_struct *, char *, kaddr));
int xvf_get_buttonx          PROTO((kform_struct *, char *, kaddr));
int xvf_set_buttonx          PROTO((kform_struct *, char *, kaddr));
int xvf_get_buttony          PROTO((kform_struct *, char *, kaddr));
int xvf_set_buttony          PROTO((kform_struct *, char *, kaddr));
int xvf_get_xpos             PROTO((kform_struct *, char *, kaddr));
int xvf_set_xpos             PROTO((kform_struct *, char *, kaddr));
int xvf_get_ypos             PROTO((kform_struct *, char *, kaddr));
int xvf_set_ypos             PROTO((kform_struct *, char *, kaddr));

int xvf_set_delete           PROTO((kform_struct *, char *, kaddr));
int xvf_set_display_subform  PROTO((kform_struct *, char *, kaddr));
int xvf_set_display_pane     PROTO((kform_struct *, char *, kaddr));

/*
 *  attrib_print.c - set & get routines for printing UIS files
 */
int xvf_get_print_uis        PROTO((kform_struct *, char *, kaddr));
int xvf_set_print_uis        PROTO((kform_struct *, char *, kaddr));
int xvf_get_print_pane       PROTO((kform_struct *, char *, kaddr));
int xvf_set_print_pane       PROTO((kform_struct *, char *, kaddr));
int xvf_get_print_subform    PROTO((kform_struct *, char *, kaddr));
int xvf_set_print_subform    PROTO((kform_struct *, char *, kaddr));
int xvf_get_pane_file        PROTO((kform_struct *, char *, kaddr));
int xvf_set_pane_file        PROTO((kform_struct *, char *, kaddr));
int xvf_get_subform_file     PROTO((kform_struct *, char *, kaddr));
int xvf_set_subform_file     PROTO((kform_struct *, char *, kaddr));
int xvf_get_uis_location     PROTO((kform_struct *, char *, kaddr));
int xvf_set_uis_location     PROTO((kform_struct *, char *, kaddr));

/*
 *  attrib_str.c - set & get routines for files, strings
 */
int xvf_get_file_name        PROTO((kform_struct *, char *, kaddr));
int xvf_set_file_name        PROTO((kform_struct *, char *, kaddr));
int xvf_get_file_check       PROTO((kform_struct *, char *, kaddr));
int xvf_set_file_check       PROTO((kform_struct *, char *, kaddr));
int xvf_get_file_def         PROTO((kform_struct *, char *, kaddr));
int xvf_set_file_def         PROTO((kform_struct *, char *, kaddr));
int xvf_get_string_val       PROTO((kform_struct *, char *, kaddr));
int xvf_set_string_val       PROTO((kform_struct *, char *, kaddr));
int xvf_get_string_def       PROTO((kform_struct *, char *, kaddr));
int xvf_set_string_def       PROTO((kform_struct *, char *, kaddr));
int xvf_get_string_multiline PROTO((kform_struct *, char *, kaddr));
int xvf_set_string_multiline PROTO((kform_struct *, char *, kaddr));

/*
 *  attrib_misc.c - set & get routines for logicals
 */
int xvf_get_logic_val         PROTO((kform_struct *, char *, kaddr));
int xvf_set_logic_val         PROTO((kform_struct *, char *, kaddr)); 
int xvf_get_logic_def         PROTO((kform_struct *, char *, kaddr));
int xvf_set_logic_def         PROTO((kform_struct *, char *, kaddr));
int xvf_get_logic_label       PROTO((kform_struct *, char *, kaddr));
int xvf_set_logic_label       PROTO((kform_struct *, char *, kaddr));


/*
 *  attrib_misc.c - set & get routines for cycles & lists
 */
int xvf_get_list_size         PROTO((kform_struct *, char *, kaddr));
int xvf_set_list_size         PROTO((kform_struct *, char *, kaddr));
int xvf_get_list_val          PROTO((kform_struct *, char *, kaddr));
int xvf_set_list_val          PROTO((kform_struct *, char *, kaddr));
int xvf_get_list_index        PROTO((kform_struct *, char *, kaddr));
int xvf_set_list_index        PROTO((kform_struct *, char *, kaddr)); 
int xvf_get_list_label        PROTO((kform_struct *, char *, kaddr));
int xvf_set_list_label        PROTO((kform_struct *, char *, kaddr));
int xvf_get_list_start        PROTO((kform_struct *, char *, kaddr));
int xvf_set_list_start        PROTO((kform_struct *, char *, kaddr));
int xvf_get_list_choices      PROTO((kform_struct *, char *, kaddr));
int xvf_set_list_choices      PROTO((kform_struct *, char *, kaddr));
int xvf_get_list_contents     PROTO((kform_struct *, char *, kaddr));
int xvf_set_list_contents     PROTO((kform_struct *, char *, kaddr));
int xvf_get_list_doubleclick  PROTO((kform_struct *, char *, kaddr));
int xvf_set_list_doubleclick  PROTO((kform_struct *, char *, kaddr));
int xvf_set_list_add          PROTO((kform_struct *, char *, kaddr));
int xvf_set_list_delete       PROTO((kform_struct *, char *, kaddr));
int xvf_set_list_deleteall    PROTO((kform_struct *, char *, kaddr));

/*
 *  attrib_misc.c - miscellaneous set & get routines
 */
int xvf_get_exectype          PROTO((kform_struct *, char *, kaddr));
int xvf_set_exectype          PROTO((kform_struct *, char *, kaddr));

int xvf_get_routine           PROTO((kform_struct *, char *, kaddr));
int xvf_set_routine           PROTO((kform_struct *, char *, kaddr));

int xvf_get_help_path         PROTO((kform_struct *, char *, kaddr));
int xvf_set_help_path         PROTO((kform_struct *, char *, kaddr));

/*
 *  attrib_int.c - set & get routines for integers
 */
int xvf_get_nobounds_sel      PROTO((kform_struct *, char *, kaddr));
int xvf_set_nobounds_sel      PROTO((kform_struct *, char *, kaddr));
int xvf_get_bounds_sel        PROTO((kform_struct *, char *, kaddr));
int xvf_set_bounds_sel        PROTO((kform_struct *, char *, kaddr));

int xvf_get_int_gt0_sel       PROTO((kform_struct *, char *, kaddr));
int xvf_set_int_gt0_sel       PROTO((kform_struct *, char *, kaddr));
int xvf_get_int_ge0_sel       PROTO((kform_struct *, char *, kaddr));
int xvf_set_int_ge0_sel       PROTO((kform_struct *, char *, kaddr));
int xvf_get_int_lt0_sel       PROTO((kform_struct *, char *, kaddr));
int xvf_set_int_lt0_sel       PROTO((kform_struct *, char *, kaddr));
int xvf_get_int_le0_sel       PROTO((kform_struct *, char *, kaddr));
int xvf_set_int_le0_sel       PROTO((kform_struct *, char *, kaddr));
int xvf_get_int_upper         PROTO((kform_struct *, char *, kaddr));
int xvf_set_int_upper         PROTO((kform_struct *, char *, kaddr));
int xvf_get_int_lower         PROTO((kform_struct *, char *, kaddr));
int xvf_set_int_lower         PROTO((kform_struct *, char *, kaddr));

int xvf_get_int_def           PROTO((kform_struct *, char *, kaddr));
int xvf_set_int_def           PROTO((kform_struct *, char *, kaddr));
int xvf_get_int_val           PROTO((kform_struct *, char *, kaddr));
int xvf_set_int_val           PROTO((kform_struct *, char *, kaddr));

/*
 *  attrib_flt.c - set & get routines for floats
 */
int xvf_get_float_gt0_sel     PROTO((kform_struct *, char *, kaddr));
int xvf_set_float_gt0_sel     PROTO((kform_struct *, char *, kaddr));
int xvf_get_float_ge0_sel     PROTO((kform_struct *, char *, kaddr));
int xvf_set_float_ge0_sel     PROTO((kform_struct *, char *, kaddr));
int xvf_get_float_lt0_sel     PROTO((kform_struct *, char *, kaddr));
int xvf_set_float_lt0_sel     PROTO((kform_struct *, char *, kaddr));
int xvf_get_float_le0_sel     PROTO((kform_struct *, char *, kaddr));
int xvf_set_float_le0_sel     PROTO((kform_struct *, char *, kaddr));
int xvf_get_float_upper       PROTO((kform_struct *, char *, kaddr));
int xvf_set_float_upper       PROTO((kform_struct *, char *, kaddr));
int xvf_get_float_lower       PROTO((kform_struct *, char *, kaddr));
int xvf_set_float_lower       PROTO((kform_struct *, char *, kaddr));

int xvf_get_float_def         PROTO((kform_struct *, char *, kaddr));
int xvf_set_float_def         PROTO((kform_struct *, char *, kaddr));
int xvf_get_float_val         PROTO((kform_struct *, char *, kaddr));
int xvf_set_float_val         PROTO((kform_struct *, char *, kaddr));

int xvf_get_precision         PROTO((kform_struct *, char *, kaddr));
int xvf_set_precision         PROTO((kform_struct *, char *, kaddr));
int xvf_get_mechanism         PROTO((kform_struct *, char *, kaddr));
int xvf_set_mechanism         PROTO((kform_struct *, char *, kaddr));

/*
 *  attrib_dbl.c - set & get routines for doubles
 */
int xvf_get_double_gt0_sel    PROTO((kform_struct *, char *, kaddr));
int xvf_set_double_gt0_sel    PROTO((kform_struct *, char *, kaddr));
int xvf_get_double_ge0_sel    PROTO((kform_struct *, char *, kaddr));
int xvf_set_double_ge0_sel    PROTO((kform_struct *, char *, kaddr));
int xvf_get_double_lt0_sel    PROTO((kform_struct *, char *, kaddr));
int xvf_set_double_lt0_sel    PROTO((kform_struct *, char *, kaddr));
int xvf_get_double_le0_sel    PROTO((kform_struct *, char *, kaddr));
int xvf_set_double_le0_sel    PROTO((kform_struct *, char *, kaddr));
int xvf_get_double_upper      PROTO((kform_struct *, char *, kaddr));
int xvf_set_double_upper      PROTO((kform_struct *, char *, kaddr));
int xvf_get_double_lower      PROTO((kform_struct *, char *, kaddr));
int xvf_set_double_lower      PROTO((kform_struct *, char *, kaddr));

int xvf_get_double_def        PROTO((kform_struct *, char *, kaddr));
int xvf_set_double_def        PROTO((kform_struct *, char *, kaddr));
int xvf_get_double_val        PROTO((kform_struct *, char *, kaddr));
int xvf_set_double_val        PROTO((kform_struct *, char *, kaddr));

/*
 *  attrib_toggle.c - set & get routines for toggles
 */
int xvf_get_toggle_size       PROTO((kform_struct *, char *, kaddr));
int xvf_set_toggle_size       PROTO((kform_struct *, char *, kaddr));
int xvf_set_toggle_num        PROTO((kform_struct *, char *, kaddr));
int xvf_get_toggle_num        PROTO((kform_struct *, char *, kaddr));
int xvf_set_toggle_val        PROTO((kform_struct *, char *, kaddr));
int xvf_get_toggle_val        PROTO((kform_struct *, char *, kaddr));
int xvf_get_toggle_type       PROTO((kform_struct *, char *, kaddr));
int xvf_set_toggle_members    PROTO((kform_struct *, char *, kaddr));

void create_new_toggle_member PROTO((kselection *, int ));

/*
 * attributes.h
 */
int xvf_get_defined_attribute PROTO((xvobject, char *, kaddr));
int xvf_set_defined_attribute PROTO((xvobject, char *, kaddr));


        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

typedef int (*attribute_handler) PROTO((kform_struct *, char *, kaddr));

typedef struct _AttributeEntry
{
        int                     token;
        char                    *attribute;
        int                     data_type;
        attribute_handler       get_attr_routine;
        attribute_handler       set_attr_routine;

} AttributeEntry;

extern int            xvf_attribute_num;
extern AttributeEntry xvf_attribute_table[];


#endif /* _xvf_attributes_h_ */
/* Don't add after this point */
