 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>       	       Motif xvobject Creation		      <<<<
   >>>>  Private:                                             <<<<
   >>>>   Static:                                             <<<<
   >>>>   Public:                                             <<<<
   >>>>                xvw_create_menubutton()		      <<<<
   >>>>                xvw_create_button()		      <<<<
   >>>>                xvw_create_label()		      <<<<
   >>>>                xvw_create_scrollbar() 	              <<<<
   >>>>                xvw_create_list() 	              <<<<
   >>>>                xvw_create_text()	 	      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */


#include "internals.h"

#ifdef KMOTIF_DEF

klist *xvw_textwidget_list = NULL;
klist *xvw_menuwidget_list = NULL;
klist *xvw_listwidget_list = NULL;


/*-----------------------------------------------------------
|
|  Routine Name: initialize_converters - this initializes the converters
|					 for Motif
|
|       Purpose: This routine initializes the converters for Motif
|         Input: 
|        Output: 
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: John Salas and Mark Young
|          Date: Dec 8, 1993
| Modifications:
|
------------------------------------------------------------*/

static void initialize_converters()
{
	static int initialized = FALSE;


	if (initialized)
	   return;

	initialized = TRUE;
	xvw_load_resources("$DESIGN/objects/library/Motif/app-defaults/Motif");
	XtAppSetTypeConverter(xvw_appcontext(NULL), XtRString,
		XmRCompoundText, cvtStringToCompoundString, NULL, 0,
		XtCacheNone, NULL);
        XtAppSetTypeConverter(xvw_appcontext(NULL), XmRCompoundText,
		XtRString, cvtCompoundStringToString, NULL, 0, XtCacheNone,
		NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: xvw_create_menubutton
|
|       Purpose: Creates a compound menubutton object
|                using the Motif Widget set.
|
|         Input: parent - the parent xvobject
|                name   - name with which to reference menubutton
|        Output: none
|       Returns: none
|    Written By: Danielle Argiro & John Salas
|          Date: April 26, 1993
| Modifications:
|
------------------------------------------------------------*/

static xvattribute menu_attributes[] = {
{XVW_LABEL,        XmNlabelString,     XtRString,  XmRCompoundText},
{XVW_BORDER_WIDTH, XmNshadowThickness, XtRInt,     XtRDimension},
};
static xvattribute parent_menu_attributes[] = {
{XVW_BORDER_WIDTH, XmNshadowThickness,  XtRInt,     XtRDimension},
{XVW_CHILDREN,     NULL, XtRWidgetList, NULL},
{XVW_NUM_CHILDREN, NULL, XtRInt,        NULL},
};

xvobject xvw_create_menubutton(
   xvobject parent,
   char   *name)
{
	xvobject object;
	Arg      arg[MAX_ARGS];
	int      i, need_rowcol = FALSE;
	klist    *menuwidget_list;
	Widget   menu, menubutton, menubar;


	static initialized = FALSE;
	initialize_converters();


	if (xvw_class(parent) != xmRowColumnWidgetClass)
	    need_rowcol = TRUE;
	if (need_rowcol)
	{
	   menu = XmCreatePopupMenu(xvw_widget(parent), "menu", NULL, 0);

	   i = 0;
           XtSetArg(arg[i], XmNstringDirection, XmSTRING_DIRECTION_L_TO_R); i++;
	   XtSetArg(arg[i], XmNalignment,       XmALIGNMENT_CENTER);        i++;
	   XtSetArg(arg[i], XmNborderWidth,       0);			   i++;
	   XtSetArg(arg[i], XmNhighlightThickness,0);			   i++;
	   XtSetArg(arg[i], XmNtraversalOn, FALSE);			   i++;
	   XtSetArg(arg[i], XmNfillOnArm, FALSE);			   i++;
	   XtSetArg(arg[i], XmNnavigationType, XmNONE);			   i++;
	   menubutton = XtCreateManagedWidget(name, xmPushButtonWidgetClass,
					xvw_widget(parent), arg, i);
	   XtAddCallback(menubutton, XmNarmCallback, xvw_popup_motif_menu,
					menu);
	}
	else
	{
	   menu = XmCreatePulldownMenu(xvw_widget(parent), "menu", NULL, 0);

	   i = 0;
           XtSetArg(arg[i], XmNstringDirection, XmSTRING_DIRECTION_L_TO_R); i++;
           XtSetArg(arg[i], XmNalignment,       XmALIGNMENT_CENTER);        i++;
	   XtSetArg(arg[i], XmNborderWidth,       0);			 i++;
	   XtSetArg(arg[i], XmNhighlightThickness,0);			 i++;
	   XtSetArg(arg[i], XmNsubMenuId, menu);		 	 i++;
	   XtSetArg(arg[i], XmNtraversalOn, FALSE);			 i++;
	   XtSetArg(arg[i], XmNnavigationType, XmNONE);			 i++;
           menubutton = XtCreateManagedWidget(name, xmCascadeButtonGadgetClass,
                                           xvw_widget(parent), arg, i);
	}
	object = xvw_object(menubutton);
	menuwidget_list = klist_locate(xvw_menuwidget_list, object);
	if (menuwidget_list == NULL)
	   xvw_menuwidget_list = klist_add(xvw_menuwidget_list, object,
					xvw_object(menu));
        else
           menuwidget_list->client_data = (kaddr) (xvw_object(menu));

	if (!initialized)
	{
	   initialized = TRUE;
	   xvw_init_attributes(xmCascadeButtonGadgetClass, menu_attributes,
		            knumber(menu_attributes), NULL, 0, NULL);
	   xvw_init_attributes(xmPushButtonWidgetClass, menu_attributes,
		            knumber(menu_attributes), NULL, 0, NULL);
	}
	return(object);
}

/*-----------------------------------------------------------
|
|  Routine Name: xvw_create_button
|
|       Purpose: Creates a button object using the Motif Widget set.
|
|         Input: parent - the parent xvobject
|                name   - name with which to reference button
|        Output: none
|       Returns: none
|    Written By: Danielle Argiro & John Salas
|          Date: April 12, 1993
| Modifications:
|
------------------------------------------------------------*/

static xvattribute button_attributes[] = {
{XVW_LABEL,           XmNlabelString,     XtRString,     XmRCompoundText},
{XVW_PIXMAP,          XmNlabelPixmap,     XmRPixmap,     NULL},
{XVW_PIXMAP_FILENAME, XmNlabelPixmap,     XtRFilename,   XtRPixmap},
{XVW_BORDER_WIDTH,    XmNshadowThickness, XtRInt,        XtRDimension},
};

xvobject xvw_create_button(
   xvobject parent,
   char   *name)
{
	int i;
	Arg arg[MAX_ARGS];
	Widget button;

	static initialized = FALSE;
	initialize_converters();

	i = 0;
        XtSetArg(arg[i], XmNmappedWhenManaged, TRUE);   		   i++;
        XtSetArg(arg[i], XmNstringDirection,   XmSTRING_DIRECTION_L_TO_R); i++;
	XtSetArg(arg[i], XmNalignment,         XmALIGNMENT_CENTER);        i++;
	XtSetArg(arg[i], XmNborderWidth,       0);			   i++;
	XtSetArg(arg[i], XmNhighlightThickness,0);			   i++;
	XtSetArg(arg[i], XmNtraversalOn, FALSE);			   i++;
	XtSetArg(arg[i], XmNnavigationType, XmNONE);			   i++;
	button = XtCreateManagedWidget(name, xmPushButtonWidgetClass, 
				            xvw_widget(parent), arg, i);
	if (!initialized)
	{
	   initialized = TRUE;
	   xvw_init_attributes(xmPushButtonWidgetClass, button_attributes,
	     knumber(button_attributes), NULL, 0, NULL);
	   xvw_define_callback(XVW_BUTTON_SELECT, XmNactivateCallback, NULL);
	   xvw_define_attributes(xmPushButtonWidgetClass,
             XVW_BUTTON_SHAPE, XtRInt, xvw_set_buttonshape, xvw_get_buttonshape,
             XVW_BUTTON_TYPE,    XtRInt, xvw_set_misc,        xvw_get_misc, 
             XVW_LABEL_JUSTIFY,  XtRInt, xvw_set_misc,        xvw_get_misc,
             XVW_PIXMAP_JUSTIFY, XtRInt, xvw_set_misc,        xvw_get_misc,
	     NULL);
	}
	return(xvw_object(button));
}


/*-----------------------------------------------------------
|
|  Routine Name: xvw_create_label
|
|       Purpose: Creates a label object using the Motif Widget set.
|
|         Input: parent - the parent xvobject
|                name   - name with which to reference label
|        Output: none
|       Returns: none
|    Written By: Danielle Argiro & John Salas
|          Date: April 12, 1993
| Modifications:
|
------------------------------------------------------------*/

static xvattribute label_attributes[] = {
{XVW_LABEL,           XmNlabelString,  XtRString,     XmRCompoundText},
{XVW_PIXMAP,          XmNlabelPixmap,  XmRPixmap,     NULL},
{XVW_PIXMAP_FILENAME, XmNlabelPixmap,  XtRFilename,   XtRPixmap},
};

xvobject xvw_create_label(
   xvobject parent,
   char   *name)
{
	int     i;
	Arg     arg[MAX_ARGS];
	Widget  label;

	static int initialized = FALSE;
	initialize_converters();

	i = 0;
        XtSetArg(arg[i], XmNstringDirection, XmSTRING_DIRECTION_L_TO_R); i++;
	XtSetArg(arg[i], XmNborderWidth,       0);                   	 i++;
        XtSetArg(arg[i], XmNmappedWhenManaged, TRUE);   		 i++;
	XtSetArg(arg[i], XmNmarginWidth,       0);	             	 i++;
	XtSetArg(arg[i], XmNmarginHeight,      0);     	        	 i++;
	XtSetArg(arg[i], XmNalignment,         XmALIGNMENT_CENTER);      i++;
	XtSetArg(arg[i], XmNtraversalOn, FALSE);			 i++;
	XtSetArg(arg[i], XmNnavigationType, XmNONE);			 i++;
	label = XtCreateManagedWidget(name, xmLabelWidgetClass,
				      xvw_widget(parent), arg, i);

	if (!initialized)
	{
	   initialized = TRUE;
	   xvw_init_attributes(xmLabelWidgetClass, label_attributes,
		knumber(label_attributes), NULL, 0, NULL);

	   xvw_define_attributes(xmLabelWidgetClass,
             XVW_LABEL_TYPE,     XtRInt, xvw_set_misc, xvw_get_misc,
             XVW_LABEL_JUSTIFY,  XtRInt, xvw_set_misc, xvw_get_misc,
             XVW_PIXMAP_JUSTIFY, XtRInt, xvw_set_misc, xvw_get_misc,
             NULL);
	}
	return(xvw_object(label));
}

/*-----------------------------------------------------------
|
|  Routine Name: xvw_create_scrollbar
|
|       Purpose: Creates a scrollbar using the Motif Widget set.
|
|         Input: parent - the parent xvobject
|                name   - name with which to reference scrollbar
|        Output: none
|       Returns: none
|    Written By: Danielle Argiro & John Salas
|          Date: April 14, 1993
| Modifications:
|
------------------------------------------------------------*/

xvobject xvw_create_scrollbar(
   xvobject parent,
   char   *name)
{
	int     i;
	Arg     arg[MAX_ARGS];
	Widget  scroll;

	static initialized = FALSE;
	initialize_converters();

	i = 0;
	XtSetArg(arg[i], XmNorientation, XmHORIZONTAL);		i++;
	XtSetArg(arg[i], XmNtraversalOn, FALSE);		i++;
	XtSetArg(arg[i], XmNnavigationType, XmNONE);		i++;
	scroll = XtCreateManagedWidget(name, xmScrollBarWidgetClass,
				       xvw_widget(parent), arg, i);

	if (!initialized)
	{
	   initialized = TRUE;

	   xvw_init_attributes(XtClass(scroll), NULL, 0, NULL, 0, NULL);
	   xvw_define_attributes(XtClass(scroll),
	      XVW_SCROLL_MIN,  XtRDouble, xvw_set_scrollbar, xvw_get_scrollbar,
	      XVW_SCROLL_MAX,  XtRDouble, xvw_set_scrollbar, xvw_get_scrollbar,
	      XVW_SCROLL_VALUE,XtRDouble, xvw_set_scrollbar, xvw_get_scrollbar,
	      XVW_SCROLL_INCR, XtRDouble, xvw_set_scrollbar, xvw_get_scrollbar,
	      XVW_ORIENTATION, XtRInt, xvw_set_orientation, NULL,
	      NULL);
           xvw_define_callback(XVW_SCROLL_CONT_MOTION, XmNdragCallback,
              xvw_update_scroll_value);
           xvw_define_callback(XVW_SCROLL_INCR_MOTION, XmNvalueChangedCallback,
	      xvw_update_scroll_value);
	}
	return(xvw_object(scroll));
}


/*-----------------------------------------------------------
|
|  Routine Name: xvw_create_list
|
|       Purpose: Creates a compound list object using the Motif Widget set.
|
|         Input: parent - the parent xvobject
|                name   - name with which to reference list
|        Output: none
|       Returns: none
|    Written By: Danielle Argiro & John Salas
|          Date: April 16, 1993
| Modifications:
|
------------------------------------------------------------*/

static xvattribute list_attributes[] = {
{XVW_LIST_SIZE,  XmNitemCount,  XtRInt,  NULL},
};


xvobject xvw_create_list(
   xvobject parent,
   char   *name)
{
	int    i;
	Arg    arg[MAX_ARGS];
	Widget list_widget;
        klist  *listwidget_list;

	static int initialized = FALSE;
	initialize_converters();

	i = 0;
        XtSetArg(arg[i], XmNlistSpacing,            5);			i++;
        XtSetArg(arg[i], XmNscrollBarDisplayPolicy, XmAS_NEEDED);	i++;
        XtSetArg(arg[i], XmNlistSizePolicy,         XmCONSTANT);	i++;
        XtSetArg(arg[i], XmNmappedWhenManaged,      TRUE);   		i++;
        XtSetArg(arg[i], XmNscrollBarPlacement,     XmBOTTOM_LEFT);	i++;
	XtSetArg(arg[i], XmNitemCount,              0);			i++;
	XtSetArg(arg[i], XmNwidth,		    10);		i++;
	XtSetArg(arg[i], XmNheight,		    10);		i++;
	list_widget = XmCreateScrolledList(xvw_widget(parent), name, arg, i);


        listwidget_list = klist_locate(xvw_listwidget_list, 
				       xvw_parent(xvw_object(list_widget)));
        if (listwidget_list != NULL)
           listwidget_list->client_data = (kaddr) list_widget;
        else xvw_listwidget_list = klist_add(xvw_listwidget_list, 
					    xvw_parent(xvw_object(list_widget)),
                                            list_widget);

	if (!initialized)
	{
	   initialized = TRUE;

	   xvw_init_attributes(XtClass(list_widget), list_attributes, 
			    knumber(list_attributes), NULL, 0, NULL);
	   xvw_define_attributes(XtClass(list_widget),
             XVW_LIST_HIGHLT_ELEM,   XtRInt, xvw_set_list_highlight,  
					     xvw_get_list_highlight,
             XVW_LIST_UNHIGHLT_ELEM, XtRInt, xvw_set_list_unhighlight, NULL,
             NULL);
	   xvw_define_callback(XVW_LIST_ITEM_SELECT, XmNbrowseSelectionCallback,
              xvw_update_list_struct);
	   xvw_define_callback(XVW_LIST_ITEM_ACTION, XmNdefaultActionCallback,
              xvw_update_list_struct);
	}
	XtManageChild(list_widget);
	return(xvw_parent(xvw_object(list_widget)));
}


/*-----------------------------------------------------------
|
|  Routine Name: xvw_create_text
|
|       Purpose: Creates a text object using the Motif Widget set.
|
|         Input: parent - the parent xvobject
|                name   - name with which to reference text object
|        Output: none
|       Returns: none
|    Written By: Danielle Argiro & John Salas
|          Date: April 14, 1993
| Modifications:
|
------------------------------------------------------------*/

static xvattribute text_attributes[] = {
{XVW_TEXT_INSERT_POS,   XmNcursorPosition,   XtRInt,              NULL},
{XVW_TEXT_LENGTH,       XmNmaxLength,        XtRInt,              NULL},
{XVW_TEXT_LEFT_MARGIN,  XmNmarginWidth,      XtRDimension,        NULL},
{XVW_BORDER_WIDTH,	XmNshadowThickness,  XtRInt,		  XtRDimension},
};

xvobject xvw_create_text(
   xvobject parent,
   char   *name)
{
	int     i, type;
	Arg     arg[MAX_ARGS];
	Widget  text;
        klist  *textwidget_list;

	static int initialized = FALSE;
	initialize_converters();

        i = 0;
	XtSetArg(arg[i], XmNborderWidth,        0);			i++;
	XtSetArg(arg[i], XmNhighlightThickness, 0);			i++;
	XtSetArg(arg[i], XmNmaxLength, KLENGTH);			i++;
	XtSetArg(arg[i], XmNwordWrap, TRUE);				i++;
	XtSetArg(arg[i], XmNeditable, TRUE);                            i++;
#if XmVERSION == 1 && XmREVISION == 2
	XtSetArg(arg[i], XmNtraversalOn, FALSE);			   i++;
#endif
	XtSetArg(arg[i], XmNnavigationType, XmNONE);			   i++;
	text = XtCreateManagedWidget(name, xmTextWidgetClass,
				     xvw_widget(parent), arg, i);

	type = KTEXT_TYPE_STRING;
        textwidget_list = klist_locate(xvw_textwidget_list, xvw_object(text));
        if (textwidget_list != NULL)
           textwidget_list->client_data = (kaddr) type;
        else xvw_textwidget_list = klist_add(xvw_textwidget_list, 
					     xvw_object(text), (kaddr) type);

	if (!initialized)
	{
	   initialized = TRUE;

	   xvw_init_attributes(XtClass(text), text_attributes,
	                    knumber(text_attributes), NULL, 0, NULL);
	   xvw_define_attributes(XtClass(text),
	     XVW_TEXT_MULTILINE, XtRInt, xvw_set_textmulti, xvw_get_textmulti,
             XVW_TEXT_TYPE,      XtRInt, xvw_set_texttype,  xvw_get_texttype,
             XVW_TEXT_STRING,    XtRString, xvw_set_text,   xvw_get_text,
             XVW_TEXT_EDIT_TYPE, XtRInt,    xvw_set_misc,   xvw_get_misc,
             XVW_TEXT_WRAP,      XtRInt,    xvw_set_misc,   xvw_get_misc,
             XVW_TEXT_SCROLL_VERT, XtRInt,    xvw_set_misc,   xvw_get_misc,
             XVW_TEXT_SCROLL_HORIZ,XtRInt,    xvw_set_misc,   xvw_get_misc,
	     NULL);
	}
#if KOPSYS_LOCAL != KOPSYS_AIX
	xvw_add_event(xvw_object(text), EnterWindowMask | LeaveWindowMask,
		      xvw_set_textfocus, NULL);
#endif
	xvw_set_attribute(xvw_object(text), XVW_TEXT_MULTILINE, FALSE);
	return(xvw_object(text));
}

#else

/*
 * These are dummy function calls so that if the widget set is not supported
 * on the machine a message is printed out.
 */
xvobject xvw_create_menubutton(
   xvobject parent,
   char   *name)
{
   kfprintf(kstderr,"\nThe Motif widget set is either not supported for this \
machine or was not\ncompiled in by the installer of Khoros.  Please contact \
the installer.\n\n");
   return(NULL);
}

xvobject xvw_create_button(
   xvobject parent,
   char   *name)
{
   kfprintf(kstderr,"\nThe Motif widget set is either not supported for this \
machine or was not\ncompiled in by the installer of Khoros.  Please contact \
the installer.\n\n");
   return(NULL);
}

xvobject xvw_create_label(
   xvobject parent,
   char   *name)
{
   kfprintf(kstderr,"\nThe Motif widget set is either not supported for this \
machine or was not\ncompiled in by the installer of Khoros.  Please contact \
the installer.\n\n");
   return(NULL);
}

xvobject xvw_create_scrollbar(
   xvobject parent,
   char   *name)
{
   kfprintf(kstderr,"\nThe Motif widget set is either not supported for this \
machine or was not\ncompiled in by the installer of Khoros.  Please contact \
the installer.\n\n");
   return(NULL);
}

xvobject xvw_create_list(
   xvobject parent,
   char   *name)
{
   kfprintf(kstderr,"\nThe Motif widget set is either not supported for this \
machine or was not\ncompiled in by the installer of Khoros.  Please contact \
the installer.\n\n");
   return(NULL);
}

xvobject xvw_create_text(
   xvobject parent,
   char   *name)
{
   kfprintf(kstderr,"\nThe Motif widget set is either not supported for this \
machine or was not\ncompiled in by the installer of Khoros.  Please contact \
the installer.\n\n");
   return(NULL);
}
#endif /* KMOTIF_DEF */
/* Don't add after the endif */
